<?php
$API_TOKEN = '';

$envFile = __DIR__ . '/.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        $line = trim($line);
        if (strpos($line, 'API_KEY=') === 0) {
            $API_TOKEN = trim(str_replace('API_KEY=', '', $line), '"');
            break;
        }
    }
}

if (!$API_TOKEN) {
    die(json_encode(["error" => "Server misconfiguration: API key missing"]));
}
