<?php

include "backend.php";

 function titleToSlug($title)
{
    // Convert to lowercase
    $slug = strtolower($title);

    // Replace special characters and accents
    $slug = str_replace(['à', 'á', 'â', 'ã', 'ä', 'å'], 'a', $slug);
    $slug = str_replace(['è', 'é', 'ê', 'ë'], 'e', $slug);
    $slug = str_replace(['ì', 'í', 'î', 'ï'], 'i', $slug);
    $slug = str_replace(['ò', 'ó', 'ô', 'õ', 'ö'], 'o', $slug);
    $slug = str_replace(['ù', 'ú', 'û', 'ü'], 'u', $slug);
    $slug = str_replace(['ç'], 'c', $slug);
    $slug = str_replace(['ñ'], 'n', $slug);

    // Remove special characters except spaces and hyphens
    $slug = preg_replace('/[^a-z0-9\s\-]/', '', $slug);

    // Replace spaces with hyphens
    $slug = preg_replace('/\s+/', '-', $slug);

    // Remove multiple consecutive hyphens
    $slug = preg_replace('/-+/', '-', $slug);

    // Trim hyphens from start and end
    $slug = trim($slug, '-');

    return $slug;
}
function fetchArticleBySlug($slug)
{
    $baseUrl = getBaseUrl();
    // $url = $baseUrl . "/admin/cms.php/Records?category_id=1&q=" . urlencode($slug) . "&search_type=slug";
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
    $url = $baseUrl . $adminPath . "/cms.php/Records?category_id=1&q=" . urlencode($slug) . "&search_type=slug";
    echo "<script>console.log('Debug from PHP: " . $url . "');</script>";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_error($ch)) {
        curl_close($ch);
        error_log("cURL Error: " . curl_error($ch));
        return null;
    }

    curl_close($ch);

    if ($httpCode === 200) {
        $data = json_decode($response, true);

        // Debug: Log the API response
        error_log("API Response: " . $response);
        error_log("Looking for slug: " . $slug);

        if ($data && $data['success'] && isset($data['data']['items']) && !empty($data['data']['items'])) {
            // Find exact slug match
            foreach ($data['data']['items'] as $article) {
                error_log("Checking article slug: " . ($article['slug'] ?? 'undefined'));
                if (isset($article['slug']) && $article['slug'] === $slug) {
                    error_log("Found matching article!");
                    return $article;
                }
            }

            // If no exact match, try partial match (for debugging)
            foreach ($data['data']['items'] as $article) {
                if (isset($article['slug']) && strpos($article['slug'], $slug) !== false) {
                    error_log("Found partial match, returning: " . $article['slug']);
                    return $article;
                }
            }
        } else {
            error_log("No valid data found in API response");
        }
    } else {
        error_log("HTTP Error: " . $httpCode);
    }

    return null;
}
$requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$scriptName = $_SERVER['SCRIPT_NAME'];

// Debug information
error_log("REQUEST_URI: " . $_SERVER['REQUEST_URI']);
error_log("SCRIPT_NAME: " . $scriptName);
error_log("Parsed URI: " . $requestUri);

// Extract the slug from the URL
$articleSlug = '';
$article = null;

// Check if the request is for blog.php with a slug
if (preg_match('#^(.*/)?blog\.php/(.+)$#', $requestUri, $matches)) {
    $articleSlug = trim($matches[2], '/');
    error_log("Extracted slug: " . $articleSlug);

    if (!empty($articleSlug)) {
        $article = fetchArticleBySlug($articleSlug);
    }
} else {
    // If no slug is provided, show 404
    http_response_code(404);
    header('HTTP/1.1 404 Not Found');
    exit('<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page introuvable - 404 | MaxMind Blog</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="text-center">
        <h1 class="text-6xl font-bold text-gray-900 mb-4">404</h1>
        <h2 class="text-2xl font-semibold text-gray-700 mb-6">Page introuvable</h2>
        <p class="text-gray-600 mb-8">L\'URL que vous avez demandée n\'existe pas ou a été déplacée.</p>
        <a href="blogs.php" class="inline-block px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
            Retour au blog
        </a>
    </div>
</body>
</html>');
}

// Debug mode (remove in production)
$debugMode = isset($_GET['debug']) && $_GET['debug'] === '1';

if (!$article) {
    if ($debugMode) {
        echo "<!-- DEBUG: No article found for slug: " . htmlspecialchars($articleSlug) . " -->";
    }

    // Show 404 page instead of default article
    http_response_code(404);
    header('HTTP/1.1 404 Not Found');
    exit('<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Article introuvable - 404 | MaxMind Blog</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="text-center">
        <h1 class="text-6xl font-bold text-gray-900 mb-4">404</h1>
        <h2 class="text-2xl font-semibold text-gray-700 mb-6">Article introuvable</h2>
        <p class="text-gray-600 mb-8">L\'article que vous recherchez n\'existe pas ou a été déplacé.</p>
        <p class="text-gray-500 mb-8">Slug recherché: <code>' . htmlspecialchars($articleSlug) . '</code></p>
        <a href="blogs.php" class="inline-block px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
            Retour au blog
        </a>
    </div>
</body>
</html>');
} else {
    if ($debugMode) {
        echo "<!-- DEBUG: Article found: " . json_encode($article) . " -->";
    }
}
// Debug mode (remove in production)
$debugMode = isset($_GET['debug']) && $_GET['debug'] === '1';

if (!$article) {
    if ($debugMode) {
        echo "<!-- DEBUG: No article found for slug: " . htmlspecialchars($articleSlug) . " -->";
    }

    // Default article data if none found
    $article = [
        'values' => [
            'title' => $articleSlug ?: 'Article introuvable',
            'description' => 'L\'article que vous recherchez n\'a pas été trouvé. Il se peut qu\'il ait été déplacé ou supprimé.',
            'content' => 'L\'article que vous recherchez n\'a pas été trouvé. Il se peut qu\'il ait été déplacé ou supprimé.',
            'image' => './imgs/opure.png'
        ],
        'created_at' => date('Y-m-d H:i:s'),
        'id' => 0,
        'slug' => $articleSlug
    ];
} else {
    if ($debugMode) {
        echo "<!-- DEBUG: Article found: " . json_encode($article) . " -->";
    }
}

// Extract article data
$articleTitle = $article['values'][0];
$articleDescription = is_array($article['values'][1]) ? implode(' ', $article['values'][1]) : $article['values'][1];
$articleContent = isset($article['values'][2]) ? (is_array($article['values'][2]) ? implode('', $article['values'][2]) : $article['values'][2]) : $articleDescription;
$articleImage = isset($article['values'][3]) ? (is_array($article['values'][3]) ? $article['values'][3][0] : $article['values'][3]) : './imgs/opure.png';
$articleDate = isset($article['created_at']) ? $article['created_at'] : date('Y-m-d');
$articleId = isset($article['id']) ? $article['id'] : 1;

// Format date
$formattedDate = date('d F Y', strtotime($articleDate));

// Generate meta description
$metaDescription = strlen($articleDescription) > 150 ? substr($articleDescription, 0, 147) . '...' : $articleDescription;

// Fetch first 6 articles for "Autres Articles" section (excluding current article)
function fetchOtherArticles($currentArticleId = null)
{
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
    $url = $baseUrl . $adminPath . "/cms.php/Records?category_id=1&page=1&per_page=7";
    echo "<script>console.log('Debug from PHP777: " . $url . "');</script>";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_error($ch)) {
        curl_close($ch);
        return [];
    }

    curl_close($ch);

    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && $data['success'] && isset($data['data']['items'])) {
            $articles = $data['data']['items'];

            // Filter out articles without images
            $articles = array_filter($articles, function($article) {
                return isset($article['values'][3]) && !empty($article['values'][3]);
            });

            // Filter out current article if ID is provided
            if ($currentArticleId) {
                $articles = array_filter($articles, function ($article) use ($currentArticleId) {
                    return $article['id'] != $currentArticleId;
                });
            }

            // Return first 6 articles
            return array_slice(array_values($articles), 0, 6);
        }
    }

    return [];
}

$otherArticles = fetchOtherArticles($articleId);

// Helper functions for other articles
function getCategoryInfoForOtherArticles($title)
{
    $title_lower = strtolower($title);

    if (strpos($title_lower, 'seo') !== false || strpos($title_lower, 'sem') !== false) {
        return ['name' => 'SEO', 'color' => 'bg-[#01acb6]', 'cat' => 'seo'];
    } elseif (strpos($title_lower, 'social') !== false || strpos($title_lower, 'instagram') !== false || strpos($title_lower, 'facebook') !== false) {
        return ['name' => 'Social Media', 'color' => 'bg-[#EF234B]', 'cat' => 'social'];
    } elseif (strpos($title_lower, 'web') !== false || strpos($title_lower, 'dev') !== false || strpos($title_lower, 'site') !== false) {
        return ['name' => 'Développement', 'color' => 'bg-[#01acb6]', 'cat' => 'dev'];
    } elseif (strpos($title_lower, 'design') !== false || strpos($title_lower, 'brand') !== false) {
        return ['name' => 'Design & Branding', 'color' => 'bg-[#EF234B]', 'cat' => 'branding'];
    } elseif (strpos($title_lower, 'marketing') !== false) {
        return ['name' => 'Marketing', 'color' => 'bg-[#01acb6]', 'cat' => 'marketing'];
    } else {
        return ['name' => 'Business', 'color' => 'bg-slate-600', 'cat' => 'business'];
    }
}

function formatDateForOtherArticles($dateString)
{
    $date = new DateTime($dateString);
    $months = [
        '01' => 'Jan',
        '02' => 'Fév',
        '03' => 'Mar',
        '04' => 'Avr',
        '05' => 'Mai',
        '06' => 'Juin',
        '07' => 'Juil',
        '08' => 'Août',
        '09' => 'Sep',
        '10' => 'Oct',
        '11' => 'Nov',
        '12' => 'Déc'
    ];

    $day = $date->format('d');
    $month = $months[$date->format('m')];
    $year = $date->format('Y');

    return "{$day} {$month} {$year}";
}

function generateExcerptForOtherArticles($content, $length = 80)
{
    $content = strip_tags($content);
    if (strlen($content) <= $length) {
        return $content;
    }
    return substr($content, 0, $length) . '...';
}
?>