<?php

include "backend.php";
if (isset($_GET['ajax']) && $_GET['ajax'] === '1') {
    header('Content-Type: application/json');

    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $search = isset($_GET['search']) ? trim($_GET['search']) : '';
    $category_filter = isset($_GET['category']) ? trim($_GET['category']) : '';
    $tag_filter = isset($_GET['tag']) ? trim($_GET['tag']) : '';
    $filter_category_id = isset($_GET['filter_category_id']) ? trim($_GET['filter_category_id']) : '';
    $sort = isset($_GET['sort']) ? trim($_GET['sort']) : 'new';

    // Fetch blog data
    $blogData = fetchBlogData($page, 8, $search, 1, $tag_filter, $filter_category_id);
    $articles = $blogData['success'] ? $blogData['data']['items'] : [];
    $pagination = $blogData['success'] ? $blogData['data']['pagination'] : ['total' => 0, 'page' => 1, 'per_page' => 8];

    // Filter out articles without images
    $articles = array_filter($articles, function($article) {
        return isset($article['values'][3]) && !empty($article['values'][3]);
    });
    $articles = array_values($articles); // Reset array keys
    $pagination['total'] = count($articles);

    // Client-side filtering by category if needed
    if (!empty($category_filter) && $category_filter !== 'all') {
        $articles = array_filter($articles, function($article) use ($category_filter) {
            $categoryInfo = getCategoryInfo($article['values'][0]);
            return $categoryInfo['cat'] === $category_filter;
        });
        // Reset array keys
        $articles = array_values($articles);
        // Update pagination count for filtered results
        $pagination['total'] = count($articles);
    }

    // Client-side search filtering if search parameter provided
    if (!empty($search)) {
        $articles = array_filter($articles, function($article) use ($search) {
            $title = $article['values'][0] ?? '';
            $content = is_array($article['values'][2]) ? implode(' ', $article['values'][2]) : ($article['values'][2] ?? '');
            $tags = isset($article['values'][4]) ?
                (is_array($article['values'][4]) ? implode(' ', $article['values'][4]) : $article['values'][4]) : '';

            // Search in title, content, and tags
            return stripos($title, $search) !== false ||
                   stripos($content, $search) !== false ||
                   stripos($tags, $search) !== false;
        });
        // Reset array keys
        $articles = array_values($articles);
        // Update pagination count for filtered results
        $pagination['total'] = count($articles);
    }

    // Apply sorting
    if ($sort === 'popular') {
        usort($articles, function($a, $b) {
            return intval($b['id']) - intval($a['id']);
        });
    } elseif ($sort === 'relevant' && !empty($search)) {
        // Sort by relevance (articles with search term in title first)
        usort($articles, function($a, $b) use ($search) {
            $aRelevant = stripos($a['values'][0], $search) !== false ? 1 : 0;
            $bRelevant = stripos($b['values'][0], $search) !== false ? 1 : 0;
            return $bRelevant - $aRelevant;
        });
    }
    // 'new' is default - already sorted by created_at DESC from API

    // Generate HTML for articles
    ob_start();
    $articlesHtml = ob_get_clean();

    // Generate pagination HTML
    ob_start();
    $paginationHtml = ob_get_clean();

    // Return JSON response
    echo json_encode([
        'success' => true,
        'articles_html' => $articlesHtml,
        'pagination_html' => $paginationHtml,
        'total' => $pagination['total'],
        'current_page' => $pagination['page'],
        'category_filter' => $category_filter,
        'filter_category_id' => $filter_category_id,
        'tag_filter' => $tag_filter,
        'search' => $search,
        'sort' => $sort
    ]);
    exit;
}

// Function to convert title to URL-friendly format
function titleToSlug($title) {
    // Convert to lowercase
    $slug = strtolower($title);

    // Replace special characters and accents
    $slug = str_replace(['à', 'á', 'â', 'ã', 'ä', 'å'], 'a', $slug);
    $slug = str_replace(['è', 'é', 'ê', 'ë'], 'e', $slug);
    $slug = str_replace(['ì', 'í', 'î', 'ï'], 'i', $slug);
    $slug = str_replace(['ò', 'ó', 'ô', 'õ', 'ö'], 'o', $slug);
    $slug = str_replace(['ù', 'ú', 'û', 'ü'], 'u', $slug);
    $slug = str_replace(['ç'], 'c', $slug);
    $slug = str_replace(['ñ'], 'n', $slug);

    // Remove special characters except spaces and hyphens
    $slug = preg_replace('/[^a-z0-9\s\-]/', '', $slug);

    // Replace spaces with hyphens
    $slug = preg_replace('/\s+/', '-', $slug);

    // Remove multiple consecutive hyphens
    $slug = preg_replace('/-+/', '-', $slug);

    // Trim hyphens from start and end
    $slug = trim($slug, '-');

    return $slug;
}

function fetchCategories() {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin/';
    $url = $baseUrl . $adminPath . "/cms.php/Records?category_id=3";
    if (!isset($_GET['ajax']) || $_GET['ajax'] !== '1') {
        echo "<script>console.log('Debug from PHP: " . $url . "');</script>";
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_error($ch)) {
        curl_close($ch);
        return [];
    }

    curl_close($ch);

    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && $data['success'] && isset($data['data']['items'])) {
            return $data['data']['items'];
        }
    }

    return [];
}

// Get parameters from URL
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$category_filter = isset($_GET['category']) ? trim($_GET['category']) : '';
$tag_filter = isset($_GET['tag']) ? trim($_GET['tag']) : '';
$filter_category_id = isset($_GET['filter_category_id']) ? trim($_GET['filter_category_id']) : '';

// Fetch blog data and categories
$blogData = fetchBlogData($page, 8, $search, 1, $tag_filter, $filter_category_id);
$categories = fetchCategories();
$articles = $blogData['success'] ? $blogData['data']['items'] : [];
$pagination = $blogData['success'] ? $blogData['data']['pagination'] : ['total' => 0, 'page' => 1, 'per_page' => 8];

// Filter out articles without images
$articles = array_filter($articles, function($article) {
    return isset($article['values'][3]) && !empty($article['values'][3]);
});
$articles = array_values($articles); // Reset array keys
$pagination['total'] = count($articles);

// Client-side search filtering if search parameter provided
if (!empty($search)) {
    $articles = array_filter($articles, function($article) use ($search) {
        $title = $article['values'][0] ?? '';
        $content = is_array($article['values'][2]) ? implode(' ', $article['values'][2]) : ($article['values'][2] ?? '');
        $tags = isset($article['values'][4]) ?
            (is_array($article['values'][4]) ? implode(' ', $article['values'][4]) : $article['values'][4]) : '';

        // Search in title, content, and tags
        return stripos($title, $search) !== false ||
               stripos($content, $search) !== false ||
               stripos($tags, $search) !== false;
    });
    // Reset array keys
    $articles = array_values($articles);
    // Update pagination count for filtered results
    $pagination['total'] = count($articles);
}

// Debug logging
error_log("Blog Data Success: " . ($blogData['success'] ? 'true' : 'false'));
error_log("Articles Count: " . count($articles));
if (count($articles) > 0) {
    error_log("First Article: " . json_encode($articles[0]));
}

// Fetch first 6 articles for "Autres Articles" section
$otherArticlesData = fetchBlogData(1, 6, '', 1, '');
$otherArticles = $otherArticlesData['success'] ? $otherArticlesData['data']['items'] : [];

// Filter out articles without images
$otherArticles = array_filter($otherArticles, function($article) {
    return isset($article['values'][3]) && !empty($article['values'][3]);
});
$otherArticles = array_values($otherArticles); // Reset array keys

// Client-side filtering by category if needed
if (!empty($category_filter) && $category_filter !== 'all') {
    $articles = array_filter($articles, function($article) use ($category_filter) {
        $categoryInfo = getCategoryInfo($article['values'][0]);
        return $categoryInfo['cat'] === $category_filter;
    });
    // Reset array keys
    $articles = array_values($articles);
    // Update pagination count for filtered results
    $pagination['total'] = count($articles);
}

// Category mapping for filtering
$categoryMapping = [
    'all' => 'All',
    'marketing' => 'Digital Marketing & Strategy',
    'seo' => 'SEO & SEM',
    'social' => 'Social Media Management',
    'dev' => 'Web Development & Mobile Apps',
    'branding' => 'Branding & Design',
    'business' => 'Business Tools & Case Studies'
];

// Function to get category badge color and name
function getCategoryInfo($title) {
    $title_lower = strtolower($title);

    if (strpos($title_lower, 'seo') !== false || strpos($title_lower, 'sem') !== false) {
        return ['name' => 'SEO', 'color' => 'bg-[#01acb6]', 'cat' => 'seo'];
    } elseif (strpos($title_lower, 'social') !== false || strpos($title_lower, 'instagram') !== false || strpos($title_lower, 'facebook') !== false) {
        return ['name' => 'Social Media', 'color' => 'bg-[#EF234B]', 'cat' => 'social'];
    } elseif (strpos($title_lower, 'web') !== false || strpos($title_lower, 'dev') !== false || strpos($title_lower, 'site') !== false) {
        return ['name' => 'Développement', 'color' => 'bg-[#01acb6]', 'cat' => 'dev'];
    } elseif (strpos($title_lower, 'design') !== false || strpos($title_lower, 'brand') !== false) {
        return ['name' => 'Branding', 'color' => 'bg-[#EF234B]', 'cat' => 'branding'];
    } elseif (strpos($title_lower, 'marketing') !== false) {
        return ['name' => 'Marketing', 'color' => 'bg-[#01acb6]', 'cat' => 'marketing'];
    } else {
        return ['name' => 'Business', 'color' => 'bg-slate-600', 'cat' => 'business'];
    }
}

// Function to format date
function formatDate($dateString) {
    $date = new DateTime($dateString);
    $months = [
        '01' => 'Jan', '02' => 'Fév', '03' => 'Mar', '04' => 'Avr',
        '05' => 'Mai', '06' => 'Juin', '07' => 'Juil', '08' => 'Août',
        '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Déc'
    ];

    $day = $date->format('d');
    $month = $months[$date->format('m')];
    $year = $date->format('Y');

    return "{$day} {$month} {$year}";
}

// Function to generate excerpt from content
function generateExcerpt($content, $length = 100) {
    $content = strip_tags($content);
    if (strlen($content) <= $length) {
        return $content;
    }
    return substr($content, 0, $length) . '...';
}
?>