<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');

// Log the request for debugging
error_log('========================================');
error_log('load_more_projects.php called');
error_log('GET params: ' . print_r($_GET, true));
error_log('========================================');

include __DIR__ . '/../admin/config.php';

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];
    $basePath = dirname(dirname($script)); // Go up one level from backend
    return $protocol . $host . $basePath;
}

function fetchProjects($page = 1, $per_page = 10, $type = 'all') {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : '/admin';
    $category_id = 4; // Projects category

    // Fetch with larger per_page to get all items, then filter by type
    $url = "{$baseUrl}{$adminPath}/cms.php/Records?category_id={$category_id}&page=1&per_page=100";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200 || !$response) {
        return [
            'success' => false,
            'message' => 'Failed to fetch projects',
            'data' => [
                'items' => [],
                'pagination' => [
                    'current_page' => $page,
                    'total_pages' => 0,
                    'per_page' => $per_page,
                    'total' => 0,
                    'has_more' => false
                ]
            ]
        ];
    }

    $data = json_decode($response, true);

    if (!$data || !isset($data['success']) || !$data['success']) {
        return [
            'success' => false,
            'message' => 'Invalid response from API',
            'data' => [
                'items' => [],
                'pagination' => [
                    'current_page' => $page,
                    'total_pages' => 0,
                    'per_page' => $per_page,
                    'total' => 0,
                    'has_more' => false
                ]
            ]
        ];
    }

    // Filter by type (values[5]) - support 'all', '8' (Design), '11' (Web), or both
    $allItems = $data['data']['items'] ?? [];
    $filteredItems = array_filter($allItems, function($item) use ($type) {
        if ($type === 'all') {
            // Show both Design (8) and Web (11) projects
            return isset($item['values'][5]) && ($item['values'][5] == 8 || $item['values'][5] == 11);
        } else {
            // Filter by specific type
            return isset($item['values'][5]) && $item['values'][5] == $type;
        }
    });

    // Reset array keys
    $filteredItems = array_values($filteredItems);
    $total = count($filteredItems);

    // Calculate pagination
    $totalPages = ceil($total / $per_page);
    $offset = ($page - 1) * $per_page;
    $items = array_slice($filteredItems, $offset, $per_page);

    return [
        'success' => true,
        'data' => [
            'items' => $items,
            'pagination' => [
                'current_page' => $page,
                'total_pages' => $totalPages,
                'per_page' => $per_page,
                'total' => $total,
                'has_more' => $page < $totalPages
            ]
        ]
    ];
}

// Get parameters from request
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$per_page = isset($_GET['per_page']) ? max(1, min(50, (int)$_GET['per_page'])) : 10;
$type = isset($_GET['type']) ? $_GET['type'] : 'all'; // Default to all projects (both 8 and 11)

error_log('Parsed parameters:');
error_log('  Page: ' . $page);
error_log('  Per page: ' . $per_page);
error_log('  Type: ' . $type);

// Fetch and return projects
$result = fetchProjects($page, $per_page, $type);

error_log('Result:');
error_log('  Success: ' . ($result['success'] ? 'true' : 'false'));
error_log('  Items count: ' . count($result['data']['items']));
error_log('  Total: ' . ($result['data']['pagination']['total'] ?? 0));
error_log('========================================');

echo json_encode($result);
?>
