<?php include "backend/blogs.php" ?>
<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MaxMind Blog | Portfolio website, company showcase, professional design</title>
    <meta name="description"
        content="Découvrez comment notre portfolio website valorise la company showcase de MaxMind: professional design, UX moderne, projets innovants et réussites clients.">
    <meta name="keywords"
        content="portfolio website, company showcase, professional design, site vitrine, UX, UI, agence digitale Maroc, MaxMind">

    <meta property="og:title" content="MaxMind Blog | Portfolio Website & Company Showcase">
    <meta property="og:description"
        content="Un professional design qui met en lumière nos projets, notre expertise et nos succès clients.">
    <meta property="og:type" content="blog">
    <meta property="og:url" content="<?php echo htmlspecialchars(getBaseUrl() . '/blogs.php'); ?>">
    <meta property="og:site_name" content="MaxMind Blog">
    <meta property="og:locale" content="fr_FR">
    <meta property="og:image" content="<?php echo htmlspecialchars(getBaseUrl()); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="MaxMind Blog - Articles et Insights">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="MaxMind Blog | Portfolio Website & Company Showcase">
    <meta name="twitter:description" content="Un professional design qui met en lumière nos projets, notre expertise et nos succès clients.">
    <meta name="twitter:image" content="<?php echo htmlspecialchars(getBaseUrl()); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta name="twitter:image:alt" content="MaxMind Blog - Articles et Insights">
    <meta name="twitter:site" content="@MaxMindMA">
    <meta name="twitter:creator" content="@MaxMindMA">

    <!-- Enhanced SEO Meta Tags -->
    <link rel="canonical" href="<?php echo htmlspecialchars(getBaseUrl() . '/blogs.php' . (!empty($_GET) ? '?' . http_build_query($_GET) : '')); ?>">
    <meta name="author" content="MaxMind">
    <meta name="publisher" content="MaxMind">
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="theme-color" content="#01acb6">
    <meta name="msapplication-TileColor" content="#01acb6">
    <meta name="language" content="French">
    <meta name="geo.region" content="MA">
    <meta name="geo.placename" content="Casablanca">
    <meta name="geo.position" content="33.5731;-7.5898">
    <meta name="ICBM" content="33.5731, -7.5898">
    <meta name="rating" content="General">
    <meta name="distribution" content="Global">
    <meta name="revisit-after" content="3 days">

    <!-- RSS Feed -->
    <link rel="alternate" type="application/rss+xml" title="MaxMind Blog RSS Feed" href="<?php echo htmlspecialchars(getBaseUrl()); ?>/rss.xml">

    <!-- Pagination Meta Tags -->
    <?php if (isset($_GET['page']) && $_GET['page'] > 1): ?>
        <link rel="prev" href="<?php echo htmlspecialchars(getBaseUrl() . '/blogs.php' . ($_GET['page'] > 2 ? '?page=' . ($_GET['page'] - 1) : '')); ?>">
    <?php endif; ?>
    <?php if (isset($pagination) && $pagination['page'] < ceil($pagination['total'] / $pagination['per_page'])): ?>
        <link rel="next" href="<?php echo htmlspecialchars(getBaseUrl() . '/blogs.php?page=' . ($pagination['page'] + 1)); ?>">
    <?php endif; ?>

    <!-- Blog Specific Meta Tags -->
    <?php if ($articles): ?>
        <meta name="blog:total_articles" content="<?php echo $pagination['total'] ?? count($articles); ?>">
        <meta name="blog:articles_per_page" content="<?php echo $pagination['per_page'] ?? 8; ?>">
        <meta name="blog:current_page" content="<?php echo $pagination['page'] ?? 1; ?>">
        <meta name="blog:articles_displayed" content="<?php echo count($articles); ?>">

        <?php
        $blog_categories = [];
        $blog_tags = [];
        $article_authors = [];
        foreach ($articles as $article) {
            $categoryInfo = getCategoryInfo($article['values'][0]);
            if (!in_array($categoryInfo['cat'], $blog_categories)) {
                $blog_categories[] = $categoryInfo['cat'];
            }
            if (isset($article['values']['tags'])) {
                $tags = is_array($article['values']['tags']) ? $article['values']['tags'] : explode(',', $article['values']['tags']);
                foreach ($tags as $tag) {
                    $tag = trim($tag);
                    if (!empty($tag) && !in_array($tag, $blog_tags)) {
                        $blog_tags[] = $tag;
                    }
                }
            }
            if (isset($article['values']['author']) && !in_array($article['values']['author'], $article_authors)) {
                $article_authors[] = $article['values']['author'];
            }
        }
        ?>

        <?php if (!empty($blog_categories)): ?>
            <meta name="blog:categories" content="<?php echo htmlspecialchars(implode(', ', $blog_categories)); ?>">
            <meta name="blog:category_count" content="<?php echo count($blog_categories); ?>">
        <?php endif; ?>

        <?php if (!empty($blog_tags)): ?>
            <meta name="blog:tags" content="<?php echo htmlspecialchars(implode(', ', array_slice($blog_tags, 0, 10))); ?>">
            <meta name="blog:tag_count" content="<?php echo count($blog_tags); ?>">
        <?php endif; ?>

        <?php if (!empty($article_authors)): ?>
            <meta name="blog:authors" content="<?php echo htmlspecialchars(implode(', ', $article_authors)); ?>">
            <meta name="blog:author_count" content="<?php echo count($article_authors); ?>">
        <?php endif; ?>
    <?php endif; ?>

    <!-- Search and Filter Meta Tags -->
    <?php if (!empty($search)): ?>
        <meta name="blog:search_query" content="<?php echo htmlspecialchars($search); ?>">
    <?php endif; ?>

    <?php if (!empty($category_filter) && $category_filter !== 'all'): ?>
        <meta name="blog:active_category_filter" content="<?php echo htmlspecialchars($category_filter); ?>">
    <?php endif; ?>

    <?php if (!empty($tag_filter)): ?>
        <meta name="blog:active_tag_filter" content="<?php echo htmlspecialchars($tag_filter); ?>">
    <?php endif; ?>

    <!-- Other Articles Meta Data -->
    <?php if ($otherArticles): ?>
        <meta name="blog:other_articles_count" content="<?php echo count($otherArticles); ?>">
    <?php endif; ?>

    <!-- Blog Categories Available -->
    <meta name="blog:available_categories" content="<?php echo htmlspecialchars(implode(', ', array_keys($categoryMapping))); ?>">

    <link rel="stylesheet" href="css/index.css">

    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "Blog",
            "name": "MaxMind Blog",
            "alternateName": "Blog MaxMind Maroc",
            "description": "Blog technique et insights sur le développement web, design, marketing digital et innovation technologique au Maroc",
            "url": "<?php echo htmlspecialchars(getBaseUrl() . '/blogs.php'); ?>",
            "mainEntityOfPage": {
                "@type": "WebPage",
                "@id": "<?php echo htmlspecialchars(getBaseUrl() . '/blogs.php'); ?>"
            },
            "inLanguage": "fr-MA",
            "keywords": "blog technique Maroc, développement web, marketing digital, SEO Maroc, design UI/UX",
            "author": {
                "@type": "Organization",
                "name": "MaxMind",
                "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>",
                "sameAs": [
                    "https://www.linkedin.com/company/maxmind-ma",
                    "https://www.facebook.com/maxmind.ma",
                    "https://www.instagram.com/maxmind.ma"
                ]
            },
            "publisher": {
                "@type": "Organization",
                "name": "MaxMind",
                "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>",
                "logo": {
                    "@type": "ImageObject",
                    "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>/imgs/LOGO_MAXMIND_BLACK.png",
                    "width": 300,
                    "height": 300
                }
            },
            "potentialAction": {
                "@type": "SearchAction",
                "target": "<?php echo htmlspecialchars(getBaseUrl()); ?>/blogs.php?search={search_term_string}",
                "query-input": "required name=search_term_string"
            }
            <?php if ($articles): ?>,
                "blogPost": [
                    <?php foreach (array_slice($articles, 0, 5) as $index => $article): ?> {
                            "@type": "BlogPosting",
                            "headline": "<?php echo htmlspecialchars($article['values'][0] ?? ''); ?>",
                            "description": "<?php echo htmlspecialchars(generateExcerpt($article['values'][1] ?? '', 160)); ?>",
                            "url": "<?php echo htmlspecialchars(getBaseUrl() . '/blog.php/' . titleToSlug($article['values'][0] ?? '')); ?>",
                            "datePublished": "<?php echo htmlspecialchars($article['created_at'] ?? ''); ?>",
                            "dateModified": "<?php echo htmlspecialchars($article['updated_at'] ?? $article['created_at'] ?? ''); ?>",
                            "author": {
                                "@type": "Organization",
                                "name": "MaxMind"
                            },
                            "publisher": {
                                "@type": "Organization",
                                "name": "MaxMind",
                                "logo": {
                                    "@type": "ImageObject",
                                    "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>/imgs/LOGO_MAXMIND_BLACK.png"
                                }
                            },
                            "mainEntityOfPage": {
                                "@type": "WebPage",
                                "@id": "<?php echo htmlspecialchars(getBaseUrl() . '/blog.php/' . titleToSlug($article['values'][0] ?? '')); ?>"
                            },
                            "inLanguage": "fr-MA"
                            <?php if (isset($article['values'][2])): ?>,
                                "image": {
                                    "@type": "ImageObject",
                                    "url": "<?php echo htmlspecialchars($article['values'][2]); ?>",
                                    "width": 1200,
                                    "height": 630
                                }
                            <?php endif; ?>
                        }
                        <?php echo $index < min(4, count($articles) - 1) ? ',' : ''; ?>
                    <?php endforeach; ?>
                ] <?php endif; ?>
        }
    </script>

    <!-- FAQ Schema for Blog -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "FAQPage",
            "mainEntity": [{
                "@type": "Question",
                "name": "Qu'est-ce que le blog MaxMind?",
                "acceptedAnswer": {
                    "@type": "Answer",
                    "text": "Le blog MaxMind est une ressource complète d'articles techniques sur le développement web, le marketing digital, le SEO et l'innovation technologique au Maroc."
                }
            }, {
                "@type": "Question",
                "name": "À quelle fréquence publiez-vous des articles?",
                "acceptedAnswer": {
                    "@type": "Answer",
                    "text": "Nous publions régulièrement de nouveaux articles techniques et insights sur les dernières tendances du digital au Maroc."
                }
            }]
        }
    </script>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- GSAP + ScrollTrigger -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">

    <!-- Canvas Animations -->
    <script src="./canvas-animations.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Roboto', 'system-ui', '-apple-system', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'gradient-shift': 'gradient-shift 8s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                        'blob-shift': 'blob-shift 20s ease-in-out infinite',
                        'blob-pulse': 'blob-pulse 8s ease-in-out infinite',
                        'light-wave': 'light-wave 15s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'blob-shift': {
                            '0%, 100%': {
                                transform: 'translate(0px, 0px) scale(1)'
                            },
                            '33%': {
                                transform: 'translate(30px, -30px) scale(1.1)'
                            },
                            '66%': {
                                transform: 'translate(-20px, 20px) scale(0.9)'
                            },
                        },
                        'blob-pulse': {
                            '0%, 100%': {
                                transform: 'scale(1)',
                                opacity: '0.6'
                            },
                            '50%': {
                                transform: 'scale(1.15)',
                                opacity: '0.8'
                            },
                        },
                        'light-wave': {
                            '0%, 100%': {
                                transform: 'translate(0px, 0px) rotate(0deg)',
                                opacity: '0.4'
                            },
                            '25%': {
                                transform: 'translate(40px, -40px) rotate(5deg)',
                                opacity: '0.7'
                            },
                            '50%': {
                                transform: 'translate(20px, 30px) rotate(-3deg)',
                                opacity: '0.5'
                            },
                            '75%': {
                                transform: 'translate(-30px, -20px) rotate(3deg)',
                                opacity: '0.8'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'gradient-shift': {
                            '0%, 100%': {
                                backgroundPosition: '0% 50%'
                            },
                            '50%': {
                                backgroundPosition: '100% 50%'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>

</head>

<body class="bg-white text-slate-800" style="margin: 0; padding: 0; width: 100%; height: 100%;">
    <?php include 'header.php'; ?>
    <?php include 'social-floating.php'; ?>

    <div class="social-floating">
        <a href="https://wa.me/212 620 15 12 53" target="_blank" rel="noopener noreferrer" class="social-whatsapp"
            title="WhatsApp">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                <path
                    d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.465 3.488" />
            </svg>
        </a>
    </div>

    <!-- Hero Section with Modern Gradient Design -->
    <section class="hero-section relative flex items-center justify-center overflow-hidden min-h-screen bg-black">
        <!-- Animated gradient blobs background -->
        <div class="absolute inset-0 w-full h-full" style="z-index: 1;">
            <!-- Large gradient blob - top left (orange to pink) -->
            <div class="absolute top-0 left-0 w-[600px] h-[600px] rounded-full blur-[120px] animate-blob-shift"
                 style="background: radial-gradient(circle, rgba(255, 107, 0, 0.8) 0%, rgba(255, 20, 147, 0.6) 50%, rgba(139, 0, 139, 0.4) 100%); animation-delay: 0s;"></div>

            <!-- Large gradient blob - top right (pink to red) -->
            <div class="absolute top-20 right-0 w-[700px] h-[700px] rounded-full blur-[130px] animate-blob-pulse"
                 style="background: radial-gradient(circle, rgba(255, 0, 128, 0.9) 0%, rgba(255, 69, 58, 0.7) 50%, rgba(255, 107, 0, 0.4) 100%); animation-delay: 2s;"></div>

            <!-- Medium gradient blob - bottom left (orange to brown) -->
            <div class="absolute bottom-0 left-20 w-[500px] h-[500px] rounded-full blur-[100px] animate-light-wave"
                 style="background: radial-gradient(circle, rgba(255, 140, 0, 0.7) 0%, rgba(139, 69, 19, 0.5) 50%, rgba(80, 40, 10, 0.3) 100%); animation-delay: 5s;"></div>

            <!-- Medium gradient blob - center right (pink to purple) -->
            <div class="absolute top-1/2 right-10 w-[550px] h-[550px] rounded-full blur-[110px] animate-blob-shift"
                 style="background: radial-gradient(circle, rgba(255, 20, 147, 0.8) 0%, rgba(186, 85, 211, 0.6) 50%, rgba(138, 43, 226, 0.4) 100%); animation-delay: 3s;"></div>

            <!-- Small accent blob - middle left (bright pink) -->
            <div class="absolute top-1/3 left-1/4 w-[400px] h-[400px] rounded-full blur-[90px] animate-blob-pulse"
                 style="background: radial-gradient(circle, rgba(255, 0, 255, 0.9) 0%, rgba(255, 20, 147, 0.6) 100%); animation-delay: 1s;"></div>

            <!-- Additional light effect blobs for more dynamic animation -->
            <div class="absolute top-1/4 right-1/3 w-[350px] h-[350px] rounded-full blur-[100px] animate-light-wave"
                 style="background: radial-gradient(circle, rgba(255, 69, 58, 0.6) 0%, rgba(255, 107, 0, 0.3) 100%); animation-delay: 7s;"></div>

            <div class="absolute bottom-1/4 right-1/4 w-[450px] h-[450px] rounded-full blur-[110px] animate-blob-pulse"
                 style="background: radial-gradient(circle, rgba(255, 20, 147, 0.7) 0%, rgba(255, 0, 128, 0.4) 100%); animation-delay: 4s;"></div>
        </div>

        <!-- Dark overlay for text contrast -->
        <div class="absolute inset-0 w-full h-full bg-gradient-to-br from-black/60 via-black/40 to-black/70" style="z-index: 2;"></div>

        <!-- Content Container -->
        <div class="relative text-left text-white px-6 sm:px-12 md:px-16 max-w-7xl w-full" style="z-index: 10;">
            <div class="max-w-4xl">
                <!-- Hero Title -->
                <h1 class="text-5xl sm:text-6xl md:text-7xl lg:text-8xl font-black mb-6 leading-tight tracking-tight">
                    <span class="block text-white">
                        MaxMind
                    </span>
                    <span class="block text-white mt-2">
                        Blog
                    </span>
                </h1>

                <!-- Subtitle -->
                <p class="text-xl sm:text-2xl md:text-3xl mb-12 leading-relaxed text-white/90 font-light max-w-3xl">
                    Découvrez nos insights, stratégies et analyses pour exceller dans le marketing digital
                </p>

                <!-- Decorative line -->
                <div class="w-32 h-1 bg-white mb-12"></div>
            </div>
        </div>

        <!-- Scroll Indicator -->
        <a href="#articles" class="scroll-indicator absolute bottom-10 right-10 sm:right-16 cursor-pointer group" style="z-index: 10;">
            <div class="w-16 h-16 sm:w-20 sm:h-20 rounded-2xl border-2 border-white/40 flex items-center justify-center bg-white/10 backdrop-blur-sm transition-all duration-300 hover:border-white hover:bg-white/20">
                <i data-lucide="arrow-down" class="w-8 h-8 text-white group-hover:translate-y-1 transition-transform duration-300"></i>
            </div>
        </a>
    </section>

    <section class="py-10 bg-white">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex flex-wrap gap-3">
                <button data-category-id=""
                    class="category-id-filter px-4 py-2 rounded-full transition-all duration-300 <?php echo empty($filter_category_id) ? 'bg-[#01acb6] text-white shadow-lg' : 'bg-slate-100 text-slate-700 hover:bg-slate-200'; ?>">
                    Toutes les catégories
                </button>
                <?php if (!empty($categories)): ?>
                    <?php foreach ($categories as $category): ?>
                        <button data-category-id="<?php echo htmlspecialchars($category['id']); ?>"
                            class="category-id-filter px-4 py-2 rounded-full transition-all duration-300 <?php echo $filter_category_id == $category['id'] ? 'bg-[#01acb6] text-white shadow-lg' : 'bg-slate-100 text-slate-700 hover:bg-slate-200'; ?>">
                            <?php echo htmlspecialchars($category['values'][0]); ?>
                        </button>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <section class="py-10" id="articles">
        <div class="max-w-7xl mx-auto px-6 grid lg:grid-cols-3 gap-10">
            <main class="lg:col-span-2">
                <div class="flex items-center justify-between mb-6">
                    <div>
                        <h2 class="text-2xl font-bold">
                            <?php if (!empty($search)): ?>
                                Résultats pour "<?php echo htmlspecialchars($search); ?>"
                                <span class="text-sm font-normal text-slate-500">(<?php echo $pagination['total']; ?> article<?php echo $pagination['total'] > 1 ? 's' : ''; ?>)</span>
                            <?php elseif (!empty($tag_filter)): ?>
                                Articles avec le tag "#<?php echo htmlspecialchars($tag_filter); ?>"
                                <span class="text-sm font-normal text-slate-500">(<?php echo $pagination['total']; ?> article<?php echo $pagination['total'] > 1 ? 's' : ''; ?>)</span>
                            <?php elseif (!empty($filter_category_id)): ?>
                                <?php
                                $categoryName = 'Articles';
                                foreach ($categories as $cat) {
                                    if ($cat['id'] == $filter_category_id) {
                                        $categoryName = $cat['name'];
                                        break;
                                    }
                                }
                                ?>
                                <?php echo htmlspecialchars($categoryName); ?>
                                <span class="text-sm font-normal text-slate-500">(<?php echo $pagination['total']; ?> article<?php echo $pagination['total'] > 1 ? 's' : ''; ?>)</span>
                            <?php elseif (!empty($category_filter) && $category_filter !== 'all'): ?>
                                <?php echo htmlspecialchars($categoryMapping[$category_filter] ?? 'Articles'); ?>
                                <span class="text-sm font-normal text-slate-500">(<?php echo $pagination['total']; ?> article<?php echo $pagination['total'] > 1 ? 's' : ''; ?>)</span>
                            <?php else: ?>
                                Derniers Articles
                                <span class="text-sm font-normal text-slate-500">(<?php echo $pagination['total']; ?> article<?php echo $pagination['total'] > 1 ? 's' : ''; ?>)</span>
                            <?php endif; ?>
                        </h2>

                        <!-- Active Filters Display -->
                        <?php if (!empty($tag_filter) || !empty($search) || !empty($filter_category_id)): ?>
                            <div class="mt-3 flex flex-wrap gap-2">
                                <?php if (!empty($filter_category_id)): ?>
                                    <div class="flex items-center gap-2 px-3 py-1 bg-blue-600 text-white text-sm rounded-full">
                                        <i data-lucide="folder" class="w-3 h-3"></i>
                                        <?php
                                        $categoryName = 'Catégorie';
                                        foreach ($categories as $cat) {
                                            if ($cat['id'] == $filter_category_id) {
                                                $categoryName = $cat['name'];
                                                break;
                                            }
                                        }
                                        echo htmlspecialchars($categoryName);
                                        ?>
                                        <button onclick="clearCategoryFilter()" class="ml-1 hover:bg-white/20 rounded-full w-4 h-4 flex items-center justify-center">
                                            <i data-lucide="x" class="w-3 h-3"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($tag_filter)): ?>
                                    <div class="flex items-center gap-2 px-3 py-1 bg-[#01acb6] text-white text-sm rounded-full">
                                        <i data-lucide="tag" class="w-3 h-3"></i>
                                        #<?php echo htmlspecialchars($tag_filter); ?>
                                        <button onclick="clearTagFilter()" class="ml-1 hover:bg-white/20 rounded-full w-4 h-4 flex items-center justify-center">
                                            <i data-lucide="x" class="w-3 h-3"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($search)): ?>
                                    <div class="flex items-center gap-2 px-3 py-1 bg-slate-600 text-white text-sm rounded-full">
                                        <i data-lucide="search" class="w-3 h-3"></i>
                                        "<?php echo htmlspecialchars($search); ?>"
                                        <button onclick="clearSearch()" class="ml-1 hover:bg-white/20 rounded-full w-4 h-4 flex items-center justify-center">
                                            <i data-lucide="x" class="w-3 h-3"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="flex items-center gap-3">
                        <div class="relative">
                            <input id="search-input" type="search" placeholder="Rechercher..."
                                value="<?php echo htmlspecialchars($search); ?>"
                                class="px-3 py-2 pr-10 border border-slate-200 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-[#01acb6] focus:border-transparent">
                            <div id="search-spinner" class="absolute right-3 top-1/2 transform -translate-y-1/2 hidden">
                                <div class="animate-spin rounded-full h-4 w-4 border-2 border-[#01acb6] border-t-transparent"></div>
                            </div>
                        </div>
                        <select id="sort-select" class="px-3 py-2 border border-slate-200 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-[#01acb6] focus:border-transparent">
                            <option value="new" <?php echo (!isset($_GET['sort']) || $_GET['sort'] === 'new') ? 'selected' : ''; ?>>Plus récents</option>
                            <option value="popular" <?php echo (isset($_GET['sort']) && $_GET['sort'] === 'popular') ? 'selected' : ''; ?>>Plus populaires</option>
                            <option value="relevant" <?php echo (isset($_GET['sort']) && $_GET['sort'] === 'relevant') ? 'selected' : ''; ?>>Pertinents</option>
                        </select>
                        <button id="search-btn" type="button" class="px-4 py-2 bg-[#01acb6] text-white rounded-lg text-sm hover:scale-105 transition-transform">
                            <i data-lucide="search" class="w-4 h-4"></i>
                        </button>
                        <button id="clear-search-btn" class="px-4 py-2 border border-slate-300 text-slate-600 rounded-lg text-sm hover:bg-slate-50 transition-colors <?php echo empty($search) ? 'hidden' : ''; ?>">
                            <i data-lucide="x" class="w-4 h-4"></i>
                        </button>
                    </div>
                </div>

                <!-- Loading overlay -->
                <div id="loading-overlay" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center">
                    <div class="bg-white p-6 rounded-lg shadow-lg flex items-center gap-3">
                        <div class="animate-spin rounded-full h-6 w-6 border-2 border-[#01acb6] border-t-transparent"></div>
                        <span class="text-gray-700">Chargement...</span>
                    </div>
                </div>

                <div id="posts" class="grid sm:grid-cols-2 gap-6 transition-opacity duration-300">
                    <?php if (!empty($articles)): ?>
                        <?php foreach ($articles as $article):
                            $categoryInfo = getCategoryInfo($article['values'][0]);
                            $formattedDate = formatDate($article['created_at']);
                            $description = is_array($article['values'][2]) ? implode(' ', $article['values'][2]) : $article['values'][2];
                            $excerpt = generateExcerpt($description);
                            $articleId = $article['id'];
                            $slug = $article['slug'];
                            $hoverColor = $categoryInfo['color'] === 'bg-[#01acb6]' ? 'hover:border-[#01acb6]/50' : 'hover:border-[#EF234B]/50';
                            $hoverTextColor = $categoryInfo['color'] === 'bg-[#01acb6]' ? 'group-hover:text-[#01acb6]' : 'group-hover:text-[#EF234B]';
                            $views = rand(20, 150); // Random views since not in API data
                        ?>
                            <article class="group card rounded-2xl overflow-hidden border border-slate-200 p-0 <?php echo $hoverColor; ?> transition-all duration-300"
                                data-cat="<?php echo htmlspecialchars($categoryInfo['cat']); ?>"
                                data-pop="<?php echo $views; ?>"
                                data-date="<?php echo date('Y-m-d', strtotime($article['created_at'])); ?>">
                                <div class="relative overflow-hidden bg-slate-200">
                                    <img src="<?php echo htmlspecialchars(is_array($article['values'][3]) ? $article['values'][3][0] : $article['values'][3]); ?>"
                                        alt="<?php echo htmlspecialchars($article['values'][0]); ?>"
                                        loading="lazy"
                                        class="w-full aspect-[4/3] object-cover group-hover:scale-105 transition-transform duration-500"
                                        onload="this.style.opacity=1"
                                        style="opacity:0;transition:opacity 0.3s ease-in-out">
                                    <div class="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                    <div class="absolute top-4 left-4">
                                        <span class="px-3 py-1 text-xs rounded-full <?php echo $categoryInfo['color']; ?> text-white font-semibold">
                                            <?php echo htmlspecialchars($categoryInfo['name']); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="p-6">
                                    <h3 class="text-xl font-bold mt-1 <?php echo $hoverTextColor; ?> transition-colors">
                                        <?php echo htmlspecialchars($article['values'][0]); ?>
                                    </h3>
                                    <p class="text-sm text-slate-600 mt-3 leading-relaxed">
                                        <?php echo htmlspecialchars($excerpt); ?>
                                    </p>

                                    <!-- Tags Section -->
                                    <?php if (isset($article['values'][4]) && !empty($article['values'][4])):
                                        $tags = is_array($article['values'][4]) ? $article['values'][4] : explode(',', $article['values'][4]);
                                    ?>
                                        <div class="mt-3 flex flex-wrap gap-1">
                                            <?php foreach (array_slice($tags, 0, 3) as $tag):
                                                $tag = trim($tag);
                                                if (!empty($tag)):
                                            ?>
                                                    <button onclick="searchByTag('<?php echo htmlspecialchars($tag); ?>')"
                                                        class="tag-button px-2 py-1 text-xs rounded-full bg-slate-100 text-slate-600 hover:bg-[#01acb6] hover:text-white transition-all duration-200 cursor-pointer">
                                                        #<?php echo htmlspecialchars($tag); ?>
                                                    </button>
                                            <?php endif;
                                            endforeach; ?>
                                            <?php if (count($tags) > 3): ?>
                                                <span class="text-xs text-slate-400">+<?php echo count($tags) - 3; ?> autres</span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="mt-4 flex items-center justify-between">
                                        <div class="flex items-center gap-3 text-xs text-slate-500">
                                            <span class="flex items-center gap-1">
                                                <i data-lucide="calendar" class="w-3 h-3"></i>
                                                <?php echo $formattedDate; ?>
                                            </span>

                                        </div>
                                        <a href="blog.php/<?php echo htmlspecialchars($slug); ?>"
                                            class="px-4 py-2 text-sm rounded-lg bg-[#01acb6] text-white hover:scale-105 transition-transform">
                                            Lire Plus
                                        </a>
                                    </div>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-span-2 text-center py-12">
                            <div class="text-slate-400 mb-4">
                                <i data-lucide="search" class="w-16 h-16 mx-auto mb-4"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-600 mb-2">Aucun article trouvé</h3>
                            <p class="text-slate-500">Essayez de modifier vos critères de recherche ou de navigation.</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Pagination -->
                <div class="pagination-container">
                    <?php if ($pagination['total'] > $pagination['per_page']):
                        $totalPages = ceil($pagination['total'] / $pagination['per_page']);
                        $currentPage = $pagination['page'];
                    ?>
                        <div class="mt-12 flex justify-center">
                            <nav class="flex items-center gap-2">
                                <?php if ($currentPage > 1): ?>
                                    <a href="?page=<?php echo $currentPage - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>"
                                        class="px-4 py-2 rounded-lg border border-slate-300 text-slate-600 hover:bg-slate-50 transition-colors">
                                        <i data-lucide="chevron-left" class="w-4 h-4"></i>
                                    </a>
                                <?php endif; ?>

                                <?php for ($i = max(1, $currentPage - 2); $i <= min($totalPages, $currentPage + 2); $i++): ?>
                                    <a href="?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>"
                                        class="px-4 py-2 rounded-lg <?php echo $i === $currentPage ? 'bg-[#01acb6] text-white' : 'border border-slate-300 text-slate-600 hover:bg-slate-50'; ?> transition-colors">
                                        <?php echo $i; ?>
                                    </a>
                                <?php endfor; ?>

                                <?php if ($currentPage < $totalPages): ?>
                                    <a href="?page=<?php echo $currentPage + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>"
                                        class="px-4 py-2 rounded-lg border border-slate-300 text-slate-600 hover:bg-slate-50 transition-colors">
                                        <i data-lucide="chevron-right" class="w-4 h-4"></i>
                                    </a>
                                <?php endif; ?>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            </main>

            <!-- 5) Sidebar -->
            <aside class="space-y-8">
                <!-- Categories -->
                <div class="p-5 rounded-2xl border border-slate-200">
                    <h3 class="font-semibold mb-3">Catégories</h3>
                    <ul class="space-y-2 text-sm">
                        <li>
                            <button data-category-id=""
                                class="category-id-filter w-full text-left px-3 py-1 rounded transition-colors <?php echo empty($filter_category_id) ? 'bg-[#01acb6] text-white' : 'bg-slate-100 text-slate-600 hover:bg-slate-200'; ?>">
                                Toutes les catégories
                            </button>
                        </li>
                        <?php if (!empty($categories)): ?>
                            <?php foreach ($categories as $category): ?>
                                <li>
                                    <button data-category-id="<?php echo htmlspecialchars($category['id']); ?>"
                                        class="category-id-filter w-full text-left px-3 py-1 rounded transition-colors <?php echo $filter_category_id == $category['id'] ? 'bg-[#01acb6] text-white' : 'bg-slate-100 text-slate-600 hover:bg-slate-200'; ?>">
                                        <?php echo htmlspecialchars($category['values'][0]); ?>
                                    </button>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
                <!-- Popular -->
                <div class="p-5 rounded-2xl border border-slate-200">
                    <h3 class="font-semibold mb-3">Les Plus Lus</h3>
                    <ul class="space-y-3 text-sm">
                        <?php
                        // Get first few articles for popular section
                        $popularArticles = array_slice($articles, 0, 3);
                        foreach ($popularArticles as $article):
                            $categoryInfo = getCategoryInfo($article['values'][0]);
                        ?>
                            <li class="flex gap-3 items-start">
                                <img src="<?php echo htmlspecialchars(is_array($article['values'][3]) ? $article['values'][3][0] : $article['values'][3]); ?>"
                                    class="w-14 h-14 object-cover rounded"
                                    alt="<?php echo htmlspecialchars($article['values'][0]); ?>"
                                    onerror="this.src='./imgs/opure.png'">
                                <div>
                                    <a href="blog.php/<?php echo htmlspecialchars($article['slug']); ?>"
                                        class="font-medium leading-snug hover:text-[#01acb6] transition-colors">
                                        <?php echo htmlspecialchars(strlen($article['values'][0]) > 35 ? substr($article['values'][0], 0, 35) . '...' : $article['values'][0]); ?>
                                    </a>
                                    <span class="text-xs text-slate-500">
                                        <?php echo $categoryInfo['name']; ?>
                                    </span>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <!-- Newsletter -->
            </aside>
        </div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>

    <script src="./canvas-animations.js"></script>
    <script src="./ai-assistant.js"></script>
    <script src="./main.js"></script>

    <script src="js/blogs.js"></script>
</body>

</html>