<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Creative Agency - Hero Section</title>
  
  <style>
    /* Dark gradient background matching reference image */
    .mmhero-section {
      position: relative;
      min-height: 100vh;
      overflow: hidden;
      background: #000000;
    }

    /* Dark Gradient Background */
    .mmhero-gradient-bg {
      position: absolute;
      inset: 0;
      background: #000000;
    }

    /* Animated gradient blobs - dark theme with pink/orange/red */
    .mmhero-blob-1 {
      position: absolute;
      top: 0;
      left: 0;
      width: 600px;
      height: 600px;
      background: radial-gradient(circle, rgba(255, 107, 0, 0.8) 0%, rgba(255, 20, 147, 0.6) 50%, rgba(139, 0, 139, 0.4) 100%);
      border-radius: 50%;
      filter: blur(120px);
      animation: mmhero-blob-shift 20s ease-in-out infinite;
      animation-delay: 0s;
    }

    .mmhero-blob-2 {
      position: absolute;
      top: 20px;
      right: 0;
      width: 700px;
      height: 700px;
      background: radial-gradient(circle, rgba(255, 0, 128, 0.9) 0%, rgba(255, 69, 58, 0.7) 50%, rgba(255, 107, 0, 0.4) 100%);
      border-radius: 50%;
      filter: blur(130px);
      animation: mmhero-blob-pulse 8s ease-in-out infinite;
      animation-delay: 2s;
    }

    .mmhero-blob-3 {
      position: absolute;
      bottom: 0;
      left: 80px;
      width: 500px;
      height: 500px;
      background: radial-gradient(circle, rgba(255, 140, 0, 0.7) 0%, rgba(139, 69, 19, 0.5) 50%, rgba(80, 40, 10, 0.3) 100%);
      border-radius: 50%;
      filter: blur(100px);
      animation: mmhero-light-wave 15s ease-in-out infinite;
      animation-delay: 5s;
    }

    .mmhero-blob-4 {
      position: absolute;
      top: 50%;
      right: 40px;
      width: 550px;
      height: 550px;
      background: radial-gradient(circle, rgba(255, 20, 147, 0.8) 0%, rgba(186, 85, 211, 0.6) 50%, rgba(138, 43, 226, 0.4) 100%);
      border-radius: 50%;
      filter: blur(110px);
      animation: mmhero-blob-shift 20s ease-in-out infinite;
      animation-delay: 3s;
    }

    .mmhero-blob-5 {
      position: absolute;
      top: 33%;
      left: 25%;
      width: 400px;
      height: 400px;
      background: radial-gradient(circle, rgba(255, 0, 255, 0.9) 0%, rgba(255, 20, 147, 0.6) 100%);
      border-radius: 50%;
      filter: blur(90px);
      animation: mmhero-blob-pulse 8s ease-in-out infinite;
      animation-delay: 1s;
    }

    @keyframes mmhero-blob-shift {
      0%, 100% {
        transform: translate(0px, 0px) scale(1);
      }
      33% {
        transform: translate(30px, -30px) scale(1.1);
      }
      66% {
        transform: translate(-20px, 20px) scale(0.9);
      }
    }

    @keyframes mmhero-blob-pulse {
      0%, 100% {
        transform: scale(1);
        opacity: 0.6;
      }
      50% {
        transform: scale(1.15);
        opacity: 0.8;
      }
    }

    @keyframes mmhero-light-wave {
      0%, 100% {
        transform: translate(0px, 0px) rotate(0deg);
        opacity: 0.4;
      }
      25% {
        transform: translate(40px, -40px) rotate(5deg);
        opacity: 0.7;
      }
      50% {
        transform: translate(20px, 30px) rotate(-3deg);
        opacity: 0.5;
      }
      75% {
        transform: translate(-30px, -20px) rotate(3deg);
        opacity: 0.8;
      }
    }

    /* Dark overlay for better text contrast */
    .mmhero-dark-overlay {
      position: absolute;
      inset: 0;
      background: linear-gradient(to bottom right, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.7));
      z-index: 1;
    }

    /* Content Container */
    .mmhero-container {
      position: relative;
      z-index: 10;
      max-width: 1280px;
      margin: 0 auto;
      padding: 1.5rem 1rem;
    }

    @media (min-width: 640px) {
      .mmhero-container {
        padding: 2rem 1.5rem;
      }
    }

    @media (min-width: 768px) {
      .mmhero-container {
        padding: 3rem 2rem;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-container {
        padding: 3rem 1rem;
      }
    }

    .mmhero-grid {
      display: flex;
      flex-direction: column;
      gap: 2rem;
      align-items: center;
      min-height: 100vh;
      justify-content: center;
    }

    @media (min-width: 640px) {
      .mmhero-grid {
        gap: 2.5rem;
      }
    }

    @media (min-width: 768px) {
      .mmhero-grid {
        gap: 3rem;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-grid {
        flex-direction: row;
        gap: 4rem;
        min-height: calc(100vh - 6rem);
      }
    }

    /* Left Content */
    .mmhero-left-content {
      display: flex;
      flex-direction: column;
      gap: 1.5rem;
      animation: mmhero-fadeInUp 0.8s ease-out forwards;
      width: 100%;
      text-align: center;
    }

    @media (min-width: 640px) {
      .mmhero-left-content {
        gap: 1.75rem;
      }
    }

    @media (min-width: 768px) {
      .mmhero-left-content {
        gap: 2rem;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-left-content {
        flex: 1;
        text-align: left;
      }
    }

    @keyframes mmhero-fadeInUp {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .mmhero-text-content {
      display: flex;
      flex-direction: column;
      gap: 0.75rem;
      width: 100%;
    }

    @media (min-width: 640px) {
      .mmhero-text-content {
        gap: 1rem;
      }
    }

    .mmhero-section h1 {
      font-size: 2rem;
      font-weight: 900;
      line-height: 1.1;
      color: #ffffff;
      letter-spacing: -0.02em;
      margin: 0;
    }

    @media (min-width: 480px) {
      .mmhero-section h1 {
        font-size: 2.5rem;
      }
    }

    @media (min-width: 640px) {
      .mmhero-section h1 {
        font-size: 3rem;
      }
    }

    @media (min-width: 768px) {
      .mmhero-section h1 {
        font-size: 3.5rem;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-section h1 {
        font-size: 4.5rem;
      }
    }

    @media (min-width: 1280px) {
      .mmhero-section h1 {
        font-size: 5rem;
      }
    }

    .mmhero-description {
      font-size: 1rem;
      line-height: 1.6;
      color: rgba(255, 255, 255, 0.8);
      font-weight: 300;
      margin: 0;
    }

    @media (min-width: 480px) {
      .mmhero-description {
        font-size: 1.0625rem;
        line-height: 1.65;
      }
    }

    @media (min-width: 640px) {
      .mmhero-description {
        font-size: 1.125rem;
        line-height: 1.7;
      }
    }

    @media (min-width: 768px) {
      .mmhero-description {
        font-size: 1.1875rem;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-description {
        font-size: 1.25rem;
      }
    }

    @media (min-width: 1280px) {
      .mmhero-description {
        font-size: 1.375rem;
      }
    }

    /* Button */
    .mmhero-cta-button {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      padding: 1rem 2rem;
      font-size: 0.9375rem;
      font-weight: 600;
      color: white;
      background: #01acb6;
      border: none;
      border-radius: 50px;
      cursor: pointer;
      box-shadow: 0 10px 30px rgba(1, 172, 182, 0.3);
      transition: all 0.3s ease;
      text-decoration: none;
      width: fit-content;
      position: relative;
      overflow: hidden;
    }

    @media (min-width: 480px) {
      .mmhero-cta-button {
        padding: 1.125rem 2.25rem;
        font-size: 1rem;
        gap: 0.625rem;
      }
    }

    @media (min-width: 640px) {
      .mmhero-cta-button {
        padding: 1.25rem 2.5rem;
        font-size: 1.0625rem;
        gap: 0.75rem;
      }
    }

    @media (min-width: 768px) {
      .mmhero-cta-button {
        font-size: 1.125rem;
      }
    }

    .mmhero-cta-button::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
      transition: left 0.5s ease;
    }

    .mmhero-cta-button:hover::before {
      left: 100%;
    }

    .mmhero-cta-button:hover {
      background: #EF234B;
      box-shadow: 0 15px 40px rgba(239, 35, 75, 0.4);
      transform: translateY(-2px);
    }

    .mmhero-cta-button:active {
      transform: translateY(0);
    }

    /* Right Content - Scrolling Images */
    .mmhero-right-content {
      position: relative;
      height: 300px;
      display: block;
      width: 100%;
      max-width: 500px;
      margin: 0 auto;
    }

    @media (min-width: 480px) {
      .mmhero-right-content {
        height: 350px;
      }
    }

    @media (min-width: 640px) {
      .mmhero-right-content {
        height: 450px;
        max-width: 600px;
      }
    }

    @media (min-width: 768px) {
      .mmhero-right-content {
        height: 550px;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-right-content {
        height: 650px;
        flex: 1;
        max-width: none;
        margin: 0;
      }
    }

    @media (min-width: 1280px) {
      .mmhero-right-content {
        height: 700px;
      }
    }

    .mmhero-images-container {
      position: absolute;
      inset: 0;
      display: flex;
      gap: 1rem;
      justify-content: center;
    }

    .mmhero-scroll-column {
      flex: 1;
      max-width: 180px;
      overflow: hidden;
    }

    @media (min-width: 640px) {
      .mmhero-scroll-column {
        max-width: 220px;
      }
    }

    @media (min-width: 1024px) {
      .mmhero-scroll-column {
        max-width: 250px;
      }
    }

    .mmhero-scroll-wrapper-up {
      animation: mmhero-scrollUp 30s linear infinite;
    }

    .mmhero-scroll-wrapper-down {
      animation: mmhero-scrollDown 30s linear infinite;
    }

    @keyframes mmhero-scrollUp {
      0% {
        transform: translateY(0);
      }
      100% {
        transform: translateY(-50%);
      }
    }

    @keyframes mmhero-scrollDown {
      0% {
        transform: translateY(-50%);
      }
      100% {
        transform: translateY(0);
      }
    }

    .mmhero-image-card {
      margin-bottom: 1rem;
      border-radius: 1rem;
      overflow: hidden;
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
      transition: all 0.3s ease;
    }

    .mmhero-image-card:hover {
      box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
    }

    .mmhero-image-card img {
      width: 100%;
      height: auto;
      display: block;
      transition: transform 0.5s ease;
    }

    .mmhero-image-card:hover img {
      transform: scale(1.05);
    }

    /* Gradient Overlays */
    .mmhero-gradient-overlay-top {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 8rem;
      /* background: linear-gradient(to bottom, rgba(243, 232, 255, 0.8), transparent); */
      pointer-events: none;
      z-index: 10;
    }

    .mmhero-gradient-overlay-bottom {
      position: absolute;
      bottom: 0;
      left: 0;
      right: 0;
      height: 8rem;
      /* background: linear-gradient(to top, rgba(254, 215, 170, 0.8), transparent); */
      pointer-events: none;
      z-index: 10;
    }

    /* Scroll Down Indicator */
    .scroll-indicator {
      position: absolute;
      bottom: 2rem;
      right: 2rem;
      z-index: 20;
      animation: bounce 2s infinite;
    }

    @keyframes bounce {
      0%, 100% {
        transform: translateY(0);
      }
      50% {
        transform: translateY(-10px);
      }
    }

    .scroll-button {
      width: 3rem;
      height: 3rem;
      border-radius: 50%;
      background: rgba(147, 51, 234, 0.1);
      backdrop-filter: blur(4px);
      border: 1px solid rgba(147, 51, 234, 0.2);
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: background 0.3s ease;
    }

    .scroll-button:hover {
      background: rgba(147, 51, 234, 0.2);
    }

    .scroll-button svg {
      width: 1.25rem;
      height: 1.25rem;
      color: #9333ea;
    }
  </style>

</head>
<body>
    <?php
        function fecthdata($page = 1, $per_page = 8, $search = '', $category_id = 4, $tag = '', $filter_category_id = '') {
            $baseUrl = getBaseUrl();
            $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
            $url = "{$baseUrl}{$adminPath}/cms.php/Records?category_id={$category_id}&page={$page}&per_page={$per_page}";
           
            if (!empty($search)) {
                $url .= "&search=" . urlencode($search);
            }
            if (!empty($tag)) {
                $url .= "&tag=" . urlencode($tag);
            }

            if (!empty($filter_category_id)) {
                $url .= "&search_field=" . urlencode("category id") . "&search_value=" . urlencode($filter_category_id);
            }

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                "X-API-TOKEN: 2250c47a4397a41fe5ff8f2c2a92b240ddf46aaeded8ffddb4f29f02ffef8720"

            ]);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            if (curl_error($ch)) {
                curl_close($ch);
                
                return ['success' => false, 'data' => ['items' => [], 'pagination' => ['total' => 0]]];
            }

            curl_close($ch);

            if ($httpCode === 200) {
                $data = json_decode($response, true);
                
                return $data ?: ['success' => false, 'data' => ['items' => [], 'pagination' => ['total' => 0]]];
            }

            return ['success' => false, 'data' => ['items' => [], 'pagination' => ['total' => 0]]];
        }
        $projects = fecthdata();
     ?>
  <section class="mmhero-section">
    <div class="mmhero-gradient-bg">
      <div class="mmhero-blob-1"></div>
      <div class="mmhero-blob-2"></div>
      <div class="mmhero-blob-3"></div>
      <div class="mmhero-blob-4"></div>
      <div class="mmhero-blob-5"></div>
    </div>

    <div class="mmhero-dark-overlay"></div>

    <div class="mmhero-container">
      <div class="mmhero-grid">
        <div class="mmhero-left-content">
          <div class="mmhero-text-content">
            <h1>MaxMind <span style="color: #EF234B;">Digital</span></h1> 
            <p class="mmhero-description">
              <span id="mmhero-rotating-text" style="color: #01acb6;"></span>
            </p>
          </div>

          <a href=<?php echo $baseUrl . 'project_web.php' ?> class="mmhero-cta-button">
            Explore Our Work
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="M5 12h14"></path>
              <path d="m12 5 7 7-7 7"></path>
            </svg>
          </a>
        </div>

        <script>
          // Typewriter animation for description
          const sentences = [
            'Crafting exceptional digital experiences that transform brands and drive growth',
            'Building innovative solutions that elevate your business',
            'Creating stunning websites that convert visitors into customers',
            'Designing powerful brands that stand out in the digital world'
          ];
          const colors = ['#01acb6', '#EF234B'];
          let sentenceIndex = 0;
          let charIndex = 0;
          let isDeleting = false;
          const rotatingText = document.getElementById('mmhero-rotating-text');
          const typingSpeed = 50; // Speed of typing
          const deletingSpeed = 30; // Speed of deleting
          const pauseDelay = 3000; // Pause before deleting

          function typeWriter() {
            const currentSentence = sentences[sentenceIndex];
            const currentColor = colors[sentenceIndex % colors.length];

            rotatingText.style.color = currentColor;

            if (isDeleting) {
              // Remove character
              rotatingText.textContent = currentSentence.substring(0, charIndex - 1);
              charIndex--;
            } else {
              // Add character
              rotatingText.textContent = currentSentence.substring(0, charIndex + 1);
              charIndex++;
            }

            // Determine next action
            let nextDelay = isDeleting ? deletingSpeed : typingSpeed;

            if (!isDeleting && charIndex === currentSentence.length) {
              // Finished typing, pause then start deleting
              nextDelay = pauseDelay;
              isDeleting = true;
            } else if (isDeleting && charIndex === 0) {
              // Finished deleting, move to next sentence
              isDeleting = false;
              sentenceIndex = (sentenceIndex + 1) % sentences.length;
            }

            setTimeout(typeWriter, nextDelay);
          }

          // Initial style
          rotatingText.style.display = 'inline-block';
          rotatingText.style.borderRight = '2px solid';
          rotatingText.style.paddingRight = '5px';
          rotatingText.style.minWidth = '20px';

          // Blinking cursor animation
          setInterval(() => {
            const currentColor = colors[sentenceIndex % colors.length];
            rotatingText.style.borderRightColor =
              rotatingText.style.borderRightColor === 'transparent' ? currentColor : 'transparent';
          }, 500);

          // Start typing animation
          setTimeout(typeWriter, 500);
        </script>

        <div class="mmhero-right-content">
          <div class="mmhero-images-container">
            <?php
            // Get projects data
            $projectsData = isset($projects['data']['items']) ? $projects['data']['items'] : [];

            // Collect all images with their project slugs
            $allImages = [];
            foreach ($projectsData as $project) {
                $slug = $project['slug'] ?? '';
                $galleryImages = isset($project['values'][2]) && is_array($project['values'][2]) ? $project['values'][2] : [];

                foreach ($galleryImages as $imageUrl) {
                    $allImages[] = [
                        'url' => $imageUrl,
                        'slug' => $slug,
                        'title' => $project['values'][0] ?? 'Project'
                    ];
                }
            }

            // Split images into two columns
            $midPoint = ceil(count($allImages) / 2);
            $column1Images = array_slice($allImages, 0, $midPoint);
            $column2Images = array_slice($allImages, $midPoint);

            // Duplicate for infinite scroll
            $column1Images = array_merge($column1Images, $column1Images);
            $column2Images = array_merge($column2Images, $column2Images);
            ?>

            <div class="mmhero-scroll-column">
              <div class="mmhero-scroll-wrapper-up">
                <?php foreach ($column1Images as $image): ?>
                    <div class="mmhero-image-card" onclick="window.location.href='<?php echo $baseUrl . 'portfolio.php/' . htmlspecialchars($image['slug']); ?>'">
                    <img src="<?php echo htmlspecialchars($image['url']); ?>" alt="<?php echo htmlspecialchars($image['title']); ?>">
                  </div>
                <?php endforeach; ?>
              </div>
            </div>

            <div class="mmhero-scroll-column">
              <div class="mmhero-scroll-wrapper-down">
                <?php foreach ($column2Images as $image): ?>
                  <div class="mmhero-image-card" onclick="window.location.href='<?php echo $baseUrl . '/portfolio.php/' . htmlspecialchars($image['slug']); ?>'">
                    <img src="<?php echo htmlspecialchars($image['url']); ?>" alt="<?php echo htmlspecialchars($image['title']); ?>">
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="mmhero-gradient-overlay-top"></div>
          <div class="mmhero-gradient-overlay-bottom"></div>
        </div>
      </div>
    </div>

    <!-- <div class="scroll-indicator">
      <button class="scroll-button" aria-label="Scroll down">
        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
        </svg>
      </button>
    </div> -->
  </section>
</body>
</html>
