    <!-- Hero Section CSS for Fixed Backgrounds -->
    <style>
        /* Enhanced fixed background for hero carousel */
        .hero-section .carousel-slide .absolute.inset-0[style*="background-image"] {
            background-attachment: fixed !important;
            background-position: center center !important;
            background-repeat: no-repeat !important;
            background-size: cover !important;
            will-change: transform;
        }

        /* Optimize for mobile devices */
        @media (max-width: 768px) {
            .hero-section .carousel-slide .absolute.inset-0[style*="background-image"] {
                background-attachment: scroll !important;
            }
        }

        /* Ensure carousel container maintains fixed background */
        .carousel-container {
            will-change: transform;
        }
    </style>

    <?php
        if (!function_exists('getBaseUrl')) {
            function getBaseUrl() {
                $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
                $host = $_SERVER['HTTP_HOST'];
                $script = $_SERVER['SCRIPT_NAME'];

                $basePath = dirname($script);

                return $protocol . $host . $basePath;
            }
            $baseUrl = getBaseUrl();
            $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : '';
        }
        
    ?>

    <section id="home" class="hero-section relative min-h-screen overflow-hidden">

        <!-- Carousel Container -->
        <div class="carousel-container relative w-full h-screen">
            <!-- Slide 1 - Innovation -->
            <div class="carousel-slide active absolute inset-0 transition-all duration-1000 ease-in-out">
                <!-- Background Image -->
                <div class="absolute inset-0 bg-cover bg-center bg-fixed" style="background-image: url('<?php echo !empty($heroData[3]) && isset($heroData[3][0]) ? htmlspecialchars($heroData[3][0]) : 'https://images.unsplash.com/photo-1451187580459-43490279c0fa?w=1920&h=1080&fit=crop'; ?>'); background-attachment: fixed; background-position: center center; background-repeat: no-repeat; background-size: cover;"></div>
                <div class="absolute inset-0 bg-black/70"></div>

                <!-- Network Animation Background -->
                <div class="network-background innovation-network">
                    <!-- Network Nodes -->
                    <!-- <div class="network-node" style="top: 15%; left: 10%; animation-delay: 0s;"></div>
                    <div class="network-node" style="top: 25%; left: 80%; animation-delay: 0.5s;"></div>
                    <div class="network-node" style="top: 60%; left: 20%; animation-delay: 1s;"></div>
                    <div class="network-node" style="top: 35%; left: 70%; animation-delay: 1.5s;"></div>
                    <div class="network-node" style="top: 80%; left: 60%; animation-delay: 2s;"></div>
                    <div class="network-node" style="top: 40%; left: 35%; animation-delay: 2.5s;"></div>
                    <div class="network-node" style="top: 70%; left: 85%; animation-delay: 1.2s;"></div>
                    <div class="network-node" style="top: 20%; left: 45%; animation-delay: 0.8s;"></div> -->

                    <!-- Network Connections -->
                    <!-- <svg class="network-connections" width="100%" height="100%">
                        <line class="network-line" x1="10%" y1="15%" x2="45%" y2="20%"></line>
                        <line class="network-line" x1="45%" y1="20%" x2="80%" y2="25%"></line>
                        <line class="network-line" x1="10%" y1="15%" x2="20%" y2="60%"></line>
                        <line class="network-line" x1="20%" y1="60%" x2="35%" y2="40%"></line>
                        <line class="network-line" x1="35%" y1="40%" x2="70%" y2="35%"></line>
                        <line class="network-line" x1="70%" y1="35%" x2="85%" y2="70%"></line>
                        <line class="network-line" x1="60%" y1="80%" x2="85%" y2="70%"></line>
                        <line class="network-line" x1="35%" y1="40%" x2="60%" y2="80%"></line>
                        <line class="network-line" x1="80%" y1="25%" x2="70%" y2="35%"></line>
                        <line class="network-line" x1="20%" y1="60%" x2="60%" y2="80%"></line>
                    </svg> -->
                </div>

                <div class="relative z-10 flex items-center justify-center h-full px-6">
                    <div class="text-center text-white max-w-4xl">
                        <div class="mb-6 inline-flex items-center gap-2 bg-[#01acb6]/20 backdrop-blur-md border border-[#01acb6]/40 rounded-full px-6 py-3">
                            <span class="text-sm font-semibold text-[#01acb6]">INNOVATION</span>
                        </div>
                        <h1 class="font-display text-4xl md:text-7xl font-black mb-4 text-[#01acb6] leading-tight tracking-tight">
                            <?php echo htmlspecialchars($heroData['title']); ?>
                        </h1>
                        <p class="text-xl text-gray-200 mb-10 font-light leading-relaxed max-w-2xl mx-auto"><?php echo htmlspecialchars($heroData['sous_titre']); ?></p>

                        <button class="group px-8 py-4 bg-[#01acb6] hover:bg-[#01acb6]/90 rounded-full font-semibold transition-all duration-300 hover:scale-105 hover:shadow-2xl hover:shadow-[#01acb6]/25 border-2 border-transparent hover:border-white/20">
                            <a href="project.php#projects" class="flex items-center gap-2">
                                Start Journey
                                <i data-lucide="arrow-right" class="w-4 h-4 group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Slide 2 - Development -->
            <div class="carousel-slide absolute inset-0 opacity-0 transition-all duration-1000 ease-in-out">
                <!-- Background Image -->
                <div class="absolute inset-0 bg-cover bg-center bg-fixed" style="background-image: url('<?php echo !empty($heroData[3]) && isset($heroData[3][1]) ? htmlspecialchars($heroData[3][1]) : 'https://images.unsplash.com/photo-1519389950473-47ba0277781c?w=1920&h=1080&fit=crop'; ?>'); background-attachment: fixed; background-position: center center; background-repeat: no-repeat; background-size: cover;"></div>
                <div class="absolute inset-0 bg-black/70"></div>

                <!-- Network Animation Background -->
                <div class="network-background development-network">
                    <!-- Network Nodes -->
                    <!-- <div class="network-node" style="top: 20%; left: 15%; animation-delay: 0.3s;"></div>
                    <div class="network-node" style="top: 35%; right: 10%; animation-delay: 1.2s;"></div>
                    <div class="network-node" style="top: 60%; right: 20%; animation-delay: 0.8s;"></div>
                    <div class="network-node" style="bottom: 30%; left: 70%; animation-delay: 1.8s;"></div>
                    <div class="network-node" style="bottom: 15%; left: 25%; animation-delay: 2.2s;"></div>
                    <div class="network-node" style="top: 45%; left: 50%; animation-delay: 0.6s;"></div>
                    <div class="network-node" style="top: 75%; right: 40%; animation-delay: 1.5s;"></div> -->

                    <!-- Network Connections -->
                    <!-- <svg class="network-connections" width="100%" height="100%">
                        <line class="network-line development-line" x1="15%" y1="20%" x2="50%" y2="45%"></line>
                        <line class="network-line development-line" x1="50%" y1="45%" x2="90%" y2="35%"></line>
                        <line class="network-line development-line" x1="15%" y1="20%" x2="25%" y2="85%"></line>
                        <line class="network-line development-line" x1="25%" y1="85%" x2="70%" y2="70%"></line>
                        <line class="network-line development-line" x1="70%" y1="70%" x2="80%" y2="60%"></line>
                        <line class="network-line development-line" x1="50%" y1="45%" x2="70%" y2="70%"></line>
                        <line class="network-line development-line" x1="80%" y1="60%" x2="60%" y2="75%"></line>
                        <line class="network-line development-line" x1="90%" y1="35%" x2="80%" y2="60%"></line>
                    </svg> -->
                </div>

                <div class="relative z-10 flex items-center justify-center h-full px-6">
                    <div class="text-center text-white max-w-4xl">
                        <div class="mb-6 inline-flex items-center gap-2 bg-[#EF234B]/20 backdrop-blur-md border border-[#EF234B]/40 rounded-full px-6 py-3">
                            <span class="text-sm font-semibold text-[#ffff]">DEVELOPMENT</span>
                        </div>
                        <h1 class="font-display text-4xl md:text-7xl font-black mb-4 bg-[#ffff] bg-clip-text text-transparent leading-tight tracking-tight">
                            Code That Inspires
                        </h1>
                        <p class="text-xl text-gray-200 mb-10 font-light leading-relaxed max-w-2xl mx-auto">Crafting powerful web solutions that drive business growth</p>
                        <button class="group px-8 py-4 bg-[#EF234B] hover:bg-[#EF234B]/90 rounded-full font-semibold transition-all duration-300 hover:scale-105 hover:shadow-2xl hover:shadow-[#EF234B]/25 border-2 border-transparent hover:border-white/20">
                            <a href="project.php#design-content" class="flex items-center gap-2">
                                View Projects
                                <i data-lucide="arrow-right" class="w-4 h-4 group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Slide 3 - Design -->
            <div class="carousel-slide absolute inset-0 opacity-0 transition-all duration-1000 ease-in-out">
                <!-- Background Image -->
                <div class="absolute inset-0 bg-cover bg-center bg-fixed" style="background-image: url('<?php echo !empty($heroData[3]) && isset($heroData[3][2]) ? htmlspecialchars($heroData[3][2]) : 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=1920&h=1080&fit=crop'; ?>'); background-attachment: fixed; background-position: center center; background-repeat: no-repeat; background-size: cover;"></div>
                <div class="absolute inset-0 bg-black/70"></div>

                <!-- Network Animation Background -->
                <div class="network-background design-network">
                    <!-- Network Nodes -->
                    <!-- <div class="network-node" style="top: 25%; left: 10%; animation-delay: 0.4s;"></div>
                    <div class="network-node" style="top: 15%; right: 25%; animation-delay: 1.1s;"></div>
                    <div class="network-node" style="bottom: 25%; right: 15%; animation-delay: 2.3s;"></div>
                    <div class="network-node" style="bottom: 40%; left: 75%; animation-delay: 0.9s;"></div>
                    <div class="network-node" style="top: 50%; left: 30%; animation-delay: 1.7s;"></div>
                    <div class="network-node" style="top: 75%; right: 60%; animation-delay: 0.2s;"></div>
                    <div class="network-node" style="top: 40%; left: 60%; animation-delay: 1.4s;"></div>
                    <div class="network-node" style="bottom: 10%; left: 45%; animation-delay: 2.1s;"></div> -->

                    <!-- Network Connections -->
                    <!-- <svg class="network-connections" width="100%" height="100%">
                        <line class="network-line design-line" x1="10%" y1="25%" x2="30%" y2="50%"></line>
                        <line class="network-line design-line" x1="30%" y1="50%" x2="60%" y2="40%"></line>
                        <line class="network-line design-line" x1="60%" y1="40%" x2="75%" y2="15%"></line>
                        <line class="network-line design-line" x1="75%" y1="60%" x2="85%" y2="75%"></line>
                        <line class="network-line design-line" x1="60%" y1="40%" x2="75%" y2="60%"></line>
                        <line class="network-line design-line" x1="30%" y1="50%" x2="45%" y2="90%"></line>
                        <line class="network-line design-line" x1="45%" y1="90%" x2="40%" y2="75%"></line>
                        <line class="network-line design-line" x1="10%" y1="25%" x2="75%" y2="60%"></line>
                        <line class="network-line design-line" x1="75%" y1="15%" x2="40%" y2="75%"></line>
                    </svg> -->
                </div>

                <div class="relative z-10 flex items-center justify-center h-full px-6">
                    <div class="text-center text-white max-w-4xl">
                        <div class="mb-6 inline-flex items-center gap-2 bg-purple-500/20 backdrop-blur-md border border-purple-500/40 rounded-full px-6 py-3">
                            <span class="text-sm font-semibold text-purple-400">DESIGN</span>
                        </div>
                        <h1 class="font-display text-4xl md:text-7xl font-black mb-4 text-purple-400 leading-tight tracking-tight">
                            Beautiful Interfaces
                        </h1>
                        <p class="text-xl text-gray-200 mb-10 font-light leading-relaxed max-w-2xl mx-auto">Creating stunning user experiences that captivate and convert</p>
                        <button class="group px-8 py-4 bg-purple-600 hover:bg-purple-600/90 rounded-full font-semibold transition-all duration-300 hover:scale-105 hover:shadow-2xl hover:shadow-purple-600/25 border-2 border-transparent hover:border-white/20">
                            <a href="project.php#projects" class="flex items-center gap-2">
                                See Designs
                                <i data-lucide="arrow-right" class="w-4 h-4 group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Carousel Dots -->
        <div style="scale: 0.7;" class="absolute bottom-8 left-1/2 transform -translate-x-1/2 z-20 flex space-x-4">
            <button class="carousel-dot active w-4 h-4 rounded-full bg-white transition-all duration-500 hover:scale-125" data-slide="0"></button>
            <button class="carousel-dot w-4 h-4 rounded-full bg-white/30 hover:bg-white/60 transition-all duration-500 hover:scale-125" data-slide="1"></button>
            <button class="carousel-dot w-4 h-4 rounded-full bg-white/30 hover:bg-white/60 transition-all duration-500 hover:scale-125" data-slide="2"></button>
        </div>

        <!-- Enhanced Progress Bar -->
        <!-- <div class="absolute bottom-0 left-0 w-full h-2 bg-white/10 z-20">
            <div id="carouselProgress" class="carousel-progress h-full bg-[#01acb6] transition-all duration-6000 ease-linear" style="width: 0%"></div>
        </div> -->
    </section>