document.addEventListener('DOMContentLoaded', function() {
            // Initialize Lucide icons
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }

            // Category filtering with AJAX
            function setupCategoryFiltering() {
                const categoryButtons = document.querySelectorAll('.category-id-filter');

                categoryButtons.forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.preventDefault();

                        const categoryId = this.getAttribute('data-category-id');
                        console.log('Category clicked:', categoryId);

                        // Update active button state immediately for better UX
                        updateCategoryButtonStates(categoryId);

                        // Make AJAX call
                        filterByCategory(categoryId);
                    });
                });
            }

            function updateCategoryButtonStates(activeCategoryId) {
                const buttons = document.querySelectorAll('.category-id-filter');
                buttons.forEach(btn => {
                    const btnCategoryId = btn.getAttribute('data-category-id');
                    if (btnCategoryId === activeCategoryId) {
                        btn.classList.remove('bg-slate-100', 'text-slate-700', 'hover:bg-slate-200');
                        btn.classList.add('bg-[#01acb6]', 'text-white', 'shadow-lg');
                    } else {
                        btn.classList.remove('bg-[#01acb6]', 'text-white', 'shadow-lg');
                        btn.classList.add('bg-slate-100', 'text-slate-700', 'hover:bg-slate-200');
                    }
                });
            }

            function filterByCategory(categoryId) {
                const loadingOverlay = document.getElementById('loading-overlay');
                if (loadingOverlay) {
                    loadingOverlay.classList.remove('hidden');
                }

                // Construct the API URL as specified
                const baseUrl = window.location.origin + window.location.pathname.replace('/blogs.php', '');

                let apiUrl = baseUrl + '/admin/cms.php/Records?category_id=1&search_field=category id&search_value=' + encodeURIComponent(categoryId);

                console.log('Making AJAX call to:', apiUrl);

                // Make the AJAX request
                fetch('blogs.php?ajax=1&filter_category_id=' + encodeURIComponent(categoryId), {
                        method: 'GET',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'X-API-TOKEN': '2250c47a4397a41fe5ff8f2c2a92b240ddf46aaeded8ffddb4f29f02ffef8720',
                        }
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        console.log('AJAX response:', data);

                        if (data.success) {
                            // Update the articles container
                            const postsContainer = document.getElementById('posts');
                            if (postsContainer && data.articles_html) {
                                postsContainer.innerHTML = data.articles_html;
                            }

                            // Update pagination if exists
                            const paginationContainer = document.querySelector('.pagination-container');
                            if (paginationContainer && data.pagination_html) {
                                paginationContainer.innerHTML = data.pagination_html;
                            }

                            // Update URL without page reload
                            const newUrl = new URL(window.location);
                            if (categoryId) {
                                newUrl.searchParams.set('filter_category_id', categoryId);
                            } else {
                                newUrl.searchParams.delete('filter_category_id');
                            }
                            newUrl.searchParams.delete('page'); // Reset to first page
                            window.history.pushState({}, '', newUrl);

                            // Re-initialize Lucide icons for new content
                            if (typeof lucide !== 'undefined') {
                                lucide.createIcons();
                            }
                        } else {
                            console.error('Filter request failed:', data);
                        }
                    })
                    .catch(error => {
                        console.error('Error filtering categories:', error);
                        // Show error message to user
                        const postsContainer = document.getElementById('posts');
                        if (postsContainer) {
                            postsContainer.innerHTML = '<div class="col-span-2 text-center py-12"><div class="text-red-500 mb-4"><i data-lucide="alert-circle" class="w-16 h-16 mx-auto mb-4"></i></div><h3 class="text-xl font-semibold text-red-600 mb-2">Erreur de chargement</h3><p class="text-slate-500">Une erreur est survenue lors du filtrage. Veuillez réessayer.</p></div>';
                        }
                    })
                    .finally(() => {
                        // Hide loading overlay
                        if (loadingOverlay) {
                            loadingOverlay.classList.add('hidden');
                        }
                    });
            }

            // Search functionality
            function setupSearchFunctionality() {
                const searchInput = document.getElementById('search-input');
                const searchBtn = document.getElementById('search-btn');
                const clearSearchBtn = document.getElementById('clear-search-btn');
                const sortSelect = document.getElementById('sort-select');

                if (searchBtn) {
                    searchBtn.addEventListener('click', performSearch);
                }

                if (searchInput) {
                    searchInput.addEventListener('keypress', function(e) {
                        if (e.key === 'Enter') {
                            e.preventDefault();
                            performSearch();
                        }
                    });
                }

                if (clearSearchBtn) {
                    clearSearchBtn.addEventListener('click', function() {
                        if (searchInput) {
                            searchInput.value = '';
                        }
                        performSearch();
                    });
                }

                if (sortSelect) {
                    sortSelect.addEventListener('change', performSearch);
                }
            }

            function performSearch() {
                const searchInput = document.getElementById('search-input');
                const sortSelect = document.getElementById('sort-select');
                const clearSearchBtn = document.getElementById('clear-search-btn');
                const searchSpinner = document.getElementById('search-spinner');

                const searchValue = searchInput ? searchInput.value.trim() : '';
                const sortValue = sortSelect ? sortSelect.value : 'new';

                // Show/hide clear button
                if (clearSearchBtn) {
                    if (searchValue) {
                        clearSearchBtn.classList.remove('hidden');
                    } else {
                        clearSearchBtn.classList.add('hidden');
                    }
                }

                const loadingOverlay = document.getElementById('loading-overlay');

                if (loadingOverlay) {
                    loadingOverlay.classList.remove('hidden');
                }
                if (searchSpinner) {
                    searchSpinner.classList.remove('hidden');
                }

                // Build URL parameters
                const params = new URLSearchParams();
                params.set('ajax', '1');
                if (searchValue) params.set('search', searchValue);
                if (sortValue && sortValue !== 'new') params.set('sort', sortValue);

                fetch('blogs.php?' + params.toString(), {
                        method: 'GET',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            const postsContainer = document.getElementById('posts');
                            if (postsContainer && data.articles_html) {
                                postsContainer.innerHTML = data.articles_html;
                            }

                            // Update pagination
                            const paginationContainer = document.querySelector('.pagination-container');
                            if (paginationContainer && data.pagination_html) {
                                paginationContainer.innerHTML = data.pagination_html;
                            }

                            // Update URL
                            const newUrl = new URL(window.location);
                            if (searchValue) {
                                newUrl.searchParams.set('search', searchValue);
                            } else {
                                newUrl.searchParams.delete('search');
                            }
                            if (sortValue && sortValue !== 'new') {
                                newUrl.searchParams.set('sort', sortValue);
                            } else {
                                newUrl.searchParams.delete('sort');
                            }
                            newUrl.searchParams.delete('page');
                            window.history.pushState({}, '', newUrl);


                            // Re-initialize icons
                            if (typeof lucide !== 'undefined') {
                                lucide.createIcons();
                            }
                        }
                    })
                    .catch(error => {
                        console.error('Search error:', error);
                    })
                    .finally(() => {
                        if (loadingOverlay) {
                            loadingOverlay.classList.add('hidden');
                        }
                        if (searchSpinner) {
                            searchSpinner.classList.add('hidden');
                        }
                    });
            }

            // Tag filtering
            window.searchByTag = function(tag) {
                const searchInput = document.getElementById('search-input');
                if (searchInput) {
                    searchInput.value = tag;
                    performSearch();
                }
            };

            // Clear filters functions
            window.clearCategoryFilter = function() {
                filterByCategory('');
            };

            window.clearTagFilter = function() {
                const newUrl = new URL(window.location);
                newUrl.searchParams.delete('tag');
                window.location.href = newUrl.toString();
            };

            window.clearSearch = function() {
                const searchInput = document.getElementById('search-input');
                if (searchInput) {
                    searchInput.value = '';
                }
                performSearch();
            };

            // Pagination handling
            function setupPaginationHandling() {
                document.addEventListener('click', function(e) {
                    if (e.target.classList.contains('pagination-btn') || e.target.closest('.pagination-btn')) {
                        e.preventDefault();

                        const button = e.target.classList.contains('pagination-btn') ? e.target : e.target.closest('.pagination-btn');
                        const page = button.getAttribute('data-page');

                        if (page) {
                            // Get current filter parameters
                            const urlParams = new URLSearchParams(window.location.search);
                            const categoryId = urlParams.get('filter_category_id') || '';
                            const searchValue = urlParams.get('search') || '';
                            const sortValue = urlParams.get('sort') || 'new';

                            // Build new request
                            const params = new URLSearchParams();
                            params.set('ajax', '1');
                            params.set('page', page);
                            if (categoryId) params.set('filter_category_id', categoryId);
                            if (searchValue) params.set('search', searchValue);
                            if (sortValue && sortValue !== 'new') params.set('sort', sortValue);

                            const loadingOverlay = document.getElementById('loading-overlay');
                            if (loadingOverlay) {
                                loadingOverlay.classList.remove('hidden');
                            }

                            fetch('blogs.php?' + params.toString(), {
                                    method: 'GET',
                                    headers: {
                                        'X-Requested-With': 'XMLHttpRequest'
                                    }
                                })
                                .then(response => response.json())
                                .then(data => {
                                    if (data.success) {
                                        const postsContainer = document.getElementById('posts');
                                        if (postsContainer && data.articles_html) {
                                            postsContainer.innerHTML = data.articles_html;
                                        }

                                        const paginationContainer = document.querySelector('.pagination-container');
                                        if (paginationContainer && data.pagination_html) {
                                            paginationContainer.innerHTML = data.pagination_html;
                                        }

                                        // Update URL
                                        const newUrl = new URL(window.location);
                                        newUrl.searchParams.set('page', page);
                                        window.history.pushState({}, '', newUrl);

                                        // Scroll to top of articles
                                        const postsElement = document.getElementById('posts');
                                        if (postsElement) {
                                            postsElement.scrollIntoView({
                                                behavior: 'smooth',
                                                block: 'start'
                                            });
                                        }

                                        // Re-initialize icons
                                        if (typeof lucide !== 'undefined') {
                                            lucide.createIcons();
                                        }
                                    }
                                })
                                .catch(error => {
                                    console.error('Pagination error:', error);
                                })
                                .finally(() => {
                                    if (loadingOverlay) {
                                        loadingOverlay.classList.add('hidden');
                                    }
                                });
                        }
                    }
                });
            }

            // Initialize all functionality
            setupCategoryFiltering();
            setupSearchFunctionality();
            setupPaginationHandling();

            console.log('Blog filtering functionality initialized');
        });
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();
        }

        function openImageModal(imageSrc) {
            const modal = document.getElementById('imageModal');
            const modalImage = document.getElementById('modalImage');
            modalImage.src = imageSrc;
            modal.classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeImageModal() {
            const modal = document.getElementById('imageModal');
            modal.classList.add('hidden');
            document.body.style.overflow = 'auto';
        }

        // Close modal on Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeImageModal();
            }
        });

        // Scroll to top functionality
        document.addEventListener('DOMContentLoaded', function() {
            const scrollToTopBtn = document.getElementById('scroll-to-top');

            if (scrollToTopBtn) {
                window.addEventListener('scroll', function() {
                    if (window.pageYOffset > 300) {
                        scrollToTopBtn.style.display = 'block';
                    } else {
                        scrollToTopBtn.style.display = 'none';
                    }
                });

                scrollToTopBtn.addEventListener('click', function() {
                    window.scrollTo({
                        top: 0,
                        behavior: 'smooth'
                    });
                });
            }
        });