<?php
try {
    $host     = '127.0.0.1'; 
    $dbname   = 'maxmind_dfsk_e5';
    $username = 'maxmind_dfsk_e5';
    $password = 'xUrw8Yteg3cZ';
    $port     = 3306; // Added explicit port number

    $dsn = "mysql:host=$host;port=$port;dbname=$dbname;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];

    $pdo = new PDO($dsn, $username, $password, $options);

    // Check if table exists and create/alter if needed
    $tableCheck = $pdo->query("SHOW TABLES LIKE 'bo_contact'");
    
    if ($tableCheck->rowCount() == 0) {
        // Create table if it doesn't exist
        $sql = "CREATE TABLE bo_contact (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nom VARCHAR(255) NOT NULL,
            telephone VARCHAR(20) NOT NULL,
            email VARCHAR(255) NOT NULL,
            ville VARCHAR(100) NOT NULL,
            type_demande VARCHAR(100) DEFAULT NULL,
            MessageClient TEXT DEFAULT NULL,
            compagne VARCHAR(100) DEFAULT NULL,
            date_ajout DATETIME DEFAULT CURRENT_TIMESTAMP,
            status VARCHAR(20) DEFAULT 'pending',
            error_message TEXT DEFAULT NULL,
            processed_at DATETIME DEFAULT NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        
        $pdo->exec($sql);
    } else {
        // Check for missing columns and add them if needed
        $columns = $pdo->query("SHOW COLUMNS FROM bo_contact");
        $existingColumns = [];
        while($column = $columns->fetch(PDO::FETCH_ASSOC)) {
            $existingColumns[] = $column['Field'];
        }

        // Add missing columns if they don't exist
        if (!in_array('type_demande', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN type_demande VARCHAR(100) DEFAULT NULL");
        }
        if (!in_array('MessageClient', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN MessageClient TEXT DEFAULT NULL");
        }
        if (!in_array('compagne', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN compagne VARCHAR(100) DEFAULT NULL");
        }
        if (!in_array('date_ajout', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN date_ajout DATETIME DEFAULT CURRENT_TIMESTAMP");
        }
        if (!in_array('status', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN status VARCHAR(20) DEFAULT 'pending'");
        }
        if (!in_array('error_message', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN error_message TEXT DEFAULT NULL");
        }
        if (!in_array('processed_at', $existingColumns)) {
            $pdo->exec("ALTER TABLE bo_contact ADD COLUMN processed_at DATETIME DEFAULT NULL");
        }
    }

} catch(PDOException $e) {
    // Rethrow so the caller can handle and return JSON
    throw $e;
}