<?php include "backend/backend.php" ?>
<?php include "backend/portfolio.php" ?>
<?php include "backend/projects.php" ?>

<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($page_description); ?>">
    <meta name="keywords"
        content="portfolio website, company showcase, professional design, site vitrine, UX, UI, agence digitale Maroc, MaxMind">

    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo htmlspecialchars($page_title); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($page_description); ?>">
    <meta property="og:type" content="article">
    <meta property="og:site_name" content="MaxMind Portfolio">
    <meta property="og:locale" content="fr_FR">
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($page_title); ?>">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($page_description); ?>">
    <!-- Additional SEO Meta Tags -->
    <meta name="author" content="MaxMind">
    <meta name="publisher" content="MaxMind">
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="theme-color" content="#01acb6">
    <meta name="msapplication-TileColor" content="#01acb6">

    <meta name="title" content="<?php echo $portfolio_data['values'][10]; ?>">

    <meta name="description" content="<?php echo $portfolio_data['values'][11]; ?>">
    <?php
    $result = [];
    foreach ($portfolio_data['values'][7] as $index => $value) {
        $result[] = $value;
    }

    $keywords = implode(",", $result);
    ?>
    <meta name="keywords7" content="<?= htmlspecialchars($keywords) ?>">

    <?php if ($portfolio_data): ?>
        <!-- Portfolio Item Meta Data -->
        <?php if (isset($portfolio_data['values'][0])): ?>
            <meta name="portfolio:title" content="<?php echo htmlspecialchars($portfolio_data['values'][0]); ?>">
        <?php endif; ?>

        <?php if (isset($portfolio_data['values'][1])): ?>
            <meta name="portfolio:description" content="<?php echo htmlspecialchars($portfolio_data['values'][1]); ?>">
        <?php endif; ?>

        <?php if (isset($portfolio_data['id'])): ?>
            <meta name="portfolio:id" content="<?php echo htmlspecialchars($portfolio_data['id']); ?>">
        <?php endif; ?>

        <?php if (isset($portfolio_data['values']['category'])): ?>
            <meta name="portfolio:category" content="<?php echo htmlspecialchars($portfolio_data['values']['category']); ?>">
        <?php endif; ?>

        <!-- Portfolio Media Meta Data -->
        <?php if (isset($portfolio_data['values'][3]) && !empty($portfolio_data['values'][3])):
            $media_files = $portfolio_data['values'][3];
            if (is_string($media_files)) {
                $media_files = json_decode($media_files, true) ?: explode(',', $media_files);
            }
            if (is_array($media_files)):
                $media_count = count($media_files);
                $video_count = 0;
                $image_count = 0;
                foreach ($media_files as $media_url) {
                    if (preg_match('/\.(mp4|webm|ogg|mov|avi|mkv)$/i', $media_url)) {
                        $video_count++;
                    } else {
                        $image_count++;
                    }
                }
        ?>
                <meta name="portfolio:media_count" content="<?php echo $media_count; ?>">
                <meta name="portfolio:image_count" content="<?php echo $image_count; ?>">
                <meta name="portfolio:video_count" content="<?php echo $video_count; ?>">
            <?php endif; ?>
        <?php endif; ?>

    <?php endif; ?>

    <!-- Custom JSON Meta Data from Backend -->
    <?php
    if ($portfolio_data && isset($portfolio_data['values'][8]) && !empty($portfolio_data['values'][8])) {
        // The JSON string might have escaped quotes, so we need to handle that
        $jsonString = $portfolio_data['values'][8];

        // Decode the JSON string
        $metaData = json_decode($jsonString, true);

        // Check if JSON decode was successful and we have an array
        if (is_array($metaData) && !empty($metaData)) {
            foreach ($metaData as $key => $value): ?>
                <meta name="<?php echo htmlspecialchars($key); ?>" content="<?php echo htmlspecialchars($value); ?>">
    <?php endforeach;
        } else {
            // Debug output to see what we're getting
            echo "<!-- Meta data JSON parse error. Raw data: " . htmlspecialchars($jsonString) . " -->\n";
            echo "<!-- JSON decode result: " . var_export($metaData, true) . " -->\n";
        }
    } else {
        echo "<!-- No additional meta data available at values[8] -->\n";
    }
    ?>

    <!-- Enhanced SEO Meta Tags -->
    <link rel="canonical" href="<?php echo htmlspecialchars($baseUrl . '/portfolio.php' . (isset($_GET['id']) ? '?id=' . $_GET['id'] : '')); ?>">
    <link rel="stylesheet" href="styleMl.css">
   
    <meta name="language" content="French">
    <meta name="geo.region" content="MA">
    <meta name="geo.placename" content="Casablanca">
    <meta name="geo.position" content="33.5731;-7.5898">
    <meta name="ICBM" content="33.5731, -7.5898">

    <!-- Enhanced Structured Data -->
    <?php if ($portfolio_data): ?>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "CreativeWork",
        "name": "<?php echo htmlspecialchars($portfolio_data['values'][0] ?? 'Projet Portfolio MaxMind'); ?>",
        "description": "<?php echo htmlspecialchars($portfolio_data['values'][1] ?? 'Découvrez ce projet réalisé par MaxMind - expertise en développement web et design'); ?>",
        "url": "<?php echo htmlspecialchars($baseUrl . '/portfolio.php' . (isset($_GET['id']) ? '?id=' . $_GET['id'] : '')); ?>",
        "creator": {
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars($baseUrl); ?>",
            "logo": "<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png",
            "address": {
                "@type": "PostalAddress",
                "addressCountry": "MA",
                "addressLocality": "Casablanca"
            }
        },
        <?php if (isset($portfolio_data['values'][3]) && !empty($portfolio_data['values'][3])): ?>
        "image": [
            <?php
            $media_files = $portfolio_data['values'][3];
            if (is_string($media_files)) {
                $media_files = json_decode($media_files, true) ?: explode(',', $media_files);
            }
            if (is_array($media_files)) {
                $image_urls = [];
                foreach ($media_files as $media_url) {
                    if (!preg_match('/\.(mp4|webm|ogg|mov|avi|mkv)$/i', $media_url)) {
                        $image_urls[] = '"' . htmlspecialchars($media_url) . '"';
                    }
                }
                echo implode(',', array_slice($image_urls, 0, 5));
            }
            ?>
        ],
        <?php endif; ?>
        "dateCreated": "<?php echo htmlspecialchars($portfolio_data['created_at'] ?? date('c')); ?>",
        "dateModified": "<?php echo htmlspecialchars($portfolio_data['updated_at'] ?? $portfolio_data['created_at'] ?? date('c')); ?>",
        "inLanguage": "fr-MA",
        "genre": "<?php echo htmlspecialchars($portfolio_data['values']['category'] ?? 'Développement Web'); ?>",
        "keywords": "<?= htmlspecialchars($keywords) ?>"
    }
    </script>
    <?php endif; ?>

    <!-- Google Fonts with optimized loading -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- GSAP (ScrollTrigger removed) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <!-- Enhanced Favicon and App Icons -->
    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">
    <link rel="apple-touch-icon" href="./imgs/LOGO_MAXMIND_BLACK.png">
    <link rel="shortcut icon" href="./imgs/LOGO_MAXMIND_BLACK.png">

    <!-- Canvas Animations -->
    <script src="./canvas-animations.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                        display: ['Space Grotesk', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'gradient-shift': 'gradient-shift 8s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'gradient-shift': {
                            '0%, 100%': {
                                backgroundPosition: '0% 50%'
                            },
                            '50%': {
                                backgroundPosition: '100% 50%'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>

    <style>
        /* Roboto Font */
        @import url('https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap');

        * {
            font-family: "Raleway", sans-serif;
        }

        html {
            scroll-behavior: smooth;
            overflow-x: hidden;
        }

        body {
            line-height: 1.6;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            overflow-x: hidden;
            background: #0a0a0a;
        }

        /* Enhanced scroll animations with improved performance */
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translate3d(0, 50px, 0);
            }

            to {
                opacity: 1;
                transform: translate3d(0, 0, 0);
            }
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translate3d(-50px, 0, 0);
            }

            to {
                opacity: 1;
                transform: translate3d(0, 0, 0);
            }
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translate3d(50px, 0, 0);
            }

            to {
                opacity: 1;
                transform: translate3d(0, 0, 0);
            }
        }

        #renderParagraphe p {
            color: white !important;
        }

        .portfolio-video,
        .portfolio-video2,
        .masonry-video {
            width: 100%;
            min-height: 200px;
            height: auto;
            object-fit: cover;
            border-radius: 12px;
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.3s ease;
            will-change: transform;
            backface-visibility: hidden;
        }

        .masonry-video:hover {
            transform: scale3d(1.02, 1.02, 1);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        /* Enhanced External video iframe styling with pixel effects */
        .iframe-container {
            width: 100%;
            min-height: 250px;
            height: auto;
            border-radius: 12px;
            overflow: hidden;
            background: #000;
            position: relative;
        }

        .iframe-container iframe {
            border-radius: 12px;
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            will-change: transform, filter;
            backface-visibility: hidden;
            /* Default pixel state for iframes */
            filter: contrast(1.3) saturate(0.8) blur(0.8px) brightness(0.9);
            image-rendering: pixelated;
            image-rendering: -moz-crisp-edges;
            image-rendering: crisp-edges;
            transform: scale(1.01);
        }

        /* Hover effects for iframe videos */
        .iframe-container:hover iframe {
            transform: scale(1.08);
            filter: contrast(1.1) saturate(1.2) blur(0px) brightness(1.1);
            image-rendering: auto;
        }

        /* Iframe pixel video overlay */
        .iframe-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            transition: opacity 0.3s ease;
            pointer-events: none;
            z-index: 1;
        }

        .iframe-container:hover::before {
            opacity: 0;
        }

        /* Iframe video play indicator */
        .iframe-container::after {
            content: '▶';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 2rem;
            background: rgba(0, 0, 0, 0.3);
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
            z-index: 2;
        }

        .iframe-container:hover::after {
            opacity: 0;
            transform: translate(-50%, -50%) scale(1.2);
        }

        /* Enhanced iframe container for hover autoplay */
        .iframe-container {
            cursor: pointer;
            position: relative;
        }

        .iframe-container[data-video-type="youtube"] iframe,
        .iframe-container[data-video-type="vimeo"] iframe {
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        @media (max-width: 768px) {
            .masonry-video {
                min-height: 180px !important;
            }

            .iframe-container {
                min-height: 200px !important;
            }
        }

        @media (max-width: 480px) {
            .masonry-video {
                min-height: 160px !important;
            }

            .iframe-container {
                min-height: 180px !important;
            }
        }

        .animate-slide-up {
            animation: slideInUp 0.8s ease-out;
        }

        .animate-slide-left {
            animation: slideInLeft 0.8s ease-out;
        }

        .animate-slide-right {
            animation: slideInRight 0.8s ease-out;
        }

        /* Canvas background elements - Optimized */
        #particleCanvas,
        #geometryCanvas,
        #flowCanvas {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            transition: opacity 0.5s ease;
            will-change: opacity;
        }

        #particleCanvas {
            opacity: 0.4;
            mix-blend-mode: normal;
            z-index: 1;
        }

        #geometryCanvas {
            opacity: 0.2;
            mix-blend-mode: overlay;
            z-index: 2;
        }

        #flowCanvas {
            opacity: 0.3;
            mix-blend-mode: soft-light;
            z-index: 3;
        }

        /* Hero section - Modern and optimized */
        .hero-section {
            position: relative;
            width: 100%;
            height: 100vh;
            min-height: 100vh;
            z-index: 1;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            background: linear-gradient(135deg,
                    #0a0a0a 0%,
                    #1a0a1a 25%,
                    #0a1a1a 50%,
                    #1a1a0a 75%,
                    #0a0a0a 100%);
            background-size: 400% 400%;
            animation: gradientShift 20s ease infinite;
        }

        @keyframes gradientShift {
            0% {
                background-position: 0% 50%;
            }

            50% {
                background-position: 100% 50%;
            }

            100% {
                background-position: 0% 50%;
            }
        }

        .hero-main-card {
            background: linear-gradient(135deg,
                    rgba(239, 35, 75, 0.9) 0%,
                    rgba(1, 172, 182, 0.8) 25%,
                    rgba(0, 0, 0, 0.95) 50%,
                    rgba(1, 172, 182, 0.8) 75%,
                    rgba(239, 35, 75, 0.9) 100%);
            border-radius: 40px;
            padding: 60px;
            max-width: 1000px;
            width: 90%;
            margin: 0 auto;
            position: relative;
            backdrop-filter: blur(30px);
            border: 2px solid rgba(255, 255, 255, 0.15);
            box-shadow:
                0 40px 80px rgba(0, 0, 0, 0.4),
                0 0 100px rgba(1, 172, 182, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            transition: transform 0.6s ease, box-shadow 0.6s ease;
            transform: translateY(0);
            will-change: transform;
        }

        .hero-main-card:hover {
            transform: translateY(-10px);
            box-shadow:
                0 50px 100px rgba(0, 0, 0, 0.5),
                0 0 150px rgba(1, 172, 182, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
        }

        .hero-main-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg,
                    rgba(239, 35, 75, 0.1) 0%,
                    transparent 50%,
                    rgba(1, 172, 182, 0.1) 100%);
            border-radius: 32px;
            pointer-events: none;
        }

        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap');

        .hero-carousel {
            height: 100vh;
            height: 100dvh;
            overflow: hidden;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
        }

        .hero-carousel::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg,
                    rgba(0, 0, 0, 0.3) 0%,
                    rgba(1, 172, 182, 0.08) 25%,
                    rgba(0, 0, 0, 0.5) 50%,
                    rgba(239, 35, 75, 0.08) 75%,
                    rgba(0, 0, 0, 0.3) 100%);
            z-index: 1;
            animation: gradientFlow 12s ease-in-out infinite;
        }

        @keyframes gradientFlow {

            0%,
            100% {
                opacity: 1;
                transform: scale(1);
            }

            50% {
                opacity: 0.8;
                transform: scale(1.05);
            }
        }

        .carousel-track {
            display: flex;
            width: 300%;
            /* Triple width for seamless loop */
            height: 100%;
            animation: slideLoop 120s linear infinite;
            /* Continuous 2-minute loop */
        }

        /* Infinite Scrolling Hero Background */
        .hero-masonry-background {
            position: absolute;
            inset: 0;
            overflow: hidden;
            opacity: 0.6;
            z-index: 2;
            will-change: transform;
        }

        .infinite-scroll-container {
            position: absolute;
            width: 100%;
            height: 200%;
            top: 0;
            left: 0;
            display: flex;
            flex-direction: column;
            gap: 20px;
            animation: infiniteVerticalScroll 120s linear infinite;
            will-change: transform;
        }

        .scroll-row {
            display: flex;
            width: 200%;
            gap: 20px;
            flex-shrink: 0;
            will-change: transform;
        }

        .scroll-row:nth-child(odd) {
            animation: infiniteHorizontalLeft 80s linear infinite;
        }

        .scroll-row:nth-child(even) {
            animation: infiniteHorizontalRight 100s linear infinite;
        }

        .scroll-row:nth-child(3n) {
            animation: infiniteHorizontalLeft 60s linear infinite;
        }

        .hero-masonry-background::before {
            content: '';
            position: absolute;
            inset: -10%;
            background: radial-gradient(circle at 30% 20%,
                    rgba(1, 172, 182, 0.1) 0%,
                    transparent 50%),
                radial-gradient(circle at 70% 80%,
                    rgba(239, 35, 75, 0.1) 0%,
                    transparent 50%);
            animation: backgroundPulse 6s ease-in-out infinite;
            z-index: -1;
        }

        @keyframes backgroundPulse {

            0%,
            100% {
                opacity: 0.3;
                transform: scale(1);
            }

            50% {
                opacity: 0.6;
                transform: scale(1.1);
            }
        }

        .hero-masonry-item {
            position: relative;
            overflow: hidden;
            border-radius: 12px;
            background: linear-gradient(135deg, #f3f4f6, #e5e7eb);
            cursor: pointer;
            flex-shrink: 0;
            will-change: transform;
            transition: transform 0.3s ease;
        }

        .scroll-item {
            width: 200px;
            height: 120px;
            flex-shrink: 0;
            position: relative;
            overflow: hidden;
            border-radius: 12px;
            background: linear-gradient(135deg, #f3f4f6, #e5e7eb);
            cursor: pointer;
            will-change: transform;
            transition: transform 0.3s ease;
        }

        .scroll-item.tall {
            height: 160px;
        }

        .scroll-item.medium {
            height: 140px;
        }

        .scroll-item.wide {
            width: 260px;
        }

        .scroll-item:hover {
            transform: scale(1.05) translateZ(0);
            z-index: 10;
        }

        .hero-masonry-item:hover {
            transform: scale3d(1.05, 1.05, 1) translate3d(0, -8px, 0);
            z-index: 5;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }

        /* Masonry Item Overlay */
        .masonry-item-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(1, 172, 182, 0.8), rgba(239, 35, 75, 0.6));
            opacity: 0;
            transition: all 0.4s ease;
            backdrop-filter: blur(2px);
            border-radius: 12px;
            z-index: 2;
        }

        .hero-masonry-item:hover .masonry-item-overlay {
            opacity: 1;
        }

        /* Icon overlays */
        .masonry-play-icon,
        .masonry-zoom-icon {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0);
            z-index: 3;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            width: 50px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(10px);
        }

        .hero-masonry-item:hover .masonry-play-icon,
        .hero-masonry-item:hover .masonry-zoom-icon {
            transform: translate(-50%, -50%) scale(1);
        }

        .play-icon,
        .zoom-icon {
            width: 20px;
            height: 20px;
            color: #1f2937;
        }

        /* Consistent height patterns for clean masonry */
        .masonry-short {
            height: 200px;
        }

        .masonry-medium {
            height: 280px;
        }

        .masonry-tall {
            height: 360px;
        }

        .hero-masonry-media {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: all 0.4s ease;
            cursor: pointer;
            filter: brightness(0.8);
        }

        .hero-masonry-item:hover .hero-masonry-media {
            filter: brightness(1) contrast(1.1);
            transform: scale(1.05);
        }

        .hero-masonry-placeholder {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #374151, #1f2937);
            border-radius: 8px;
        }

        .portfolio-item2 {
            position: relative;
            overflow: hidden;
            border-radius: 1rem;
        }

        .portfolio-item2 img,
        .portfolio-item2 video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .portfolio-video2 {
            transition: none;
            /* Remove transitions for smoother performance */
        }

        @keyframes slideLoop {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-66.666%);
            }

            /* Move 2/3 to loop back */
        }

        /* Enhanced overlay with better gradient for text readability */
        .hero-overlay-enhanced {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg,
                    rgba(0, 0, 0, 0.75) 0%,
                    rgba(0, 0, 0, 0.5) 25%,
                    rgba(0, 0, 0, 0.6) 50%,
                    rgba(0, 0, 0, 0.5) 75%,
                    rgba(0, 0, 0, 0.75) 100%);
            backdrop-filter: blur(2px);
            z-index: 10;
        }

        /* Centered content container */
        .hero-content-centered {
            position: absolute;
            inset: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 20;
            padding: 2rem;
        }

        .hero-content-wrapper {
            text-align: center;
            color: white;
            max-width: 900px;
            width: 100%;
            animation: heroContentSlideUp 1.2s cubic-bezier(0.4, 0, 0.2, 1) 0.3s both;
            transform: translateY(30px);
            opacity: 0;
        }

        /* Hero Badge */
        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50px;
            padding: 1rem 1.5rem;
            margin-bottom: 2rem;
            transition: all 0.3s ease;
        }

        .hero-badge:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateY(-2px);
        }

        .hero-badge-icon {
            width: 1.25rem;
            height: 1.25rem;
            color: #01acb6;
        }

        .hero-badge span {
            font-size: 0.875rem;
            font-weight: 600;
            letter-spacing: 0.1em;
            color: white;
        }

        /* Hero Title */
        .hero-title {
            font-size: clamp(3rem, 8vw, 6rem);
            font-weight: 900;
            line-height: 1.1;
            margin-bottom: 1.5rem;
            letter-spacing: -0.02em;
        }

        .hero-title-gradient {
            background: #01acb6;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Hero Tagline */
        .hero-tagline-text {
            font-size: clamp(1.125rem, 3vw, 1.5rem);
            color: rgba(255, 255, 255, 0.9);
            line-height: 1.6;
            margin-bottom: 2.5rem;
            font-weight: 300;
        }

        /* Call to Action Buttons */
        .hero-cta-wrapper {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            justify-content: center;
            align-items: center;
        }

        .hero-cta-primary {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            background: #01acb6;
            color: white;
            padding: 1.25rem 2.5rem;
            border-radius: 50px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            font-size: 1.1rem;
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.3);
        }

        .hero-cta-primary::before {
            content: '';
            position: absolute;
            inset: 0;
            background: #01acb6;
            opacity: 0;
            transition: opacity 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .hero-cta-primary:hover::before {
            opacity: 1;
        }

        .hero-cta-primary:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 15px 40px rgba(1, 172, 182, 0.5);
        }

        .hero-cta-primary span,
        .hero-cta-primary i {
            position: relative;
            z-index: 1;
        }

        .hero-cta-secondary {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            color: white;
            padding: 1.25rem 2.5rem;
            border-radius: 50px;
            font-weight: 600;
            border: 2px solid rgba(255, 255, 255, 0.2);
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            font-size: 1.1rem;
            box-shadow: 0 8px 25px rgba(255, 255, 255, 0.1);
        }

        .hero-cta-secondary::before {
            content: '';
            position: absolute;
            inset: 0;
            background: rgba(255, 255, 255, 0.1);
            opacity: 0;
            transition: opacity 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .hero-cta-secondary:hover::before {
            opacity: 1;
        }

        .hero-cta-secondary:hover {
            border-color: rgba(255, 255, 255, 0.4);
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 15px 40px rgba(255, 255, 255, 0.2);
        }

        .hero-cta-icon {
            width: 1rem;
            height: 1rem;
            transition: transform 0.3s ease;
        }

        .hero-cta-primary:hover .hero-cta-icon {
            transform: translateX(4px);
        }

        /* Floating Geometric Shapes */
        .floating-shapes-container {
            position: absolute;
            inset: 0;
            pointer-events: none;
            z-index: 5;
        }

        .floating-shape {
            position: absolute;
            opacity: 0.3;
            animation: floatAnimation 6s ease-in-out infinite;
        }

        .shape-circle {
            width: 60px;
            height: 60px;
            background: #01acb6;
            border-radius: 50%;
            filter: blur(1px);
        }

        .shape-triangle {
            width: 0;
            height: 0;
            border-left: 30px solid transparent;
            border-right: 30px solid transparent;
            border-bottom: 50px solid #01acb6;
            filter: blur(1px);
        }

        .shape-square {
            width: 50px;
            height: 50px;
            background: #EF234B;
            border-radius: 8px;
            filter: blur(1px);
            transform: rotate(45deg);
        }

        /* Animation Keyframes */
        /* Infinite Scrolling Animations */
        @keyframes infiniteVerticalScroll {
            0% {
                transform: translateY(0);
            }

            100% {
                transform: translateY(-50%);
            }
        }

        @keyframes infiniteHorizontalLeft {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-50%);
            }
        }

        @keyframes infiniteHorizontalRight {
            0% {
                transform: translateX(-50%);
            }

            100% {
                transform: translateX(0);
            }
        }

        .scroll-item img,
        .scroll-item video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .scroll-item:hover img,
        .scroll-item:hover video {
            transform: scale(1.1);
        }

        @keyframes floatAnimation {

            0%,
            100% {
                transform: translate3d(0, 0, 0) rotate(0deg);
            }

            33% {
                transform: translate3d(0, -20px, 0) rotate(120deg);
            }

            66% {
                transform: translate3d(0, 10px, 0) rotate(240deg);
            }
        }

        @keyframes heroContentSlideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Enhanced Staggered Hero Content Animations */
        .hero-badge {
            opacity: 0;
            transform: translateY(-20px);
            animation: badgeSlideDown 0.8s cubic-bezier(0.4, 0, 0.2, 1) 0.6s both;
        }

        .hero-title {
            opacity: 0;
            transform: translateY(30px);
            animation: titleSlideUp 1s cubic-bezier(0.4, 0, 0.2, 1) 0.8s both;
        }

        .hero-tagline-text {
            opacity: 0;
            transform: translateY(20px);
            animation: taglineSlideUp 0.8s cubic-bezier(0.4, 0, 0.2, 1) 1.1s both;
        }

        .hero-cta-wrapper {
            opacity: 0;
            transform: translateY(25px);
            animation: ctaSlideUp 0.9s cubic-bezier(0.4, 0, 0.2, 1) 1.4s both;
        }

        @keyframes badgeSlideDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes titleSlideUp {
            from {
                opacity: 0;
                transform: translateY(40px) scale(0.9);
            }

            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        @keyframes taglineSlideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes ctaSlideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile responsive adjustments */
        @media (max-width: 1024px) {
            .scroll-item {
                width: 180px;
                height: 100px;
            }

            .scroll-item.tall {
                height: 140px;
            }

            .scroll-item.medium {
                height: 120px;
            }

            .scroll-item.wide {
                width: 220px;
            }

            .infinite-scroll-container {
                gap: 15px;
            }

            .scroll-row {
                gap: 15px;
            }

            .hero-title {
                font-size: clamp(2.5rem, 7vw, 5rem);
                margin-bottom: 1rem;
            }

            .hero-tagline-text {
                font-size: clamp(1rem, 2.5vw, 1.25rem);
                margin-bottom: 2rem;
            }

            .hero-cta-wrapper {
                gap: 0.75rem;
            }

            .hero-cta-primary,
            .hero-cta-secondary {
                padding: 1rem 2rem;
                font-size: 1rem;
            }
        }

        @media (max-width: 768px) {
            .scroll-item {
                width: 160px;
                height: 90px;
            }

            .scroll-item.tall {
                height: 120px;
            }

            .scroll-item.medium {
                height: 100px;
            }

            .scroll-item.wide {
                width: 200px;
            }

            .infinite-scroll-container {
                gap: 12px;
            }

            .scroll-row {
                gap: 12px;
            }

            /* Slower animations on mobile for better performance */
            .infinite-scroll-container {
                animation-duration: 150s;
            }

            .scroll-row:nth-child(odd) {
                animation-duration: 100s;
            }

            .scroll-row:nth-child(even) {
                animation-duration: 120s;
            }

            .hero-content-centered {
                padding: 1rem;
            }

            .hero-cta-wrapper {
                flex-direction: column;
                gap: 0.75rem;
            }

            .hero-cta-primary,
            .hero-cta-secondary {
                width: 100%;
                max-width: 280px;
                justify-content: center;
            }

            /* Reduce floating shapes on mobile */
            .floating-shape {
                opacity: 0.2;
                transform: scale(0.7);
            }

            .shape-circle {
                width: 40px;
                height: 40px;
            }

            .shape-square {
                width: 35px;
                height: 35px;
            }

            .shape-triangle {
                border-left-width: 20px;
                border-right-width: 20px;
                border-bottom-width: 35px;
            }
        }

        @media (max-width: 480px) {
            .scroll-item {
                width: 140px;
                height: 80px;
            }

            .scroll-item.tall {
                height: 100px;
            }

            .scroll-item.medium {
                height: 90px;
            }

            .scroll-item.wide {
                width: 180px;
            }

            .infinite-scroll-container {
                gap: 10px;
            }

            .scroll-row {
                gap: 10px;
            }

            .hero-masonry-background {
                opacity: 0.4;
            }

            .hero-badge {
                padding: 0.75rem 1.25rem;
                margin-bottom: 1.5rem;
            }

            .hero-badge span {
                font-size: 0.75rem;
            }

            /* Very slow animations on smallest screens */
            .infinite-scroll-container {
                animation-duration: 200s;
            }

            .scroll-row:nth-child(odd) {
                animation-duration: 140s;
            }

            .scroll-row:nth-child(even) {
                animation-duration: 160s;
            }

            .scroll-row:nth-child(3n) {
                animation-duration: 120s;
            }
        }

        .hero-content-wrapper {
            position: relative;
            z-index: 2;
            color: white;
        }

        .hero-tagline {
            font-size: clamp(2rem, 5vw, 4rem);
            font-weight: 300;
            line-height: 1.2;
            margin-bottom: 2rem;
            text-align: center;
        }

        .hero-tagline .highlight {
            font-weight: 700;
            background: #EF234B;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero-stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .hero-stat-item h3 {
            font-size: clamp(2.5rem, 4vw, 4rem);
            font-weight: 800;
            margin-bottom: 0.5rem;
            color: #ffffff;
        }

        .hero-stat-item p {
            font-size: 1rem;
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.4;
        }

        .hero-description {
            text-align: center;
            margin-top: 2rem;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .hero-description p {
            font-size: 1.1rem;
            color: rgba(255, 255, 255, 0.9);
            line-height: 1.6;
            max-width: 600px;
            margin: 0 auto;
        }

        .hero-cta-button {
            position: absolute;
            bottom: 40px;
            right: 40px;
            width: 80px;
            height: 80px;
            background: #EF234B;
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 8px 25px rgba(239, 35, 75, 0.4);
        }

        .hero-cta-button:hover {
            transform: scale(1.1);
            box-shadow: 0 12px 35px rgba(239, 35, 75, 0.6);
        }

        .hero-cta-button svg {
            width: 24px;
            height: 24px;
            color: white;
        }

        /* Scroll reveal effects */
        .reveal {
            opacity: 0;
            transform: translateY(22px);
            transition: opacity .6s ease, transform .6s ease;
            will-change: opacity, transform;
        }

        .reveal-up {
            transform: translateY(22px);
        }

        .reveal-left {
            transform: translateX(-22px);
        }

        .reveal-right {
            transform: translateX(22px);
        }

        .reveal.is-visible {
            opacity: 1;
            transform: none;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .hero-main-card {
                margin: 20px;
                padding: 32px 24px;
                border-radius: 24px;
                width: calc(100% - 40px);
                max-width: none;
            }

            .hero-stats-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
                text-align: center;
            }

            .hero-cta-button {
                bottom: 20px;
                right: 20px;
                width: 60px;
                height: 60px;
            }

            .hero-cta-button svg {
                width: 20px;
                height: 20px;
            }
        }

        @media (max-width: 480px) {
            .hero-main-card {
                margin: 15px;
                padding: 24px 16px;
                border-radius: 20px;
                width: calc(100% - 30px);
            }
        }

        /* Optimized transitions - Applied selectively */
        .nav-link,
        .portfolio-filter,
        .portfolio-item,
        .hero-cta-primary,
        .hero-cta-secondary,
        .testimonial-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Custom scrollbar for modern look */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: rgba(15, 23, 42, 0.1);
        }

        ::-webkit-scrollbar-thumb {
            background: #01acb6;
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(to bottom, #0891b2, #2563eb);
        }

        /* Enhanced Header with modern glassmorphism */
        #header {
            z-index: 9999;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            will-change: transform, background-color, backdrop-filter;
            backdrop-filter: blur(25px);
            background: rgba(0, 0, 0, 0.7);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
        }

        /* Enhanced smooth transitions for all header elements */
        #header * {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Modern scrolled state with glassmorphism */
        #header.scrolled {
            background: rgba(0, 0, 0, 0.9);
            backdrop-filter: blur(25px);
            border-bottom: 1px solid rgba(1, 172, 182, 0.2);
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.4),
                0 0 0 1px rgba(1, 172, 182, 0.1);
        }

        /* Enhanced navigation links with advanced animations */
        .nav-link {
            position: relative;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.75rem;
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
            overflow: hidden;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(1, 172, 182, 0.12), rgba(239, 35, 75, 0.12));
            transform: scale(0) rotate(45deg);
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
            border-radius: 0.75rem;
            z-index: -1;
        }

        .nav-link::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: radial-gradient(circle, rgba(1, 172, 182, 0.3), transparent 70%);
            transform: translate(-50%, -50%);
            transition: all 0.6s cubic-bezier(0.23, 1, 0.32, 1);
            border-radius: 50%;
            z-index: -1;
        }

        .nav-link:hover::before {
            transform: scale(1.1) rotate(0deg);
        }

        .nav-link:hover::after {
            width: 100px;
            height: 100px;
        }

        .nav-link:hover {
            color: #EF234B;
            transform: translateY(-3px) scale(1.02);
            text-shadow: 0 0 20px rgba(1, 172, 182, 0.5);
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.2);
        }

        .nav-link:hover i {
            transform: scale(1.15) rotate(10deg);
            filter: drop-shadow(0 0 8px rgba(1, 172, 182, 0.4));
        }

        /* Active state for current page */
        .nav-link.active {
            background: linear-gradient(135deg, rgba(1, 172, 182, 0.15), rgba(239, 35, 75, 0.15));
            color: #EF234B;
            font-weight: 600;
            transform: translateY(-1px);
            box-shadow: 0 4px 15px rgba(1, 172, 182, 0.25);
        }

        /* Portfolio Filter Buttons */
        .portfolio-filter {
            display: inline-flex;
            align-items: center;
            padding: 12px 24px;
            background: rgba(255, 255, 255, 0.1);
            border: 2px solid rgba(1, 172, 182, 0.3);
            border-radius: 50px;
            color: #666;
            font-weight: 500;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }

        .portfolio-filter::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(1, 172, 182, 0.2), transparent);
            transition: left 0.5s ease;
        }

        .portfolio-filter:hover::before {
            left: 100%;
        }

        .portfolio-filter:hover {
            background: rgba(1, 172, 182, 0.1);
            border-color: rgba(1, 172, 182, 0.6);
            color: #01acb6;
            transform: translateY(-2px) scale(1.02);
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.2);
        }

        .portfolio-filter.active {
            background: linear-gradient(135deg, #01acb6, #018a92);
            border-color: #01acb6;
            color: white;
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.4);
            transform: translateY(-2px);
        }

        .portfolio-filter.active::before {
            display: none;
        }

        /* Portfolio Grid Animation */
        .portfolio-grid {
            transition: all 0.5s ease;
        }

        .portfolio-item {
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            transform-origin: center;
        }

        .portfolio-item.hidden {
            opacity: 0;
            transform: scale(0.8) translateY(20px);
            pointer-events: none;
        }

        .portfolio-item.show {
            opacity: 1;
            transform: scale(1) translateY(0);
            pointer-events: all;
        }

        /* Portfolio Item Hover Effects */
        .portfolio-item:hover {
            transform: translateY(-8px) scale(1.02);
        }

        /* Testimonials Animation */
        .testimonial-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .testimonial-card:hover {
            transform: translateY(-8px) rotate(1deg);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }

        @media (max-width: 768px) {
            .portfolio-filter {
                padding: 10px 16px;
                font-size: 12px;
                margin: 4px;
            }

            .portfolio-item {
                margin-bottom: 2rem;
            }
        }

        .nav-link i {
            transition: all 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            display: inline-block;
        }

        /* Header entrance animation */
        @keyframes headerSlideDown {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        #header {
            animation: headerSlideDown 0.8s cubic-bezier(0.23, 1, 0.32, 1);
        }

        /* Enhanced logo with hover effects */
        #header img {
            transition: all 0.5s cubic-bezier(0.23, 1, 0.32, 1);
            filter: drop-shadow(0 0 10px rgba(1, 172, 182, 0.2));
        }

        #header img:hover {
            transform: scale(1.08) rotate(5deg);
            filter: drop-shadow(0 0 25px rgba(1, 172, 182, 0.6));
        }

        /* CTA Button enhanced animations */
        .cta-button,
        a[class*="bg-gradient-to-r"] {
            position: relative;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
        }

        .cta-button::before,
        a[class*="bg-gradient-to-r"]::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: all 0.6s cubic-bezier(0.23, 1, 0.32, 1);
        }

        .cta-button:hover::before,
        a[class*="bg-gradient-to-r"]:hover::before {
            left: 100%;
        }

        .cta-button:hover,
        a[class*="bg-gradient-to-r"]:hover {
            transform: translateY(-2px) scale(1.02);
            box-shadow: 0 15px 40px rgba(1, 172, 182, 0.4);
        }

        #header.scrolled img {
            filter: brightness(1.1) drop-shadow(0 0 15px rgba(1, 172, 182, 0.4));
        }

        /* Modern mobile menu button */
        #mobile-menu-btn {
            position: relative;
            padding: 0.75rem;
            border-radius: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        #mobile-menu-btn:hover {
            background: rgba(1, 172, 182, 0.2);
            border-color: rgba(1, 172, 182, 0.4);
            transform: scale(1.05);
        }

        #header.scrolled #mobile-menu-btn {
            background: rgba(1, 172, 182, 0.1);
            border-color: rgba(1, 172, 182, 0.3);
        }

        /* Enhanced mobile menu */
        #mobile-menu {
            background: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(1, 172, 182, 0.2);
            border-radius: 1rem;
            margin-top: 1rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            transform: translateY(-10px);
            opacity: 0;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        #mobile-menu:not(.hidden) {
            transform: translateY(0);
            opacity: 1;
        }

        #mobile-menu .nav-link {
            display: block;
            margin: 0.25rem 0;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        #mobile-menu .nav-link:hover {
            background: rgba(1, 172, 182, 0.1);
            transform: translateX(10px);
        }

        /* Header visible state */
        #header.header-visible {
            transform: translateY(0);
        }

        /* Header hidden state */
        #header.header-hidden {
            transform: translateY(-100%);
        }

        /* Marquee Animation */
        .marquee-wrapper {
            overflow: hidden;
            width: 100%;
            position: relative;
        }

        .marquee-track {
            display: flex;
            gap: 6vw;
            width: max-content;
            animation: marquee-scroll 30s linear infinite;
        }

        @keyframes marquee-scroll {
            0% {
                transform: translate3d(0, 0, 0);
            }

            100% {
                transform: translate3d(-100%, 0, 0);
            }
        }

        @keyframes marquee-scroll {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-50%);
            }
        }

        .marquee-logo {
            height: clamp(28px, 6vh, 56px);
            width: auto;
            max-height: 72vh;
            opacity: 0.9;
            transition: opacity 0.2s ease, transform 0.2s ease;
        }

        .marquee-logo:hover {
            opacity: 1;
            transform: scale(1.05);
        }

        @media (max-width: 768px) {
            .marquee-track {
                gap: 10vw;
                animation-duration: 24s;
            }

            .marquee-logo {
                height: clamp(24px, 5.5vh, 48px);
            }
        }

        @media (max-width: 480px) {
            .marquee-track {
                gap: 12vw;
                animation-duration: 20s;
            }

            .marquee-logo {
                height: clamp(22px, 5vh, 42px);
            }
        }

        /* Prevent long words from breaking layouts */
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        p,
        .card h3,
        .card p {
            overflow-wrap: anywhere;
            word-break: normal;
        }

        /* Responsive header logo sizing */
        #header img {
            height: clamp(28px, 6vw, 48px);
            width: auto;
        }

        /* Respect reduced motion preferences */
        @media (prefers-reduced-motion: reduce) {
            .marquee-track {
                animation: none;
            }
        }

        /* Image modal sizing and animation */
        #imageModal .modal-content {
            width: min(90vw, 1100px);
            max-width: none;
            padding: 1rem;
        }

        #imageModal .modal-image {
            width: 100%;
            height: auto;
            aspect-ratio: 16 / 9;
            max-height: min(75vh, 650px);
            object-fit: contain;
            transition: transform 0.3s ease;
        }

        #imageModal .modal-image:hover {
            transform: scale(1.01);
        }

        @keyframes imagePop {
            from {
                transform: scale(0.96);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        #imageModal .modal-image.animate-in {
            animation: imagePop 0.35s ease-out;
        }

        /* Individual social media colors */
        .social-tiktok {
            background: #000000;
        }

        .social-linkedin {
            background: #0077B5;
        }

        .social-facebook {
            background: #1877F2;
        }

        .social-instagram {
            background: linear-gradient(45deg, #F56040, #E1306C, #C13584, #833AB4);
        }

        .social-whatsapp {
            background: #25D366;
        }

        @keyframes socialFloat {

            0%,
            100% {
                transform: translateY(0px) translateX(0px);
            }

            25% {
                transform: translateY(-5px) translateX(2px);
            }

            50% {
                transform: translateY(0px) translateX(-2px);
            }

            75% {
                transform: translateY(5px) translateX(1px);
            }
        }

        /* Portfolio Social Media Icons - Brand Colors */
        .social-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 48px;
            height: 48px;
            border-radius: 12px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateY(0);
            position: relative;
            overflow: hidden;
        }

        .social-icon::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            border-radius: inherit;
            background: inherit;
            opacity: 0;
            transform: scale(0);
            transition: all 0.3s ease;
        }

        .social-icon:hover::before {
            opacity: 0.1;
            transform: scale(1.1);
        }

        .social-icon:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }

        .instagram-icon {
            background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
            color: white;
        }

        .instagram-icon:hover {
            box-shadow: 0 8px 25px rgba(225, 48, 108, 0.4);
        }

        .facebook-icon {
            background: #1877F2;
            color: white;
        }

        .facebook-icon:hover {
            box-shadow: 0 8px 25px rgba(24, 119, 242, 0.4);
        }

        .tiktok-icon {
            background: #000000;
            color: white;
        }

        .tiktok-icon:hover {
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
        }

        .youtube-icon {
            background: #FF0000;
            color: white;
        }

        .youtube-icon:hover {
            box-shadow: 0 8px 25px rgba(255, 0, 0, 0.4);
        }

        .twitter-icon {
            background: #1DA1F2;
            color: white;
        }

        .twitter-icon:hover {
            box-shadow: 0 8px 25px rgba(29, 161, 242, 0.4);
        }

        .linkedin-icon {
            background: #0077B5;
            color: white;
        }

        .linkedin-icon:hover {
            box-shadow: 0 8px 25px rgba(0, 119, 181, 0.4);
        }

        .snapchat-icon {
            background: #FFFC00;
            color: black;
        }

        .snapchat-icon:hover {
            box-shadow: 0 8px 25px rgba(255, 252, 0, 0.4);
        }

        .whatsapp-icon {
            background: #25D366;
            color: white;
        }

        .whatsapp-icon:hover {
            box-shadow: 0 8px 25px rgba(37, 211, 102, 0.4);
        }

        .link-icon {
            background: #6B7280;
            color: white;
        }

        .link-icon:hover {
            background: #01acb6;
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.4);
        }

        /* Shared tag and card styles for consistency */
        .tag {
            transition: all .2s ease;
            border: 2px solid transparent;
        }

        .tag:hover {
            background: #01acb6 !important;
            color: #fff !important;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(1, 172, 182, 0.3);
        }

        .card {
            transition: transform .25s ease, box-shadow .25s ease;
            border: 2px solid transparent;
        }

        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 24px rgba(2, 6, 23, .08);
        }

        /* Modern glassmorphism effects */
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        /* Modern shadows */
        .modern-shadow {
            box-shadow:
                0 4px 6px -1px rgba(0, 0, 0, 0.1),
                0 2px 4px -1px rgba(0, 0, 0, 0.06),
                0 20px 25px -5px rgba(0, 0, 0, 0.1),
                0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        /* Hover glow effects */
        .hover-glow:hover {
            box-shadow:
                0 0 20px rgba(6, 182, 212, 0.3),
                0 0 40px rgba(6, 182, 212, 0.2),
                0 0 60px rgba(6, 182, 212, 0.1);
        }

        .section {
            padding: 6rem 0;
        }

        @media (max-width: 768px) {
            .section {
                padding: 4rem 0;
            }
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 800;
            text-align: center;
            margin-bottom: 4rem;
            letter-spacing: -0.02em;
            line-height: 1.1;
        }

        @media (min-width: 768px) {
            .section-title {
                font-size: 3.5rem;
            }
        }

        .grid {
            display: grid;
            gap: 2rem;
        }

        .grid-2 {
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        }

        .grid-3 {
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        }

        .card {
            background: white;
            border-radius: 1rem;
            padding: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .card-icon {
            width: 60px;
            height: 60px;
            background: #01acb6;
            border-radius: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
            color: white;
        }

        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: #333;
        }

        .card-description {
            color: #666;
            line-height: 1.6;
        }

        /* <CHANGE> Added alternating light and dark carousel themes */
        .carousel-container {
            position: relative;
            width: 100%;
            height: 50vh;
            min-height: 280px;
            overflow: hidden;
            border-radius: 1.5rem;
            border: 1px solid rgba(255, 255, 255, 0.1);
            background: rgb(0, 0, 0);
        }

        /* Dark theme carousel (default) */
        .carousel-container.dark {
            background: rgba(0, 0, 0, 0.8);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .carousel-container.dark .carousel-overlay {
            background: linear-gradient(to top, rgba(0, 0, 0, 0.8) 0%, rgba(0, 0, 0, 0.2) 50%, transparent 100%);
        }

        .carousel-container.dark .carousel-content {
            color: white;
        }


        /* Light theme carousel */
        .carousel-container.light {
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(0, 0, 0, 0.1);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .carousel-container.light .carousel-overlay {
            background: linear-gradient(to top, rgba(255, 255, 255, 0.9) 0%, rgba(255, 255, 255, 0.3) 50%, transparent 100%);
        }

        .carousel-container.light .carousel-content {
            color: #333;
        }

        .carousel-container.light .carousel-content h3 {
            color: #01acb6;
        }

        .carousel-container.light .carousel-content p {
            color: #666 !important;
        }


        .carousel-slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }

        .carousel-slide.active {
            opacity: 1;
        }

        .carousel-slide img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .carousel-content {
            position: absolute;
            bottom: 0;
            left: 0;
            background-color: rgba(0, 0, 0, 0.558);

            right: 0;
            padding: 2rem;
        }

        /* Minimal Modern Carousel Dots - 60fps Optimized */
        .carousel-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: rgba(156, 163, 175, 0.5);
            /* Soft gray for inactive */
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            /* Smooth easing for 60fps */
            border: none;
            will-change: transform, background-color;
            /* GPU optimization for smooth animations */
            transform-origin: center;
        }

        .carousel-dot.active {
            background: #01acb6;
            /* Brand accent color */
            transform: scale(1.6);
            /* Smooth animated growth */
        }

        .carousel-dot:hover:not(.active) {
            background: rgba(156, 163, 175, 0.8);
            /* Enhanced soft gray on hover */
            transform: scale(1.15);
        }

        /* Light theme dots - minimal clean styling */
        .carousel-dots.light .carousel-dot {
            background: rgba(107, 114, 128, 0.4);
            /* Soft gray for light theme */
        }

        .carousel-dots.light .carousel-dot.active {
            background: #01acb6;
            /* Same brand color for consistency */
        }

        .carousel-dots.light .carousel-dot:hover:not(.active) {
            background: rgba(107, 114, 128, 0.7);
        }

        /* Minimal Carousel Dots Container */
        .carousel-dots-container {
            padding: 8px 0;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            background: transparent;
            border: none;
        }

        /* Responsive behavior - Minimal and Clean */
        @media (max-width: 768px) {
            .carousel-dot {
                width: 8px;
                height: 8px;
            }

            .carousel-dot.active {
                transform: scale(1.5);
                /* Slightly smaller growth on mobile */
            }

            .carousel-dots-container {
                gap: 10px;
            }
        }

        @media (max-width: 480px) {
            .carousel-dot {
                width: 7px;
                height: 7px;
            }

            .carousel-dot.active {
                transform: scale(1.4);
            }

            .carousel-dots-container {
                gap: 8px;
                padding: 6px 0;
            }
        }

        .info-card {
            padding: 1.25rem;
            border-radius: 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }

        .info-card:hover {
            background: rgba(255, 255, 255, 0.08);
            transform: translateY(-2px);
        }

        /* Light theme info cards */
        .info-card.light {
            background: rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.1);
            color: #333;
        }

        .info-card.light:hover {
            background: rgba(0, 0, 0, 0.08);
        }

        /* Fallback for missing images */
        .carousel-slide img {
            background: #01acb6;
        }


        /* Section background alternating */
        .section.dark {
            background: #1a1a1a;
            color: white;
        }

        .section.light {
            background: #f8f9fa;
            color: #333;
        }

        .section.dark .section-title {
            color: #ffffff;
            background: linear-gradient(135deg, #ffffff 0%, #e2e8f0 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .section.light .section-title {
            color: #1a1a1a;
            background: linear-gradient(135deg, #1a1a1a 0%, #4a5568 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Portfolio Video Hover Styles */
        .portfolio-video {
            position: relative;
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: all 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            cursor: pointer;
        }

        /* Pixel video effect */
        .portfolio-video {
            image-rendering: pixelated;
            image-rendering: -moz-crisp-edges;
            image-rendering: crisp-edges;
        }

        /* Enhanced Video states with pixel effects */
        .portfolio-video.paused,
        .masonry-video.paused,
        video.paused {
            filter: contrast(1.3) saturate(0.8) blur(0.8px) brightness(0.9) grayscale(10%);
            image-rendering: pixelated;
            image-rendering: -moz-crisp-edges;
            image-rendering: crisp-edges;
        }

        .portfolio-video.playing,
        .masonry-video.playing,
        video.playing {
            filter: brightness(1.1) contrast(1.05) saturate(1.2) blur(0px) grayscale(0%);
            image-rendering: auto;
        }

        /* Pixel video transition effects */
        .masonry-video,
        .portfolio-video,
        video {
            transition: filter 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94),
                       transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94),
                       image-rendering 0.3s ease;
        }

        /* Enhanced hover effects for portfolio items */
        .portfolio-item .group {
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            overflow: hidden;
        }

        .portfolio-item .group:hover {
            /* No movement, just subtle effects */
        }

        .portfolio-item .group:hover .portfolio-video {
            transform: scale(1.05);
            filter: brightness(1.1) contrast(1.05) saturate(1.1) grayscale(0%);
        }


        /* Video first frame styling */
        .portfolio-video:not(.playing) {
            filter: grayscale(10%) brightness(0.95);
        }

        .tool-icon {
            width: 24px;
            height: 24px;
            /* filter: brightness(0) saturate(100%) invert(69%) sepia(25%) saturate(1738%) hue-rotate(158deg) brightness(91%) contrast(87%); */
        }

        .container2 {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Enhanced Masonry Grid with Dynamic Spanning */
        .masonry-grid1 {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            grid-auto-rows: minmax(200px, auto);
            grid-auto-flow: dense;
            padding: 20px;
        }

        .masonry-item {
            position: relative;
            overflow: hidden;
            border-radius: 16px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            transform-origin: center;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        }

        .masonry-item:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        /* Horizontal span for wide media (width > height) */
        .masonry-item.span-horizontal {
            grid-column: span 2;
        }

        /* Vertical span for tall media (height > width) */
        .masonry-item.span-vertical {
            grid-row: span 2;
        }

        /* Special case: extra wide or tall content */
        .masonry-item.span-large-horizontal {
            grid-column: span 3;
        }

        .masonry-item.span-large-vertical {
            grid-row: span 3;
        }

        /* Enhanced media styling */
        .masonry-item .masonry-image,
        .masonry-item .masonry-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 12px;
        }

        /* Enhanced Pixelated video effect */
        .masonry-item .masonry-video,
        .masonry-item video,
        .portfolio-item video,
        .scroll-item video {
            filter: contrast(1.3) saturate(0.8) blur(0.8px) brightness(0.9);
            image-rendering: pixelated;
            image-rendering: -moz-crisp-edges;
            image-rendering: crisp-edges;
            image-rendering: optimize-contrast;
            transform: scale(1.01);
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        /* Pixel effect for iframe videos */
        .iframe-container iframe,
        .masonry-item iframe {
            filter: contrast(1.3) saturate(0.8) blur(0.8px) brightness(0.9);
            image-rendering: pixelated;
            image-rendering: -moz-crisp-edges;
            image-rendering: crisp-edges;
            image-rendering: optimize-contrast;
            transform: scale(1.01);
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        /* Hover effects */
        .masonry-item:hover .masonry-image {
            transform: scale(1.1);
        }

        /* Enhanced hover effects for videos and iframes */
        .masonry-item:hover .masonry-video,
        .masonry-item:hover video,
        .portfolio-item:hover video,
        .scroll-item:hover video {
            transform: scale(1.08);
            filter: contrast(1.1) saturate(1.2) blur(0px) brightness(1.1);
            image-rendering: auto;
        }

        .iframe-container:hover iframe,
        .masonry-item:hover iframe {
            transform: scale(1.08);
            filter: contrast(1.1) saturate(1.2) blur(0px) brightness(1.1);
            image-rendering: auto;
        }

        /* Video play indicator */
        .video-play-indicator {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: rgba(0, 0, 0, 0.7);
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 1;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            pointer-events: none;
            backdrop-filter: blur(10px);
            border: 2px solid rgba(255, 255, 255, 0.3);
        }

        .masonry-item:hover .video-play-indicator {
            opacity: 0;
            transform: translate(-50%, -50%) scale(1.2);
        }

        /* Enhanced video overlay */
        .video-overlay {
            opacity: 1 !important;
            background: linear-gradient(135deg, rgba(0, 0, 0, 0.1) 0%, rgba(0, 0, 0, 0.05) 100%) !important;
        }

        .masonry-item:hover .video-overlay {
            opacity: 0 !important;
        }

        .error {
            background: #2a1a1a;
            color: #ff6b6b;
            padding: 15px;
            text-align: center;
            font-size: 12px;
        }

        /* Responsive adjustments */
        @media (max-width: 1200px) {
            .masonry-grid1 {
                grid-template-columns: repeat(3, 1fr);
                gap: 16px;
                padding: 16px;
            }

            /* Reduce spans on smaller screens */
            .masonry-item.span-large-horizontal {
                grid-column: span 2;
            }
        }

        @media (max-width: 768px) {
            .masonry-grid1 {
                grid-template-columns: repeat(2, 1fr);
                gap: 12px;
                padding: 12px;
                grid-auto-rows: minmax(180px, auto);
            }

            /* On tablets, horizontal spans become single */
            .masonry-item.span-horizontal,
            .masonry-item.span-large-horizontal {
                grid-column: span 1;
            }

            /* Vertical spans reduced */
            .masonry-item.span-large-vertical {
                grid-row: span 2;
            }

            /* Optimized pixelated effect on mobile */
            .masonry-item .masonry-video,
            .masonry-item video,
            .portfolio-item video,
            .scroll-item video {
                filter: contrast(1.2) saturate(0.9) blur(0.5px) brightness(0.95);
                transform: scale(1.005);
            }

            /* Smoother transitions on mobile */
            .masonry-video,
            .portfolio-video,
            video {
                transition: filter 0.3s ease,
                           transform 0.3s ease,
                           image-rendering 0.2s ease;
            }

            /* Reduce hover effects on mobile for better performance */
            .masonry-item:hover video,
            .portfolio-item:hover video,
            .scroll-item:hover video {
                transform: scale(1.05);
                filter: contrast(1.05) saturate(1.1) blur(0px) brightness(1.05);
            }

            .video-play-indicator {
                width: 50px;
                height: 50px;
            }

            .video-play-indicator svg {
                width: 20px;
                height: 20px;
            }
        }

        @media (max-width: 480px) {
            .masonry-grid1 {
                grid-template-columns: 1fr;
                gap: 10px;
                padding: 10px;
                grid-auto-rows: minmax(160px, auto);
            }

            /* All items single column/row on mobile */
            .masonry-item.span-horizontal,
            .masonry-item.span-vertical,
            .masonry-item.span-large-horizontal,
            .masonry-item.span-large-vertical {
                grid-column: span 1;
                grid-row: span 1;
            }
        }

        /* Loading states */
        .masonry-item.loading {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
        }

        @keyframes loading {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }
    </style>
</head>

<body class="bg-white text-slate-800" style="margin: 0; padding: 0; width: 100%; height: 100%;">
    <!-- Social Media Icons Floating -->
    <?php include 'header.php'; ?>

    <!-- Creative Portfolio Gallery Hero Section -->
    <!-- <section class="hero-carousel">
        <div class="hero-masonry-background" id="infiniteScrollBackground">
            <div class="infinite-scroll-container" id="scrollContainer">
            </div>
        </div>

        <div class="floating-shapes-container">
            <div class="floating-shape shape-circle" style="top: 10%; left: 15%; animation-delay: 0s;"></div>
            <div class="floating-shape shape-triangle" style="top: 20%; right: 20%; animation-delay: 1s;"></div>
            <div class="floating-shape shape-square" style="bottom: 30%; left: 10%; animation-delay: 2s;"></div>
            <div class="floating-shape shape-circle" style="bottom: 15%; right: 15%; animation-delay: 1.5s;"></div>
            <div class="floating-shape shape-triangle" style="top: 60%; left: 75%; animation-delay: 0.5s;"></div>
            <div class="floating-shape shape-square" style="top: 40%; right: 70%; animation-delay: 2.5s;"></div>
        </div>

        <div class="hero-overlay-enhanced"></div>

        <div class="hero-content-centered">
            <div class="hero-content-wrapper">
                <div class="hero-badge">
                    <i class="hero-badge-icon" data-lucide="camera"></i>
                    <span>VISUAL STORIES</span>
                </div>

                <h1 class="hero-title">
                    <span class="hero-title-gradient">
                        Visual<br>Stories
                    </span>
                </h1>

                <p class="hero-tagline-text">
                    Where creativity meets technology and dreams become reality
                </p>

                <div class="hero-cta-wrapper">
                    <a href="#portfolio" class="hero-cta-primary">
                        <span>Explore Our Work</span>
                        <i data-lucide="arrow-right" class="hero-cta-icon"></i>
                    </a>

                </div>
            </div>
        </div>
    </section> -->
    <!-- description section -->
    <section class="mt-10 relative min-h-screen bg-gradient-to-br from-black via-gray-900 to-black overflow-hidden py-20">
        <!-- Enhanced Background Elements -->
        <div class="absolute inset-0 pointer-events-none">
            <!-- Animated gradient orbs -->
            <div class="absolute top-20 left-20 w-64 h-64 rounded-full bg-gradient-to-r from-[#01acb6]/30 to-[#0891b2]/20 blur-3xl animate-pulse"></div>
            <div class="absolute bottom-32 right-16 w-80 h-80 rounded-full bg-gradient-to-l from-[#EF234B]/25 to-[#dc2626]/15 blur-3xl animate-pulse" style="animation-delay: 1s;"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-96 h-96 rounded-full bg-gradient-to-r from-[#01acb6]/10 to-[#EF234B]/10 blur-3xl animate-pulse" style="animation-delay: 2s;"></div>

            <!-- Geometric patterns -->
            <div class="absolute top-10 right-10 w-32 h-32 border border-[#01acb6]/20 rotate-45 animate-spin" style="animation-duration: 20s;"></div>
            <div class="absolute bottom-20 left-10 w-24 h-24 border border-[#EF234B]/20 rotate-12 animate-bounce" style="animation-duration: 3s;"></div>
        </div>

        <!-- Grid overlay for tech feel -->
        <div class="absolute inset-0 opacity-5" style="background-image: radial-gradient(circle, #01acb6 1px, transparent 1px); background-size: 50px 50px;"></div>

        <div class="container relative z-20 px-6 mx-auto mt-10">
            <!-- Enhanced Title Section -->
            <div class="text-center mb-8">
                <div class="inline-block">

                    <p class="text-[#01acb6]/80 text-lg tracking-widest uppercase font-medium">
                        Portfolio Showcase
                    </p>
                </div>
            </div>

            <!-- Enhanced Content Grid -->
            <div class="grid lg:grid-cols-2 gap-16 lg:gap-24 items-center">
                <!-- Left Content with better spacing and animations -->
                <div class="space-y-8 text-center lg:text-left">
                    <!-- Company name with special styling -->
                    <div class="relative">
                        <h1 class="text-3xl md:text-5xl font-black text-white mb-2 relative">
                            <?php echo htmlspecialchars($portfolio_data['values'][0] ?? 'Portfolio Item'); ?>
                        </h1>
                        <div class="w-20 h-1 bg-[#EF234B] rounded-full"></div>
                    </div>

                    <!-- Enhanced description -->
                    <div class="relative" id="renderParagraphe">
                        <?php echo $portfolio_data['values'][1] ?? 'Portfolio Description'; ?>

                        <div class="absolute -top-4 -left-4 text-6xl text-[#01acb6]/20 font-bold">"</div>
                    </div>
                    
                    <!-- Enhanced tags section -->
                    <div class="space-y-4">
                        <h3 class="text-white font-semibold text-lg tracking-wide">Technologies & Skills</h3>
                        <div class="flex flex-wrap justify-center lg:justify-start gap-3">
                            <?php
                            if (isset($portfolio_data['values'][6]) && is_array($portfolio_data['values'][6])):
                                foreach ($portfolio_data['values'][6] as $tags):
                                    if (!empty($tags)): ?>
                                        <span class="group relative inline-block px-4 py-2 rounded-xl bg-gradient-to-r from-[#01acb6]/10 to-[#01acb6]/5 border border-[#01acb6]/30 text-[#01acb6] text-sm font-medium hover:from-[#01acb6]/20 hover:to-[#01acb6]/10 hover:border-[#01acb6]/50 transition-all duration-300 hover:scale-105 hover:shadow-lg hover:shadow-[#01acb6]/25">
                                            <?= htmlspecialchars($tags) ?>
                                            <div class="absolute inset-0 rounded-xl bg-gradient-to-r from-[#01acb6]/0 to-[#01acb6]/10 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                        </span>
                                <?php endif;
                                endforeach;
                            endif; ?>
                        </div>
                        <div class="flex flex-wrap justify-center lg:justify-start gap-3">
                            <?php
                            if (isset($portfolio_data['values'][4]) && is_array($portfolio_data['values'][4])):
                                foreach ($portfolio_data['values'][4] as $tags):
                                    if (!empty($tags)): ?>
                                        <span class="group relative inline-block text-[#01acb6] text-sm font-medium hover:from-[#01acb6]/20 hover:to-[#01acb6]/10 hover:border-[#01acb6]/50 transition-all duration-300">
                                            #<?= htmlspecialchars($tags) ?>
                                            <div class="absolute inset-0 rounded-xl bg-gradient-to-r from-[#01acb6]/0 to-[#01acb6]/10 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                        </span>
                            <?php endif;
                                endforeach;
                            endif; ?>
                        </div>
                        
                    </div>

                    <!-- Call to action button -->
                    <!-- <div class="pt-6">
          <button class="group relative px-8 py-4 bg-gradient-to-r from-[#01acb6] to-[#0891b2] text-white font-semibold rounded-xl hover:from-[#0891b2] hover:to-[#01acb6] transition-all duration-300 hover:scale-105 hover:shadow-2xl hover:shadow-[#01acb6]/50">
            <span class="relative z-10">View Project Details</span>
            <div class="absolute inset-0 rounded-xl bg-white/10 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
          </button>
        </div> -->
                </div>

                <!-- Enhanced Right Image Section -->
                <div class="flex flex-col">
                    <div class="relative group flex justify-center items-center">
                    <?php if (!empty($portfolio_data['values'][2])):
                        $image_src = is_array($portfolio_data['values'][2]) ? $portfolio_data['values'][2][0] : $portfolio_data['values'][2];
                    ?>
                        <div class="relative w-full">
                            <div class="relative overflow-hidden rounded-3xl border border-white/20 backdrop-blur-sm shadow-2xl shadow-[#01acb6]/20 w-full group-hover:shadow-[#01acb6]/40 transition-all duration-700">
                                <img src="<?php echo htmlspecialchars($image_src); ?>"
                                    alt="<?php echo htmlspecialchars($portfolio_data['values'][0] ?? 'Portfolio Image'); ?>"
                                    class="w-full h-[500px] md:h-[400px] object-cover object-center transition-all duration-700 group-hover:scale-110">

                                <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/20 to-transparent"></div>
                                
                            </div>

                            <!-- Floating decoration elements -->
                            <div class="absolute -top-4 -right-4 w-8 h-8 border-2 border-[#01acb6] rounded-full animate-spin" style="animation-duration: 3s;"></div>
                            <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-[#EF234B] rounded-full animate-bounce" style="animation-duration: 2s;"></div>

                            <!-- Glowing effect -->
                            <div class="absolute inset-0 rounded-3xl bg-gradient-to-r from-[#01acb6]/20 to-[#EF234B]/20 blur-xl opacity-0 group-hover:opacity-100 transition-opacity duration-700 -z-10"></div>

                        </div>
                        <?php endif; ?>
                    </div>
                    <?php
                    // Get social media URLs from   data
                    $urls = $portfolio_data['values'][9] ?? [];

                    // Function to generate social media icons
                    function generateSocialMediaIcons($urls) {
                        $icons = [
                            'instagram' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-instagram"><rect width="20" height="20" x="2" y="2" rx="5" ry="5"/><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"/><line x1="17.5" x2="17.51" y1="6.5" y2="6.5"/></svg>',
                            'facebook' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-facebook"><path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"/></svg>',
                            'tiktok' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-music"><path d="M9 18V5l12-2v13"/><circle cx="6" cy="18" r="3"/><circle cx="18" cy="16" r="3"/></svg>',
                            'youtube' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-play"><polygon points="5,3 19,12 5,21"/></svg>',
                            'twitter' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-twitter"><path d="M22 4s-.7 2.1-2 3.4c1.6 10-9.4 17.3-18 11.6 2.2.1 4.4-.6 6-2C3 15.5.5 9.6 3 5c2.2 2.6 5.6 4.1 9 4-.9-4.2 4-6.6 7-3.8 1.1 0 3-1.2 3-1.2z"/></svg>',
                            'linkedin' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-linkedin"><path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"/><rect width="4" height="12" x="2" y="9"/><circle cx="4" cy="4" r="2"/></svg>',
                            'snapchat' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-camera"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>',
                            'whatsapp' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-message-circle"><path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"/></svg>',
                            'link' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-link"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"/><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"/></svg>'
                        ];

                        function getIconType($url) {
                            if (strpos($url, 'instagram.com') !== false) return 'instagram';
                            if (strpos($url, 'facebook.com') !== false) return 'facebook';
                            if (strpos($url, 'tiktok.com') !== false) return 'tiktok';
                            if (strpos($url, 'youtube.com') !== false || strpos($url, 'youtu.be') !== false) return 'youtube';
                            if (strpos($url, 'twitter.com') !== false || strpos($url, 'x.com') !== false) return 'twitter';
                            if (strpos($url, 'linkedin.com') !== false) return 'linkedin';
                            if (strpos($url, 'snapchat.com') !== false) return 'snapchat';
                            if (strpos($url, 'whatsapp.com') !== false || strpos($url, 'wa.me') !== false) return 'whatsapp';
                            return 'link';
                        }

                        if (empty($urls) || !is_array($urls)) {
                            return '';
                        }

                        // Define brand colors and styles for each platform
                        $brandStyles = [
                            'instagram' => 'social-icon instagram-icon',
                            'facebook' => 'social-icon facebook-icon',
                            'tiktok' => 'social-icon tiktok-icon',
                            'youtube' => 'social-icon youtube-icon',
                            'twitter' => 'social-icon twitter-icon',
                            'linkedin' => 'social-icon linkedin-icon',
                            'snapchat' => 'social-icon snapchat-icon',
                            'whatsapp' => 'social-icon whatsapp-icon',
                            'link' => 'social-icon link-icon'
                        ];

                        $iconElements = '';
                        foreach ($urls as $url) {
                            if (!empty(trim($url))) {
                                $iconType = getIconType($url);
                                $styleClass = $brandStyles[$iconType] ?? 'social-icon link-icon';
                                $iconElements .= '<a href="' . htmlspecialchars(trim($url)) . '" target="_blank" class="' . $styleClass . '">' . $icons[$iconType] . '</a>';
                            }
                        }

                        return $iconElements ? '<div class="mt-5 flex justify-center gap-5">' . $iconElements . '</div>' : '';
                    }

                        // Generate and display social media icons if URLs exist
                        if (!empty($urls) && is_array($urls)) {
                            echo generateSocialMediaIcons($urls);
                        }
                    ?>

                </div>
            </div>


        </div>

        <div class="bg-black " style="margin-top: 13%;">
            <div class="mx-auto animate-bounce text-white text-3xl">
                <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex flex-col items-center space-y-4" id="scrollIndicators">
                    <div class="text-white text-sm uppercase tracking-widest animate-pulse">
                        Scroll Down
                    </div>

                    <!-- Arrow indicator -->
                    <div class="animate-bounce">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
                        </svg>
                    </div>

                    <!-- Mouse scroll indicator -->
                    <div class="relative">
                        <div class="w-6 h-10 border-2 border-white/60 rounded-full flex justify-center">
                            <div class="w-1 h-2 bg-white rounded-full mt-2 animate-ping"></div>
                        </div>
                    </div>

                </div>
                </svg>
            </div>
        </div>

    </section>

    <?php if ($portfolio_data): ?>
        <!-- Portfolio Detail Section -->
        <!-- <section class="py-20 bg-gradient-to-b from-slate-50 to-white">
        <div class="max-w-7xl mx-auto px-6">

            <?php if (isset($portfolio_data['values'][3]) && !empty($portfolio_data['values'][3])): ?>
            <div class="mb-16">
                <h2 class="text-3xl font-bold text-slate-900 text-center mb-12">Project Gallery</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php
                    $images = $portfolio_data['values'][3];
                    if (is_string($images)) {
                        $images = json_decode($images, true) ?: explode(',', $images);
                    }
                    if (is_array($images)):
                        foreach ($images as $index => $image_url):
                            if (!empty(trim($image_url))): ?>
                    <div class="group relative overflow-hidden rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300">
                        <img src="<?php echo htmlspecialchars(trim($image_url)); ?>"
                             alt="Gallery Image <?php echo $index + 1; ?>"
                             class="w-full h-64 object-cover group-hover:scale-105 transition-transform duration-500 cursor-pointer"
                             onclick="openLightbox('<?php echo htmlspecialchars(trim($image_url)); ?>', 'Gallery Image <?php echo $index + 1; ?>', 'Portfolio')">
                        <div class="absolute inset-0 bg-black opacity-0 group-hover:opacity-20 transition-opacity duration-300"></div>
                    </div>
                    <?php
                            endif;
                        endforeach;
                    endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (isset($portfolio_data['values']['links']) && !empty($portfolio_data['values']['links'])): ?>
            <div class="text-center">
                <h3 class="text-2xl font-bold text-slate-900 mb-6">Project Links</h3>
                <div class="flex justify-center space-x-4">
                    <?php
                    $links = explode(',', $portfolio_data['values']['links']);
                    foreach ($links as $link):
                        $link = trim($link);
                        if (!empty($link)): ?>
                    <a href="<?php echo htmlspecialchars($link); ?>"
                       target="_blank"
                       rel="noopener noreferrer"
                       class="inline-flex items-center px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors duration-300">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                        </svg>
                        View Project
                    </a>
                    <?php
                        endif;
                    endforeach; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section> -->
    <?php endif; ?>

    <?php
    $images = $portfolio_data['values'][3] ?? [];
    ?>
    <section class="py-20 bg-white" id="#portfolio">
        <div class="max-w-7xl mx-auto px-6">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-6xl font-display font-black text-gray-900 mb-4">
                    <span class="bg-[#01acb6] bg-clip-text text-transparent">Portfolio</span>
                </h2>
            </div>

            <?php echo generateFilterButtons($portfolio_categories); ?>

            <!-- portfolio section -->
            <div class="container2">
                <div class="masonry-grid1" id="masonryGrid">
                    <?php echo generateMasonryGrid($portfolio_media, 50); ?>
                </div>
            </div>

            <?php if (empty($portfolio_media)): ?>
                <div class="text-center py-16">
                    <div class="max-w-md mx-auto">
                        <div class="w-24 h-24 mx-auto mb-6 bg-gray-100 rounded-full flex items-center justify-center">
                            <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">No Portfolio Items</h3>
                        <p class="text-gray-600">Add portfolio items through your CMS to see them displayed here.</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
    
    <?php
    $type = $portfolio_data['values'][5];
    $Currentproject = $portfolio_data['values'][0]
    ?>
    <?php include "projectsType.php" ?>
    <br>
    <div class="mt-5"></div>
    <?php include "footer.php" ?>
    
    <div id="lightbox" class="fixed inset-0 hidden items-center justify-center z-[99999]">
        <div id="lightbox-backdrop" class="absolute inset-0 bg-black/80"></div>
        <div class="relative w-[min(85vw,900px)] max-w-none mx-auto p-0">
            <button id="lightbox-close" aria-label="Close" class="absolute -top-10 right-0 text-white/90 hover:text-white transition">
                ✕
            </button>
            <div class="w-full aspect-video bg-black rounded-xl overflow-hidden shadow-2xl">
                <img id="lightboxImage" class="w-full h-full object-contain hidden" alt="Preview" />
                <video id="lightboxVideo" class="w-full h-full object-contain hidden" controls playsinline></video>
                <iframe id="lightboxIframe" class="w-full h-full hidden" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
            <div class="mt-3 flex items-center justify-between text-white/90">
                <div>
                    <div id="lightboxTitle" class="font-semibold"></div>
                    <div id="lightboxCategory" class="text-white/70 text-sm"></div>
                </div>
            </div>
        </div>
    </div>

    <script src="./canvas-animations.js"></script>
    <script src="./ai-assistant.js"></script>
    <script src="./main.js"></script>
    <script>
        lucide.createIcons();
        // GSAP ScrollTrigger removed

        // === NAVBAR SCROLL AND NAVIGATION FUNCTIONALITY ===
        // Header scrolled state + scroll-to-top visibility
        (function() {
            const header = document.getElementById('header');
            const toTop = document.getElementById('scroll-to-top');
            const onScroll = () => {
                const y = window.scrollY;
                if (header) header.classList.toggle('scrolled', y > 16);
                if (toTop) {
                    const show = y > 400;
                    toTop.style.opacity = show ? '1' : '0';
                    toTop.style.pointerEvents = show ? 'auto' : 'none';
                }
            };
            onScroll();
            window.addEventListener('scroll', onScroll, {
                passive: true
            });
        })();

        // Header scroll effect
        const header = document.getElementById('header');
        const scrollToTopBtn = document.getElementById('scroll-to-top');

        // Scroll effects removed

        // Smooth scroll for navigation links
        const navLinks = document.querySelectorAll('a[href^="#"]');
        navLinks.forEach(link => {
            link.addEventListener('click', (e) => {
                e.preventDefault();
                const targetId = link.getAttribute('href');
                const targetElement = document.querySelector(targetId);

                if (targetElement) {
                    const offsetTop = targetElement.offsetTop - 100; // Account for fixed header
                    window.scrollTo({
                        top: offsetTop,
                        behavior: 'smooth'
                    });
                }
            });
        });

        // Active states for navigation links (for blog page sections)
        function updateActiveNavLinks() {
            const sections = document.querySelectorAll('section[id], div[id]');
            const navLinks = document.querySelectorAll('.nav-link');

            let currentSection = '';

            sections.forEach(section => {
                const sectionTop = section.offsetTop - 150;
                const sectionHeight = section.offsetHeight;
                const scrollPosition = window.scrollY;

                if (scrollPosition >= sectionTop && scrollPosition < sectionTop + sectionHeight) {
                    currentSection = section.getAttribute('id');
                }
            });

            navLinks.forEach(link => {
                const href = link.getAttribute('href');
                if (href && href.startsWith('#')) {
                    const sectionId = href.substring(1);
                    if (sectionId === currentSection) {
                        link.classList.add('active');
                    } else {
                        link.classList.remove('active');
                    }
                }
            });
        }

        // Scroll-based active link updates removed

        // Update active links on page load
        document.addEventListener('DOMContentLoaded', updateActiveNavLinks);

        // IntersectionObserver scroll reveals
        (function() {
            const items = document.querySelectorAll('.reveal');
            if (!items.length) return;
            const io = new IntersectionObserver((entries) => {
                entries.forEach(e => {
                    if (e.isIntersecting) {
                        e.target.classList.add('is-visible');
                        io.unobserve(e.target);
                    }
                })
            }, {
                threshold: 0.15,
                rootMargin: '0px 0px -5% 0px'
            });
            items.forEach(el => io.observe(el));
        })();

        // Scroll to top button functionality
        if (scrollToTopBtn) {
            scrollToTopBtn.addEventListener('click', () => {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            });

            // Initial state
            scrollToTopBtn.classList.add('opacity-0', 'pointer-events-none');
        }

        // Mobile menu toggle functionality (Complete version like index.html)
        const mobileMenuBtn = document.getElementById('mobile-menu-btn');
        const mobileMenu = document.getElementById('mobile-menu');

        if (mobileMenuBtn && mobileMenu) {
            mobileMenuBtn.addEventListener('click', function() {
                // Toggle the hidden class
                mobileMenu.classList.toggle('hidden');

                // Update ARIA attributes for accessibility
                const isOpen = !mobileMenu.classList.contains('hidden');
                mobileMenuBtn.setAttribute('aria-expanded', isOpen);

                // Change icon based on menu state
                const icon = mobileMenuBtn.querySelector('i');
                if (icon) {
                    if (isOpen) {
                        icon.setAttribute('data-lucide', 'x');
                    } else {
                        icon.setAttribute('data-lucide', 'menu');
                    }
                    // Refresh Lucide icons
                    if (typeof lucide !== 'undefined') {
                        lucide.createIcons();
                    }
                }
            });

            // Close mobile menu when clicking on nav links
            const mobileNavLinks = mobileMenu.querySelectorAll('a');
            mobileNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    mobileMenu.classList.add('hidden');
                    mobileMenuBtn.setAttribute('aria-expanded', 'false');

                    // Reset icon
                    const icon = mobileMenuBtn.querySelector('i');
                    if (icon) {
                        icon.setAttribute('data-lucide', 'menu');
                        if (typeof lucide !== 'undefined') {
                            lucide.createIcons();
                        }
                    }
                });
            });

            // Close mobile menu when clicking outside
            document.addEventListener('click', function(event) {
                const isClickInsideMenu = mobileMenu.contains(event.target);
                const isClickOnButton = mobileMenuBtn.contains(event.target);

                if (!isClickInsideMenu && !isClickOnButton && !mobileMenu.classList.contains('hidden')) {
                    mobileMenu.classList.add('hidden');
                    mobileMenuBtn.setAttribute('aria-expanded', 'false');

                    // Reset icon
                    const icon = mobileMenuBtn.querySelector('i');
                    if (icon) {
                        icon.setAttribute('data-lucide', 'menu');
                        if (typeof lucide !== 'undefined') {
                            lucide.createIcons();
                        }
                    }
                }
            });
        }
    </script>

    <script>
        class InfiniteScrollingBackground {
            constructor() {
                this.container = document.getElementById('scrollContainer');
                this.images = [];
                this.rowCount = 12;
                this.itemsPerRow = [8, 10, 9, 11, 7, 12, 8, 10, 9, 11, 8, 10];
                this.sizeClasses = ['', 'tall', 'medium', 'wide'];
                this.init();
            }

            init() {
                this.loadPortfolioImages();
                this.generateRows();
                this.startIntersectionObserver();
            }

            loadPortfolioImages() {
                // Get portfolio media data from the same source as the portfolio section
                const portfolioMediaData = <?php
                                            // Extract all media URLs from portfolio_media array
                                            $media_urls = [];
                                            foreach ($portfolio_media as $media) {
                                                if (!empty($media['url'])) {
                                                    $media_urls[] = $media['url'];
                                                }
                                            }
                                            echo json_encode($media_urls);
                                            ?>;

                if (portfolioMediaData && Array.isArray(portfolioMediaData) && portfolioMediaData.length > 0) {
                    this.images = portfolioMediaData.map(url => url.trim()).filter(url => url);
                } else {
                    // Fallback images if no portfolio data
                    this.images = [
                        'https://images.unsplash.com/photo-1498050108023-c5249f4df085?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1461749280684-dccba630e2f6?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1555949963-aa79dcee981c?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1504639725590-34d0984388bd?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1517180102446-f3ece451e9d8?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1558655146-d09347e92766?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1551650975-87deedd944c3?w=400&h=300&fit=crop',
                        'https://images.unsplash.com/photo-1556656793-08538906a9f8?w=400&h=300&fit=crop'
                    ];
                }

                // Duplicate images to ensure seamless looping (3x minimum)
                const originalLength = this.images.length;
                while (this.images.length < originalLength * 3) {
                    this.images = [...this.images, ...this.images.slice(0, originalLength)];
                }
            }

            generateRows() {
                this.container.innerHTML = '';

                for (let rowIndex = 0; rowIndex < this.rowCount; rowIndex++) {
                    const row = this.createRow(rowIndex);
                    this.container.appendChild(row);
                }
            }

            createRow(rowIndex) {
                const row = document.createElement('div');
                row.className = 'scroll-row';
                row.dataset.row = rowIndex;

                const itemCount = this.itemsPerRow[rowIndex % this.itemsPerRow.length];

                // Create enough items to fill the row + duplicates for seamless scrolling
                const totalItems = Math.max(itemCount * 3, 24);

                for (let i = 0; i < totalItems; i++) {
                    const item = this.createScrollItem(rowIndex, i);
                    row.appendChild(item);
                }

                return row;
            }

            createScrollItem(rowIndex, itemIndex) {
                const item = document.createElement('div');
                const sizeClass = this.sizeClasses[Math.floor(Math.random() * this.sizeClasses.length)];
                item.className = `scroll-item ${sizeClass}`;

                const imageIndex = (rowIndex * 10 + itemIndex) % this.images.length;
                const imageUrl = this.images[imageIndex];

                const isVideo = /\.(mp4|webm|ogg|mov|avi|mkv)$/i.test(imageUrl);

                if (isVideo) {
                    item.innerHTML = `
                        <div class="group relative overflow-hidden cursor-pointer h-full rounded-lg">
                            <video muted loop preload="auto" class="scroll-media w-full h-full object-cover masonry-video"
                                   onclick="openLightbox('${this.escapeHtml(imageUrl)}', 'Portfolio Video', 'Portfolio')">
                                <source src="${this.escapeHtml(imageUrl)}" type="video/mp4">
                            </video>
                            <div class="video-overlay absolute inset-0 bg-black bg-opacity-10 transition-all duration-300 pointer-events-none"></div>
                            <div class="video-play-indicator absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-10 h-10 bg-white bg-opacity-20 rounded-full flex items-center justify-center backdrop-blur-sm transition-all duration-300">
                                <i data-lucide="play" class="w-4 h-4 text-white"></i>
                            </div>
                        </div>
                    `;

                    // Wait for video to load then seek to 3 seconds for thumbnail
                    const video = item.querySelector('video');

                    // Multiple event listeners to ensure thumbnail is set
                    video.addEventListener('loadedmetadata', function() {
                        this.currentTime = 3;
                    });

                    video.addEventListener('loadeddata', function() {
                        if (this.currentTime < 3) {
                            this.currentTime = 3;
                        }
                    });

                    video.addEventListener('canplay', function() {
                        if (this.currentTime < 3) {
                            this.currentTime = 3;
                        }
                    });
                } else{
                    item.innerHTML = `
                        <img src="${this.escapeHtml(imageUrl)}"
                             alt="Portfolio Visual"
                             class="scroll-media"
                             onclick="openLightbox('${this.escapeHtml(imageUrl)}', 'Portfolio Image', 'Portfolio')"
                             loading="lazy">
                        <div class="absolute inset-0 bg-black/10 hover:bg-transparent transition-colors duration-300"></div>
                        <div class="absolute top-2 right-2 w-8 h-8 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            <i data-lucide="zoom-in" class="w-4 h-4 text-white"></i>
                        </div>
                    `;
                }

                item.classList.add('group');
                return item;
            }

            escapeHtml(text) {
                const div = document.createElement('div');
                div.textContent = text;
                return div.innerHTML;
            }

            startIntersectionObserver() {
                const options = {
                    root: null,
                    rootMargin: '100px',
                    threshold: 0.1
                };

                const observer = new IntersectionObserver((entries) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            const videos = entry.target.querySelectorAll('video');
                            videos.forEach(video => {
                                if (!video.dataset.loaded) {
                                    video.load();
                                    video.dataset.loaded = 'true';
                                }
                            });
                        }
                    });
                }, options);

                const items = document.querySelectorAll('.scroll-item');
                items.forEach(item => observer.observe(item));
            }

            // Public method to update images dynamically
            // This method allows external scripts to sync the hero background with portfolio changes
            updateBackgroundImages(newImageArray) {
                if (Array.isArray(newImageArray) && newImageArray.length > 0) {
                    this.images = newImageArray.map(url => url.trim()).filter(url => url);

                    // Duplicate for seamless looping
                    const originalLength = this.images.length;
                    while (this.images.length < originalLength * 3) {
                        this.images = [...this.images, ...this.images.slice(0, originalLength)];
                    }

                    this.generateRows();
                    this.startIntersectionObserver();

                    // Reinitialize lucide icons
                    if (typeof lucide !== 'undefined') {
                        lucide.createIcons();
                    }
                }
            }

            // Performance optimization: pause animations when not visible
            pauseAnimations() {
                this.container.style.animationPlayState = 'paused';
                const rows = this.container.querySelectorAll('.scroll-row');
                rows.forEach(row => {
                    row.style.animationPlayState = 'paused';
                });
            }

            resumeAnimations() {
                this.container.style.animationPlayState = 'running';
                const rows = this.container.querySelectorAll('.scroll-row');
                rows.forEach(row => {
                    row.style.animationPlayState = 'running';
                });
            }
        }

        // Initialize the infinite scrolling background
        let infiniteBackground;

        document.addEventListener('DOMContentLoaded', function() {
            infiniteBackground = new InfiniteScrollingBackground();

            // Initialize lucide icons for dynamically created content
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });

        // Global function for external use
        function updateBackgroundImages(newImageArray) {
            if (infiniteBackground) {
                infiniteBackground.updateBackgroundImages(newImageArray);
            }
        }

        // Performance optimization: pause/resume based on visibility
        document.addEventListener('visibilitychange', function() {
            if (infiniteBackground) {
                if (document.hidden) {
                    infiniteBackground.pauseAnimations();
                } else {
                    infiniteBackground.resumeAnimations();
                }
            }
        });

        // Respect user's reduced motion preferences
        if (window.matchMedia('(prefers-reduced-motion: reduce)').matches) {
            document.addEventListener('DOMContentLoaded', function() {
                const scrollContainer = document.getElementById('scrollContainer');
                if (scrollContainer) {
                    scrollContainer.style.animation = 'none';
                    const rows = scrollContainer.querySelectorAll('.scroll-row');
                    rows.forEach(row => {
                        row.style.animation = 'none';
                    });
                }
            });
        }
    </script>
    <script>
        lucide.createIcons();
        // Scroll animations removed

        // Basic client-side filtering/search/sort
        const tags = document.querySelectorAll('[data-cat]');
        const posts = document.querySelectorAll('#posts article');
        const featured = document.querySelectorAll('#featured-articles [data-cat]');
        const allCards = [...posts, ...featured];
        document.querySelectorAll('.tag').forEach(btn => {
            btn.addEventListener('click', () => {
                const cat = btn.getAttribute('data-cat');
                allCards.forEach(c => {
                    const ok = cat === 'all' || c.getAttribute('data-cat') === cat;
                    c.style.display = ok ? 'block' : 'none';
                });
            });
        });
        document.getElementById('search').addEventListener('input', e => {
            const q = e.target.value.toLowerCase();
            posts.forEach(p => {
                const txt = p.innerText.toLowerCase();
                p.style.display = txt.includes(q) ? 'block' : 'none';
            });
        });
        document.getElementById('sort').addEventListener('change', e => {
            const v = e.target.value;
            const wrap = document.getElementById('posts');
            const arr = [...posts];
            if (v === 'new') arr.sort((a, b) => new Date(b.dataset.date) - new Date(a.dataset.date));
            if (v === 'popular') arr.sort((a, b) => (b.dataset.pop | 0) - (a.dataset.pop | 0));
            if (v === 'relevant') arr.sort(() => 0.5 - Math.random());
            arr.forEach(n => wrap.appendChild(n));
        });
    </script>
    <script>
        // Initialize Lucide icons
        lucide.createIcons();

        // Carousel functionality - Multiple carousel support
        class DesignCarousel {
            constructor() {
                this.carousels = [];
                this.init();
            }

            init() {
                // Find all carousel containers and create separate instances
                const carouselContainers = document.querySelectorAll('.carousel-container');

                carouselContainers.forEach((container, index) => {
                    const carouselData = {
                        index: index,
                        currentSlide: 0,
                        container: container,
                        slides: container.querySelectorAll('.carousel-slide'),
                        dotContainer: this.findDotContainer(container),
                        dots: [],
                        autoplayInterval: null,
                        autoplayDelay: 4000
                    };

                    this.carousels.push(carouselData);
                    this.initCarousel(carouselData);
                });
            }

            findDotContainer(carouselContainer) {
                // Find the dot container for this specific carousel
                const parent = carouselContainer.closest('.relative');
                return parent ? parent.querySelector('[data-carousel-dots]') : null;
            }

            initCarousel(carousel) {

                this.generateDots(carousel);

                // Add hover listeners
                carousel.container.addEventListener('mouseenter', () => this.pauseAutoplay(carousel));
                carousel.container.addEventListener('mouseleave', () => this.startAutoplay(carousel));

                // Initialize first slide
                this.updateSlide(carousel);
                this.startAutoplay(carousel);
            }

            generateDots(carousel) {
                if (!carousel.dotContainer) return;

                // Clear existing dots
                carousel.dotContainer.innerHTML = '';
                carousel.dots = [];

                // Create dots based on number of slides in this carousel
                for (let i = 0; i < carousel.slides.length; i++) {
                    const dot = document.createElement('div');
                    dot.className = 'carousel-dot';
                    dot.setAttribute('data-slide', i);
                    dot.setAttribute('data-carousel', carousel.index);
                    if (i === 0) dot.classList.add('active');

                    // Add click event listener
                    dot.addEventListener('click', () => this.goToSlide(carousel, i));

                    carousel.dotContainer.appendChild(dot);
                    carousel.dots.push(dot);
                }
            }

            goToSlide(carousel, index) {
                carousel.currentSlide = index;
                this.updateSlide(carousel);
            }

            nextSlide(carousel) {
                carousel.currentSlide = (carousel.currentSlide + 1) % carousel.slides.length;
                this.updateSlide(carousel);
            }

            previousSlide(carousel) {
                carousel.currentSlide = carousel.currentSlide === 0 ? carousel.slides.length - 1 : carousel.currentSlide - 1;
                this.updateSlide(carousel);
            }

            updateSlide(carousel) {
                // Update slides
                carousel.slides.forEach((slide, index) => {
                    slide.classList.toggle('active', index === carousel.currentSlide);
                });

                // Update dots
                carousel.dots.forEach((dot, index) => {
                    dot.classList.toggle('active', index === carousel.currentSlide);
                });
            }

            startAutoplay(carousel) {
                this.pauseAutoplay(carousel); // Clear any existing interval

                // Safety check: ensure autoplayDelay is reasonable
                const minDelay = 1000; // Minimum 1 second
                const maxDelay = 30000; // Maximum 30 seconds
                const safeDelay = Math.max(minDelay, Math.min(maxDelay, carousel.autoplayDelay || 3000));

                carousel.autoplayInterval = setInterval(() => {
                    try {
                        this.nextSlide(carousel);
                    } catch (error) {
                        console.error('Carousel autoplay error:', error);
                        this.pauseAutoplay(carousel); // Stop autoplay on error
                    }
                }, safeDelay);
            }

            pauseAutoplay(carousel) {
                if (carousel.autoplayInterval) {
                    clearInterval(carousel.autoplayInterval);
                    carousel.autoplayInterval = null;
                }
            }
        }

        // Initialize carousel when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            new DesignCarousel();
        });


        <?php
        $images = $portfolio_data['values'][3] ?? [];
        ?>
            // Removed legacy LightboxGallery block (conflicted with new lightbox)

            // Simple Lightbox (image/video) implementation
            (function() {
                const modal = document.getElementById('lightbox');
                const backdrop = document.getElementById('lightbox-backdrop');
                const closeBtn = document.getElementById('lightbox-close');
                const img = document.getElementById('lightboxImage');
                const video = document.getElementById('lightboxVideo');
                const iframe = document.getElementById('lightboxIframe');
                const titleEl = document.getElementById('lightboxTitle');
                const categoryEl = document.getElementById('lightboxCategory');

                function isVideoUrl(url) {
                    return /\.(mp4|webm|ogg|mov|avi|mkv)(\?.*)?$/i.test(url);
                }

                function isExternalVideoUrl(url) {
                    // Check for YouTube URLs
                    if (/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/i.test(url)) {
                        return 'youtube';
                    }

                    // Check for Instagram URLs
                    if (/instagram\.com\/(?:p|reel)\/([a-zA-Z0-9_-]+)/i.test(url)) {
                        return 'instagram';
                    }

                    // Check for Vimeo URLs
                    if (/vimeo\.com\/(\d+)/i.test(url)) {
                        return 'vimeo';
                    }

                    return false;
                }

                function getExternalVideoEmbedUrl(url, type) {
                    switch (type) {
                        case 'youtube':
                            const youtubeMatch = url.match(/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/i);
                            if (youtubeMatch) {
                                return `https://www.youtube.com/embed/${youtubeMatch[1]}?autoplay=1&mute=0&controls=1&rel=0`;
                            }
                            break;
                        case 'instagram':
                            const instagramMatch = url.match(/instagram\.com\/(?:p|reel)\/([a-zA-Z0-9_-]+)/i);
                            if (instagramMatch) {
                                return `https://www.instagram.com/p/${instagramMatch[1]}/embed/`;
                            }
                            break;
                        case 'vimeo':
                            const vimeoMatch = url.match(/vimeo\.com\/(\d+)/i);
                            if (vimeoMatch) {
                                return `https://player.vimeo.com/video/${vimeoMatch[1]}?autoplay=1&muted=0`;
                            }
                            break;
                    }
                    return url;
                }

                window.openLightbox = function(src, title = '', category = '') {
                    if (!modal) return;
                    const showVideo = isVideoUrl(src);
                    const externalVideoType = isExternalVideoUrl(src);

                    // Reset all elements
                    img.classList.add('hidden');
                    video.classList.add('hidden');
                    iframe.classList.add('hidden');
                    video.pause();
                    video.removeAttribute('src');
                    video.load();
                    iframe.removeAttribute('src');

                    if (externalVideoType) {
                        // Handle external videos with iframe
                        const embedUrl = getExternalVideoEmbedUrl(src, externalVideoType);
                        iframe.setAttribute('src', embedUrl);
                        iframe.classList.remove('hidden');
                    } else if (showVideo) {
                        // Handle local videos
                        video.setAttribute('src', src);
                        video.classList.remove('hidden');
                        // Autoplay if allowed
                        video.play().catch(() => {});
                    } else {
                        // Handle images
                        img.setAttribute('src', src);
                        img.classList.remove('hidden');
                    }

                    titleEl.textContent = title || '';
                    categoryEl.textContent = category || '';

                    modal.classList.remove('hidden');
                    modal.classList.add('flex');
                    document.body.style.overflow = 'hidden';
                };

                window.closeLightbox = function() {
                    if (!modal) return;
                    // Cleanup
                    if (!video.classList.contains('hidden')) {
                        video.pause();
                    }
                    modal.classList.add('hidden');
                    modal.classList.remove('flex');
                    document.body.style.overflow = '';
                };

                // Events
                closeBtn?.addEventListener('click', window.closeLightbox);
                backdrop?.addEventListener('click', window.closeLightbox);
                document.addEventListener('keydown', (e) => {
                    if (e.key === 'Escape' && !modal.classList.contains('hidden')) {
                        window.closeLightbox();
                    }
                });
            })();

        // GSAP animations removed - no scroll effects
    </script>
    <script>
        // Enhanced Portfolio Filtering for Masonry Layout
        document.addEventListener('DOMContentLoaded', function() {
            // This functionality is now handled by the MasonryLayout class
            // Keep this for backward compatibility if needed

            // Initialize video hover effects for dynamic content
            initializeVideoHoverEffects();
        });

        function initializeVideoHoverEffects() {
            const portfolioItems = document.querySelectorAll('.portfolio-item .group');

            portfolioItems.forEach(item => {
                const video = item.querySelector('.portfolio-video');

                if (video) {
                    // Initialize video to show first frame
                    video.currentTime = 0;
                    video.classList.add('paused');

                    video.addEventListener('loadeddata', () => {
                        video.currentTime = 0;
                    });

                    // Mouse enter - start playing video
                    item.addEventListener('mouseenter', () => {
                        video.classList.remove('paused');
                        video.classList.add('playing');
                        video.currentTime = 0;
                        video.play().catch(e => console.log('Video play failed:', e));
                    });

                    // Mouse leave - pause and return to first frame
                    item.addEventListener('mouseleave', () => {
                        video.classList.remove('playing');
                        video.classList.add('paused');
                        video.pause();
                        setTimeout(() => {
                            video.currentTime = 0;
                        }, 100);
                    });

                    video.addEventListener('error', () => {
                        console.log('Video failed to load for:', item);
                        video.style.display = 'none';
                    });
                }
            });
        }
    </script>
    <!-- Portfolio Video Hover Effects Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Portfolio video hover functionality
            const portfolioItems = document.querySelectorAll('.portfolio-item .group');

            portfolioItems.forEach(item => {
                const video = item.querySelector('.portfolio-video');

                if (video) {
                    // Initialize video to show first frame
                    video.currentTime = 0;
                    video.classList.add('paused');

                    // Set up video loading states
                    video.addEventListener('loadstart', () => {
                        video.dataset.loading = 'true';
                    });

                    video.addEventListener('loadeddata', () => {
                        video.dataset.loading = 'false';
                        // Ensure we're showing the first frame
                        video.currentTime = 0;
                    });

                    video.addEventListener('canplay', () => {
                        // Video is ready, ensure first frame is displayed
                        if (video.classList.contains('paused')) {
                            video.currentTime = 0;
                        }
                    });

                    // Mouse enter - start playing video
                    item.addEventListener('mouseenter', () => {
                        video.classList.remove('paused');
                        video.classList.add('playing');

                        // Start playing from beginning
                        video.currentTime = 0;
                        video.play().catch(e => {
                            console.log('Video play failed:', e);
                        });
                    });

                    // Mouse leave - pause and return to first frame
                    item.addEventListener('mouseleave', () => {
                        video.classList.remove('playing');
                        video.classList.add('paused');

                        // Pause and return to first frame
                        video.pause();

                        // Return to first frame with a small delay for smooth transition
                        setTimeout(() => {
                            video.currentTime = 0;
                        }, 100);
                    });

                    // Handle video errors gracefully
                    video.addEventListener('error', () => {
                        console.log('Video failed to load for:', item);
                        video.style.display = 'none';
                    });

                    // Ensure video doesn't autoplay accidentally
                    video.addEventListener('play', (e) => {
                        if (!video.classList.contains('playing')) {
                            e.preventDefault();
                            video.pause();
                            video.currentTime = 0;
                        }
                    });
                }
            });

            // Preload videos when they come into viewport
            const videoObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const video = entry.target.querySelector('.portfolio-video');
                        if (video && !video.dataset.loaded) {
                            video.load();
                            video.dataset.loaded = 'true';

                            // Ensure first frame is shown after loading
                            video.addEventListener('loadeddata', () => {
                                video.currentTime = 0;
                            }, {
                                once: true
                            });
                        }
                    }
                });
            }, {
                threshold: 0.1,
                rootMargin: '50px'
            });

            // Observe all portfolio items for video preloading
            portfolioItems.forEach(item => {
                if (item.querySelector('.portfolio-video')) {
                    videoObserver.observe(item);
                }
            });

            console.log('Portfolio video hover effects initialized for', portfolioItems.length, 'items with first-frame display');

            // Initialize pixel video effects for scroll media and masonry items
            initializePixelVideoEffects();
        });

        // Enhanced Pixel Video Effects for all video types
        function initializePixelVideoEffects() {
            // Handle scroll media videos
            const scrollVideos = document.querySelectorAll('.scroll-media video, .masonry-video');

            scrollVideos.forEach(video => {
                const container = video.closest('.group') || video.closest('.scroll-item') || video.closest('.masonry-item');
                const playIndicator = container ? container.querySelector('.video-play-indicator') : null;
                const overlay = container ? container.querySelector('.video-overlay') : null;

                if (container) {
                    // Initialize pixel video state
                    video.currentTime = 0;
                    video.classList.add('paused');

                    // Setup hover events
                    container.addEventListener('mouseenter', () => {
                        video.classList.remove('paused');
                        video.classList.add('playing');
                        if (playIndicator) playIndicator.style.opacity = '0';
                        if (overlay) overlay.style.opacity = '0';
                        video.currentTime = 0;
                        video.play().catch(e => console.log('Scroll video play failed:', e));
                    });

                    container.addEventListener('mouseleave', () => {
                        video.classList.add('paused');
                        video.classList.remove('playing');
                        if (playIndicator) playIndicator.style.opacity = '1';
                        if (overlay) overlay.style.opacity = '1';
                        video.pause();
                        setTimeout(() => {
                            video.currentTime = 0;
                        }, 100);
                    });

                    // Handle video loading
                    video.addEventListener('loadeddata', () => {
                        video.currentTime = 0;
                    });
                }
            });

            // Handle dynamically created videos with mutation observer
            const videoObserver = new MutationObserver((mutations) => {
                mutations.forEach((mutation) => {
                    mutation.addedNodes.forEach((node) => {
                        if (node.nodeType === 1) { // Element node
                            const videos = node.querySelectorAll ? node.querySelectorAll('video') : [];
                            videos.forEach(video => {
                                if (video.classList.contains('scroll-media') || video.classList.contains('masonry-video')) {
                                    const container = video.closest('.group') || video.closest('.scroll-item') || video.closest('.masonry-item');
                                    if (container) {
                                        setupSingleVideoPixelEffect(video, container);
                                    }
                                }
                            });
                        }
                    });
                });
            });

            videoObserver.observe(document.body, {
                childList: true,
                subtree: true
            });

            // Handle iframe video containers with autoplay on hover
            initializeIframeVideoEffects();

            console.log('Pixel video effects initialized for', scrollVideos.length, 'videos');
        }

        // Initialize iframe video hover effects with autoplay
        function initializeIframeVideoEffects() {
            const iframeContainers = document.querySelectorAll('.iframe-container');

            iframeContainers.forEach(container => {
                const iframe = container.querySelector('iframe');
                if (!iframe) return;

                const originalSrc = iframe.src;
                const isYoutube = originalSrc.includes('youtube.com') || originalSrc.includes('youtu.be');
                const isVimeo = originalSrc.includes('vimeo.com');

                if (isYoutube || isVimeo) {
                    // Set data attributes for styling
                    container.setAttribute('data-video-type', isYoutube ? 'youtube' : 'vimeo');

                    // Prepare autoplay URL
                    let autoplayUrl = originalSrc;
                    if (isYoutube) {
                        autoplayUrl = addYouTubeAutoplay(originalSrc);
                    } else if (isVimeo) {
                        autoplayUrl = addVimeoAutoplay(originalSrc);
                    }

                    // Store URLs
                    iframe.dataset.originalSrc = originalSrc;
                    iframe.dataset.autoplaySrc = autoplayUrl;

                    // Add hover events
                    container.addEventListener('mouseenter', () => {
                        if (iframe.src !== autoplayUrl) {
                            iframe.src = autoplayUrl;
                        }
                    });

                    container.addEventListener('mouseleave', () => {
                        // Reset to original URL to stop the video
                        setTimeout(() => {
                            iframe.src = originalSrc;
                        }, 1000); // Delay to allow some viewing time
                    });
                }
            });

            console.log('Iframe video effects initialized for', iframeContainers.length, 'iframe containers');
        }

        // Helper function to add YouTube autoplay parameters
        function addYouTubeAutoplay(url) {
            try {
                const urlObj = new URL(url);
                urlObj.searchParams.set('autoplay', '1');
                urlObj.searchParams.set('mute', '1'); // Required for autoplay
                return urlObj.toString();
            } catch (e) {
                console.warn('Invalid YouTube URL:', url);
                return url;
            }
        }

        // Helper function to add Vimeo autoplay parameters
        function addVimeoAutoplay(url) {
            try {
                const urlObj = new URL(url);
                urlObj.searchParams.set('autoplay', '1');
                urlObj.searchParams.set('muted', '1'); // Required for autoplay
                return urlObj.toString();
            } catch (e) {
                console.warn('Invalid Vimeo URL:', url);
                return url;
            }
        }

        // Setup pixel effects for a single video
        function setupSingleVideoPixelEffect(video, container) {
            const playIndicator = container.querySelector('.video-play-indicator');
            const overlay = container.querySelector('.video-overlay');

            // Initialize pixel video state
            video.currentTime = 0;
            video.classList.add('paused');

            // Remove existing listeners to prevent duplicates
            container.removeEventListener('mouseenter', container._pixelVideoEnter);
            container.removeEventListener('mouseleave', container._pixelVideoLeave);

            // Create new listeners
            container._pixelVideoEnter = () => {
                video.classList.remove('paused');
                video.classList.add('playing');
                if (playIndicator) playIndicator.style.opacity = '0';
                if (overlay) overlay.style.opacity = '0';
                video.currentTime = 0;
                video.play().catch(e => console.log('Pixel video play failed:', e));
            };

            container._pixelVideoLeave = () => {
                video.classList.add('paused');
                video.classList.remove('playing');
                if (playIndicator) playIndicator.style.opacity = '1';
                if (overlay) overlay.style.opacity = '1';
                video.pause();
                setTimeout(() => {
                    video.currentTime = 0;
                }, 100);
            };

            container.addEventListener('mouseenter', container._pixelVideoEnter);
            container.addEventListener('mouseleave', container._pixelVideoLeave);
        }

        // Modern Masonry Layout Implementation
        class MasonryLayout {
            constructor() {
                this.container = document.getElementById('masonryGrid') || document.querySelector('.masonry-grid1');
                this.items = [];
                this.observer = null;
                this.resizeTimeout = null;
                this.init();
            }

            init() {
                if (!this.container) {
                    console.log('MasonryLayout: No container found');
                    return;
                }

                // Mark that MasonryLayout is initialized
                window.masonryLayoutInitialized = true;
                console.log('MasonryLayout: Initialized with container', this.container.id || this.container.className);

                this.setupLazyLoading();
                this.setupFilterSystem();
                this.setupVideoHoverEffects();
                this.loadVisibleItems();
                this.setupResponsiveResize();
                this.setupAccessibility();

                // Initial layout after a short delay
                setTimeout(() => {
                    this.refreshLayout();
                }, 100);
            }

            setupLazyLoading() {
                const options = {
                    threshold: 0.1,
                    rootMargin: '50px 0px'
                };

                this.observer = new IntersectionObserver((entries) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            this.loadMedia(entry.target);
                            this.observer.unobserve(entry.target);
                        }
                    });
                }, options);

                // Observe all items
                this.container.querySelectorAll('.masonry-item').forEach(item => {
                    this.observer.observe(item);
                });
            }

            loadMedia(item) {
                const img = item.querySelector('.masonry-image[data-src]');
                const video = item.querySelector('.masonry-video[data-src]');

                if (img) {
                    this.loadImage(img, item);
                } else if (video) {
                    this.loadVideo(video, item);
                } else {
                    // No lazy loading needed, just show the item
                    this.showItem(item);
                }
            }

            loadImage(img, item) {
                const src = img.getAttribute('data-src');
                if (!src) return;

                // Create a new image to preload
                const newImg = new Image();

                newImg.onload = () => {
                    img.src = src;
                    img.removeAttribute('data-src');
                    this.showItem(item);
                    this.refreshLayout();
                };

                newImg.onerror = () => {
                    img.src = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 400 300'%3E%3Crect width='400' height='300' fill='%23f3f4f6'/%3E%3Ctext x='50%25' y='50%25' dominant-baseline='middle' text-anchor='middle' fill='%239ca3af'%3EImage not available%3C/text%3E%3C/svg%3E";
                    this.showItem(item);
                };

                newImg.src = src;
            }

            loadVideo(video, item) {
                const src = video.getAttribute('data-src');
                if (!src) return;

                const source = video.querySelector('source[data-src]');
                if (source) {
                    source.src = source.getAttribute('data-src');
                    source.removeAttribute('data-src');
                }

                video.src = src;
                video.removeAttribute('data-src');
                video.load();

                // Set initial state
                video.currentTime = 0;
                video.classList.add('paused');

                video.addEventListener('loadedmetadata', () => {
                    video.currentTime = 0; // Ensure first frame
                    this.showItem(item);
                    this.refreshLayout();
                }, {
                    once: true
                });

                video.addEventListener('error', () => {
                    item.style.display = 'none';
                }, {
                    once: true
                });
            }

            showItem(item) {
                item.classList.add('loaded');

                // Stagger the animation
                const delay = parseInt(item.dataset.index) * 50;
                setTimeout(() => {
                    item.style.animationDelay = '0s';
                }, delay);
            }

            setupFilterSystem() {
                const filterButtons = document.querySelectorAll('.portfolio-filter');
                const items = this.container.querySelectorAll('.masonry-item, .portfolio-item');

                if (!filterButtons.length) {
                    console.log('MasonryLayout: No filter buttons found');
                    return;
                }

                if (!items.length) {
                    console.log('MasonryLayout: No portfolio items found');
                    return;
                }

                console.log(`MasonryLayout: Found ${filterButtons.length} filter buttons and ${items.length} portfolio items`);

                filterButtons.forEach(button => {
                    button.addEventListener('click', (e) => {
                        e.preventDefault();

                        const filter = button.getAttribute('data-filter');
                        console.log(`MasonryLayout: Filtering by "${filter}"`);

                        // Update active button
                        filterButtons.forEach(btn => btn.classList.remove('active'));
                        button.classList.add('active');

                        // Filter items with enhanced animation
                        let visibleCount = 0;
                        items.forEach((item, index) => {
                            const category = item.getAttribute('data-category');
                            const shouldShow = filter === 'all' || category === filter;

                            console.log(`Item ${index}: category="${category}", filter="${filter}", shouldShow=${shouldShow}`);

                            setTimeout(() => {
                                if (shouldShow) {
                                    // Show item
                                    item.style.display = 'block';
                                    item.classList.remove('hidden');
                                    item.classList.add('show');
                                    item.style.animationDelay = `${visibleCount * 0.05}s`;

                                    // Enhanced visibility animation
                                    setTimeout(() => {
                                        item.style.opacity = '1';
                                        item.style.transform = 'scale(1) translateY(0)';
                                    }, visibleCount * 50);

                                    visibleCount++;
                                } else {
                                    // Hide item
                                    item.style.opacity = '0';
                                    item.style.transform = 'scale(0.8) translateY(20px)';
                                    item.classList.add('hidden');
                                    item.classList.remove('show');

                                    // Hide completely after animation
                                    setTimeout(() => {
                                        item.style.display = 'none';
                                    }, 300);
                                }
                            }, index * 20);
                        });

                        // Log filtering results
                        const visibleItems = Array.from(items).filter(item => {
                            const category = item.getAttribute('data-category');
                            return filter === 'all' || category === filter;
                        });
                        console.log(`MasonryLayout: ${visibleItems.length} items will be visible after filtering`);

                        // Refresh layout after filtering
                        setTimeout(() => {
                            this.refreshLayout();
                            // Trigger custom event to re-setup video hover effects
                            this.container.dispatchEvent(new CustomEvent('filterChanged'));
                        }, items.length * 20 + 100);
                    });
                });

                // Initialize - ensure all items are visible by default
                items.forEach(item => {
                    item.style.opacity = '1';
                    item.style.transform = 'scale(1) translateY(0)';
                    item.style.display = 'block';
                    item.classList.add('show');
                    item.classList.remove('hidden');
                });
            }

            loadVisibleItems() {
                // Load items that are already visible (above the fold)
                const items = this.container.querySelectorAll('.masonry-item');
                const viewportHeight = window.innerHeight;

                items.forEach((item, index) => {
                    const rect = item.getBoundingClientRect();
                    if (rect.top < viewportHeight && rect.bottom > 0) {
                        this.loadMedia(item);
                        if (this.observer) {
                            this.observer.unobserve(item);
                        }
                    }
                });
            }

            setupResponsiveResize() {
                window.addEventListener('resize', () => {
                    clearTimeout(this.resizeTimeout);
                    this.resizeTimeout = setTimeout(() => {
                        this.refreshLayout();
                    }, 150);
                });
            }

            setupVideoHoverEffects() {
                // Set up hover effects for masonry videos
                const handleVideoHover = () => {
                    const videoItems = this.container.querySelectorAll('.masonry-item');

                    videoItems.forEach(item => {
                        const video = item.querySelector('.masonry-video');
                        const groupElement = item.querySelector('.group');

                        if (video && groupElement) {
                            // Remove any existing event listeners to prevent duplicates
                            groupElement.removeEventListener('mouseenter', groupElement._videoMouseEnter);
                            groupElement.removeEventListener('mouseleave', groupElement._videoMouseLeave);

                            // Initialize video state
                            video.currentTime = 0;
                            video.classList.add('paused');

                            // Create event handlers
                            groupElement._videoMouseEnter = () => {
                                if (video.readyState >= 2) { // HAVE_CURRENT_DATA
                                    video.classList.remove('paused');
                                    video.classList.add('playing');
                                    video.currentTime = 0;
                                    video.play().catch(e => console.log('Video play failed:', e));
                                }
                            };

                            groupElement._videoMouseLeave = () => {
                                video.classList.remove('playing');
                                video.classList.add('paused');
                                video.pause();
                                setTimeout(() => {
                                    video.currentTime = 0;
                                }, 100);
                            };

                            // Add event listeners
                            groupElement.addEventListener('mouseenter', groupElement._videoMouseEnter);
                            groupElement.addEventListener('mouseleave', groupElement._videoMouseLeave);

                            // Handle video loading
                            video.addEventListener('loadeddata', () => {
                                video.currentTime = 0;
                            }, {
                                once: true
                            });

                            // Error handling
                            video.addEventListener('error', () => {
                                console.log('Masonry video failed to load:', video.src);
                            }, {
                                once: true
                            });
                        }
                    });
                };

                // Initial setup
                setTimeout(() => {
                    handleVideoHover();
                }, 500);

                // Re-setup after filter changes
                this.container.addEventListener('filterChanged', () => {
                    setTimeout(handleVideoHover, 200);
                });
            }

            setupAccessibility() {
                // Add keyboard navigation
                this.container.addEventListener('keydown', (e) => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        const target = e.target.closest('.masonry-item .group');
                        if (target) {
                            e.preventDefault();
                            target.click();
                        }
                    }
                });

                // Add focus management
                const items = this.container.querySelectorAll('.masonry-item .group');
                items.forEach(item => {
                    item.setAttribute('tabindex', '0');
                    item.setAttribute('role', 'button');
                    item.setAttribute('aria-label', 'Open image in lightbox');
                });
            }

            refreshLayout() {
                // Force reflow for masonry layout
                if (this.container) {
                    const display = this.container.style.display;
                    this.container.style.display = 'none';
                    this.container.offsetHeight; // Trigger reflow
                    this.container.style.display = display;
                }
            }

            destroy() {
                if (this.observer) {
                    this.observer.disconnect();
                }
                clearTimeout(this.resizeTimeout);
                window.removeEventListener('resize', this.setupResponsiveResize);
            }
        }

        // Initialize the masonry layout
        document.addEventListener('DOMContentLoaded', () => {
            new MasonryLayout();

            // Initialize orientation detection for portfolio grid
            initPortfolioOrientationDetection();

            // Initialize hero animations
            initHeroAnimations();
        });

        // Portfolio Orientation Detection and Dynamic Spanning
        function initPortfolioOrientationDetection() {
            const portfolioGrid = document.getElementById('masonryGrid');
            if (!portfolioGrid) return;

            const items = portfolioGrid.querySelectorAll('.masonry-item');

            // Process each item for orientation detection
            items.forEach((item, index) => {
                const media = item.querySelector('.masonry-image, .masonry-video');
                if (!media) return;

                // Add loading class initially
                item.classList.add('loading');

                if (media.tagName === 'VIDEO') {
                    // Setup video hover functionality
                    setupVideoHoverEffects(item, media);

                    // Handle video orientation detection
                    media.addEventListener('loadedmetadata', () => {
                        detectAndApplyOrientation(media, item, index);
                    });

                    // Fallback if metadata doesn't load
                    setTimeout(() => {
                        if (media.videoWidth > 0 || media.videoHeight > 0) {
                            detectAndApplyOrientation(media, item, index);
                        }
                    }, 1000);
                } else {
                    // Handle image orientation detection
                    if (media.complete) {
                        detectAndApplyOrientation(media, item, index);
                    } else {
                        media.addEventListener('load', () => {
                            detectAndApplyOrientation(media, item, index);
                        });
                    }
                }
            });
        }

        // Video Hover Effects for Pixelated Playback
        function setupVideoHoverEffects(item, video) {
            let hoverTimeout;
            let isPlaying = false;

            // Mouse enter - start playing after delay
            item.addEventListener('mouseenter', () => {
                clearTimeout(hoverTimeout);
                hoverTimeout = setTimeout(async () => {
                    try {
                        if (!isPlaying) {
                            // Reset video to start
                            video.currentTime = 0;
                            await video.play();
                            isPlaying = true;
                        }
                    } catch (error) {
                        console.log('Video play failed:', error);
                    }
                }, 200); // Small delay to prevent accidental triggers
            });

            // Mouse leave - pause and reset
            item.addEventListener('mouseleave', () => {
                clearTimeout(hoverTimeout);
                try {
                    video.pause();
                    video.currentTime = 0;
                    isPlaying = false;
                } catch (error) {
                    console.log('Video pause failed:', error);
                }
            });

            // Ensure video is paused initially
            video.pause();
            video.currentTime = 0;
        }

        function detectAndApplyOrientation(media, item, index) {
            let width, height;

            // Get dimensions based on media type
            if (media.tagName === 'VIDEO') {
                width = media.videoWidth || media.clientWidth;
                height = media.videoHeight || media.clientHeight;
            } else {
                width = media.naturalWidth || media.clientWidth;
                height = media.naturalHeight || media.clientHeight;
            }

            // Calculate aspect ratio
            const aspectRatio = width / height;

            // Remove loading state
            item.classList.remove('loading');

            // Remove any existing span classes
            item.classList.remove('span-horizontal', 'span-vertical', 'span-large-horizontal', 'span-large-vertical');

            // Apply orientation-based spans
            if (aspectRatio > 2.5) {
                // Extra wide content
                item.classList.add('span-large-horizontal');
            } else if (aspectRatio > 1.3) {
                // Wide content (landscape)
                item.classList.add('span-horizontal');
            } else if (aspectRatio < 0.4) {
                // Extra tall content
                item.classList.add('span-large-vertical');
            } else if (aspectRatio < 0.75) {
                // Tall content (portrait)
                item.classList.add('span-vertical');
            }
            // Square-ish content (0.75 <= ratio <= 1.3) gets no span classes

            // Add subtle entrance animation with delay
            setTimeout(() => {
                item.style.opacity = '1';
                item.style.transform = 'translateY(0)';
            }, index * 50);

            // Debug log (remove in production)
            console.log(`Item ${index}: ${width}x${height}, ratio: ${aspectRatio.toFixed(2)}, classes: ${item.className}`);
        }

        // Handle responsive recalculation on window resize
        let resizeTimeoutOrientation;
        window.addEventListener('resize', () => {
            clearTimeout(resizeTimeoutOrientation);
            resizeTimeoutOrientation = setTimeout(() => {
                // Re-run orientation detection on significant resize
                const items = document.querySelectorAll('#masonryGrid .masonry-item');
                items.forEach((item, index) => {
                    const media = item.querySelector('.masonry-image, .masonry-video');
                    if (media) {
                        detectAndApplyOrientation(media, item, index);
                    }
                });
            }, 250);
        });

        // Hero animations and effects
        function initHeroAnimations() {
            // Add parallax effect to masonry items
            const masonryItems = document.querySelectorAll('.hero-masonry-item');
            const floatingShapes = document.querySelectorAll('.floating-shape');

            // Scroll-based parallax effect
            function handleParallax() {
                const scrolled = window.pageYOffset;
                const rate = scrolled * -0.5;

                // Parallax for masonry background
                const masonryBackground = document.querySelector('.hero-masonry-background');
                if (masonryBackground && scrolled < window.innerHeight) {
                    masonryBackground.style.transform = `translateY(${rate}px)`;
                }

                // Parallax for floating shapes
                floatingShapes.forEach((shape, index) => {
                    const speed = (index + 1) * 0.3;
                    shape.style.transform = `translateY(${scrolled * speed}px) rotate(${scrolled * 0.1}deg)`;
                });
            }

            // Throttled scroll handler
            let ticking = false;

            function handleScroll() {
                if (!ticking) {
                    requestAnimationFrame(() => {
                        handleParallax();
                        ticking = false;
                    });
                    ticking = true;
                }
            }

            window.addEventListener('scroll', handleScroll);

            // Add mouse movement effect to masonry items
            const heroSection = document.querySelector('.hero-carousel');
            if (heroSection) {
                heroSection.addEventListener('mousemove', (e) => {
                    const {
                        clientX,
                        clientY
                    } = e;
                    const {
                        innerWidth,
                        innerHeight
                    } = window;

                    const xPercent = (clientX / innerWidth - 0.5) * 2;
                    const yPercent = (clientY / innerHeight - 0.5) * 2;

                    masonryItems.forEach((item, index) => {
                        const speed = (index % 3 + 1) * 2;
                        const x = xPercent * speed;
                        const y = yPercent * speed;

                        item.style.transform = `translate(${x}px, ${y}px)`;
                    });
                });

                // Reset on mouse leave
                heroSection.addEventListener('mouseleave', () => {
                    masonryItems.forEach(item => {
                        item.style.transform = 'translate(0, 0)';
                    });
                });
            }

            // Intersection Observer for masonry items
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const masonryObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.animationDelay = '0s';
                        entry.target.classList.add('masonry-animate');
                    }
                });
            }, observerOptions);

            masonryItems.forEach(item => {
                masonryObserver.observe(item);
            });

            // Add glow effect on hover for enhanced interactivity
            masonryItems.forEach(item => {
                item.addEventListener('mouseenter', () => {
                    item.style.boxShadow = '0 25px 50px rgba(1, 172, 182, 0.4), 0 0 0 1px rgba(1, 172, 182, 0.2)';
                });

                item.addEventListener('mouseleave', () => {
                    item.style.boxShadow = '';
                });
            });
        }

        // Dynamic Portfolio Media Handler
        document.addEventListener('DOMContentLoaded', function() {
            const dynamicGrid = document.getElementById('dynamic-portfolio-grid');
            if (!dynamicGrid) return;

            // Handle video hover interactions for dynamic content
            const dynamicVideos = dynamicGrid.querySelectorAll('video[data-media-type="video"]');

            dynamicVideos.forEach(video => {
                const container = video.closest('.portfolio-item2');

                // Initialize video
                video.currentTime = 0;
                video.classList.add('paused');

                // Mouse enter - start playing
                container.addEventListener('mouseenter', () => {
                    video.classList.remove('paused');
                    video.classList.add('playing');
                    video.currentTime = 0;
                    video.play().catch(e => console.log('Video play failed:', e));
                });

                // Mouse leave - pause and reset
                container.addEventListener('mouseleave', () => {
                    video.classList.remove('playing');
                    video.classList.add('paused');
                    video.pause();
                    setTimeout(() => {
                        video.currentTime = 0;
                    }, 100);
                });

                // Error handling
                video.addEventListener('error', () => {
                    console.log('Dynamic video failed to load:', video.src);
                    container.style.display = 'none';
                });
            });

            // Optimize layout based on actual media dimensions
            const mediaItems = dynamicGrid.querySelectorAll('[data-media-type]');
            mediaItems.forEach((media, index) => {
                if (media.tagName === 'IMG') {
                    media.addEventListener('load', () => {
                        optimizeGridLayout(media, index);
                    });
                } else if (media.tagName === 'VIDEO') {
                    media.addEventListener('loadedmetadata', () => {
                        optimizeGridLayout(media, index);
                    });
                }
            });

            function optimizeGridLayout(media, index) {
                const container = media.closest('[class*="col-span"]');
                if (!container) return;

                const aspectRatio = media.naturalWidth / media.naturalHeight || media.videoWidth / media.videoHeight;

                // Adjust grid span based on aspect ratio
                let newSpan;
                if (aspectRatio > 2) {
                    // Very wide - give more horizontal space
                    newSpan = Math.min(12, 8);
                } else if (aspectRatio > 1.5) {
                    // Wide - medium horizontal space
                    newSpan = Math.min(12, 6);
                } else if (aspectRatio > 0.8) {
                    // Square-ish - standard space
                    newSpan = 4;
                } else {
                    // Tall - less horizontal space
                    newSpan = 3;
                }

                // Update classes
                const currentClasses = container.className;
                const newClasses = currentClasses.replace(/col-span-\d+/g, `col-span-${newSpan}`);
                container.className = newClasses;
            }

            console.log('Dynamic portfolio media handler initialized for', mediaItems.length, 'items');
        });
    </script>
    <script>
        // Your JSON data

        const mediaData = {
            "images": <?= json_encode($portfolio_data['values'][3] ?? []) ?>
        };
        class SeamlessMasonryGrid {
            constructor(container2, mediaUrls) {
                this.container2 = container2;
                this.mediaUrls = mediaUrls;
                this.loadedItems = 0;
                this.init();
            }

            init() {
                this.createItems();
            }

            parseUrlDimensions(url) {
                const urlParams = new URLSearchParams(url.split('?')[1]);
                const width = urlParams.get('w');
                const height = urlParams.get('h');

                if (width && height) {
                    return {
                        width: parseInt(width),
                        height: parseInt(height)
                    };
                }
                return null;
            }

            createItems() {
                this.mediaUrls.forEach((url, index) => {
                    const item = this.createMasonryItem(url, index);
                    this.container2.appendChild(item);
                });
            }

            createMasonryItem(url, index) {
                const item = document.createElement('div');
                item.className = 'masonry-item';

                // Show loading state initially
                item.innerHTML = '<div class="loading"><div class="spinner"></div></div>';

                // Determine if it's a video or image
                const isVideo = url.toLowerCase().includes('.mp4');

                if (isVideo) {
                    this.loadVideo(item, url);
                } else {
                    this.loadImage(item, url);
                }

                return item;
            }

            loadImage(item, url) {
                const img = new Image();

                img.onload = () => {
                    item.innerHTML = `
                        <img src="${url}" alt="Portfolio item" loading="lazy">
                        <div class="media-overlay">IMG</div>
                    `;

                    this.onItemLoaded();
                };

                img.onerror = () => {
                    item.innerHTML = '<div class="error">Failed to load image</div>';
                    this.onItemLoaded();
                };

                img.src = url;
            }

            loadVideo(item, url) {
                const video = document.createElement('video');
                video.muted = true;
                video.loop = true;
                video.playsInline = true;
                video.preload = 'auto';

                video.onloadedmetadata = () => {
                    item.innerHTML = `
                        <div class="group relative overflow-hidden rounded-xl cursor-pointer h-full">
                            <video muted loop playsinline class="masonry-video w-full h-full object-cover" preload="auto">
                                <source src="${url}" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                            <div class="video-overlay absolute inset-0 bg-black bg-opacity-10 transition-all duration-300 pointer-events-none"></div>
                            <div class="video-play-indicator absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center backdrop-blur-sm transition-all duration-300">
                                <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="media-overlay absolute top-2 right-2 px-2 py-1 bg-black bg-opacity-50 rounded text-white text-xs font-medium">MP4</div>
                        </div>
                    `;

                    // Enhanced hover play/pause functionality with pixel effects
                    const videoElement = item.querySelector('video');
                    const playIndicator = item.querySelector('.video-play-indicator');
                    const overlay = item.querySelector('.video-overlay');

                    videoElement.classList.add('paused');

                    // Set thumbnail to 3 seconds on multiple events
                    videoElement.addEventListener('loadedmetadata', function() {
                        this.currentTime = 3;
                    });

                    videoElement.addEventListener('loadeddata', function() {
                        if (this.currentTime < 3) {
                            this.currentTime = 3;
                        }
                    });

                    videoElement.addEventListener('canplay', function() {
                        if (this.currentTime < 3) {
                            this.currentTime = 3;
                        }
                    });

                    // Hover to play functionality
                    item.addEventListener('mouseenter', () => {
                        videoElement.classList.remove('paused');
                        videoElement.classList.add('playing');
                        playIndicator.style.opacity = '0';
                        overlay.style.opacity = '0';
                        videoElement.currentTime = 0;
                        videoElement.play().catch(e => console.log('Video play failed:', e));
                    });

                    // Leave to pause functionality
                    item.addEventListener('mouseleave', () => {
                        videoElement.classList.add('paused');
                        videoElement.classList.remove('playing');
                        playIndicator.style.opacity = '1';
                        overlay.style.opacity = '1';
                        videoElement.pause();
                        setTimeout(() => {
                            videoElement.currentTime = 3;
                        }, 100);
                    });

                    this.onItemLoaded();
                };

                video.onerror = () => {
                    item.innerHTML = '<div class="error bg-gray-800 text-white p-4 rounded-xl flex items-center justify-center h-full">Failed to load video</div>';
                    this.onItemLoaded();
                };

                video.src = url;
            }

            onItemLoaded() {
                this.loadedItems++;
                if (this.loadedItems === this.mediaUrls.length) {
                    console.log('All items loaded seamlessly');
                }
            }
        }

        // Initialize portfolio filtering when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            // Only initialize standalone filtering if MasonryLayout doesn't handle it
            const hasMasonryContainer = document.getElementById('masonryGrid') || document.querySelector('.masonry-grid1');
            if (hasMasonryContainer && !window.masonryLayoutInitialized) {
                console.log('Portfolio filtering will be handled by MasonryLayout class');
            } else {
                setupPortfolioFiltering();
            }
        });

        // Enhanced Portfolio filtering functionality
        function setupPortfolioFiltering() {
            const filterButtons = document.querySelectorAll('.portfolio-filter');
            const items = document.querySelectorAll('.masonry-item, .portfolio-item');
            const masonryGrid = document.querySelector('#masonryGrid, .masonry-grid1');

            if (!filterButtons.length || !items.length) {
                console.log('Portfolio filtering: No filter buttons or items found');
                return;
            }

            console.log(`Found ${filterButtons.length} filter buttons and ${items.length} portfolio items`);

            filterButtons.forEach(button => {
                button.addEventListener('click', (e) => {
                    e.preventDefault();

                    const filter = button.getAttribute('data-filter');
                    console.log(`Filtering by: ${filter}`);

                    // Update active button
                    filterButtons.forEach(btn => btn.classList.remove('active'));
                    button.classList.add('active');

                    // Filter items with enhanced animation
                    let visibleCount = 0;
                    items.forEach((item, index) => {
                        const category = item.getAttribute('data-category');
                        console.log(`Item ${index}: category="${category}", filter="${filter}"`);

                        const shouldShow = filter === 'all' || category === filter;

                        setTimeout(() => {
                            if (shouldShow) {
                                // Show item
                                item.style.display = 'block';
                                item.classList.remove('hidden');
                                item.classList.add('show');

                                // Staggered fade-in animation
                                setTimeout(() => {
                                    item.style.opacity = '1';
                                    item.style.transform = 'scale(1) translateY(0)';
                                }, visibleCount * 50);
                                visibleCount++;
                            } else {
                                // Hide item
                                item.style.opacity = '0';
                                item.style.transform = 'scale(0.8) translateY(20px)';
                                item.classList.add('hidden');
                                item.classList.remove('show');

                                // Hide completely after animation
                                setTimeout(() => {
                                    item.style.display = 'none';
                                }, 300);
                            }
                        }, index * 20);
                    });

                    // Update count display if exists
                    const visibleItems = Array.from(items).filter(item => {
                        const category = item.getAttribute('data-category');
                        return filter === 'all' || category === filter;
                    });

                    console.log(`${visibleItems.length} items will be visible after filtering`);
                });
            });

            // Initialize - show all items
            items.forEach(item => {
                item.style.opacity = '1';
                item.style.transform = 'scale(1) translateY(0)';
                item.classList.add('show');
                item.classList.remove('hidden');
            });
        }

        // Handle window resize
        let resizeTimeoutSeamless;
        window.addEventListener('resize', () => {
            clearTimeout(resizeTimeoutSeamless);
            resizeTimeoutSeamless = setTimeout(() => {
                console.log('Window resized, seamless layout maintained');
            }, 250);
        });
    </script>
</body>

</html>
