<?php
header('Content-Type: application/xml; charset=utf-8');

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];
    $basePath = dirname($script);
    return $protocol . $host . $basePath;
}

function fetchPortfolioItems() {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
    $api_url = $baseUrl . $adminPath . "/cms.php/Records?category_id=4";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Accept: application/json'
    ));

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success'] && isset($data['data']['items'])) {
            return $data['data']['items'];
        }
    }

    return [];
}

function fetchBlogItems() {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
    $api_url = $baseUrl . $adminPath . "/cms.php/Records?category_id=1";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Accept: application/json'
    ));

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success'] && isset($data['data']['items'])) {
            return $data['data']['items'];
        }
    }

    return [];
}

$baseUrl = 'https://maxmind.ma';
$portfolioItems = fetchPortfolioItems();
$blogItems = fetchBlogItems();
$currentDate = date('Y-m-d');

echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
        http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">

    <!-- Main Pages -->
    <url>
        <loc><?php echo $baseUrl; ?>/</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>1.0</priority>
    </url>

    <url>
        <loc><?php echo $baseUrl; ?>/index.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>1.0</priority>
    </url>

    <!-- Blog Section -->
    <url>
        <loc><?php echo $baseUrl; ?>/blogs.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>

    <!-- Portfolio Section -->
    <url>
        <loc><?php echo $baseUrl; ?>/portfolio.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
    </url>

    <!-- Individual Blog Post -->
    <url>
        <loc><?php echo $baseUrl; ?>/blog.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>

    <!-- Services -->
    <url>
        <loc><?php echo $baseUrl; ?>/services.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>

    <!-- Projets Design -->
    <url>
        <loc><?php echo $baseUrl; ?>/project_design.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>

    <!-- Projets Web -->
    <url>
        <loc><?php echo $baseUrl; ?>/project_web.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>

    <!-- Types de Projets -->
    <url>
        <loc><?php echo $baseUrl; ?>/projectsType.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>

    <!-- Mentions légales -->
    <url>
        <loc><?php echo $baseUrl; ?>/mentions-legales.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>yearly</changefreq>
        <priority>0.3</priority>
    </url>

    <!-- Politique de confidentialité -->
    <url>
        <loc><?php echo $baseUrl; ?>/politique_de_confidentialite_max_mind_maroc.php</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>yearly</changefreq>
        <priority>0.3</priority>
    </url>

    <!-- Sections within the main page -->
    <url>
        <loc><?php echo $baseUrl; ?>/#about</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
    </url>

    <url>
        <loc><?php echo $baseUrl; ?>/#services</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
    </url>

    <url>
        <loc><?php echo $baseUrl; ?>/#contact</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
    </url>

    <url>
        <loc><?php echo $baseUrl; ?>/#projects</loc>
        <lastmod><?php echo $currentDate; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>

    <?php
    // Dynamic Portfolio Items
    if (!empty($portfolioItems)) {
        foreach ($portfolioItems as $item) {
            if (isset($item['slug']) && !empty($item['slug'])) {
                $lastModified = isset($item['created_at']) ? date('Y-m-d', strtotime($item['created_at'])) : $currentDate;
                echo "    <url>\n";
                echo "        <loc>" . $baseUrl . "/portfolio.php/" . htmlspecialchars($item['slug']) . "</loc>\n";
                echo "        <lastmod>" . $lastModified . "</lastmod>\n";
                echo "        <changefreq>monthly</changefreq>\n";
                echo "        <priority>0.8</priority>\n";
                echo "    </url>\n";
            }
        }
    }
    ?>

    <?php
    // Dynamic Blog Items
    if (!empty($blogItems)) {
        foreach ($blogItems as $item) {
            if (isset($item['slug']) && !empty($item['slug'])) {
                $lastModified = isset($item['created_at']) ? date('Y-m-d', strtotime($item['created_at'])) : $currentDate;
                echo "    <url>\n";
                echo "        <loc>" . $baseUrl . "/blog.php/" . htmlspecialchars($item['slug']) . "</loc>\n";
                echo "        <lastmod>" . $lastModified . "</lastmod>\n";
                echo "        <changefreq>monthly</changefreq>\n";
                echo "        <priority>0.7</priority>\n";
                echo "    </url>\n";
            }
        }
    }
    ?>

</urlset>