<?php 
include __DIR__ . '/../admin/config.php';

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];

    $basePath = dirname($script);

    return $protocol . $host . $basePath;
}

function truncateText($text, $maxLength = 35) {
    if (strlen($text) <= $maxLength) {
        return $text;
    }
    return substr($text, 0, $maxLength) . '...';
}

// Fetch hero section data from CMS
function fetchHeroSectionData() {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin/';
    $apiUrl = $baseUrl . $adminPath . 'cms.php/hero-section';
    
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: application/json'
        ),
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false
    ));

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $error = curl_error($curl);
    curl_close($curl);

    if ($error) {
        error_log("cURL Error fetching hero data: " . $error);
        return getDefaultHeroData();
    }

    if ($httpCode !== 200) {
        error_log("HTTP Error fetching hero data: " . $httpCode);
        return getDefaultHeroData();
    }

    $data = json_decode($response, true);

    if (!$data || !isset($data['success']) || !$data['success']) {
        error_log("API Error fetching hero data: " . ($data['error'] ?? 'Unknown error'));
        return getDefaultHeroData();
    }

    return $data['data'] ?? getDefaultHeroData();
}

function fetchBlogData($page = 1, $per_page = 8, $search = '', $category_id = 4, $tag = '', $filter_category_id = '') {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
    $url = "{$baseUrl}{$adminPath}/cms.php/Records?category_id={$category_id}&page={$page}&per_page={$per_page}";
    if (!empty($search)) {
        $url .= "&search=" . urlencode($search);
    }
    if (!empty($tag)) {
        $url .= "&tag=" . urlencode($tag);
    }

    if (!empty($filter_category_id)) {
        $url .= "&search_field=" . urlencode("category id") . "&search_value=" . urlencode($filter_category_id);
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"

    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_error($ch)) {
        curl_close($ch);
        
        return ['success' => false, 'data' => ['items' => [], 'pagination' => ['total' => 0]]];
    }

    curl_close($ch);

    if ($httpCode === 200) {
        $data = json_decode($response, true);
        
        return $data ?: ['success' => false, 'data' => ['items' => [], 'pagination' => ['total' => 0]]];
    }

    return ['success' => false, 'data' => ['items' => [], 'pagination' => ['total' => 0]]];
}

// Fetch category settings to get records_per_page
function fetchCategorySettings($category_id) {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';
    $url = "{$baseUrl}{$adminPath}/cms.php/categories/{$category_id}";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            return $data['data'] ?? null;
        }
    }

    return null;
}

// Get pagination parameters from URL
$current_page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;

// Fetch category settings to get the records_per_page value
$category_id = 4; // Projects category
$categorySettings = fetchCategorySettings($category_id);
$default_per_page = ($categorySettings && isset($categorySettings['records_per_page']))
    ? (int)$categorySettings['records_per_page']
    : 50;

// For project pages, fetch initial 10 items only
$projects_per_page = 10; // Fixed to 10 for Load More functionality
$search_query = isset($_GET['search']) ? trim($_GET['search']) : '';

$projects = fetchBlogData($current_page, $projects_per_page, $search_query);

// Extract unique project types for filtering (both Design ID 8 and Web ID 11)
$projectTypes = [];
if (isset($projects['data']['items']) && !empty($projects['data']['items'])) {
    foreach ($projects['data']['items'] as $project) {
        // Include both Design Projects (ID 8) and Web Projects (ID 11)
        if ($project['values'][5] == 8 || $project['values'][5] == 11) {
            $type = $project['values'][8] ?? 'Portfolio';
            $type = trim($type);
            if (!empty($type) && !in_array($type, $projectTypes)) {
                $projectTypes[] = $type;
            }
        }
    }
}

// Get base URL for use in HTML
$baseUrl = getBaseUrl();

function getDefaultHeroData() {
    return [
        'title' => 'Digital Excellence',
        'sous_titre' => "Building tomorrow's technology today with innovation and excellence",
        'images' => []
    ];
}

$heroData = fetchHeroSectionData();

?>