<?php include 'backend/backend.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<link rel="stylesheet" href="styleMl.css">
<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MaxMind - Innovation Technology | Solutions Digitales Maroc</title>
    <meta name="description" content="MaxMind, votre partenaire technologique au Maroc. Développement web, applications mobile, e-commerce et design UI/UX. Solutions digitales innovantes à Casablanca.">
    <meta name="keywords" content="développement web Maroc, application mobile Casablanca, e-commerce Maroc, design UI/UX, MaxMind technology">
    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">

    <!-- Open Graph -->
    <meta property="og:title" content="MaxMind - Innovation Technology">
    <meta property="og:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo htmlspecialchars($baseUrl); ?>">
    <meta property="og:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta property="og:locale" content="fr_MA">
    <meta property="og:site_name" content="MaxMind">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="MaxMind - Innovation Technology">
    <meta name="twitter:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta name="twitter:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta name="twitter:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta name="twitter:site" content="@MaxMindMA">
    <meta name="twitter:creator" content="@MaxMindMA">

    <!-- Additional SEO -->
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="author" content="MaxMind">
    <meta name="publisher" content="MaxMind">
    <meta name="language" content="French">
    <meta name="theme-color" content="#01acb6">
    <meta name="msapplication-TileColor" content="#01acb6">
    <link rel="stylesheet" href="css/index.css">
    <!-- Hero Section Meta Data -->
    <?php if ($heroData): ?>
        <meta name="hero:title" content="<?php echo htmlspecialchars($heroData['title'] ?? ''); ?>">
        <meta name="hero:subtitle" content="<?php echo htmlspecialchars($heroData['sous_titre'] ?? ''); ?>">
        <?php if (isset($heroData['images']) && is_array($heroData['images'])): ?>
            <meta name="hero:image_count" content="<?php echo count($heroData['images']); ?>">
            <?php foreach ($heroData['images'] as $index => $image): ?>
                <meta name="hero:image_<?php echo $index + 1; ?>" content="<?php echo htmlspecialchars($image); ?>">
            <?php endforeach; ?>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Blog/Projects Meta Data -->
    <?php if ($projects && isset($projects['data']['items'])): ?>
        <meta name="homepage:total_projects" content="<?php echo count($projects['data']['items']); ?>">
        <meta name="homepage:projects_displayed" content="<?php echo min(8, count($projects['data']['items'])); ?>">
        <?php if (isset($projects['data']['pagination']['total'])): ?>
            <meta name="homepage:total_available_projects" content="<?php echo $projects['data']['pagination']['total']; ?>">
        <?php endif; ?>

        <?php
        $project_categories = [];
        $project_tags = [];
        foreach ($projects['data']['items'] as $project) {
            if (isset($project['values']['category']) && !in_array($project['values']['category'], $project_categories)) {
                $project_categories[] = $project['values']['category'];
            }
            if (isset($project['values']['tags'])) {
                $tags = is_array($project['values']['tags']) ? $project['values']['tags'] : explode(',', $project['values']['tags']);
                foreach ($tags as $tag) {
                    $tag = trim($tag);
                    if (!empty($tag) && !in_array($tag, $project_tags)) {
                        $project_tags[] = $tag;
                    }
                }
            }
        }
        ?>
        <?php if (!empty($project_categories)): ?>
            <meta name="homepage:project_categories" content="<?php echo htmlspecialchars(implode(', ', $project_categories)); ?>">
            <meta name="homepage:category_count" content="<?php echo count($project_categories); ?>">
        <?php endif; ?>

        <?php if (!empty($project_tags)): ?>
            <meta name="homepage:project_tags" content="<?php echo htmlspecialchars(implode(', ', array_slice($project_tags, 0, 10))); ?>">
            <meta name="homepage:tag_count" content="<?php echo count($project_tags); ?>">
        <?php endif; ?>
    <?php endif; ?>

    <!-- Schema.org Structured Data -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars($baseUrl); ?>",
            "logo": "<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png",
            "description": "Solutions digitales exceptionnelles au Maroc - Développement web, applications mobile, e-commerce et design UI/UX",
            "foundingDate": "2020",
            "address": {
                "@type": "PostalAddress",
                "addressCountry": "MA",
                "addressLocality": "Casablanca"
            },
            "contactPoint": {
                "@type": "ContactPoint",
                "contactType": "customer service",
                "availableLanguage": ["French", "Arabic", "English"]
            },
            "sameAs": [
                "https://www.linkedin.com/company/maxmind-ma",
                "https://www.facebook.com/maxmind.ma",
                "https://www.instagram.com/maxmind.ma"
            ],
            "service": [{
                    "@type": "Service",
                    "name": "Développement Web",
                    "description": "Solutions web sur mesure et développement d'applications web modernes"
                },
                {
                    "@type": "Service",
                    "name": "Applications Mobile",
                    "description": "Développement d'applications mobiles iOS et Android"
                },
                {
                    "@type": "Service",
                    "name": "E-commerce",
                    "description": "Solutions e-commerce complètes et plateformes de vente en ligne"
                },
                {
                    "@type": "Service",
                    "name": "Design UI/UX",
                    "description": "Design d'interface utilisateur et expérience utilisateur optimisée"
                }
            ] <?php if ($heroData && isset($heroData['title'])): ?>,
            "slogan": "<?php echo htmlspecialchars($heroData['title']); ?>"
        <?php endif; ?>
        }
    </script>

    <!-- Preload critical resources -->
    <link rel="preload" href="./imgs/LOGO_MAXMIND_WHITE.png" as="image" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- GSAP -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', '-apple-system', 'sans-serif'],
                        display: ['Space Grotesk', 'Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>
</head>

<body class="bg-white" style="margin: 0; padding: 0; width: 100%; height: 100%;">
    <!-- Skip to content link for accessibility -->
    <a href="#main-content" class="sr-only focus:not-sr-only focus:absolute focus:top-4 focus:left-4 bg-primary-500 text-white px-4 py-2 rounded-md z-50">Passer au contenu principal</a>
    <?php include 'social-floating.php'; ?>
    <?php include 'header.php'; ?>

    <main id="main-content">
        <?php
        //  include 'hero-section.php';
         include 'header-component.php';
          ?>
        <section id="about"
            class="py-32 bg-slate-50 relative overflow-hidden">
            <div class="absolute inset-0 overflow-hidden">
                <div
                    class="absolute top-20 left-10 w-72 h-72 bg-[#01acb6]/15 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-float">
                </div>
                <div
                    class="absolute bottom-20 right-10 w-80 h-80 bg-[#01acb6]/15 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-float-delayed">
                </div>
            </div>

            <div class="max-w-7xl mx-auto px-6 relative">
                <div class="text-center mb-20">
                    <div
                        class="inline-flex items-center gap-3 bg-white/60 backdrop-blur-md border border-[#01acb6]/40 rounded-full px-6 py-3 mb-8">
                        <i data-lucide="target" class="w-5 h-5 text-[#01acb6]"></i>
                        <span class="text-sm font-semibold text-slate-700">L'AGENCE DIGITALE ORIENTÉE R.O.I</span>
                    </div>

                    <h2 class="about-title font-display text-4xl md:text-6xl font-black text-slate-900 mb-8 leading-tight tracking-tight">
                        Votre Agence de Communication Digitale Experte en
                        <span
                            class="bg-[#EF234B] bg-clip-text text-transparent">
                            Stratégie Marketing
                        </span>
                    </h2>

                    <p class="text-xl text-slate-600 max-w-5xl mx-auto leading-relaxed font-light">
                        Maxmind c'est plus de <span class="font-semibold text-[#01acb6]">100 projets</span> : des sites
                        internet, des campagnes Facebook et Instagram, des logiciels de gestion mais aussi du print et plein d'autres services !
                        <br><br>
                        Nous répondons aux besoins de nos clients pour leur communication online et offline depuis
                        <span class="font-semibold text-[#EF234B]">2015</span> grâce à une équipe qui centralise toutes les compétences digitales indispensables aux projets multicanaux.
                    </p>
                </div>

                <!-- Simple Services cards -->
                <div class="about-cards grid md:grid-cols-3 gap-8 mb-20">
                    <!-- Card 1: Conseil & Stratégie -->
                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden">
                        <div class="h-48 overflow-hidden">
                            <img src="./imgs/images_unsplash_com-photo-1560472354-b33ff0c44a43.webp"
                                alt="Conseil & Stratégie"
                                class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" />
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-bold text-slate-800 mb-3">
                                Conseil & Stratégie
                            </h3>
                            <p class="text-slate-600 leading-relaxed text-sm">
                                Plus qu'une agence de communication intégrant uniquement la réalisation graphique ou
                                technique de vos projets de communication, Maxmind se positionne également comme une agence
                                conseil et audit.
                            </p>
                        </div>
                    </div>

                    <!-- Card 2: Création & Production -->
                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden">
                        <div class="h-48 overflow-hidden">
                            <img src="./imgs/images_unsplash_com-photo-1581291518857-4e27b48ff24e.webp"
                                alt="Création & Production"
                                class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" />
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-bold text-slate-800 mb-3">
                                Création & Production
                            </h3>
                            <p class="text-slate-600 leading-relaxed text-sm">
                                Nous nous lançons dans la conception graphique sans laisser de place à l'improvisation. Nous
                                imaginons des visuels et donnons naissance à des créations dans le but d'en faire l'exact
                                reflet de votre entreprise.
                            </p>
                        </div>
                    </div>

                    <!-- Card 3: Développement & Conception -->
                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden">
                        <div class="h-48 overflow-hidden">
                            <img src="./imgs/images_unsplash_com-photo-1555066931-4365d14bab8c.webp"
                                alt="Développement & Conception"
                                class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" />
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-bold text-slate-800 mb-3">
                                Développement & Conception
                            </h3>
                            <p class="text-slate-600 leading-relaxed text-sm">
                                Nous construisons une ergonomie capable de répondre efficacement aux attentes des
                                utilisateurs de votre marque en privilégiant une expérience client optimisé afin de les
                                fidéliser.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="relative bg-[#1B2638] rounded-[2rem] p-12 md:p-16 text-white overflow-hidden">
                    <!-- Background decorative elements -->
                    <div class="absolute inset-0 overflow-hidden">
                        <div
                            class="absolute top-0 right-0 w-64 h-64 bg-[#01acb6]/15 rounded-full blur-3xl">
                        </div>
                        <div
                            class="absolute bottom-0 left-0 w-80 h-80 bg-[#01acb6]/15 rounded-full blur-3xl">
                        </div>
                    </div>
                    <div class="relative z-10 grid md:grid-cols-2 gap-16 items-center">
                        <div>
                            <div
                                class="inline-flex items-center gap-3 bg-white/10 backdrop-blur-md border border-white/20 rounded-full px-6 py-3 mb-8">
                                <i data-lucide="telescope" class="w-5 h-5 text-[#01acb6]"></i>
                                <span class="text-sm font-semibold">Notre Vision</span>
                            </div>

                            <h3
                                class="text-4xl md:text-5xl font-black mb-8 text-white leading-tight">
                                L'avenir digital commence ici
                            </h3>

                            <p class="text-slate-200 text-xl leading-relaxed mb-8 font-light">
                                Être le partenaire technologique de référence pour les entreprises qui souhaitent
                                se démarquer dans l'écosystème digital. Nous croyons en la puissance de
                                <span class="font-semibold text-[#01acb6]">l'innovation</span>
                                pour créer des expériences utilisateur exceptionnelles.
                            </p>

                            <div class="grid grid-cols-3 gap-4">
                                <div
                                    class="bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl p-4 text-center hover:bg-white/10 transition-all duration-300">
                                    <div class="text-3xl font-bold text-[#EF234B] mb-1">50+</div>
                                    <div class="text-sm text-slate-300">Projets</div>
                                </div>
                                <div
                                    class="bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl p-4 text-center hover:bg-white/10 transition-all duration-300">
                                    <div class="text-3xl font-bold text-[#EF234B] mb-1">5+</div>
                                    <div class="text-sm text-slate-300">Années</div>
                                </div>
                                <div
                                    class="bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl p-4 text-center hover:bg-white/10 transition-all duration-300">
                                    <div class="text-3xl font-bold text-[#EF234B] mb-1">100%</div>
                                    <div class="text-sm text-slate-300">Satisfaction</div>
                                </div>
                            </div>
                        </div>

                        <div >
                            <h4 class="text-2xl font-bold mb-8 text-white">Nos Valeurs Fondamentales</h4>
                            <div class="space-y-6">
                                <div
                                    class="flex items-start gap-4 p-4 bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl hover:bg-white/10 transition-all duration-300">
                                    <div class="w-3 h-3 bg-[#01acb6] rounded-full mt-2 flex-shrink-0"></div>
                                    <div>
                                        <h5 class="font-semibold text-[#01acb6] mb-1">Intégrité et transparence</h5>
                                        <p class="text-slate-300 text-sm">Des relations basées sur la confiance et
                                            l'honnêteté</p>
                                    </div>
                                </div>

                                <div
                                    class="flex items-start gap-4 p-4 bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl hover:bg-white/10 transition-all duration-300">
                                    <div class="w-3 h-3 bg-[#01acb6] rounded-full mt-2 flex-shrink-0"></div>
                                    <div>
                                        <h5 class="font-semibold text-[#01acb6] mb-1">Innovation constante</h5>
                                        <p class="text-slate-300 text-sm">Toujours à la pointe des dernières technologies
                                        </p>
                                    </div>
                                </div>

                                <div
                                    class="flex items-start gap-4 p-4 bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl hover:bg-white/10 transition-all duration-300">
                                    <div class="w-3 h-3 bg-[#01acb6] rounded-full mt-2 flex-shrink-0"></div>
                                    <div>
                                        <h5 class="font-semibold text-[#01acb6] mb-1">Excellence technique</h5>
                                        <p class="text-slate-300 text-sm">Des solutions robustes et performantes</p>
                                    </div>
                                </div>

                                <div
                                    class="flex items-start gap-4 p-4 bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl hover:bg-white/10 transition-all duration-300">
                                    <div class="w-3 h-3 bg-[#01acb6] rounded-full mt-2 flex-shrink-0"></div>
                                    <div>
                                        <h5 class="font-semibold text-[#01acb6] mb-1">Service personnalisé</h5>
                                        <p class="text-slate-300 text-sm">Chaque projet est unique et mérite une attention
                                            particulière</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Animated Timeline Section -->
        <div id="services">
            <section id="" class="py-16 bg-slate-100 relative overflow-hidden" >
            <!-- Background decorative elements -->
            <div class="absolute inset-0 overflow-hidden">
                <div class="absolute top-20 right-10 w-96 h-96 bg-[#01acb6]/10 rounded-full mix-blend-multiply filter blur-3xl opacity-40 animate-float"></div>
                <div class="absolute bottom-20 left-10 w-80 h-80 bg-[#EF234B]/10 rounded-full mix-blend-multiply filter blur-3xl opacity-40 animate-float-delayed"></div>
            </div>

            <div class="max-w-6xl mx-auto px-6 relative" id="">
                <!-- Section Header -->
                <div class="text-center mb-12">
                    <div class="inline-flex items-center gap-3 bg-white/60 backdrop-blur-md border border-[#01acb6]/30 rounded-full px-6 py-3 mb-8">
                        <i data-lucide="clock" class="w-5 h-5 text-[#01acb6]"></i>
                        <span class="text-sm font-semibold text-slate-700">NOTRE APPROCHE</span>
                    </div>
                    <h2 class="font-display text-4xl md:text-6xl font-black text-slate-900 mb-8 ">
                        SMALL WINS
                        <span class="text-[#01acb6]">
                            ONE STEP AT A TIME
                        </span>
                    </h2>
                    <p class="text-xl text-slate-600 max-w-3xl mx-auto leading-relaxed">
                        Votre succès se construit une étape à la fois : explorez les moments clés de votre parcours
                    </p>
                </div>

                <!-- Timeline Container -->
                <div class="relative">
                    <!-- Central Timeline Line -->
                    <div class="absolute left-1/2 transform -translate-x-1/2 w-1 h-full bg-[#01acb6] rounded-full opacity-30"></div>
                    <div class="timeline-progress absolute left-1/2 transform -translate-x-1/2 w-1 bg-[#EF234B] rounded-full" style="height: 0%"></div>

                    <!-- Timeline Items -->
                    <div class="space-y-16">
                        <!-- Step 1: Découverte -->
                        <div class="process-step relative flex items-center" data-step="1">
                            <div class="w-1/2 pr-12 text-right">
                                <div class="process-content bg-white/80 backdrop-blur-xl border border-[#01acb6]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                    <div class="flex items-center justify-end gap-3 mb-4">
                                        <div class="process-step-number bg-[#01acb6] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">1</div>
                                        <div class="process-icon bg-[#01acb6]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                            <i data-lucide="search" class="w-6 h-6 text-[#01acb6]"></i>
                                        </div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-slate-800 mb-3">Découverte</h3>
                                    <p class="text-slate-600 mb-4 leading-relaxed">Ateliers collaboratifs pour comprendre vos objectifs, définir les KPI et identifier les contraintes techniques.</p>
                                    <div class="process-details bg-[#01acb6]/5 p-3 rounded-lg text-xs text-slate-700">
                                        <strong>Livrables:</strong> Brief, roadmap
                                    </div>
                                    <div class="process-duration mt-3 text-xs text-[#01acb6] font-semibold flex items-center justify-end gap-1">
                                    </div>
                                </div>
                            </div>
                            <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#01acb6] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                                <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                            </div>
                            <div class="w-1/2 pl-12"></div>
                        </div>

                        <!-- Step 2: Design -->
                        <div class="process-step relative flex items-center" data-step="2" style="margin-top: -10px;">
                            <div class="w-1/2 pr-12"></div>
                            <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#EF234B] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                                <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                            </div>
                            <div class="w-1/2 pl-12">
                                <div class="process-content bg-white/80 backdrop-blur-xl border border-[#EF234B]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                    <div class="flex items-center gap-3 mb-4">
                                        <div class="process-icon bg-[#EF234B]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                            <i data-lucide="palette" class="w-6 h-6 text-[#EF234B]"></i>
                                        </div>
                                        <div class="process-step-number bg-[#EF234B] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">2</div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-slate-800 mb-3">Etude et planning</h3>
                                    <p class="text-slate-600 mb-4 leading-relaxed">Une étape crutial pour visualisé votre objectif et le transformé en road map.</p>
                                    <div class="process-details bg-[#EF234B]/5 p-3 rounded-lg text-xs text-slate-700">
                                        <strong>Livrables:</strong> Wireframes, prototypes
                                    </div>
                                    <div class="process-duration mt-3 text-xs text-[#EF234B] font-semibold flex items-center gap-1">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Step 3: Développement -->
                        <div class="process-step relative flex items-center" data-step="3" style="margin-top: -10px;">
                            <div class="w-1/2 pr-12 text-right">
                                <div class="process-content bg-white/80 backdrop-blur-xl border border-[#01acb6]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                    <div class="flex items-center justify-end gap-3 mb-4">
                                        <div class="process-step-number bg-[#01acb6] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">3</div>
                                        <div class="process-icon bg-[#01acb6]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                            <i data-lucide="code" class="w-6 h-6 text-[#01acb6]"></i>
                                        </div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-slate-800 mb-3">Design</h3>
                                    <p class="text-slate-600 mb-4 leading-relaxed">UI/UX axé conversion et accessibilité avec une approche centrée utilisateur.</p>
                                    <div class="process-details bg-[#01acb6]/5 p-3 rounded-lg text-xs text-slate-700">
                                        <strong>Livrables:</strong> CI/CD, Wireframes, prototypes
                                    </div>
                                    <div class="process-duration mt-3 text-xs text-[#01acb6] font-semibold flex items-center justify-end gap-1">
                                    </div>
                                </div>
                            </div>
                            <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#01acb6] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                                <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                            </div>
                            <div class="w-1/2 pl-12"></div>
                        </div>
                        <!-- <div class="process-step relative flex items-center" data-step="3" style="margin-top: -10px;">
                        <div class="w-1/2 pr-12 text-right">
                            <div class="process-content bg-white/80 backdrop-blur-xl border border-[#01acb6]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                <div class="flex items-center justify-end gap-3 mb-4">
                                    <div class="process-step-number bg-[#01acb6] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">3</div>
                                    <div class="process-icon bg-[#01acb6]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                        <i data-lucide="code" class="w-6 h-6 text-[#01acb6]"></i>
                                    </div>
                                </div>
                                <h3 class="text-2xl font-bold text-slate-800 mb-3">Développement</h3>
                                <p class="text-slate-600 mb-4 leading-relaxed">Stack moderne, bonnes pratiques de développement et assurance qualité rigoureuse.</p>
                                <div class="process-details bg-[#01acb6]/5 p-3 rounded-lg text-xs text-slate-700">
                                    <strong>Livrables:</strong> CI/CD, tests, performance
                                </div>
                                <div class="process-duration mt-3 text-xs text-[#01acb6] font-semibold flex items-center justify-end gap-1">
                                    <i data-lucide="clock" class="w-3 h-3"></i>
                                    <span class="process-timer" data-duration="28">4-6 semaines</span>
                                </div>
                            </div>
                        </div>
                        <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#01acb6] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                            <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                        </div>
                        <div class="w-1/2 pl-12"></div>
                    </div> -->

                        <!-- Step 4: Lancement & Optimisation -->
                        <div class="process-step relative flex items-center" data-step="4" style="margin-top: -10px;">
                            <div class="w-1/2 pr-12"></div>
                            <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#01acb6] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                                <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                            </div>
                            <div class="w-1/2 pl-12">
                                <div class="process-content bg-white/80 backdrop-blur-xl border border-[#EF234B]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                    <div class="flex items-center gap-3 mb-4">
                                        <div class="process-icon bg-[#EF234B]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                            <i data-lucide="rocket" class="w-6 h-6 text-[#EF234B]"></i>
                                        </div>
                                        <div class="process-step-number bg-[#EF234B] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">4</div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-slate-800 mb-3">Développement</h3>
                                    <p class="text-slate-600 mb-4 leading-relaxed">Stack moderne, bonnes pratiques de développement et assurance qualité rigoureuse.</p>
                                    <div class="process-details bg-[#EF234B]/5 p-3 rounded-lg text-xs text-slate-700">
                                        <strong>Livrables:</strong> CI/CD, tests, performance
                                    </div>
                                    <div class="process-duration mt-3 text-xs text-[#EF234B] font-semibold flex items-center gap-1">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="process-step relative flex items-center" data-step="3" style="margin-top: -10px;">
                            <div class="w-1/2 pr-12 text-right">
                                <div class="process-content bg-white/80 backdrop-blur-xl border border-[#01acb6]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                    <div class="flex items-center justify-end gap-3 mb-4">
                                        <div class="process-step-number bg-[#01acb6] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">5</div>
                                        <div class="process-icon bg-[#01acb6]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                            <i data-lucide="bullseye" class="w-6 h-6 text-[#01acb6]"></i>
                                        </div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-slate-800 mb-3">Realisation</h3>
                                    <p class="text-slate-600 mb-4 leading-relaxed">Plan Marketing, Strategie marketing, MVP, Proof of Concept.</p>
                                    <div class="process-details bg-[#01acb6]/5 p-3 rounded-lg text-xs text-slate-700">
                                        <!-- <strong>Livrables:</strong> CI/CD, tests, performance -->
                                    </div>
                                    <div class="process-duration mt-3 text-xs text-[#01acb6] font-semibold flex items-center justify-end gap-1">
                                    </div>
                                </div>
                            </div>
                            <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#01acb6] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                                <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                            </div>
                            <div class="w-1/2 pl-12"></div>
                        </div>


                        <div class="process-step relative flex items-center" data-step="4" style="margin-top: -10px;">
                            <div class="w-1/2 pr-12"></div>
                            <div class="absolute left-1/2 transform -translate-x-1/2 w-8 h-8 bg-[#01acb6] rounded-full border-4 border-white shadow-lg z-10 hidden md:flex items-center justify-center">
                                <div class="w-3 h-3 bg-white rounded-full animate-pulse"></div>
                            </div>
                            <div class="w-1/2 pl-12">
                                <div class="process-content bg-white/80 backdrop-blur-xl border border-[#EF234B]/20 p-6 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 hover:-translate-y-2 group">
                                    <div class="flex items-center gap-3 mb-4">
                                        <div class="process-icon bg-[#EF234B]/10 p-3 rounded-2xl group-hover:scale-110 transition-transform">
                                            <i data-lucide="shield-halved" class="w-6 h-6 text-[#EF234B]"></i>
                                        </div>
                                        <div class="process-step-number bg-[#EF234B] text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">6</div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-slate-800 mb-3">Lancement & Optimisation</h3>
                                    <p class="text-slate-600 mb-4 leading-relaxed">Déploiement sécurisé et amélioration continue basée sur l'analyse des données.</p>
                                    <div class="process-details bg-[#EF234B]/5 p-3 rounded-lg text-xs text-slate-700">
                                        <strong>Livrables:</strong> Monitoring, support
                                    </div>

                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
        </div>

        <section id="contact" class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-16">
                    <h2 class="contact-title text-4xl md:text-5xl font-bold text-[#000] mb-6">
                        Contactez-
                        <span class="bg-[#01acb6] bg-clip-text text-transparent">nous</span>
                    </h2>
                    <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                        Prêt à donner vie à votre projet ? Contactez notre équipe d'experts pour une consultation gratuite
                    </p>
                </div>

                <div class="grid lg:grid-cols-2 gap-12">
                    <!-- Form -->
                    <form method="POST" action="<?php echo $baseUrl . '/mail/submit-form.php';  ?>" class="contact-form space-y-6" id="contactForm" novalidate aria-label="Formulaire de contact">
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-medium text-[#000] mb-2">
                                    Nom complet <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="name" name="full-name"
                                    class="w-full px-4 py-3 border border-[#01acb6]/30 rounded-xl focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                                    minlength="2" maxlength="50" pattern="[A-Za-zÀ-ÿ\s]+"
                                    title="Veuillez entrer votre nom complet (lettres uniquement, 2-50 caractères)"
                                    required>
                                <div class="error-message text-red-500 text-sm mt-1 hidden"></div>
                            </div>
                            <div>
                                <label for="ville" class="block text-sm font-medium text-[#000] mb-2">
                                    Ville <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="ville" name="ville"
                                    class="w-full px-4 py-3 border border-[#01acb6]/30 rounded-xl focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                                    minlength="2" maxlength="30" pattern="[A-Za-zÀ-ÿ\s-]+"
                                    title="Veuillez entrer une ville valide (lettres uniquement, 2-30 caractères)"
                                    required>
                                <div class="error-message text-red-500 text-sm mt-1 hidden"></div>
                            </div>
                        </div>

                        <div>
                            <label for="phone" class="block text-sm font-medium text-[#000] mb-2">
                                Téléphone <span class="text-red-500">*</span>
                            </label>
                            <input type="tel" id="phone" name="phone-number"
                                class="w-full px-4 py-3 border border-[#01acb6]/30 rounded-xl focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                                pattern="^(\+212|0)([5-7][0-9]{8})$"
                                placeholder="Ex: +212612345678 ou 0612345678"
                                title="Veuillez entrer un numéro de téléphone marocain valide"
                                required>
                            <div class="error-message text-red-500 text-sm mt-1 hidden"></div>
                        </div>

                        <div>
                            <label for="email" class="block text-sm font-medium text-[#000] mb-2">
                                Email <span class="text-red-500">*</span>
                            </label>
                            <input type="email" id="email" name="email"
                                class="w-full px-4 py-3 border border-[#01acb6]/30 rounded-xl focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                                pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$"
                                placeholder="exemple@email.com"
                                title="Veuillez entrer une adresse email valide"
                                required>
                            <div class="error-message text-red-500 text-sm mt-1 hidden"></div>
                        </div>

                        <div>
                            <label for="type_demande" class="block text-sm font-medium text-[#000] mb-2">
                                Type de demande <span class="text-red-500">*</span>
                            </label>
                            <select id="type_demande" name="type_demande"
                                class="w-full px-4 py-3 border border-[#01acb6]/30 rounded-xl focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors bg-white"
                                required>
                                <option value="">Sélectionnez un type de demande</option>
                                <option value="developpement_applicatif">Développement d'applicatif sur mesure</option>
                                <option value="site_ecommerce">Site E-commerce</option>
                                <option value="marketing_digital">Marketing Digital et Advertising</option>
                                <option value="gestion_reseaux_sociaux">Gestion des réseaux sociaux</option>
                                <option value="seo_sem">SEO - SEM</option>
                                <option value="solution_facturation">Solution de gestion de facturation</option>
                                <option value="gestion_commerciale_crm">Gestion Commerciale/CRM</option>
                                <option value="gestion_stock">Gestion de Stock</option>
                                <option value="systeme_rh">Système de gestion des Ressources Humaines</option>
                                <option value="systeme_salle_sport">Système de gestion de salle de sport</option>
                            </select>
                            <div class="error-message text-red-500 text-sm mt-1 hidden"></div>
                        </div>
                        <div class="grid gap-6">
                            <div>
                                <label for="message" class="block text-sm font-medium text-[#000] mb-2">
                                    message <span class="text-red-500">*</span>
                                </label>
                                <textarea id="message" name="MessageClient"
                                    class="w-full px-4 py-3 border border-[#01acb6]/30 rounded-xl focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                                    minlength="2" maxlength="50" pattern="[A-Za-zÀ-ÿ\s]+"
                                    title=""
                                    required></textarea>
                                <div class="error-message text-red-500 text-sm mt-1 hidden"></div>
                            </div>
                        </div>


                        <button type="submit"
                            class="w-full group relative px-8 py-4 bg-[#01acb6] rounded-xl font-semibold text-white transition-all duration-300 hover:scale-105 hover:shadow-lg hover:shadow-[#01acb6]/30">
                            <span class="flex items-center justify-center">
                                <!-- Envoyer le message -->
                                Envoyer
                                <i data-lucide="send"
                                    class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform"></i>
                            </span>
                        </button>
                    </form>
                    <div class="contact-info space-y-8">
                        <div
                            class="bg-slate-50 rounded-2xl p-8 border border-[#01acb6]/20">
                            <h3 class="text-2xl font-bold text-[#000] mb-6">Informations de contact</h3>

                            <div class="space-y-6">
                                <a href="mailto:contact@maxmind.ma"
                                    class="flex items-center p-4 bg-white rounded-xl shadow-sm hover:shadow-md transition-shadow group">
                                    <div
                                        class="p-3 bg-[#01acb6] rounded-xl mr-4 group-hover:scale-110 transition-transform">
                                        <i data-lucide="mail" class="w-5 h-5 text-white"></i>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-[#000]">Email</div>
                                        <div class="text-slate-600">contact@maxmind.ma</div>
                                    </div>
                                </a>

                                <a href="tel:+212522XXXXXX"
                                    class="flex items-center p-4 bg-white rounded-xl shadow-sm hover:shadow-md transition-shadow group">
                                    <div
                                        class="p-3 bg-[#01acb6] rounded-xl mr-4 group-hover:scale-110 transition-transform">
                                        <i data-lucide="phone" class="w-5 h-5 text-white"></i>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-[#000]">Téléphone</div>
                                        <div class="text-slate-600">+ 212 620 15 12 53</div>
                                    </div>
                                </a>

                                <div
                                    class="flex items-center p-4 bg-white rounded-xl shadow-sm hover:shadow-md transition-shadow group">
                                    <div
                                        class="p-3 bg-[#01acb6] rounded-xl mr-4 group-hover:scale-110 transition-transform">
                                        <i data-lucide="map-pin" class="w-5 h-5 text-white"></i>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-[#000]">Adresse</div>
                                        <div class="text-slate-600">Imm Soft City, Oasis, Office 17. 3rd floor, Casablanca 20180</div>
                                    </div>
                                </div>

                                <div
                                    class="flex items-center p-4 bg-white rounded-xl shadow-sm hover:shadow-md transition-shadow group">

                                    <div>
                                        <div class="font-semibold text-[#000]">Horaires</div>
                                        <div class="text-slate-600">Lun - Ven: 9h - 18h</div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- CTA -->
                        <!-- <div class="text-center p-6 border-2 border-dashed border-[#01acb6]/40 rounded-2xl bg-[#01acb6]/5">
                        <h4 class="text-lg font-bold text-[#000] mb-2">Consultation gratuite</h4>
                        <p class="text-slate-600 mb-4">Discutons de votre projet sans engagement</p>
                        <button
                            class="px-6 py-2 bg-[#01acb6] text-white rounded-full font-medium hover:scale-105 transition-transform shadow-lg hover:shadow-[#01acb6]/30">
                            Réserver un appel
                        </button>
                    </div> -->
                    </div>

                    <!-- Suivez-nous Section -->


                </div>
            </div>
        </section>


        <?php include 'footer.php'; ?>

    </main>

    <div id="devis-modal"
        class="fixed inset-0 bg-black/50 backdrop-blur-sm z-[9999] hidden items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full max-h-[90vh] overflow-y-auto transform scale-95 opacity-0 transition-all duration-300"
            id="modal-content">
            <div class="bg-[#01acb6] p-6 rounded-t-2xl">
                <div class="flex items-center justify-between">
                    <h3 class="text-xl font-bold text-white">Demander un devis gratuit</h3>
                    <button id="close-modal" class="text-white hover:text-gray-200 transition-colors">
                        <i data-lucide="x" class="w-6 h-6"></i>
                    </button>
                </div>
                <p class="text-white/90 text-sm mt-2">Remplissez le formulaire et nous vous contacterons rapidement</p>
            </div>

            <form id="devis-form" class="p-6 space-y-4">
                <div>
                    <label for="prenom" class="block text-sm font-medium text-gray-700 mb-2">
                        Prénom <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="prenom" name="prenom" required
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                        placeholder="Votre prénom">
                </div>

                <div>
                    <label for="nom" class="block text-sm font-medium text-gray-700 mb-2">
                        Nom <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="nom" name="nom" required
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                        placeholder="Votre nom">
                </div>

                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                        Email <span class="text-red-500">*</span>
                    </label>
                    <input type="email" id="email" name="email" required
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                        placeholder="votre.email@exemple.com">
                </div>

                <div>
                    <label for="telephone" class="block text-sm font-medium text-gray-700 mb-2">
                        Téléphone
                    </label>
                    <input type="tel" id="telephone" name="telephone"
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors"
                        placeholder="+212 6XX XXX XXX">
                </div>

                <div>
                    <label for="message" class="block text-sm font-medium text-gray-700 mb-2">
                        Décrivez votre projet
                    </label>
                    <textarea id="message" name="message" rows="4"
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6] transition-colors resize-none"
                        placeholder="Décrivez brièvement votre projet et vos besoins..."></textarea>
                </div>

                <div class="flex gap-3 pt-4">
                    <button type="button" id="cancel-btn"
                        class="flex-1 px-4 py-3 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        Annuler
                    </button>
                    <button type="submit"
                        class="flex-1 px-4 py-3 bg-[#01acb6] text-white rounded-lg hover:scale-105 transition-transform duration-300 font-semibold">
                        Envoyer
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script src="js/index.js"></script>

    <script>
        // Initialize Lucide icons immediately and after DOM loads
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();

            // Re-initialize after a short delay to catch any dynamically loaded content
            setTimeout(() => {
                lucide.createIcons();
            }, 100);

            // Re-initialize when DOM is fully loaded
            window.addEventListener('load', () => {
                lucide.createIcons();
            });
        }
    </script>

</body>

</html>