// Register GSAP plugins
gsap.registerPlugin(ScrollTrigger);

// DOM Elements
let header, mobileMenuBtn, mobileMenu, scrollToTopBtn, contactForm;

// Header scroll effect - Hide navbar elements when scrolling
let isScrolled = false;
let defaultBG =document.getElementById("header").style.backgroundColor;
function handleScroll() {
    const scrollY = window.scrollY;
    const heroSection = document.querySelector('.hero-section');
    const heroHeight = heroSection ? heroSection.offsetHeight : window.innerHeight;

    // Change header background when scrolling past hero section
    if (scrollY > heroHeight - 100 && !isScrolled) {
        isScrolled = true;
        // Add scrolled class and solid black background
        header.classList.add('scrolled');
        header.style.backgroundColor = '#000000'; // Solid black
    } else if (scrollY <= heroHeight - 100 && isScrolled) {
        isScrolled = false;
        // Remove scrolled class to make header transparent
        header.classList.remove('scrolled');
        header.style.backgroundColor = 'transparent';
    }

    // Show/hide scroll to top button
    if (scrollToTopBtn) {
        if (scrollY > 200) {
            scrollToTopBtn.style.display = 'block';
        } else {
            scrollToTopBtn.style.display = 'none';
        }
    }
}

// Debounced scroll handler
const debouncedScrollHandler = debounce(handleScroll, 10);

// Mobile menu toggle
function initializeMobileMenu() {
    if (!mobileMenuBtn || !mobileMenu) return;

    mobileMenuBtn.addEventListener('click', () => {
        const isOpen = !mobileMenu.classList.contains('hidden');

        if (isOpen) {
            mobileMenu.classList.add('hidden');
            mobileMenuBtn.innerHTML = '<i data-lucide="menu" class="w-6 h-6"></i>';
        } else {
            mobileMenu.classList.remove('hidden');
            mobileMenuBtn.innerHTML = '<i data-lucide="x" class="w-6 h-6"></i>';
        }

        // Re-initialize icons
        lucide.createIcons();
    });
}

// Smooth scrolling for navigation links
function initializeNavigation() {
    document.querySelectorAll('.nav-link').forEach(link => {
        link.addEventListener('click', (e) => {
            e.preventDefault();
            const targetId = link.getAttribute('href');
            const targetElement = document.querySelector(targetId);

            if (targetElement) {
                targetElement.scrollIntoView({ behavior: 'smooth' });

                // Close mobile menu if open
                if (mobileMenu && mobileMenuBtn) {
                    mobileMenu.classList.add('hidden');
                    mobileMenuBtn.innerHTML = '<i data-lucide="menu" class="w-6 h-6"></i>';
                    lucide.createIcons();
                }
            }
        });
    });
}

// Scroll to top functionality
function initializeScrollToTop() {
    if (!scrollToTopBtn) return;

    scrollToTopBtn.addEventListener('click', () => {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });
}

// Scroll indicator functionality
function initializeScrollIndicator() {
    const scrollIndicator = document.querySelector('.scroll-indicator');
    if (!scrollIndicator) return;

    scrollIndicator.addEventListener('click', () => {
        const aboutSection = document.getElementById('about');
        if (aboutSection) {
            aboutSection.scrollIntoView({ behavior: 'smooth' });
        }
    });
}

// Contact form handling
function initializeContactForm() {
    if (!contactForm) return;

    contactForm.addEventListener('submit', (e) => {
        e.preventDefault();

        const formData = new FormData(contactForm);
        const data = Object.fromEntries(formData);

        console.log('Form submitted:', data);

        // Here you would typically send the data to your server
        alert('Merci pour votre message ! Nous vous répondrons dans les plus brefs délais.');

        // Reset form
        contactForm.reset();
    });
}

// Enhanced GSAP Animations
function initializeAnimations() {
    // Modern hero section animations with stagger
    const heroTl = gsap.timeline();

    // Hero icon animation
    heroTl.fromTo('.hero-icon',
        { opacity: 0, scale: 0, rotation: -180 },
        { opacity: 1, scale: 1, rotation: 0, duration: 1, ease: "back.out(1.7)" }
    )
    // Title animation with split text effect
    .fromTo('.hero-title',
        { opacity: 0, y: 100, scale: 0.8, rotationX: 45 },
        { opacity: 1, y: 0, scale: 1, rotationX: 0, duration: 1.5, ease: "power3.out" },
        "-=0.5"
    )
    // Subtitle with typewriter effect
    .fromTo('.hero-subtitle',
        { opacity: 0, y: 80, skewY: 5 },
        { opacity: 1, y: 0, skewY: 0, duration: 1, ease: "power2.out" },
        "-=0.8"
    )
    // CTA buttons with bounce
    .fromTo('.hero-cta',
        { opacity: 0, y: 60, scale: 0.8 },
        { opacity: 1, y: 0, scale: 1, duration: 0.8, ease: "back.out(1.7)" },
        "-=0.6"
    );

    // Enhanced scroll indicator animation
    gsap.to('.scroll-indicator', {
        y: 15,
        duration: 2,
        ease: "power2.inOut",
        repeat: -1,
        yoyo: true
    });

    // Floating background elements animation - DISABLED to fix positioning
    // gsap.to('.animate-float', {
    //     y: -30,
    //     x: 20,
    //     rotation: 5,
    //     duration: 8,
    //     ease: "power1.inOut",
    //     repeat: -1,
    //     yoyo: true,
    //     stagger: 2
    // });

    // Glassmorphism cards entrance animation
    gsap.fromTo('.glass-effect',
        { opacity: 0, y: 50, scale: 0.9, backdropFilter: 'blur(0px)' },
        {
            opacity: 1,
            y: 0,
            scale: 1,
            backdropFilter: 'blur(20px)',
            duration: 1,
            ease: "power3.out",
            stagger: 0.2,
            scrollTrigger: {
                trigger: '.glass-effect',
                start: "top 80%",
                end: "bottom 20%"
            }
        }
    );

    // Hero parallax effect - DISABLED to fix positioning bug
    // gsap.to('.hero-section', {
    //     yPercent: -50,
    //     ease: "none",
    //     scrollTrigger: {
    //         trigger: '.hero-section',
    //         start: "top bottom",
    //         end: "bottom top",
    //         scrub: true
    //     }
    // });

    // About section animations
    gsap.fromTo('.about-title',
        { opacity: 0, y: 60 },
        {
            opacity: 1,
            y: 0,
            duration: 1,
            scrollTrigger: {
                trigger: '.about-title',
                start: "top 80%",
                end: "bottom 20%",
                toggleActions: "play none none reverse"
            }
        }
    );

    gsap.fromTo('.about-cards > *',
        { opacity: 0, y: 80, scale: 0.9 },
        {
            opacity: 1,
            y: 0,
            scale: 1,
            duration: 0.8,
            stagger: 0.2,
            ease: "power3.out",
            scrollTrigger: {
                trigger: '.about-cards',
                start: "top 80%",
                end: "bottom 20%",
                toggleActions: "play none none reverse"
            }
        }
    );

    // Services section animations
    gsap.fromTo('.services-title',
        { opacity: 0, y: 60 },
        {
            opacity: 1,
            y: 0,
            duration: 1,
            scrollTrigger: {
                trigger: '.services-title',
                start: "top 80%",
                end: "bottom 20%"
            }
        }
    );

    gsap.fromTo('.services-grid > *',
        { opacity: 0, y: 100, rotationX: 45 },
        {
            opacity: 1,
            y: 0,
            rotationX: 0,
            duration: 1,
            stagger: 0.15,
            ease: "power3.out",
            scrollTrigger: {
                trigger: '.services-grid',
                start: "top 80%",
                end: "bottom 20%"
            }
        }
    );

    // Projects section animations
    gsap.fromTo('.projects-title',
        { opacity: 0, y: 60 },
        {
            opacity: 1,
            y: 0,
            duration: 1,
            scrollTrigger: {
                trigger: '.projects-title',
                start: "top 80%"
            }
        }
    );

    gsap.fromTo('.projects-grid > *',
        { opacity: 0, y: 80, scale: 0.95 },
        {
            opacity: 1,
            y: 0,
            scale: 1,
            duration: 0.8,
            stagger: 0.2,
            ease: "power3.out",
            scrollTrigger: {
                trigger: '.projects-grid',
                start: "top 80%"
            }
        }
    );

    // Contact section animations
    gsap.fromTo('.contact-title',
        { opacity: 0, y: 60 },
        {
            opacity: 1,
            y: 0,
            duration: 1,
            scrollTrigger: {
                trigger: '.contact-title',
                start: "top 80%"
            }
        }
    );

    gsap.fromTo(['.contact-form', '.contact-info'],
        { opacity: 0, y: 80 },
        {
            opacity: 1,
            y: 0,
            duration: 0.8,
            stagger: 0.2,
            scrollTrigger: {
                trigger: '#contact',
                start: "top 70%"
            }
        }
    );

    // Refresh ScrollTrigger after all animations are set
    ScrollTrigger.refresh();
}

// Intersection Observer for additional animations
function initializeIntersectionObserver() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-fade-in');
            }
        });
    }, observerOptions);

    // Observe elements for fade-in animation
    document.querySelectorAll('.group').forEach(el => {
        observer.observe(el);
    });

    // Add CSS class for fade-in animation
    const style = document.createElement('style');
    style.textContent = `
        .animate-fade-in {
            animation: fadeIn 0.6s ease-out forwards;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    `;
    document.head.appendChild(style);
}

// Performance optimization: Debounce scroll events
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

// Initialize everything when DOM is loaded
document.addEventListener('DOMContentLoaded', () => {
    
    // Initialize DOM elements
    header = document.getElementById('header');
    mobileMenuBtn = document.getElementById('mobile-menu-btn');
    mobileMenu = document.getElementById('mobile-menu');
    scrollToTopBtn = document.getElementById('scroll-to-top');
    contactForm = document.getElementById('contact-form');

    // Initialize Lucide icons
    lucide.createIcons();

    // Initialize all functionality
    initializeMobileMenu();
    initializeNavigation();
    initializeScrollToTop();
    initializeScrollIndicator();
    initializeContactForm();
    initializeAnimations();
    initializeIntersectionObserver();

    // Initialize canvas animations
    if (typeof window.CanvasAnimations !== 'undefined') {
        console.log('Initializing canvas animations with settings:', window.CanvasAnimations.settings);

        window.CanvasAnimations.initialize();
       
        window.CanvasAnimations.setupVisibilityControl();

        // Test canvas integration
        setTimeout(() => {
            const testResults = window.CanvasAnimations.testIntegration();
            console.log('Canvas integration test results:', testResults);
        }, 1000);

        // Pause animations when hero section is not visible for better performance
        const heroObserver = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (window.CanvasAnimations) {
                    if (entry.isIntersecting) {
                        console.log('Hero section visible - canvas animations active');
                        document.getElementById("header").style.backgroundColor = 'transparent';
    
                   

} else {
    document.getElementById("header").style.backgroundColor = 'black';
                        console.log('Hero section not visible - canvas animations continue for visual continuity');
                        // Note: We keep animations running for smooth visual experience
                        // The visibility API will handle pausing when tab is not active
                    }
                }
            });
        }, { threshold: 0.1 });

        const heroSection = document.querySelector('.hero-section');
        if (heroSection) {
            heroObserver.observe(heroSection);
        }
    }

    // Note: Initial header state is now handled by the enhanced scroll handler

    // Hide scroll to top button initially
    if (scrollToTopBtn) {
        scrollToTopBtn.style.display = 'none';
    }

    // Note: Enhanced scroll handler is now initialized separately at the bottom of the file
});

// Handle window resize
window.addEventListener('resize', debounce(() => {
    ScrollTrigger.refresh();
}, 250));

// Preload critical images
const criticalImages = [
    'https://images.pexels.com/photos/4050290/pexels-photo-4050290.jpeg?auto=compress&cs=tinysrgb&w=800',
    'https://images.pexels.com/photos/4386467/pexels-photo-4386467.jpeg?auto=compress&cs=tinysrgb&w=800',
    'https://images.pexels.com/photos/6801648/pexels-photo-6801648.jpeg?auto=compress&cs=tinysrgb&w=800'
];

criticalImages.forEach(src => {
    const img = new Image();
    img.src = src;
});

console.log('MaxMind website loaded successfully! 🚀');

// Enhanced Header Scroll Handler - Fixed Version
function createHeaderScrollHandler() {
    let isScrolled = false;
    let ticking = false;

    function updateHeaderBackground() {
        const header = document.getElementById('header');
        const scrollY = window.scrollY;
        const threshold = 100; // 100px scroll threshold

        if (!header) {
            console.error('❌ Header element not found!');
            return;
        }

        if (scrollY > threshold && !isScrolled) {
            isScrolled = true;
            header.classList.add('scrolled');
            console.log('🔄 Header scrolled state activated at:', scrollY + 'px');

            // Verify the class was added
            if (header.classList.contains('scrolled')) {
                console.log('✅ Scrolled class successfully added');
            } else {
                console.error('❌ Failed to add scrolled class');
            }
        } else if (scrollY <= threshold && isScrolled) {
            isScrolled = false;
            header.classList.remove('scrolled');
            console.log('🔄 Header scrolled state deactivated at:', scrollY + 'px');

            // Verify the class was removed
            if (!header.classList.contains('scrolled')) {
                console.log('✅ Scrolled class successfully removed');
            } else {
                console.error('❌ Failed to remove scrolled class');
            }
        }
    }

    function onScroll() {
        if (!ticking) {
            requestAnimationFrame(() => {
                updateHeaderBackground();
                ticking = false;
            });
            ticking = true;
        }
    }

    // Test function to verify header element exists
    function testHeaderElement() {
        const header = document.getElementById('header');
        console.log('🧪 Header element test:', {
            exists: !!header,
            classes: header ? Array.from(header.classList) : 'N/A',
            computedBackground: header ? getComputedStyle(header).backgroundColor : 'N/A'
        });
    }

    // Add the scroll event listener
    window.addEventListener('scroll', onScroll, { passive: true });

    // Initial check and test
    testHeaderElement();
    updateHeaderBackground();

    console.log('✅ Enhanced header scroll handler initialized with debugging');

    // Return test function for manual testing
    return { testHeaderElement, updateHeaderBackground };
}

// Initialize the header scroll handler
const headerScrollDebug = createHeaderScrollHandler();

// Make debug functions available globally for testing
window.headerScrollDebug = headerScrollDebug;

// Additional debugging: Log scroll events for the first 10 seconds
let debugScrollCount = 0;
const debugScrollLimit = 50; // Limit debug messages

