<!DOCTYPE html>
<html lang="fr">
<style>
    .advanced-carousel-container {
        position: relative;
        width: 100%;
        max-width: 1200px;
        overflow: visible;
        margin: 0 auto;
        background: #ffffff;
        padding: 40px 80px;
        border-radius: 12px;
    }

    .advanced-carousel-wrapper {
        overflow: hidden;
        width: 100%;
        position: relative;
    }

    .advanced-carousel {
        display: flex;
        gap: 20px;
        transition: transform 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        padding: 20px 0;
    }

    .advanced-carousel-card {
        border-radius: 12px;
        width: 350px;
        height: 250px;
        position: relative;
        overflow: hidden;
        cursor: pointer;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        flex-shrink: 0;
        background: #ffffff;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.04);
    }

    .advanced-carousel-card img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        position: relative;
        z-index: 2;
    }

    .advanced-carousel-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
    }

    .advanced-carousel-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(0, 0, 0, 0.05) 0%, rgba(0, 0, 0, 0.15) 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
        z-index: 1;
    }

    .advanced-carousel-card:hover::before {
        opacity: 1;
    }

    .advanced-carousel-card .link-icon {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 40px;
        height: 40px;
        background: rgba(255, 255, 255, 0.9);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        z-index: 10;
        opacity: 0;
        transform: translateY(-10px);
    }

    .advanced-carousel-card:hover .link-icon {
        opacity: 1;
        transform: translateY(0);
    }

    .advanced-carousel-card .link-icon:hover {
        background: white;
        transform: scale(1.1);
    }

    .advanced-carousel-card .link-icon svg {
        width: 20px;
        height: 20px;
        stroke: #333;
        stroke-width: 2;
    }

    /* Hover overlay styles */
    .carousel-hover-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 3;
        pointer-events: none;
    }

    .carousel-overlay-bg {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(0, 0, 0, 0.6) 0%, rgba(0, 0, 0, 0.4) 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .advanced-carousel-card:hover .carousel-overlay-bg {
        opacity: 1;
    }

    /* Content overlay styles */
    .carousel-content-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 24px;
        z-index: 4;
        transform: translateY(20px);
        opacity: 0;
        transition: all 0.3s ease;
    }

    .advanced-carousel-card:hover .carousel-content-overlay {
        transform: translateY(0);
        opacity: 1;
    }

    .carousel-title {
        font-size: 1.25rem;
        font-weight: 600;
        color: white;
        margin-bottom: 6px;
        line-height: 1.4;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    }

    .carousel-description {
        font-size: 0.875rem;
        color: rgba(255, 255, 255, 0.92);
        line-height: 1.5;
        margin: 0;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        font-weight: 400;
    }

    .advanced-nav-btn {
        border: none;
        color: #01acb6;
        width: 48px;
        height: 48px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        position: absolute;
        top: calc(50% - 20px);
        transform: translateY(-50%);
        z-index: 5;
        box-shadow: 0 4px 12px rgba(45, 55, 72, 0.3);
    }

    .advanced-nav-btn:hover:not(:disabled) {
        background: #ffffffff;
        color: #38d9a9;
        transform: translateY(-50%) scale(1.05);
        box-shadow: 0 6px 16px rgba(45, 55, 72, 0.4);
    }

    .advanced-nav-btn.prev {
        left: -20px;
    }

    .advanced-nav-btn.next {
        right: -20px;
    }

    .advanced-nav-btn:disabled {
        opacity: 0.4;
        cursor: not-allowed;
        background: #718096;
        color: #a0aec0;
    }

    .advanced-dots {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 8px;
        margin-top: 36px;
    }

    .advanced-dot {
        border-radius: 50%;
        background: #e5e7eb;
        cursor: pointer;
        transition: all 0.3s ease;
        width: 6px;
        height: 6px;
        border: 1px solid transparent;
    }

    .advanced-dot.center {
        width: 10px;
        height: 10px;
        background: #01acb6;
        border: 2px solid #01acb6;
        box-shadow: none;
    }

    .advanced-dot.adjacent {
        width: 8px;
        height: 8px;
        background: #d1d5db;
        border: 1px solid #d1d5db;
    }

    .advanced-dot.outer {
        width: 6px;
        height: 6px;
        background: #f3f4f6;
        border: 1px solid #e5e7eb;
    }

    .advanced-loading-placeholder {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, #f3f4f6 25%, #e5e7eb 50%, #f3f4f6 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #6b7280;
        font-size: 14px;
        font-weight: 500;
        z-index: 1;
    }

    @keyframes loading {
        0% {
            background-position: 200% 0;
        }

        100% {
            background-position: -200% 0;
        }
    }

    @media (max-width: 768px) {
        .advanced-carousel-container {
            padding: 24px 60px;
            overflow: hidden;
        }

        .advanced-carousel {
            gap: 15px;
            padding: 20px;
        }

        .advanced-carousel-card {
            width: 280px;
            height: 220px;
        }

        .advanced-nav-btn {
            width: 40px;
            height: 40px;
        }

        .advanced-nav-btn.prev {
            left: -20px;
        }

        .advanced-nav-btn.next {
            right: -20px;
        }

        .advanced-dots {
            gap: 6px;
            margin-top: 28px;
        }
    }

    @media (max-width: 480px) {
        .advanced-carousel-container {
            padding: 20px 16px;
            overflow: hidden;
        }

        .advanced-nav-btn.prev {
            left: 5px;
        }

        .advanced-nav-btn.next {
            right: 8px;
        }

        .advanced-carousel-card {
            width: 260px;
            height: 200px;
        }
    }
</style>
<link rel="stylesheet" href="styleMl.css">

<body class="bg-white">
    <main>
        <br>
        <!-- design section -->
        <section id="design-content"
            class="relative overflow-hidden">
            <!-- Background Effects -->
            <div class="absolute inset-0">
                <div class="absolute top-20 left-10 w-72 h-72 bg-[#01acb6]/5 rounded-full blur-xl opacity-30"></div>
                <div class="absolute bottom-20 right-10 w-96 h-96 bg-[#EF234B]/5 rounded-full blur-xl opacity-30"></div>
                <div
                    class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-purple-500/3 rounded-full blur-xl opacity-30">
                </div>
            </div>
            <div class="max-w-7xl mx-auto px-6 relative z-10">
                <!-- Section Header -->
                
                <?php if ($projects['success'] && !empty($projects['data']['items'])): ?>
                    <?php
                    $designProjects = array_filter($projects['data']['items'], function ($project) use ($type, $Currentproject) {
                        return $project['values'][5] == $type && $project['values'][0] != $Currentproject;
                    });
                    $designProjects = array_values($designProjects);

                    // Further filter to only include projects with valid images
                    $validDesignProjects = [];
                    foreach ($designProjects as $project) {
                        $projectImage = $project['values'][2] ?? null;
                        if (!empty($projectImage) && is_array($projectImage) && !empty($projectImage[0])) {
                            $validDesignProjects[] = $project;
                        }
                    }
                    ?>

                    <?php if (!empty($validDesignProjects)): ?>
                        <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-bold text-white mb-6">
                        <?php if ($type == 8): ?>
                            <span class="bg-[#01acb6] bg-clip-text text-transparent" id="design">Voir plus de design</span>
                        <?php else: ?>
                            <span class="bg-[#01acb6] bg-clip-text text-transparent" id="design">Voir plus de projects</span>
                        <?php endif; ?>
                    </h2>
                    <p class="text-xl max-w-3xl mx-auto leading-relaxed">
                        Découvrez notre expertise créative à travers une sélection de nos plus beaux designs.
                        Chaque création reflète notre passion pour l'innovation visuelle et l'excellence graphique.
                    </p>
                </div>
                        <div class="advanced-carousel-container relative mb-16">
                            <button class="advanced-nav-btn prev" id="prevBtn">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                </svg>
                            </button>

                            <div class="advanced-carousel-wrapper">
                                <div class="advanced-carousel" id="carousel">
                                    <?php foreach ($validDesignProjects as $index => $project): ?>
                                        <?php $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : ''; ?>
                                            <div class="advanced-carousel-card" data-link="<?php echo $baseUrl . $adminPath . 'portfolio.php/' . htmlspecialchars($project['slug']); ?>">
                                                <!-- Loading placeholder -->
                                                <div class="advanced-loading-placeholder">Loading...</div>

                                                <!-- Image element -->
                                                <img src="<?php echo htmlspecialchars($project['values'][2][0]); ?>"
                                                    alt="<?php echo htmlspecialchars($project['values'][0]); ?>"
                                                    loading="eager"
                                                    style="display: block;">

                                                <!-- Hover overlay with dark background -->
                                                <div class="carousel-hover-overlay">
                                                    <div class="carousel-overlay-bg"></div>
                                                </div>

                                                <!-- Content overlay -->
                                                <div class="carousel-content-overlay">
                                                    <h3 class="carousel-title">
                                                        <?php echo htmlspecialchars($project['values'][0]); ?>
                                                    </h3>
                                                    <p class="carousel-description">
                                                        <?php echo htmlspecialchars(truncateText(stripHTMLTags($project['values'][1]), 120)); ?>
                                                    </p>
                                                </div>

                                                <!-- Link icon -->
                                                <div class="link-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-right-icon lucide-arrow-up-right">
                                                        <path d="M7 7h10v10" />
                                                        <path d="M7 17 17 7" />
                                                    </svg>
                                                </div>
                                            </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <button class="advanced-nav-btn next" id="nextBtn">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </button>

                            <div class="advanced-dots" id="dotsContainer">
                                <!-- Dots will be generated dynamically by JavaScript -->
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div id="imagePopup" class="fixed inset-0 z-50 hidden items-center justify-center p-4">
                <!-- Blurred + dark background -->
                <div class="absolute inset-0 bg-black/60 backdrop-blur-md"></div>

                <div class="relative max-w-4xl max-h-full z-10">
                    <!-- Close button -->
                    <button onclick="closePopup()" class="absolute -top-12 right-0 text-white hover:text-gray-300 transition-colors duration-200">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>

                </div>
            </div>

            </div>
        </section>

    </main>
    <script src="js/projects.js"></script>
    <script>
        class AdvancedCarousel {
            constructor() {
                console.log('AdvancedCarousel constructor called');

                this.carousel = document.getElementById('carousel');
                this.dotsContainer = document.getElementById('dotsContainer');
                this.prevBtn = document.getElementById('prevBtn');
                this.nextBtn = document.getElementById('nextBtn');

                console.log('Carousel elements found:', {
                    carousel: !!this.carousel,
                    dotsContainer: !!this.dotsContainer,
                    prevBtn: !!this.prevBtn,
                    nextBtn: !!this.nextBtn
                });

                if (!this.carousel) {
                    console.log('No carousel found, exiting');
                    return; // Exit if carousel doesn't exist on this page
                }

                this.currentIndex = 0;
                this.cardWidth = 370; // 350px width + 20px gap
                this.visibleDotsCount = 5;
                this.dotsStartIndex = 0;

                console.log('Initializing carousel...');
                this.init();
            }

            init() {
                this.cards = Array.from(this.carousel.children);
                this.totalSlides = this.cards.length;

                if (this.totalSlides === 0) return;

                this.setupImages();
                this.generateDots();
                this.updateCarousel();
                this.attachEventListeners();
                this.updateNavigationButtons();
                this.startAutoPlay();
            }

            setupImages() {
                console.log('Setting up images for', this.cards.length, 'cards');

                this.cards.forEach((card, index) => {
                    const placeholder = card.querySelector('.advanced-loading-placeholder');
                    const img = card.querySelector('img');

                    if (img && placeholder) {
                        console.log('Setting up image for card', index, 'with src:', img.src);

                        // Check if image is already loaded (for cached images)
                        if (img.complete && img.naturalHeight !== 0) {
                            console.log('Image already loaded for card', index);
                            placeholder.style.display = 'none';
                            return;
                        }

                        // Show image when loaded, hide placeholder
                        img.onload = () => {
                            console.log('Image loaded successfully for card', index);
                            if (placeholder) {
                                placeholder.style.display = 'none';
                            }
                        };

                        // Handle image load error
                        img.onerror = () => {
                            console.error('Image failed to load for card', index, 'src:', img.src);
                            if (placeholder) {
                                placeholder.textContent = 'Failed to load';
                                placeholder.style.background = 'linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%)';
                            }
                        };

                        // For already loaded images (immediate check)
                        setTimeout(() => {
                            if (img.complete && img.naturalHeight !== 0) {
                                console.log('Image was already loaded (delayed check) for card', index);
                                if (placeholder) {
                                    placeholder.style.display = 'none';
                                }
                            }
                        }, 100);
                    } else {
                        console.warn('Missing image or placeholder for card', index);
                    }
                });
            }

            generateDots() {
                if (!this.dotsContainer) return;

                this.dotsContainer.innerHTML = '';

                for (let i = 0; i < this.totalSlides; i++) {
                    const dot = document.createElement('div');
                    dot.className = 'advanced-dot';
                    dot.dataset.index = i;
                    dot.addEventListener('click', () => this.goToSlide(i));
                    this.dotsContainer.appendChild(dot);
                }

                this.dots = Array.from(this.dotsContainer.children);
                this.updateDotsVisibility();
            }

            updateDotsVisibility() {
                if (!this.dots) return;

                // Hide all dots first
                this.dots.forEach(dot => {
                    dot.style.display = 'none';
                    dot.classList.remove('center', 'adjacent', 'outer');
                });

                // Calculate the range of dots to show
                let start = Math.max(0, this.currentIndex - 2);
                let end = Math.min(this.totalSlides - 1, start + 4);

                // Adjust if we're near the end
                if (end - start < 4 && this.totalSlides >= 5) {
                    start = Math.max(0, end - 4);
                }

                // Show and style the visible dots
                for (let i = start; i <= end; i++) {
                    const dot = this.dots[i];
                    if (dot) {
                        dot.style.display = 'block';

                        const relativePos = i - start;
                        const centerPos = Math.floor((end - start) / 2);

                        if (i === this.currentIndex) {
                            dot.classList.add('center');
                        } else if (Math.abs(relativePos - centerPos) === 1) {
                            dot.classList.add('adjacent');
                        } else {
                            dot.classList.add('outer');
                        }
                    }
                }
            }

            updateCarousel() {
                if (!this.carousel) return;

                const translateX = -this.currentIndex * this.cardWidth;
                this.carousel.style.transform = `translateX(${translateX}px)`;
                this.updateDotsVisibility();
            }

            updateNavigationButtons() {
                if (this.prevBtn) this.prevBtn.disabled = this.currentIndex === 0;
                if (this.nextBtn) this.nextBtn.disabled = this.currentIndex === this.totalSlides - 1;
            }

            goToSlide(index) {
                if (index >= 0 && index < this.totalSlides) {
                    this.currentIndex = index;
                    this.updateCarousel();
                    this.updateNavigationButtons();
                }
            }

            nextSlide() {
                if (this.currentIndex < this.totalSlides - 1) {
                    this.goToSlide(this.currentIndex + 1);
                }
            }

            prevSlide() {
                if (this.currentIndex > 0) {
                    this.goToSlide(this.currentIndex - 1);
                }
            }

            startAutoPlay() {
                this.stopAutoPlay(); // Clear any existing interval
                this.autoPlayInterval = setInterval(() => {
                    if (this.currentIndex >= this.totalSlides - 1) {
                        // Reset to first slide when reaching the end
                        this.goToSlide(0);
                    } else {
                        this.nextSlide();
                    }
                }, 4000); // Move every 1 second
            }

            stopAutoPlay() {
                if (this.autoPlayInterval) {
                    clearInterval(this.autoPlayInterval);
                    this.autoPlayInterval = null;
                }
            }

            attachEventListeners() {
                if (this.prevBtn) {
                    this.prevBtn.addEventListener('click', () => {
                        this.stopAutoPlay();
                        this.prevSlide();
                        this.startAutoPlay();
                    });
                }
                if (this.nextBtn) {
                    this.nextBtn.addEventListener('click', () => {
                        this.stopAutoPlay();
                        this.nextSlide();
                        this.startAutoPlay();
                    });
                }

                // Pause auto-play on hover
                if (this.carousel.parentElement) {
                    this.carousel.parentElement.addEventListener('mouseenter', () => {
                        this.stopAutoPlay();
                    });
                    this.carousel.parentElement.addEventListener('mouseleave', () => {
                        this.startAutoPlay();
                    });
                }

                // Card click events
                this.cards.forEach((card, index) => {
                    card.addEventListener('click', (e) => {
                        // If clicked directly on the card (not the link icon)
                        if (!e.target.closest('.link-icon')) {
                            const link = card.dataset.link;
                            if (link) {
                                window.location.href = link;
                            }
                        }
                    });

                    // Link icon click events
                    const linkIcon = card.querySelector('.link-icon');
                    if (linkIcon) {
                        linkIcon.addEventListener('click', (e) => {
                            e.stopPropagation(); // Prevent card click
                            const link = card.dataset.link;
                            if (link) {
                                window.open(link, '_blank');
                            }
                        });
                    }
                });

                // Keyboard navigation
                document.addEventListener('keydown', (e) => {
                    if (e.key === 'ArrowLeft') {
                        this.stopAutoPlay();
                        this.prevSlide();
                        this.startAutoPlay();
                    } else if (e.key === 'ArrowRight') {
                        this.stopAutoPlay();
                        this.nextSlide();
                        this.startAutoPlay();
                    }
                });

                // Touch/swipe support for mobile
                let startX = 0;
                let isDragging = false;

                if (this.carousel) {
                    this.carousel.addEventListener('touchstart', (e) => {
                        startX = e.touches[0].clientX;
                        isDragging = true;
                        this.stopAutoPlay();
                    });

                    this.carousel.addEventListener('touchmove', (e) => {
                        if (!isDragging) return;
                        e.preventDefault();
                    });

                    this.carousel.addEventListener('touchend', (e) => {
                        if (!isDragging) return;

                        const endX = e.changedTouches[0].clientX;
                        const diff = startX - endX;

                        if (Math.abs(diff) > 50) { // Minimum swipe distance
                            if (diff > 0) {
                                this.nextSlide();
                            } else {
                                this.prevSlide();
                            }
                        }

                        isDragging = false;
                        this.startAutoPlay();
                    });
                }
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            new AdvancedCarousel();
        });

        // Initialiser Lucide icons
        lucide.createIcons();

        // Fonction de filtrage améliorée
        const filterButtons = document.querySelectorAll('.filter-btn');
        const projectCards = document.querySelectorAll('.project-card');
        const projectsGrid = document.querySelector('.projects-grid');

        filterButtons.forEach(button => {
            button.addEventListener('click', () => {
                // Retirer la classe active de tous les boutons
                filterButtons.forEach(btn => {
                    btn.classList.remove('active-filter');
                    btn.classList.add('bg-white', 'text-slate-700', 'border-slate-200');
                    btn.classList.remove('bg-[#01acb6]', 'text-white', 'border-[#01acb6]');
                });

                // Ajouter la classe active au bouton cliqué
                button.classList.add('active-filter');
                button.classList.remove('bg-white', 'text-slate-700', 'border-slate-200');
                button.classList.add('bg-[#01acb6]', 'text-white', 'border-[#01acb6]');

                // Add click feedback animation
                button.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    button.style.transform = 'scale(1)';
                }, 100);

                // Effectuer le filtrage
                const category = button.getAttribute('data-filter');
                filterProjects(category);
            });
        });

        // Initialize smooth transitions
        projectCards.forEach(card => {
            card.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
        });

        if (projectsGrid) {
            projectsGrid.style.transition = 'opacity 0.3s ease';
        }

        // Filter buttons transition
        filterButtons.forEach(btn => {
            btn.style.transition = 'all 0.3s ease, transform 0.1s ease';
        });

    </script>

</body>

</html>
