<?php
include __DIR__ . '/../admin/config.php';

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];
    $basePath = dirname($script);
    return $protocol . $host . $basePath;
}

// Function to fetch ALL projects from the API
function fetchAllProjects($category_id = 4) {
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/admin' : 'admin';

    $allItems = [];
    $page = 1;
    $perPage = 50; // Fetch in batches of 50

    do {
        $url = "{$baseUrl}{$adminPath}/cms.php/Records?category_id={$category_id}&page={$page}&per_page={$perPage}";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            "X-API-TOKEN: {$GLOBALS['API_TOKEN']}"
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode !== 200) {
            break;
        }

        $data = json_decode($response, true);

        if (!$data || !isset($data['success']) || !$data['success']) {
            break;
        }

        $items = $data['data']['items'] ?? [];
        $allItems = array_merge($allItems, $items);

        // Check if we have more pages
        $pagination = $data['data']['pagination'] ?? [];
        $currentPage = $pagination['page'] ?? $page;
        $lastPage = $pagination['last_page'] ?? $page;

        if ($currentPage >= $lastPage) {
            break;
        }

        $page++;

    } while (true);

    return $allItems;
}

// Function to separate and paginate by type
function getPaginatedByType($type, $page = 1, $perPage = 8) {
    $allProjects = fetchAllProjects();

    // Filter by type (values[5])
    $filteredProjects = array_filter($allProjects, function($project) use ($type) {
        return isset($project['values'][5]) && $project['values'][5] == $type;
    });

    // Reset array keys
    $filteredProjects = array_values($filteredProjects);

    // Calculate pagination
    $total = count($filteredProjects);
    $totalPages = ceil($total / $perPage);
    $offset = ($page - 1) * $perPage;

    // Get current page items
    $items = array_slice($filteredProjects, $offset, $perPage);

    return [
        'success' => true,
        'data' => [
            'items' => $items,
            'pagination' => [
                'total' => $total,
                'current_page' => $page,
                'per_page' => $perPage,
                'total_pages' => $totalPages,
                'from' => $offset + 1,
                'to' => min($offset + $perPage, $total)
            ]
        ]
    ];
}

// Handle API request
header('Content-Type: application/json');

$type = $_GET['type'] ?? '11'; // Default to type 11 (web)
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$perPage = isset($_GET['per_page']) ? max(1, min(50, (int)$_GET['per_page'])) : 8;

$result = getPaginatedByType($type, $page, $perPage);

echo json_encode($result);
?>
