<?php

$projectTypes = [];
if (isset($projects['data']['items']) && !empty($projects['data']['items'])) {
    foreach ($projects['data']['items'] as $project) {
        // Include both Design Projects (ID 8) and Web Projects (ID 11)
        if ($project['values'][5] == 8 || $project['values'][5] == 11) {
            $type = $project['values'][8] ?? 'Portfolio';
            $type = trim($type);
            if (!empty($type) && !in_array($type, $projectTypes)) {
                $projectTypes[] = $type;
            }
        }
    }
}

$baseUrl = getBaseUrl();

function stripHTMLTags($html)
{
    $text = strip_tags($html);
    $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');

    $text = preg_replace('/\s+/', ' ', $text);

    return trim($text);
}
?>