<?php include "backend/blog.php" ?>
<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($articleTitle); ?> | MaxMind Blog</title>
    <meta name="description" content="<?php echo htmlspecialchars($metaDescription); ?>">
    <meta name="keywords" content="SEO Maroc, référencement Maroc, SEO technique, contenu multilingue, Arabe Français, marketing digital Maroc">

    <!-- Enhanced SEO Meta Tags -->
    <link rel="canonical" href="<?php echo htmlspecialchars(getBaseUrl() . '/blog.php' . $_SERVER['PATH_INFO']); ?>">
    <meta name="language" content="French">
    <meta name="geo.region" content="MA">
    <meta name="geo.placename" content="Casablanca">
    <meta name="geo.position" content="33.5731;-7.5898">
    <meta name="ICBM" content="33.5731, -7.5898">
    <meta name="rating" content="General">
    <meta name="distribution" content="Global">
    <meta name="revisit-after" content="7 days">
    <meta name="article:author" content="MaxMind">
    <meta name="article:publisher" content="MaxMind">
    <link rel="stylesheet" href="css/index.css">
    <!-- Open Graph Enhanced -->
    <meta property="og:title" content="<?php echo htmlspecialchars($articleTitle); ?> | MaxMind Blog">
    <meta property="og:description" content="<?php echo htmlspecialchars($metaDescription); ?>">
    <meta property="og:type" content="article">
    <meta property="og:url" content="<?php echo htmlspecialchars(getBaseUrl() . '/blog.php' . $_SERVER['PATH_INFO']); ?>">
    <meta property="og:site_name" content="MaxMind Blog">
    <meta property="og:locale" content="fr_MA">
    <?php if (isset($article['values'][3])): ?>
    <meta property="og:image" content="<?php echo htmlspecialchars(is_array($article['values'][3]) ? $article['values'][3][0] : $article['values'][3]); ?>">
    <meta property="og:image:type" content="image/jpeg">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="<?php echo htmlspecialchars($articleTitle); ?>">
    <?php endif; ?>
    <meta property="article:published_time" content="<?php echo htmlspecialchars($article['created_at'] ?? date('c')); ?>">
    <meta property="article:modified_time" content="<?php echo htmlspecialchars($article['updated_at'] ?? $article['created_at'] ?? date('c')); ?>">
    <meta property="article:author" content="MaxMind">
    <meta property="article:section" content="SEO & Référencement">

    <!-- Twitter Card Enhanced -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($articleTitle); ?>">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($metaDescription); ?>">
    <meta name="twitter:site" content="@MaxMindMA">
    <meta name="twitter:creator" content="@MaxMindMA">
    <?php if (isset($article['values'][3])): ?>
    <meta name="twitter:image" content="<?php echo htmlspecialchars(is_array($article['values'][3]) ? $article['values'][3][0] : $article['values'][3]); ?>">
    <meta name="twitter:image:alt" content="<?php echo htmlspecialchars($articleTitle); ?>">
    <?php endif; ?>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- GSAP + ScrollTrigger -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <!-- Enhanced Structured Data for Article -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "BlogPosting",
        "headline": "<?php echo htmlspecialchars($articleTitle); ?>",
        "description": "<?php echo htmlspecialchars($metaDescription); ?>",
        "url": "<?php echo htmlspecialchars(getBaseUrl() . '/blog.php' . $_SERVER['PATH_INFO']); ?>",
        "datePublished": "<?php echo htmlspecialchars($article['created_at'] ?? date('c')); ?>",
        "dateModified": "<?php echo htmlspecialchars($article['updated_at'] ?? $article['created_at'] ?? date('c')); ?>",
        "author": {
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>",
            "logo": {
                "@type": "ImageObject",
                "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>/imgs/LOGO_MAXMIND_BLACK.png"
            }
        },
        "publisher": {
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>",
            "logo": {
                "@type": "ImageObject",
                "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>/imgs/LOGO_MAXMIND_BLACK.png",
                "width": 300,
                "height": 300
            }
        },
        "mainEntityOfPage": {
            "@type": "WebPage",
            "@id": "<?php echo htmlspecialchars(getBaseUrl() . '/blog.php' . $_SERVER['PATH_INFO']); ?>"
        },
        "inLanguage": "fr-MA",
        "articleSection": "SEO & Référencement",
        "keywords": "SEO Maroc, référencement Maroc, SEO technique, contenu multilingue, marketing digital Maroc",
        "wordCount": "<?php echo str_word_count(strip_tags($articleContent ?? '')); ?>",
        "timeRequired": "PT12M",
        "isAccessibleForFree": true,
        <?php if (isset($article['values'][3])): ?>
        "image": {
            "@type": "ImageObject",
            "url": "<?php echo htmlspecialchars(is_array($article['values'][3]) ? $article['values'][3][0] : $article['values'][3]); ?>",
            "width": 1200,
            "height": 630,
            "caption": "<?php echo htmlspecialchars($articleTitle); ?>"
        },
        <?php endif; ?>
        "about": {
            "@type": "Thing",
            "name": "SEO et Référencement au Maroc",
            "description": "Techniques et stratégies SEO adaptées au marché marocain"
        },
        "mentions": [{
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars(getBaseUrl()); ?>"
        }]
    }
    </script>

    <!-- BreadcrumbList Schema -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "BreadcrumbList",
        "itemListElement": [{
            "@type": "ListItem",
            "position": 1,
            "name": "Accueil",
            "item": "<?php echo htmlspecialchars(getBaseUrl()); ?>"
        }, {
            "@type": "ListItem",
            "position": 2,
            "name": "Blog",
            "item": "<?php echo htmlspecialchars(getBaseUrl()); ?>/blogs.php"
        }, {
            "@type": "ListItem",
            "position": 3,
            "name": "<?php echo htmlspecialchars($articleTitle); ?>",
            "item": "<?php echo htmlspecialchars(getBaseUrl() . '/blog.php' . $_SERVER['PATH_INFO']); ?>"
        }]
    }
    </script>

    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">



    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Roboto', 'system-ui', '-apple-system', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'gradient-shift': 'gradient-shift 8s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'gradient-shift': {
                            '0%, 100%': {
                                backgroundPosition: '0% 50%'
                            },
                            '50%': {
                                backgroundPosition: '100% 50%'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>

</head>

<body class="bg-white text-slate-800" style="margin: 0; padding: 0; width: 100%; height: 100%;">
    <?php include 'social-floating.php'; ?>
    <?php include 'header.php'; ?>

    <section class="hero-section flex items-center justify-center overflow-hidden bg-[#000]">
        <!-- Animated background elements with brand colors -->
        <div class="absolute inset-0 w-full h-full opacity-20" style="z-index: 5;">
            <div class="absolute inset-0 bg-gradient-to-r from-[#01acb6]/10 via-transparent to-[#EF234B]/10 animate-pulse"></div>
            <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-gradient-to-r from-[#01acb6] to-[#01acb6]/60 rounded-full mix-blend-multiply filter blur-3xl animate-float"
                style="animation-delay: 0s;"></div>
            <div class="absolute top-1/3 right-1/4 w-80 h-80 bg-gradient-to-r from-[#EF234B] to-[#EF234B]/60 rounded-full mix-blend-multiply filter blur-3xl animate-float"
                style="animation-delay: 2s;"></div>
        </div>

        <!-- Subtle overlay -->
        <!-- <div class="absolute inset-0 w-full h-full bg-gradient-to-b from-transparent via-black/10 to-black/30" style="z-index: 6;"></div> -->

        <div class="relative mt-[300px] text-center text-white px-6 max-w-5xl" style="z-index: 10;">
            <!-- Category Badge -->
            <div class="mb-6">
                <span class="px-4 py-2 rounded-full bg-[#01acb6] text-white font-semibold text-sm">SEO & Référencement</span>
            </div>

            <!-- Article Title -->
            <h1 class="text-3xl md:text-5xl font-black mb-6 leading-tight">
                <?php
                $titleWords = explode(' ', $articleTitle);
                $lastWords = array_slice($titleWords, -2); // Get last 2 words
                $firstWords = array_slice($titleWords, 0, -2); // Get all but last 2 words

                if (count($firstWords) > 0) {
                    echo htmlspecialchars(implode(' ', $firstWords)) . ' ';
                }
                ?>
                <span class="bg-[#01acb6] bg-clip-text text-transparent">
                    <?php echo htmlspecialchars(implode(' ', $lastWords)); ?>
                </span>
            </h1>

            <!-- Meta Information -->
            <div class="meta-info flex flex-wrap items-center justify-center gap-4 md:gap-6 mb-8 text-sm text-slate-300">
                <!-- <div class="flex items-center gap-2">
                    <img src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=32&h=32&fit=crop&crop=face"
                        alt="Author" class="w-8 h-8 rounded-full">
                    <span>Par <span class="text-white font-semibold">Ahmed Bennani</span></span>
                </div> -->
                <div class="flex items-center gap-2">
                    <i data-lucide="calendar" class="w-4 h-4 text-[#01acb6]"></i>
                    <span><?php echo $formattedDate; ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <i data-lucide="clock" class="w-4 h-4 text-[#01acb6]"></i>
                    <span class="hidden sm:inline">12 min de lecture</span>
                    <span class="sm:hidden">12 min</span>
                </div>
                
            </div>

            <!-- Social Share -->
            <div class="social-share flex flex-col sm:flex-row justify-center gap-3 sm:gap-4 mb-8">
                <button class="flex items-center justify-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md border border-white/20 rounded-lg hover:bg-white/20 transition-all">
                    <i data-lucide="share-2" class="w-4 h-4"></i>
                    <span class="hidden sm:inline">Partager</span>
                    <span class="sm:hidden">Partager</span>
                </button>
                <button class="flex items-center justify-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md border border-white/20 rounded-lg hover:bg-white/20 transition-all">
                    <i data-lucide="bookmark" class="w-4 h-4"></i>
                    <span class="hidden sm:inline">Sauvegarder</span>
                    <span class="sm:hidden">Sauvegarder</span>
                </button>
            </div>
        </div>
    </section>

    <section class="py-16 bg-white">
        <div class="max-w-4xl mx-auto px-6">
            <!-- Featured Image/Gallery -->
            <div class="mb-12">
                <?php
                $images = isset($article['values'][3]) ? $article['values'][3] : [];
                if (!is_array($images)) {
                    $images = [$images];
                }

                if (count($images) > 1): ?>
                    <!-- Image Gallery -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <?php foreach ($images as $index => $image): ?>
                            <div class="<?php echo $index === 0 ? 'md:col-span-2' : ''; ?>">
                                <img src="<?php echo htmlspecialchars($image); ?>"
                                    alt="<?php echo htmlspecialchars($articleTitle); ?> - Image <?php echo $index + 1; ?>"
                                    class="w-full <?php echo $index === 0 ? 'aspect-video' : 'aspect-square'; ?> object-cover rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 cursor-pointer"
                                    onclick="openImageModal(this.src)">
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <!-- Single Featured Image -->
                    <img src="<?php echo htmlspecialchars($articleImage); ?>"
                        alt="<?php echo htmlspecialchars($articleTitle); ?>"
                        class="w-full aspect-video object-cover rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 cursor-pointer"
                        onclick="openImageModal(this.src)">
                <?php endif; ?>
            </div>

            <!-- Image Modal -->
            <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-75 z-50 hidden flex items-center justify-center p-4" onclick="closeImageModal()">
                <div class="modal-content max-w-4xl max-h-full">
                    <img id="modalImage" src="" alt="" class="modal-image w-full h-auto rounded-lg">
                    <button onclick="closeImageModal()" class="absolute top-4 right-4 text-white hover:text-gray-300 text-2xl">&times;</button>
                </div>
            </div>

            <!-- Blog Content -->
            <div class="blog-content">
                <?php if (!empty($articleContent)): ?>
                    <section id="introduction">
                        <h2><?php echo htmlspecialchars($articleTitle); ?></h2>
                        <div>
                            <?php
                            // Use content field if available, otherwise fall back to description
                            $contentToDisplay = $articleContent;

                            // Display HTML content directly if it contains HTML tags
                            if (strpos($contentToDisplay, '<') !== false && strpos($contentToDisplay, '>') !== false) {
                                // Content appears to be HTML, display it directly
                                echo $contentToDisplay;
                            } else {
                                // Convert line breaks to paragraphs for plain text
                                $content = nl2br(htmlspecialchars($contentToDisplay));
                                // If content is too short, add some default structure
                                if (strlen($contentToDisplay) < 200) {
                                    echo '<p>' . $content . '</p>';
                                    echo '<p>Cet article explore en détail ce sujet important et fournit des insights pratiques pour votre stratégie digitale.</p>';
                                } else {
                                    // Split content into paragraphs for better readability
                                    $paragraphs = explode("\n\n", $contentToDisplay);
                                    foreach ($paragraphs as $paragraph) {
                                        if (trim($paragraph)) {
                                            echo '<p>' . nl2br(htmlspecialchars(trim($paragraph))) . '</p>';
                                        }
                                    }
                                }
                            }

                            ?>
                        </div>
                    </section>
                <?php else: ?>
                    <section id="introduction">
                        <h2>Introduction</h2>
                        <p>
                            Cet article vous présente des informations importantes et des stratégies pratiques pour optimiser votre présence digitale.
                        </p>

                        <p>
                            Découvrez les meilleures pratiques et techniques adaptées au marché marocain et aux tendances actuelles du digital.
                        </p>

                        <blockquote>
                            "L'innovation digitale au Maroc ouvre de nouvelles opportunités pour les entreprises qui savent s'adapter aux besoins locaux." - Expert Digital MaxMind
                        </blockquote>
                    </section>
                <?php endif; ?>

            </div>
        </div>
    </section>

    <section class="py-16 bg-slate-50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-bold mb-4">Autres Articles du Blog</h2>
                <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                    Découvrez d'autres articles qui pourraient vous intéresser sur le marketing digital et le développement web.
                </p>
            </div>

            <?php if (!empty($otherArticles)): ?>
                <div class="other-articles-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <?php foreach ($otherArticles as $otherArticle):
                        $categoryInfo = getCategoryInfoForOtherArticles($otherArticle['values'][0]);
                        $formattedDate = formatDateForOtherArticles($otherArticle['created_at']);
                        $description = is_array($otherArticle['values'][1]) ? implode(' ', $otherArticle['values'][1]) : $otherArticle['values'][1];
                        $excerpt = generateExcerptForOtherArticles($description);
                        $slug = $otherArticle['slug'];
                        $otherArticleImage = is_array($otherArticle['values'][3]) ? $otherArticle['values'][3][0] : $otherArticle['values'][3];
                        $views = rand(50, 300);
                    ?>
                        <article class="article-card group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-xl transition-all duration-300 hover:transform hover:-translate-y-2">
                            <div class="relative overflow-hidden bg-slate-200">
                                <img src="<?php echo htmlspecialchars($otherArticleImage); ?>"
                                    alt="<?php echo htmlspecialchars($otherArticle['values'][0]); ?>"
                                    loading="lazy"
                                    class="w-full aspect-[4/3] object-cover group-hover:scale-110 transition-transform duration-500"
                                    onload="this.style.opacity=1"
                                    style="opacity:0;transition:opacity 0.3s ease-in-out">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                <div class="absolute top-4 left-4">
                                    <span class="px-3 py-1 text-xs rounded-full <?php echo $categoryInfo['color']; ?> text-white font-semibold">
                                        <?php echo htmlspecialchars($categoryInfo['name']); ?>
                                    </span>
                                </div>
                            </div>

                            <div class="p-6">
                                <h3 class="text-lg font-bold mb-3 line-clamp-2 group-hover:text-[#01acb6] transition-colors">
                                    <a href="blog.php/<?php echo htmlspecialchars($slug); ?>" class="hover:text-[#01acb6]">
                                        <?php echo htmlspecialchars($otherArticle['values'][0]); ?>
                                    </a>
                                </h3>

                                <p class="text-sm text-slate-600 mb-4 line-clamp-3">
                                    <?php echo htmlspecialchars($excerpt); ?>
                                </p>

                                <!-- Tags Section -->
                                <?php if (isset($otherArticle['values'][4]) && !empty($otherArticle['values'][4])):
                                    $tags = is_array($otherArticle['values'][4]) ? $otherArticle['values'][4] : explode(',', $otherArticle['values'][4]);
                                ?>
                                    <div class="mb-4 flex flex-wrap gap-1">
                                        <?php foreach (array_slice($tags, 0, 2) as $tag):
                                            $tag = trim($tag);
                                            if (!empty($tag)):
                                        ?>
                                                <a href="blogs.php?tag=<?php echo urlencode($tag); ?>"
                                                    class="tag-button px-2 py-1 text-xs rounded-full bg-slate-100 text-slate-600 hover:bg-gradient-to-r hover:from-[#01acb6] hover:to-[#EF234B] hover:text-white transition-all duration-200">
                                                    #<?php echo htmlspecialchars($tag); ?>
                                                </a>
                                        <?php endif;
                                        endforeach; ?>
                                        <?php if (count($tags) > 2): ?>
                                            <span class="text-xs text-slate-400">+<?php echo count($tags) - 2; ?></span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>

                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-3 text-xs text-slate-500">
                                        <span class="flex items-center gap-1">
                                            <i data-lucide="calendar" class="w-3 h-3"></i>
                                            <?php echo $formattedDate; ?>
                                        </span>
                                    </div>
                                    <a href="/blog.php/<?php echo htmlspecialchars($slug); ?>"
                                        class="px-4 py-2 text-sm rounded-lg bg-[#01acb6] text-white hover:scale-105 transition-transform">
                                        Lire Plus
                                    </a>
                                </div>
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div>

                <!-- View All Button -->
                <!-- <div class="text-center mt-12">
                    <a href="blogs.php"
                        class="inline-flex items-center gap-3 px-8 py-4 bg-[#01acb6] text-white rounded-xl font-semibold hover:scale-105 transition-all duration-300 shadow-lg hover:shadow-xl">
                        <i data-lucide="grid" class="w-5 h-5"></i>
                        Voir Tous les Articles
                        <i data-lucide="arrow-right" class="w-5 h-5"></i>
                    </a>
                </div> -->
            <?php else: ?>
                <div class="text-center py-12">
                    <div class="text-slate-400 mb-4">
                        <i data-lucide="file-text" class="w-16 h-16 mx-auto mb-4"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-slate-600 mb-2">Aucun autre article disponible</h3>
                    <p class="text-slate-500">Découvrez d'autres contenus sur notre blog principal.</p>
                    <a href="blogs.php" class="mt-4 inline-block px-6 py-2 bg-gradient-to-r from-[#01acb6] to-[#EF234B] text-white rounded-lg hover:scale-105 transition-transform">
                        Aller au Blog
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php include 'footer.php'; ?>
</body>

</html>
