
<!DOCTYPE html>
<html lang="fr">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MaxMind - Innovation Technology | Solutions Digitales Maroc</title>
    <meta name="description" content="MaxMind, votre partenaire technologique au Maroc. Développement web, applications mobile, e-commerce et design UI/UX. Solutions digitales innovantes à Casablanca.">
    <meta name="keywords" content="développement web Maroc, application mobile Casablanca, e-commerce Maroc, design UI/UX, MaxMind technology">
    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">

    <meta property="og:title" content="MaxMind - Innovation Technology">
    <meta property="og:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo htmlspecialchars($baseUrl); ?>">
    <meta property="og:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta property="og:locale" content="fr_MA">
    <meta property="og:site_name" content="MaxMind">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="MaxMind - Innovation Technology">
    <meta name="twitter:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta name="twitter:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta name="twitter:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta name="twitter:site" content="@MaxMindMA">
    <meta name="twitter:creator" content="@MaxMindMA">

    <!-- Additional SEO -->
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="author" content="MaxMind">
    <meta name="publisher" content="MaxMind">
    <meta name="language" content="French">
    <meta name="theme-color" content="#01acb6">
    <meta name="msapplication-TileColor" content="#01acb6">

    <?php if ($heroData): ?>
        <meta name="hero:title" content="<?php echo htmlspecialchars($heroData['title'] ?? ''); ?>">
        <meta name="hero:subtitle" content="<?php echo htmlspecialchars($heroData['sous_titre'] ?? ''); ?>">
        <?php if (isset($heroData['images']) && is_array($heroData['images'])): ?>
            <meta name="hero:image_count" content="<?php echo count($heroData['images']); ?>">
            <?php foreach ($heroData['images'] as $index => $image): ?>
                <meta name="hero:image_<?php echo $index + 1; ?>" content="<?php echo htmlspecialchars($image); ?>">
            <?php endforeach; ?>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Blog/Projects Meta Data -->
    <?php if ($projects && isset($projects['data']['items'])): ?>
        <meta name="homepage:total_projects" content="<?php echo count($projects['data']['items']); ?>">
        <meta name="homepage:projects_displayed" content="<?php echo min(8, count($projects['data']['items'])); ?>">
        <?php if (isset($projects['data']['pagination']['total'])): ?>
            <meta name="homepage:total_available_projects" content="<?php echo $projects['data']['pagination']['total']; ?>">
        <?php endif; ?>

        <?php
        $project_categories = [];
        $project_tags = [];
        foreach ($projects['data']['items'] as $project) {
            if (isset($project['values']['category']) && !in_array($project['values']['category'], $project_categories)) {
                $project_categories[] = $project['values']['category'];
            }
            if (isset($project['values']['tags'])) {
                $tags = is_array($project['values']['tags']) ? $project['values']['tags'] : explode(',', $project['values']['tags']);
                foreach ($tags as $tag) {
                    $tag = trim($tag);
                    if (!empty($tag) && !in_array($tag, $project_tags)) {
                        $project_tags[] = $tag;
                    }
                }
            }
        }
        ?>
        <?php if (!empty($project_categories)): ?>
            <meta name="homepage:project_categories" content="<?php echo htmlspecialchars(implode(', ', $project_categories)); ?>">
            <meta name="homepage:category_count" content="<?php echo count($project_categories); ?>">
        <?php endif; ?>

        <?php if (!empty($project_tags)): ?>
            <meta name="homepage:project_tags" content="<?php echo htmlspecialchars(implode(', ', array_slice($project_tags, 0, 10))); ?>">
            <meta name="homepage:tag_count" content="<?php echo count($project_tags); ?>">
        <?php endif; ?>
    <?php endif; ?>

    <!-- Preload critical resources -->
    <link rel="preload" href="./imgs/LOGO_MAXMIND_WHITE.png" as="image" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- GSAP -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', '-apple-system', 'sans-serif'],
                        display: ['Space Grotesk', 'Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>

</head>
<style>
        html {
            scroll-behavior: smooth;
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
        }

        body {
            font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            line-height: 1.6;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            margin: 0;
            padding: 0;
            width: 100%;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Appliquer Roboto à tous les éléments */
        * {
            font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        }

        /* Classes utilitaires pour Roboto */
        .font-roboto-thin {
            font-family: 'Roboto', sans-serif;
            font-weight: 100;
        }

        .font-roboto-light {
            font-family: 'Roboto', sans-serif;
            font-weight: 300;
        }

        .font-roboto-regular {
            font-family: 'Roboto', sans-serif;
            font-weight: 400;
        }

        .font-roboto-medium {
            font-family: 'Roboto', sans-serif;
            font-weight: 500;
        }

        .font-roboto-bold {
            font-family: 'Roboto', sans-serif;
            font-weight: 700;
        }

        .font-roboto-black {
            font-family: 'Roboto', sans-serif;
            font-weight: 900;
        }

        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }

        ::-webkit-scrollbar-thumb {
            background: #01acb6;
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #01acb6;
        }

        /* Hero section full screen - Fixed positioning */
        .hero-section {
            position: relative !important;
            width: 100% !important;
            height: 100vh !important;
            height: 100dvh !important;
            z-index: 1 !important;
            margin: 0 !important;
            padding: 0 !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            overflow: hidden;
        }

        /* Centrage parfait du contenu principal */
        .hero-content-wrapper {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 100%;
            min-height: 80vh;
            text-align: center;
            z-index: 10;
        }

        /* Media Queries - Mobile First Approach */

        /* Tablettes et petits écrans (768px et moins) */
        @media (max-width: 768px) {

            /* Prevent horizontal scroll on mobile */
            body {
                overflow-x: hidden !important;
            }

            /* Header responsive */
            #header {
                padding: 0.5rem 0 !important;
            }

            #header .max-w-7xl {
                padding: 0 1rem !important;
            }

            /* Hero section mobile */
            .hero-section {
                min-height: 100vh !important;
                height: 100vh !important;
                padding: 0 !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
            }

            .hero-section .absolute {
                position: absolute !important;
                left: 0 !important;
                right: 0 !important;
                width: 100% !important;
                height: 100% !important;
            }

            .hero-section .relative {
                position: relative !important;
                z-index: 10 !important;
                padding: 1rem !important;
                width: 100% !important;
                max-width: 100% !important;
            }

            /* Centrage parfait du contenu */
            .hero-section .text-center {
                display: flex !important;
                flex-direction: column !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 80vh !important;
            }

            /* Titre responsive */
            .hero-title {
                font-size: 0.5rem !important;
                line-height: 1.1 !important;
                margin-bottom: 1.5rem !important;
            }

            .hero-subtitle {
                font-size: 1rem !important;
                margin-bottom: 2rem !important;
                padding: 0 1rem !important;
                line-height: 1.4 !important;
            }

            /* Boutons responsive */
            .hero-cta {
                flex-direction: column !important;
                gap: 1rem !important;
                width: 100% !important;
                max-width: 300px !important;
            }

            .hero-cta button {
                width: 100% !important;
                padding: 0.8rem 1rem !important;
                font-size: 0.9rem !important;
            }
        }

        /* Petits mobiles (480px et moins) */
        @media (max-width: 480px) {

            /* Header plus compact */
            #header .max-w-7xl {
                padding: 0 0.5rem !important;
            }

            /* Hero title plus petit */
            .hero-title {
                font-size: 2rem !important;
                line-height: 1.1 !important;
                margin-bottom: 1rem !important;
            }

            .hero-title .block:first-child {
                font-size: 1.8rem !important;
                margin-bottom: 0.5rem !important;
            }

            .hero-subtitle {
                font-size: 0.9rem !important;
                margin-bottom: 1.5rem !important;
                padding: 0 0.5rem !important;
            }

            /* Boutons plus compacts */
            .hero-cta button {
                padding: 0.7rem 1rem !important;
                font-size: 0.85rem !important;
            }

            /* Services badges responsive - Mobile specific */
            .services-badges-container {
                grid-template-columns: repeat(1, 1fr) !important;
                gap: 0.75rem !important;
            }

            .services-badges-container>div {
                min-height: 70px !important;
                padding: 0.75rem !important;
            }

            .services-badges-container .text-sm {
                font-size: 0.8rem !important;
            }

            .services-badges-container .text-xs {
                font-size: 0.7rem !important;
            }

            /* Éléments d'arrière-plan réduits */
            .hero-section .animate-float,
            .hero-section .w-96,
            .hero-section .w-80,
            .hero-section .w-72 {
                width: 150px !important;
                height: 150px !important;
                opacity: 0.3 !important;
            }

            /* Corrections spécifiques pour très petits écrans */
            .hero-cta button {
                min-height: 48px !important;
                /* Touch target minimum */
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
            }

            /* Correction espacement hero */
            .hero-section .text-center {
                min-height: calc(100vh - 120px) !important;
                padding: 0.5rem !important;
            }

            /* Prevent horizontal scroll */
            body {
                overflow-x: hidden !important;
            }

            /* Mobile menu positioning */
            #mobile-menu {
                position: relative !important;
                z-index: 60 !important;
            }

            /* Contact info card - extra small screens */
            .contact-info .bg-solid {
                padding: 0.75rem !important;
                /* Even smaller padding on very small screens */
                border-radius: 1rem !important;
                /* Smaller border radius */
            }

            .contact-info .flex.items-center {
                padding: 0.5rem !important;
                /* Minimal padding on contact items */
                flex-direction: column !important;
                /* Stack vertically on very small screens */
                text-align: center !important;
                gap: 0.5rem !important;
            }

            .contact-info .mr-4 {
                margin-right: 0 !important;
                /* Remove right margin when stacked */
                margin-bottom: 0.5rem !important;
                /* Add bottom margin instead */
            }

            .contact-info h3 {
                font-size: 1.125rem !important;
                /* Even smaller title */
                margin-bottom: 0.75rem !important;
            }

            /* Fix contact item text on very small screens */
            .contact-info .font-semibold {
                font-size: 0.875rem !important;
            }

            .contact-info .text-slate-600 {
                font-size: 0.8125rem !important;
                word-break: break-word !important;
                /* Prevent text overflow */
            }
        }

        /* Tablettes (769px - 1024px) */
        @media (min-width: 769px) and (max-width: 1024px) {
            .hero-section {
                min-height: 100vh !important;
                height: 100vh !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
            }

            .hero-title {
                font-size: 3.5rem !important;
                line-height: 1.1 !important;
            }

            .hero-subtitle {
                font-size: 1.1rem !important;
                max-width: 600px !important;
                margin: 0 auto 2rem auto !important;
            }

            .hero-cta {
                gap: 1.5rem !important;
                flex-direction: row !important;
            }

            .hero-cta button {
                padding: 0.8rem 1.5rem !important;
                font-size: 1rem !important;
            }

            /* Services badges for tablets */
            .services-badges-container {
                grid-template-columns: repeat(3, 1fr) !important;
            }

            .services-badges-container>div {
                min-height: 85px !important;
            }
        }

        /* Très petits écrans (320px et moins) */
        @media (max-width: 320px) {
            .hero-title {
                font-size: 1.8rem !important;
            }

            .hero-title .block:first-child {
                font-size: 1.6rem !important;
            }

            .hero-subtitle {
                font-size: 0.8rem !important;
                padding: 0 0.25rem !important;
            }

            .hero-section .px-6 {
                padding-left: 0.25rem !important;
                padding-right: 0.25rem !important;
            }

            .hero-cta button {
                padding: 0.6rem 0.8rem !important;
                font-size: 0.8rem !important;
            }
        }

        /* Ensure background covers full screen */
        .hero-section .absolute.inset-0 {
            width: 100vw !important;
            height: 100vh !important;
            height: 100dvh !important;
            left: 0 !important;
            top: 0 !important;
            right: 0 !important;
            bottom: 0 !important;
            position: absolute !important;
        }

        /* Reset any container constraints */
        .hero-section * {
            box-sizing: border-box;
        }

        /* Fix scroll behavior */
        html,
        body {
            scroll-behavior: smooth;
            overflow-x: hidden;
        }

        /* Header with smooth hide/show transitions */
        #header {
            z-index: 9999 !important;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            will-change: transform, background-color, backdrop-filter;
            backdrop-filter: blur(25px);
            background: #1b2638be;
            border-bottom: 1px solid #1b263862;
            box-shadow: 0 8px 32px #1b2638d8;
            position: fixed !important;
            top: 0;
            left: 0;
            right: 0;
        }

        /* Enhanced smooth transitions for all header elements */
        #header * {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Modern scrolled state with glassmorphism */
        #header.scrolled {
            background: rgba(0, 0, 0, 0.9) !important;
            backdrop-filter: blur(30px) !important;
            border-bottom: 1px solid rgba(1, 172, 182, 0.3);
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5),
                0 0 0 1px rgba(1, 172, 182, 0.2) !important;
        }

        /* Enhanced navigation links with advanced animations */
        .nav-link {
            position: relative;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.75rem;
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
            overflow: hidden;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            z top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(1, 172, 182, 0.12);
            transform: scale(0) rotate(45deg);
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
            border-radius: 0.75rem;
            z-index: -1;
        }

        .nav-link::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(1, 172, 182, 0.3);
            transform: translate(-50%, -50%);
            transition: all 0.6s cubic-bezier(0.23, 1, 0.32, 1);
            border-radius: 50%;
            z-index: -1;
        }

        .nav-link:hover::before {
            transform: scale(1.1) rotate(0deg);
        }

        .nav-link:hover::after {
            width: 100px;
            height: 100px;
        }

        .nav-link:hover {
            /* color: #EF234B !important; */
            transform: translateY(-3px) scale(1.02);
            text-shadow: 0 0 20px rgba(1, 172, 182, 0.5);
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.2);
        }

        .nav-link:hover i {
            transform: scale(1.15) rotate(10deg);
            filter: drop-shadow(0 0 8px rgba(1, 172, 182, 0.4));
        }

        /* Active state for current page */
        .nav-link.active {
            background: rgba(1, 172, 182, 0.15);
            color: #01acb6 !important;
            font-weight: 600;
            transform: translateY(-1px);
            box-shadow: 0 4px 15px rgba(1, 172, 182, 0.25);
        }

        .nav-link i {
            transition: all 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            display: inline-block;
        }

        /* Header entrance animation */
        @keyframes headerSlideDown {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        #header {
            animation: headerSlideDown 0.8s cubic-bezier(0.23, 1, 0.32, 1);
        }

        /* Enhanced logo with hover effects */
        #header img {
            transition: all 0.5s cubic-bezier(0.23, 1, 0.32, 1);
            filter: drop-shadow(0 0 10px rgba(1, 172, 182, 0.2));
        }

        #header img:hover {
            transform: scale(1.08) rotate(5deg);
            filter: drop-shadow(0 0 25px rgba(1, 172, 182, 0.6));
        }

        .cta-button,
        a[class*="bg-solid"] {
            position: relative;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
        }

        .cta-button::before,
        a[class*="bg-solid"]::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.3);
            transition: all 0.6s cubic-bezier(0.23, 1, 0.32, 1);
        }

        .cta-button:hover::before,
        a[class*="bg-solid"]:hover::before {
            left: 100%;
        }

        .cta-button:hover,
        a[class*="bg-solid"]:hover {
            transform: translateY(-2px) scale(1.02);
            box-shadow: 0 15px 40px rgba(1, 172, 182, 0.4);
        }

        #header.scrolled img {
            filter: brightness(1.1) drop-shadow(0 0 15px rgba(1, 172, 182, 0.4));
        }

        /* Modern mobile menu button */
        #mobile-menu-btn {
            position: relative;
            padding: 0.75rem;
            border-radius: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        #mobile-menu-btn:hover {
            background: rgba(1, 172, 182, 0.2);
            border-color: rgba(1, 172, 182, 0.4);
            transform: scale(1.05);
        }

        #header.scrolled #mobile-menu-btn {
            background: rgba(1, 172, 182, 0.1);
            border-color: rgba(1, 172, 182, 0.3);
        }

        /* Enhanced mobile menu */
        #mobile-menu {
            background: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(1, 172, 182, 0.2);
            border-radius: 1rem;
            margin-top: 1rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            transform: translateY(-10px);
            opacity: 0;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        #mobile-menu:not(.hidden) {
            transform: translateY(0);
            opacity: 1;
        }

        #mobile-menu .nav-link {
            display: block;
            margin: 0.25rem 0;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        #mobile-menu .nav-link:hover {
            background: rgba(255, 47, 40, 0.1);
            transform: translateX(10px);
        }

        /* Header visible state */
        #header.header-visible {
            transform: translateY(0);
        }

        /* Header hidden state */
        #header.header-hidden {
            transform: translateY(-100%);
        }

        /* Services badges consistent height fix */
        .services-badges-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1rem;
        }

        .services-badges-container>div {
            display: flex;
            flex-direction: column;
            justify-content: center;
            min-height: 80px;
            height: auto;
            padding: 1rem;
        }

        @media (min-width: 768px) {
            .services-badges-container {
                grid-template-columns: repeat(5, 1fr);
            }

            .services-badges-container>div {
                min-height: 90px;
            }
        }

        /* Services badges floating animation */
        .services-badges-container>div {
            animation: floatBadge 6s ease-in-out infinite;
        }

        .services-badges-container>div:nth-child(1) {
            animation-delay: 0s;
        }

        .services-badges-container>div:nth-child(2) {
            animation-delay: 1.2s;
        }

        .services-badges-container>div:nth-child(3) {
            animation-delay: 2.4s;
        }

        .services-badges-container>div:nth-child(4) {
            animation-delay: 3.6s;
        }

        .services-badges-container>div:nth-child(5) {
            animation-delay: 4.8s;
        }

        @keyframes floatBadge {

            0%,
            100% {
                transform: translateY(0px) translateX(0px);
            }

            25% {
                transform: translateY(-8px) translateX(3px);
            }

            50% {
                transform: translateY(-4px) translateX(-2px);
            }

            75% {
                transform: translateY(-12px) translateX(1px);
            }
        }

        /* Pause animation on hover to avoid interference */
        .services-badges-container>div:hover {
            animation-play-state: paused;
        }

        /* Media queries pour les sections générales */
        @media (max-width: 768px) {

            /* Sections padding */
            section {
                padding: 3rem 0 !important;
            }

            /* Titres des sections - Fix visibility on mobile */
            .about-title,
            .services-title,
            .projects-title,
            .contact-title,
            .text-4xl,
            .text-5xl {
                font-size: 1.875rem !important;
                /* 30px - clearly visible on mobile */
                line-height: 1.2 !important;
                text-align: center !important;
                padding: 0 1rem !important;
                /* Prevent edge cutoff */
                margin-bottom: 1.5rem !important;
            }

            .text-3xl {
                font-size: 1.5rem !important;
                line-height: 1.3 !important;
                text-align: center !important;
                padding: 0 0.5rem !important;
            }

            /* Grilles responsive */
            .grid-cols-2 {
                grid-template-columns: repeat(1, minmax(0, 1fr)) !important;
            }

            .grid-cols-3 {
                grid-template-columns: repeat(1, minmax(0, 1fr)) !important;
            }

            .md\\:grid-cols-2 {
                grid-template-columns: repeat(1, minmax(0, 1fr)) !important;
            }

            .md\\:grid-cols-3 {
                grid-template-columns: repeat(1, minmax(0, 1fr)) !important;
            }
        }

        @media (max-width: 480px) {

            /* Sections plus compactes */
            section {
                padding: 2rem 0 !important;
            }

            /* Container padding */
            .px-6 {
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }

            /* Boutons responsive */
            .px-8 {
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }

            .py-3 {
                padding-top: 0.7rem !important;
                padding-bottom: 0.7rem !important;
            }

            .contact-info .bg-solid {
                padding: 1rem !important;
                /* Reduce from p-8 to p-4 on mobile */
                margin: 0 !important;
            }

            .contact-info .space-y-6>* {
                margin-bottom: 1rem !important;
            }

            .contact-info .flex.items-center {
                padding: 0.75rem !important;
                /* Reduce padding on contact items */
                flex-direction: row !important;
                align-items: center !important;
            }

            .contact-info .mr-4 {
                margin-right: 0.75rem !important;
                /* Reduce margin on mobile */
            }

            .contact-info h3 {
                font-size: 1.25rem !important;
                /* Smaller title on mobile */
                margin-bottom: 1rem !important;
                text-align: center !important;
            }

            /* Fix social links in contact section on mobile */
            .contact-info .flex.space-x-4 {
                justify-content: center !important;
                /* Center social icons */
                flex-wrap: wrap !important;
                /* Allow wrapping if needed */
                gap: 0.75rem !important;
                /* Consistent spacing */
            }

            .contact-info .flex.space-x-4 a {
                flex-shrink: 0 !important;
                /* Prevent shrinking */
            }

            iframe[src*="google.com/maps"] {
                pointer-events: auto !important;
                touch-action: manipulation !important;
            }

            .about-title,
            .services-title,
            .projects-title,
            .contact-title,
            .text-4xl,
            .text-5xl {
                font-size: 1.5rem !important;
                /* 24px - optimized for tiny screens */
                line-height: 1.1 !important;
                padding: 0 0.75rem !important;
                margin-bottom: 1rem !important;
            }

            .text-3xl {
                font-size: 1.25rem !important;
                /* 20px */
                line-height: 1.2 !important;
                padding: 0 0.5rem !important;
            }

            .text-2xl {
                font-size: 1.125rem !important;
                /* 18px */
                line-height: 1.3 !important;
            }
        }

        /* Header visible state */
        #header.header-visible {
            transform: translateY(0);
        }

        /* Header hidden state */
        #header.header-hidden {
            transform: translateY(-100%);
        }

        /* Modern glassmorphism effects */
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        /* Timeline Section Styles */
        .timeline-item {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.6s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        .timeline-item.animate-in {
            opacity: 1;
            transform: translateY(0);
        }

        .timeline-content {
            position: relative;
            overflow: hidden;
        }

        .timeline-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.4);
            transition: left 0.8s ease;
        }

        .timeline-content.animate-sweep::before {
            left: 100%;
        }

        .timeline-progress {
            transition: height 0.3s ease;
        }

        /* Mobile Timeline Adjustments */
        @media (max-width: 768px) {
            .timeline-item {
                flex-direction: column;
            }

            .timeline-item .w-1\/2 {
                width: 100% !important;
                padding: 0 !important;
                margin-bottom: 2rem;
            }

            .timeline-item .absolute {
                position: relative !important;
                left: auto !important;
                transform: none !important;
                margin: 1rem auto;
            }

            .timeline-item:nth-child(even) .timeline-content,
            .timeline-item:nth-child(odd) .timeline-content {
                text-align: center;
            }
        }

        /* Process Timeline Styles */
        .process-step {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.6s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        .process-step.animate-in {
            opacity: 1;
            transform: translateY(0);
        }

        .process-content {
            position: relative;
            overflow: hidden;
        }

        .process-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.6);
            transition: left 0.8s ease;
        }

        .process-content:hover::before {
            left: 100%;
        }

        .process-timeline-progress {
            transition: height 0.5s ease;
        }

        .process-step-number {
            animation: pulse-number 1.5s ease-in-out infinite;
        }

        @keyframes pulse-number {

            0%,
            100% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(1, 172, 182, 0.3);
            }

            50% {
                transform: scale(1.03);
                box-shadow: 0 0 0 8px rgba(1, 172, 182, 0);
            }
        }

        .process-icon {
            transition: all 0.3s ease;
        }

        .process-timer {
            animation: timer-pulse 2s ease-in-out infinite;
        }

        @keyframes timer-pulse {

            0%,
            100% {
                opacity: 1;
            }

            50% {
                opacity: 0.8;
            }
        }

        /* Mobile Process Adjustments */
        @media (max-width: 768px) {
            .process-step {
                flex-direction: column;
            }

            .process-step .w-1\/2 {
                width: 100% !important;
                padding: 0 !important;
                margin-bottom: 2rem;
            }

            .process-step .absolute {
                position: relative !important;
                left: auto !important;
                transform: none !important;
                margin: 1rem auto;
            }

            .process-step:nth-child(even) .process-content,
            .process-step:nth-child(odd) .process-content {
                text-align: center;
            }

            .process-timeline-progress {
                display: none;
            }
        }

        /* Creative Card Enhancements */
        .about-cards .group img {
            filter: grayscale(20%) contrast(1.1);
            transition: all 0.5s ease;
        }

        .about-cards .group:hover img {
            transform: scale(1.15) rotate(5deg);
            filter: grayscale(0%) contrast(1.2) brightness(1.1);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }

        .about-cards .group {
            position: relative;
        }

        .about-cards .group::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: rgba(1, 172, 182, 0.1);
            border-radius: 1.75rem;
            opacity: 0;
            transition: opacity 0.5s ease;
            z-index: -1;
        }

        .about-cards .group:hover::before {
            opacity: 1;
        }

        /* Floating animation for decorative elements */
        @keyframes float-gentle {

            0%,
            100% {
                transform: translateY(0px) rotate(0deg);
            }

            50% {
                transform: translateY(-10px) rotate(180deg);
            }
        }

        .about-cards .group:hover .w-20,
        .about-cards .group:hover .w-16,
        .about-cards .group:hover .w-12 {
            animation: float-gentle 3s ease-in-out infinite;
        }

        /* Advanced animations */
        .solid-animation {
            background: #06b6d4;
            background-size: 400% 400%;
        }

        /* Text shimmer effect */
        .text-shimmer {
            background: rgba(255, 255, 255, 0.4);
            background-size: 200% 100%;
            animation: text-shimmer 3s ease-in-out infinite;
        }

        /* Modern shadows */
        .modern-shadow {
            box-shadow:
                0 4px 6px -1px rgba(0, 0, 0, 0.1),
                0 2px 4px -1px rgba(0, 0, 0, 0.06),
                0 20px 25px -5px rgba(0, 0, 0, 0.1),
                0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        /* Hover glow effects */
        .hover-glow:hover {
            box-shadow:
                0 0 20px rgba(6, 182, 212, 0.3),
                0 0 40px rgba(6, 182, 212, 0.2),
                0 0 60px rgba(6, 182, 212, 0.1);
        }

        /* Canvas background elements */
        #particleCanvas,
        #geometryCanvas,
        #flowCanvas {
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            width: 100% !important;
            height: 100% !important;
            pointer-events: none;
            opacity: 0.8;
            mix-blend-mode: screen;
            transition: opacity 0.5s ease;
        }

        #particleCanvas {
            opacity: 0.7;
            mix-blend-mode: normal;
        }

        #geometryCanvas {
            opacity: 0.3;
            mix-blend-mode: overlay;
        }

        #flowCanvas {
            opacity: 0.4;
            mix-blend-mode: soft-light;
        }

        /* Geometric Animations for Hero Carousel */
        .geometric-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            overflow: hidden;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }

        .carousel-slide.active .geometric-background {
            opacity: 1;
        }

        /* Innovation Slide - Hexagonal Network */
        .innovation-geo {
            background: rgba(1, 172, 182, 0.1);
            background-size: 120px 120px;
            animation: hexagonalFlow 20s linear infinite;
        }

        .innovation-geo::before {
            content: '';
            position: absolute;
            width: 200px;
            height: 200px;
            background: rgba(1, 172, 182, 0.4);
            border-radius: 50%;
            top: 20%;
            left: 10%;
            animation: rotateClockwise 15s linear infinite;
        }

        .innovation-geo::after {
            content: '';
            position: absolute;
            width: 150px;
            height: 150px;
            background: rgba(1, 172, 182, 0.3);
            border-radius: 50%;
            bottom: 20%;
            right: 10%;
            animation: rotateCounterClockwise 12s linear infinite;
        }

        /* Development Slide - Code Matrix */
        .development-geo {
            background: rgba(239, 35, 75, 0.2);
            background-size: 60px 60px;
            animation: matrixScroll 8s linear infinite;
        }

        .development-geo::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 2px;
            background: rgba(239, 35, 75, 0.6);
            top: 30%;
            animation: scanLineHorizontal 3s ease-in-out infinite;
        }

        .development-geo::after {
            content: '';
            position: absolute;
            width: 2px;
            height: 100%;
            background: rgba(239, 35, 75, 0.6);
            left: 60%;
            animation: scanLineVertical 4s ease-in-out infinite;
        }

        /* Design Slide - Flowing Curves */
        .design-geo {
            background: rgba(147, 51, 234, 0.1);
            animation: flowingGradient 12s ease-in-out infinite;
        }

        .design-geo::before {
            content: '';
            position: absolute;
            width: 300px;
            height: 300px;
            border: 2px solid rgba(147, 51, 234, 0.3);
            border-radius: 50%;
            top: 10%;
            right: 15%;
            animation: pulseRing 6s ease-in-out infinite;
        }

        .design-geo::after {
            content: '';
            position: absolute;
            width: 200px;
            height: 200px;
            border: 1px solid rgba(147, 51, 234, 0.2);
            border-radius: 50%;
            bottom: 15%;
            left: 20%;
            animation: pulseRing 8s ease-in-out infinite 2s;
        }

        /* Keyframes for animations */
        @keyframes hexagonalFlow {
            0% {
                background-position: 0 0, 60px 60px, 0 0, 60px 60px;
            }

            100% {
                background-position: 120px 120px, 180px 180px, 120px 120px, 180px 180px;
            }
        }

        @keyframes rotateClockwise {
            0% {
                transform: rotate(0deg) scale(1);
            }

            50% {
                transform: rotate(180deg) scale(1.1);
            }

            100% {
                transform: rotate(360deg) scale(1);
            }
        }

        @keyframes rotateCounterClockwise {
            0% {
                transform: rotate(360deg) scale(1);
            }

            50% {
                transform: rotate(180deg) scale(0.9);
            }

            100% {
                transform: rotate(0deg) scale(1);
            }
        }

        @keyframes matrixScroll {
            0% {
                background-position: 0 0, 0 0;
            }

            100% {
                background-position: 60px 60px, 60px 60px;
            }
        }

        @keyframes scanLineHorizontal {

            0%,
            100% {
                top: 20%;
                opacity: 0;
            }

            50% {
                top: 80%;
                opacity: 1;
            }
        }

        @keyframes scanLineVertical {

            0%,
            100% {
                left: 20%;
                opacity: 0;
            }

            50% {
                left: 80%;
                opacity: 1;
            }
        }

        @keyframes flowingGradient {

            0%,
            100% {
                background-position: 0% 0%, 100% 0%, 0% 100%;
                filter: hue-rotate(0deg);
            }

            33% {
                background-position: 100% 100%, 0% 100%, 100% 0%;
                filter: hue-rotate(120deg);
            }

            66% {
                background-position: 100% 0%, 0% 0%, 100% 100%;
                filter: hue-rotate(240deg);
            }
        }

        @keyframes pulseRing {

            0%,
            100% {
                transform: scale(1) rotate(0deg);
                opacity: 0.3;
            }

            50% {
                transform: scale(1.2) rotate(180deg);
                opacity: 0.6;
            }
        }

        /* Floating geometric shapes */
        .floating-shape {
            position: absolute;
            pointer-events: none;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }

        .carousel-slide.active .floating-shape {
            opacity: 1;
        }

        .shape-triangle {
            width: 0;
            height: 0;
            border-left: 25px solid transparent;
            border-right: 25px solid transparent;
            animation: floatUpDown 8s ease-in-out infinite;
        }

        .shape-square {
            width: 40px;
            height: 40px;
            animation: rotateFloat 10s linear infinite;
        }

        .shape-circle {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            animation: bounceFloat 6s ease-in-out infinite;
        }

        @keyframes floatUpDown {

            0%,
            100% {
                transform: translateY(0) rotate(0deg);
            }

            50% {
                transform: translateY(-30px) rotate(180deg);
            }
        }

        @keyframes rotateFloat {
            0% {
                transform: rotate(0deg) translateX(20px) rotate(0deg);
            }

            100% {
                transform: rotate(360deg) translateX(20px) rotate(-360deg);
            }
        }

        @keyframes bounceFloat {

            0%,
            100% {
                transform: translateY(0) scale(1);
            }

            25% {
                transform: translateY(-15px) scale(1.1);
            }

            75% {
                transform: translateY(-5px) scale(0.95);
            }
        }

        /* Responsive adjustments for geometric animations */
        @media (max-width: 768px) {
            .geometric-background {
                opacity: 0.6;
            }

            .carousel-slide.active .geometric-background {
                opacity: 0.8;
            }

            .innovation-geo::before,
            .innovation-geo::after {
                width: 120px;
                height: 120px;
            }

            .design-geo::before {
                width: 200px;
                height: 200px;
            }

            .design-geo::after {
                width: 150px;
                height: 150px;
            }

            .floating-shape {
                opacity: 0.7;
            }

            .shape-triangle {
                border-left-width: 15px;
                border-right-width: 15px;
            }

            .shape-square {
                width: 25px;
                height: 25px;
            }

            .shape-circle {
                width: 20px;
                height: 20px;
            }
        }

        @media (max-width: 480px) {
            .geometric-background {
                opacity: 0.4;
            }

            .carousel-slide.active .geometric-background {
                opacity: 0.6;
            }

            .innovation-geo::before,
            .innovation-geo::after {
                width: 80px;
                height: 80px;
            }

            .design-geo::before {
                width: 150px;
                height: 150px;
            }

            .design-geo::after {
                width: 100px;
                height: 100px;
            }

            .floating-shape {
                opacity: 0.5;
            }

            .shape-triangle {
                border-left-width: 10px;
                border-right-width: 10px;
            }

            .shape-square {
                width: 20px;
                height: 20px;
            }

            .shape-circle {
                width: 15px;
                height: 15px;
            }

            /* Reduce animation complexity on very small screens */
            .innovation-geo,
            .development-geo,
            .design-geo {
                animation-duration: 30s;
                /* Slower animations */
            }

            .shape-triangle,
            .shape-square,
            .shape-circle {
                animation-duration: 12s;
                /* Slower animations */
            }
        }

        /* Responsive canvas adjustments */
        @media (max-width: 768px) {

            #particleCanvas,
            #geometryCanvas,
            #flowCanvas {
                opacity: 0.5;
            }

            #particleCanvas {
                opacity: 0.4;
            }

            #geometryCanvas {
                opacity: 0.2;
            }

            #flowCanvas {
                opacity: 0.3;
            }
        }

        @media (max-width: 480px) {

            #particleCanvas,
            #geometryCanvas,
            #flowCanvas {
                opacity: 0.3;
            }

            #particleCanvas {
                opacity: 0.3;
            }

            #geometryCanvas {
                opacity: 0.15;
            }

            #flowCanvas {
                opacity: 0.2;
            }
        }

        /* Smooth transitions for all elements */
        * {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Custom scrollbar for modern look */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: rgba(15, 23, 42, 0.1);
        }

        ::-webkit-scrollbar-thumb {
            background: #06b6d4;
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #0891b2;
        }

        /* AI Assistant Styles */
        .ai-assistant {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
            font-family: 'Roboto', sans-serif;
        }

        /* Chat Toggle Button */
        .chat-toggle {
            position: relative;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #01acb6;
            border: none;
            cursor: pointer;
            box-shadow: 0 4px 20px rgba(1, 172, 182, 0.3);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            overflow: hidden;
        }

        .chat-toggle:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 25px rgba(1, 172, 182, 0.4);
        }

        .chat-toggle:active {
            transform: scale(0.95);
        }

        .chat-pulse {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: #01acb6;
            opacity: 0.7;
            animation: pulse-ring 2s infinite;
        }

        @keyframes pulse-ring {
            0% {
                transform: scale(1);
                opacity: 0.7;
            }

            50% {
                transform: scale(1.2);
                opacity: 0.3;
            }

            100% {
                transform: scale(1.4);
                opacity: 0;
            }
        }

        .chat-icon,
        .chat-close-icon {
            position: relative;
            z-index: 2;
            transition: all 0.3s ease;
        }

        .chat-toggle.active .chat-icon {
            transform: rotate(180deg);
            opacity: 0;
        }

        .chat-toggle.active .chat-close-icon {
            transform: rotate(0deg);
            opacity: 1;
        }

        /* Chat Window */
        .chat-window {
            position: absolute;
            bottom: 80px;
            right: 0;
            width: 30vw;
            height: 60vh;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            overflow: hidden;
            transform: translateY(20px) scale(0.95);
            opacity: 0;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(1, 172, 182, 0.1);
        }

        .chat-window.show {
            transform: translateY(0) scale(1);
            opacity: 1;
        }

        /* Chat Header */
        .chat-header {
            background: #01acb6;
            padding: 20px;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .chat-header-content {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .assistant-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 6px;
        }

        .assistant-name {
            font-size: 16px;
            font-weight: 600;
            margin: 0;
        }

        .assistant-status {
            font-size: 12px;
            margin: 0;
            opacity: 0.9;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .status-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #4ade80;
            animation: pulse-dot 2s infinite;
        }

        @keyframes pulse-dot {

            0%,
            100% {
                opacity: 1;
            }

            50% {
                opacity: 0.5;
            }
        }

        .chat-minimize {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            border-radius: 8px;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .chat-minimize:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        /* Chat Messages */
        .chat-messages {
            height: 280px;
            overflow-y: auto;
            padding: 20px;
            background: #f8fafc;
            scroll-behavior: smooth;
        }

        .chat-messages::-webkit-scrollbar {
            width: 4px;
        }

        .chat-messages::-webkit-scrollbar-track {
            background: transparent;
        }

        .chat-messages::-webkit-scrollbar-thumb {
            background: rgba(1, 172, 182, 0.3);
            border-radius: 2px;
        }

        .message {
            display: flex;
            gap: 10px;
            margin-bottom: 16px;
            animation: messageSlideIn 0.3s ease-out;
        }

        @keyframes messageSlideIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .message-avatar {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: #01acb6;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            padding: 4px;
        }

        .user-message {
            flex-direction: row-reverse;
        }

        .user-message .message-avatar {
            background: #EF234B;
        }

        .message-content {
            max-width: 250px;
            background: white;
            padding: 12px 16px;
            border-radius: 18px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            position: relative;
        }

        .user-message .message-content {
            background: #01acb6;
            color: white;
        }

        .message-content p {
            margin: 0;
            font-size: 14px;
            line-height: 1.4;
        }

        .message-time {
            font-size: 11px;
            color: #64748b;
            margin-top: 4px;
            display: block;
        }

        .user-message .message-time {
            color: rgba(255, 255, 255, 0.8);
        }

        /* Quick Actions */
        .quick-actions {
            padding: 16px 20px;
            background: white;
            border-top: 1px solid #e2e8f0;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 8px;
        }

        .quick-action {
            background: #f1f5f9;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 10px 12px;
            font-size: 12px;
            font-weight: 500;
            color: #475569;
            cursor: pointer;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .quick-action:hover {
            background: #01acb6;
            color: white;
            border-color: #01acb6;
            transform: translateY(-1px);
        }

        /* Chat Input */
        .chat-input-container {
            background: white;
            border-top: 1px solid #e2e8f0;
        }

        .chat-input-wrapper {
            padding: 16px 20px;
            display: flex;
            gap: 12px;
            align-items: center;
        }

        .chat-input {
            flex: 1;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 10px 16px;
            font-size: 14px;
            outline: none;
            transition: border-color 0.2s ease;
            background: #f8fafc;
        }

        .chat-input:focus {
            border-color: #01acb6;
            background: white;
        }

        .chat-send {
            background: #01acb6;
            border: none;
            border-radius: 12px;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .chat-send:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(1, 172, 182, 0.3);
        }

        .chat-send:disabled {
            opacity: 0.5;
            /* cursor: not-allowed; */
            transform: none;
        }

        .chat-input-footer {
            padding: 8px 20px 16px;
            text-align: center;
        }

        .powered-by {
            font-size: 11px;
            color: #94a3b8;
        }

        /* Typing Indicator */
        .typing-indicator {
            display: flex;
            gap: 10px;
            align-items: center;
            padding: 12px 16px;
            background: white;
            border-radius: 18px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            max-width: 250px;
        }

        .typing-dots {
            display: flex;
            gap: 4px;
        }

        .typing-dot {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: #94a3b8;
            animation: typingDot 1.4s infinite;
        }

        .typing-dot:nth-child(2) {
            animation-delay: 0.2s;
        }

        .typing-dot:nth-child(3) {
            animation-delay: 0.4s;
        }

        @keyframes typingDot {

            0%,
            60%,
            100% {
                transform: translateY(0);
                opacity: 0.4;
            }

            30% {
                transform: translateY(-10px);
                opacity: 1;
            }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .ai-assistant {
                bottom: 15px;
                right: 15px;
            }

            .chat-toggle {
                width: 55px;
                height: 55px;
            }

            .chat-window {
                width: calc(100vw - 30px);
                height: 70vh;
                max-height: 500px;
                bottom: 75px;
                right: -15px;
            }

            .chat-messages {
                height: calc(70vh - 220px);
                min-height: 200px;
            }

            .quick-actions {
                grid-template-columns: 1fr;
                gap: 6px;
            }

            .quick-action {
                padding: 12px;
                font-size: 13px;
            }
        }

        @media (max-width: 480px) {
            .chat-window {
                width: calc(100vw - 20px);
                height: 75vh;
                bottom: 70px;
                right: -10px;
                border-radius: 16px;
            }

            .chat-header {
                padding: 16px;
            }

            .assistant-name {
                font-size: 15px;
            }

            .chat-messages {
                padding: 16px;
                height: calc(75vh - 200px);
            }

            .message-content {
                max-width: 200px;
            }
        }

        /* Hidden class */
        .hidden {
            display: none !important;
        }

        /* Enhanced Animations */
        @keyframes chatBounceIn {
            0% {
                opacity: 0;
                transform: scale(0.3) translateY(20px);
            }

            50% {
                opacity: 1;
                transform: scale(1.05) translateY(-5px);
            }

            70% {
                transform: scale(0.95) translateY(0);
            }

            100% {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }

        @keyframes chatSlideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes chatGlow {

            0%,
            100% {
                box-shadow: 0 4px 20px rgba(1, 172, 182, 0.3);
            }

            50% {
                box-shadow: 0 6px 30px rgba(1, 172, 182, 0.5);
            }
        }

        /* Enhanced chat window animation */
        .chat-window.show {
            animation: chatBounceIn 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Enhanced message animations */
        .message {
            animation: chatSlideUp 0.3s ease-out;
        }

        /* Glow effect for chat toggle */
        .chat-toggle:hover {
            animation: chatGlow 2s infinite;
        }

        /* Smooth hover effects for quick actions */
        .quick-action {
            position: relative;
            overflow: hidden;
        }

        .quick-action::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: rgba(1, 172, 182, 0.2);
            transition: left 0.5s ease;
        }

        .quick-action:hover::before {
            left: 100%;
        }

        /* Enhanced typing indicator */
        .typing-indicator {
            animation: chatSlideUp 0.3s ease-out;
        }

        /* Notification styles */
        .ai-notification {
            font-family: 'Roboto', sans-serif;
            backdrop-filter: blur(10px);
        }

        /* Message button hover effects */
        .message-button {
            position: relative;
            overflow: hidden;
        }

        .message-button::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(1, 172, 182, 0.3);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }

        .message-button:hover::after {
            width: 100px;
            height: 100px;
        }

        /* Accessibility improvements */
        .chat-toggle:focus,
        .chat-send:focus,
        .chat-input:focus,
        .quick-action:focus {
            outline: 2px solid #01acb6;
            outline-offset: 2px;
        }

        /* Dark mode support (optional) */
        @media (prefers-color-scheme: dark) {
            .chat-messages {
                background: #1e293b;
            }

            .message-content {
                background: #334155;
                color: #f1f5f9;
            }

            .chat-input {
                background: #334155;
                color: #f1f5f9;
                border-color: #475569;
            }

            .quick-action {
                background: #334155;
                color: #f1f5f9;
                border-color: #475569;
            }
        }

        /* Performance optimizations */
        .ai-assistant * {
            will-change: transform, opacity;
        }

        .chat-toggle {
            will-change: transform, box-shadow;
        }

        .chat-window {
            will-change: transform, opacity;
        }

        /* Hero Carousel Styles */
        .carousel-container {
            overflow: hidden;
        }

        .carousel-slide {
            transition: opacity 1.5s cubic-bezier(0.4, 0, 0.2, 1),
                transform 1.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .carousel-slide:not(.active) {
            opacity: 0;
            transform: scale(1.05);
        }

        .carousel-slide.active {
            opacity: 1;
            transform: scale(1);
        }

        /* Simple Dot Pagination Styles */
        /* Replace the existing carousel pagination styles with this: */
        .carousel-pagination {
            backdrop-filter: blur(10px);
            background: rgba(0, 0, 0, 0.3);
            border-radius: 25px;
            padding: 8px 16px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .carousel-dot {
            width: 3px;
            height: 3px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.4);
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
        }

        /* Active dot styles */
        .carousel-dot.active {
            background: #ffffff;
            transform: scale(1.3);
            box-shadow: 0 0 8px rgba(255, 255, 255, 0.5);
        }

        /* Hover effects */
        .carousel-dot:hover:not(.active) {
            background: rgba(255, 255, 255, 0.6);
            transform: scale(1.1);
        }

        /* Responsive dot styles */
        @media (max-width: 768px) {
            .carousel-pagination {
                padding: 6px 12px;
                bottom: 15px !important;
            }

            .carousel-dot {
                width: 3px;
                height: 3px;
            }
        }

        @media (max-width: 480px) {
            .carousel-pagination {
                padding: 4px 10px;
            }

            .carousel-dot {
                width: 3px;
                height: 3px;
            }
        }

        /* Marquee logos */
        .marquee-wrapper {
            overflow: hidden;
            width: 100%;
        }

        .marquee-track {
            display: flex;
            gap: 6vw;
            width: max-content;
            animation: marquee-scroll 30s linear infinite;
            align-items: center;
        }

        @keyframes marquee-scroll {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-50%);
            }
        }

        .marquee-logo {
            height: 6vh;
            width: auto;
            max-height: 72vh;
            opacity: 0.9;
            transition: opacity 0.2s ease, transform 0.2s ease;
            filter: none;
        }

        .marquee-logo:hover {
            opacity: 1;
            transform: scale(1.05);
        }

        @media (max-width: 768px) {
            .marquee-track {
                gap: 10vw;
                animation-duration: 24s;
            }

            .marquee-logo {
                height: 5.5vh;
            }
        }

        @media (max-width: 480px) {
            .marquee-track {
                gap: 12vw;
                animation-duration: 20s;
            }

            .marquee-logo {
                height: 5vh;
            }
        }

             /* Design Train Animation */
        .design-train-container {
            width: 100%;
            height: 400px;
            mask: none;
            -webkit-mask: none;
        }

        .design-train {
            animation: none;
            transform: translateX(0);
            will-change: auto;
        }

        /* Cards Grid Styles */
        .design-cards-grid {
            gap: 2rem;
        }

        .design-card {
            transition: all 0.3s ease;
            will-change: transform;
        }

        .design-card:hover {
            transform: scale(1.05);
        }

        .design-card img {
            transition: all 0.5s ease;
        }

        /* Alternating hover effects */
        .design-card:nth-child(odd) img {
            transform-origin: left center;
        }

        .design-card:nth-child(even) img {
            transform-origin: right center;
        }

        /* Design Carousel Styles */
        .design-carousel-container {
            position: relative;
        }

        .design-carousel-track {
            overflow: hidden;
        }

        .design-carousel-slides {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }

        .design-carousel-slide {
            flex: 0 0 100%;
            max-width: 100%;
        }

        .design-carousel-prev,
        .design-carousel-next {
            opacity: 0;
            transform: translateY(-50%) scale(0.9);
            transition: all 0.3s ease;
        }

        .design-carousel-container:hover .design-carousel-prev,
        .design-carousel-container:hover .design-carousel-next {
            opacity: 1;
            transform: translateY(-50%) scale(1);
        }

        .design-carousel-dot.active {
            background-color: #01acb6 !important;
            transform: scale(1.3);
            box-shadow: 0 0 8px rgba(1, 172, 182, 0.5);
        }

        /* Responsive design carousel */
        @media (max-width: 768px) {
            .design-cards-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }

            .design-carousel-slide .grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
                padding: 0 1rem;
            }

            .design-card {
                max-width: 400px;
                margin: 0 auto;
            }

            .design-card:hover {
                transform: scale(1.02);
            }

            .design-carousel-prev,
            .design-carousel-next {
                width: 10px;
                height: 10px;
            }

            .design-carousel-prev {
                left: 8px;
            }

            .design-carousel-next {
                right: 8px;
            }

            .design-carousel-prev i,
            .design-carousel-next i {
                width: 4px;
                height: 4px;
            }
        }

        @media (max-width: 1024px) and (min-width: 769px) {
            .design-carousel-slide .grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 480px) {
            .design-cards-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .design-card {
                max-width: 320px;
            }

            .design-card .relative.h-80 {
                height: 250px;
            }

            .design-card:hover {
                transform: none;
            }

            .design-card img:hover {
                transform: scale(1.05);
            }

            /* Désactiver les effets coûteux sur mobile */
            #design-content .blur-xl {
                display: none !important;
            }

            #design-content [class*="backdrop-blur"] {
                backdrop-filter: none !important;
                background: rgba(0, 0, 0, 0.2) !important;
            }

            /* / */

            .design-cards-grid {
                padding: 2rem;
                background: #667eea;
                min-height: 100vh;
            }

            .modal-overlay {
                backdrop-filter: blur(10px);
                background: rgba(0, 0, 0, 0.8);
            }

            .modal-content {
                animation: modalFadeIn 0.3s ease-out;
            }

            @keyframes modalFadeIn {
                from {
                    opacity: 0;
                    transform: scale(0.9) translateY(-20px);
                }

                to {
                    opacity: 1;
                    transform: scale(1) translateY(0);
                }
            }

            .modal-image {
                max-height: 80vh;
                max-width: 90vw;
                width: auto;
                height: auto;
                object-fit: contain;
            }

            .close-btn:hover {
                transform: rotate(90deg);
            }
        }

        /* Advanced Carousel Styles */
        .advanced-carousel-container {
            position: relative;
            width: 100%;
            max-width: 1200px;
            overflow: hidden;
            margin: 0 auto;
        }

        .advanced-carousel-wrapper {
            overflow: hidden;
            width: 100%;
        }

        .advanced-carousel {
            display: flex;
            gap: 20px;
            transition: transform 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            padding: 20px 0;
        }

        .advanced-carousel-card {
            border-radius: 16px;
            width: 350px;
            height: 250px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            flex-shrink: 0;
        }

        .advanced-carousel-card img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
            position: relative;
            z-index: 2;
        }

        .advanced-carousel-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.4);
        }

        .advanced-carousel-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(0, 0, 0, 0.1) 0%, rgba(0, 0, 0, 0.3) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: 1;
        }

        .advanced-carousel-card:hover::before {
            opacity: 1;
        }

        .advanced-carousel-card .link-icon {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            z-index: 10;
            opacity: 0;
            transform: translateY(-10px);
        }

        .advanced-carousel-card:hover .link-icon {
            opacity: 1;
            transform: translateY(0);
        }

        .advanced-carousel-card .link-icon:hover {
            background: white;
            transform: scale(1.1);
        }

        .advanced-carousel-card .link-icon svg {
            width: 20px;
            height: 20px;
            stroke: #333;
            stroke-width: 2;
        }

        /* Hover overlay styles */
        .carousel-hover-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 3;
            pointer-events: none;
        }

        .carousel-overlay-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(0, 0, 0, 0.7) 0%, rgba(0, 0, 0, 0.5) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .advanced-carousel-card:hover .carousel-overlay-bg {
            opacity: 1;
        }

        /* Content overlay styles */
        .carousel-content-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 24px;
            z-index: 4;
            transform: translateY(20px);
            opacity: 0;
            transition: all 0.3s ease;
        }

        .advanced-carousel-card:hover .carousel-content-overlay {
            transform: translateY(0);
            opacity: 1;
        }

        .carousel-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: white;
            margin-bottom: 8px;
            line-height: 1.3;
        }

        .carousel-description {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.9);
            line-height: 1.4;
            margin: 0;
        }

        .advanced-nav-btn {
            background: rgba(1, 172, 182, 0.2);
            border: 2px solid rgba(1, 172, 182, 0.3);
            color: #01acb6;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            z-index: 5;
        }

        .advanced-nav-btn:hover:not(:disabled) {
            background: rgba(1, 172, 182, 0.4);
            border-color: rgba(1, 172, 182, 0.6);
            color: white;
        }

        .advanced-nav-btn.prev {
            left: 10px;
        }

        .advanced-nav-btn.next {
            right: 10px;
        }

        .advanced-nav-btn:disabled {
            opacity: 0.3;
            cursor: not-allowed;
        }

        .advanced-dots {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
            margin-top: 30px;
        }

        .advanced-dot {
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.25);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .advanced-dot.center {
            width: 10px;
            height: 10px;
            background: #01acb6;
        }

        .advanced-dot.adjacent {
            width: 8px;
            height: 8px;
            background: rgba(1, 172, 182, 0.6);
        }

        .advanced-dot.outer {
            width: 6px;
            height: 6px;
            background: rgba(255, 255, 255, 0.25);
        }

        .advanced-loading-placeholder {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, #333 25%, #444 50%, #333 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
            z-index: 1;
        }

        @keyframes loading {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }

        @media (max-width: 768px) {
            .advanced-carousel {
                gap: 15px;
                padding: 20px;
            }

            .advanced-carousel-card {
                width: 300px;
            }

            .advanced-nav-btn.prev {
                left: 10px;
            }

            .advanced-nav-btn.next {
                right: 10px;
            }
        }

        /* Enhanced Filter Button Styles */
        .filter-btn {
            transition: all 0.3s ease, transform 0.1s ease;
            position: relative;
            overflow: hidden;
        }

        .filter-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.3);
        }

        .filter-btn.active-filter {
            background: #01acb6 !important;
            color: white !important;
            border-color: #01acb6 !important;
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.4);
            transform: translateY(-1px);
        }

        .filter-btn.active-filter::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255, 255, 255, 0.1) 0%, transparent 100%);
            pointer-events: none;
        }

        .filter-btn.active-filter:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(1, 172, 182, 0.5);
        }
    </style>

<body class="">
    <main>
        <br>
        <section id="design-content"
            class="py-20 relative overflow-hidden">
            <!-- Background Effects -->
            <div class="absolute inset-0">
                <div class="absolute top-20 left-10 w-72 h-72 bg-[#01acb6]/5 rounded-full blur-xl opacity-30"></div>
                <div class="absolute bottom-20 right-10 w-96 h-96 bg-[#EF234B]/5 rounded-full blur-xl opacity-30"></div>
                <div
                    class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-purple-500/3 rounded-full blur-xl opacity-30">
                </div>
            </div>
            <div class="max-w-7xl mx-auto px-6 relative z-10">
                <!-- Section Header -->
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-bold text-white mb-6">
                        <span class="bg-[#01acb6] bg-clip-text text-transparent" id="design">Voir plus de projets
                        </span>
                    </h2>
                    <p class="text-xl max-w-3xl mx-auto leading-relaxed">
                        Découvrez notre expertise créative à travers une sélection de nos plus beaux designs.
                        Chaque création reflète notre passion pour l'innovation visuelle et l'excellence graphique.
                    </p>
                </div>

                <!-- Design Gallery - Carousel -->
                <?php if ($projects['success'] && !empty($projects['data']['items'])): ?>
                    <?php
                    // Filter projects to only show design content items (where values[5] == 8)
                    $designProjects = array_filter($projects['data']['items'], function ($project) {
                        return $project['values'][5] == 8;
                    });
                    $designProjects = array_values($designProjects); // Reset array keys

                    $itemsPerSlide = 4;
                    $totalSlides = ceil(count($designProjects) / $itemsPerSlide);
                    ?>
                    <?php if (!empty($designProjects)): ?>
                        <div class="advanced-carousel-container relative mb-16">
                            <button class="advanced-nav-btn prev" id="prevBtn">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                </svg>
                            </button>

                            <div class="advanced-carousel-wrapper">
                                <div class="advanced-carousel" id="carousel">
                                    <?php foreach ($designProjects as $index => $project): ?>
                                        <?php $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : ''; ?>
                                        <div class="advanced-carousel-card" data-link="<?php echo $baseUrl . $adminPath . 'portfolio.php/' . htmlspecialchars($project['slug']); ?>">
                                            <!-- Loading placeholder -->
                                            <div class="advanced-loading-placeholder">Loading...</div>
                                            <?php $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : ''; ?>

                                            <!-- Image element -->
                                            <img src="<?php echo htmlspecialchars($project['values'][2][0]); ?>"
                                                alt="<?php echo htmlspecialchars($project['values'][0]); ?>"
                                                loading="eager"
                                                style="display: block;">

                                            <!-- Hover overlay with dark background -->
                                            <div class="carousel-hover-overlay">
                                                <div class="carousel-overlay-bg"></div>
                                            </div>

                                            <!-- Content overlay -->
                                            <div class="carousel-content-overlay">
                                                <h3 class="carousel-title">
                                                    <?php echo htmlspecialchars($project['values'][0]); ?>
                                                </h3>
                                                <p class="carousel-description">
                                                    <?php echo htmlspecialchars(truncateText(stripHTMLTags($project['values'][1]), 120)); ?>
                                                </p>
                                            </div>

                                            <!-- Link icon -->
                                            <div class="link-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-right-icon lucide-arrow-up-right">
                                                    <path d="M7 7h10v10" />
                                                    <path d="M7 17 17 7" />
                                                </svg>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <button class="advanced-nav-btn next" id="nextBtn">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </button>

                            <div class="advanced-dots" id="dotsContainer">
                                <!-- Dots will be generated dynamically by JavaScript -->
                            </div>
                        </div>
                    <?php else: ?>
                        <p class="text-center text-slate-400 mb-16">No design content projects found.</p>
                    <?php endif; ?>
                <?php else: ?>
                    <p class="text-center text-slate-400 mb-16">No projects found.</p>
                <?php endif; ?>
            </div>
            <div id="imagePopup" class="fixed inset-0 z-50 hidden items-center justify-center p-4">
                <!-- Blurred + dark background -->
                <div class="absolute inset-0 bg-black/60 backdrop-blur-md"></div>

                <div class="relative max-w-4xl max-h-full z-10">
                    <!-- Close button -->
                    <button onclick="closePopup()" class="absolute -top-12 right-0 text-white hover:text-gray-300 transition-colors duration-200">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>

                </div>
            </div>
            </div>
        </section>     

        <!-- Footer -->

    </main>

   <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Fixing footer interactivity...');

            // Force footer elements to be clickable
            const footer = document.querySelector('footer');
            if (footer) {
                // Apply styles directly via JavaScript
                footer.style.pointerEvents = 'auto';
                footer.style.zIndex = '100';
                footer.style.position = 'relative';

                console.log('Footer found and styled');

                // Fix all interactive elements in footer
                const interactiveElements = footer.querySelectorAll('a, button, iframe, [onclick]');
                console.log('Found', interactiveElements.length, 'interactive elements');

                interactiveElements.forEach((element, index) => {
                    element.style.pointerEvents = 'auto';
                    element.style.cursor = 'pointer';
                    element.style.zIndex = '101';
                    element.style.position = 'relative';

                    // Special handling for Google Maps iframe
                    if (element.tagName === 'IFRAME' && element.src.includes('google.com/maps')) {
                        element.style.touchAction = 'auto';
                        element.style.userSelect = 'auto';
                        element.removeAttribute('loading'); // Remove lazy loading
                        console.log('Google Maps iframe fixed');
                    }

                    // Add click event listener for debugging
                    element.addEventListener('click', function(e) {
                        console.log('Footer element clicked:', element);
                    });
                });

                // Remove any overlapping elements that might block clicks
                const overlayElements = document.querySelectorAll('[style*="position: absolute"], [style*="position: fixed"]');
                overlayElements.forEach(element => {
                    if (element !== footer && !footer.contains(element)) {
                        const rect = element.getBoundingClientRect();
                        const footerRect = footer.getBoundingClientRect();

                        // Check if element overlaps with footer
                        if (rect.bottom > footerRect.top && rect.top < footerRect.bottom) {
                            element.style.pointerEvents = 'none';
                            console.log('Disabled pointer events for overlapping element:', element);
                        }
                    }
                });
            } else {
                console.error('Footer not found!');
            }
        });

        // Additional fix on window load
        window.addEventListener('load', function() {
            setTimeout(() => {
                const footer = document.querySelector('footer');
                const iframe = footer?.querySelector('iframe');
                if (iframe) {
                    iframe.style.pointerEvents = 'auto';
                    iframe.style.touchAction = 'auto';
                    console.log('Google Maps iframe re-enabled after load');
                }
            }, 1000);
        });

        // Gestion du modal de devis
        document.addEventListener('DOMContentLoaded', function() {
            const devisBtn = document.getElementById('devis-btn');
            const modal = document.getElementById('devis-modal');
            const modalContent = document.getElementById('modal-content');
            const closeModal = document.getElementById('close-modal');
            const cancelBtn = document.getElementById('cancel-btn');
            const devisForm = document.getElementById('devis-form');

            // Ouvrir le modal
            function openModal(imageSrc, title) {
                const modal = document.getElementById('imageModal');
                const modalImage = document.getElementById('modalImage');
                const modalTitle = document.getElementById('modalTitle');

                // Use preloaded images instead of loading from source
                let preloadedImg;
                switch (imageSrc) {
                    case 'design/2835 copy.png?w=800&h=600&fit=crop':
                        preloadedImg = document.getElementById('preload-img1');
                        break;
                    case 'design/dwdwdw.png?w=800&h=600&fit=crop':
                        preloadedImg = document.getElementById('preload-img2');
                        break;
                    case 'newImages/COVER-COPIMA.png?w=800&h=600&fit=crop':
                        preloadedImg = document.getElementById('preload-img3');
                        break;
                    case 'newImages/COVER-SESAME.png?w=800&h=600&fit=crop':
                        preloadedImg = document.getElementById('preload-img4');
                        break;
                    default:
                        // Fallback to original method if not one of our preloaded images
                        modalImage.src = imageSrc;
                }

                if (preloadedImg) {
                    modalImage.src = preloadedImg.src;
                }

                modalImage.alt = title;
                modalTitle.textContent = title;

                modal.classList.remove('hidden');
                document.body.style.overflow = 'hidden'; // Prevent scrolling
            }

            // Fermer le modal
            function closeModalFunc() {
                modalContent.classList.remove('scale-100', 'opacity-100');
                modalContent.classList.add('scale-95', 'opacity-0');
                setTimeout(() => {
                    modal.classList.remove('flex');
                    modal.classList.add('hidden');
                    document.body.style.overflow = ''; // Restaurer le scroll
                }, 300);
            }

            // Event listeners
            devisBtn?.addEventListener('click', openModal);
            closeModal?.addEventListener('click', closeModalFunc);
            cancelBtn?.addEventListener('click', closeModalFunc);

            // Fermer en cliquant sur le backdrop
            modal?.addEventListener('click', function(e) {
                if (e.target === modal) {
                    closeModalFunc();
                }
            });

            // Fermer avec Escape
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && !modal.classList.contains('hidden')) {
                    closeModalFunc();
                }
            });

            // Gestion du formulaire
            devisForm?.addEventListener('submit', function(e) {
                e.preventDefault();

                const formData = new FormData(devisForm);
                const data = {
                    prenom: formData.get('prenom'),
                    nom: formData.get('nom'),
                    email: formData.get('email'),
                    telephone: formData.get('telephone'),
                    message: formData.get('message')
                };

                // Créer le lien mailto
                const subject = encodeURIComponent('Demande de devis - ' + data.prenom + ' ' + data.nom);
                const body = encodeURIComponent(
                    `Bonjour,\n\n` +
                    `Je souhaite obtenir un devis pour mon projet.\n\n` +
                    `Mes informations :\n` +
                    `- Prénom : ${data.prenom}\n` +
                    `- Nom : ${data.nom}\n` +
                    `- Email : ${data.email}\n` +
                    `- Téléphone : ${data.telephone || 'Non renseigné'}\n\n` +
                    `Description du projet :\n${data.message || 'Aucune description fournie'}\n\n` +
                    `Cordialement,\n${data.prenom} ${data.nom}`
                );

                const mailtoLink = `mailto:contact@maxmind.ma?subject=${subject}&body=${body}`;

                // Ouvrir le client email
                window.location.href = mailtoLink;

                // Fermer le modal après un court délai
                setTimeout(() => {
                    closeModalFunc();
                    // Réinitialiser le formulaire
                    devisForm.reset();
                }, 1000);
            });
        });
    </script>
    <script>
        // Initialiser Lucide icons
        lucide.createIcons();

        // Fonction de filtrage améliorée
        const filterButtons = document.querySelectorAll('.filter-btn');
        const projectCards = document.querySelectorAll('.project-card');
        const projectsGrid = document.querySelector('.projects-grid');

        // Compteur de projets visible (console only)
        function updateProjectCount() {
            const visibleProjects = document.querySelectorAll('.project-card:not([style*="display: none"])').length;
            const totalProjects = projectCards.length;

            console.log(`${visibleProjects} projets sur ${totalProjects} affichés`);
        }

        function filterProjects(category) {
            // Add smooth transition effect
            if (projectsGrid) {
                projectsGrid.style.opacity = '0.7';
            }

            setTimeout(() => {
                projectCards.forEach((card) => {
                    const cardCategory = card.getAttribute('data-category');
                    const shouldShow = category === 'all' || cardCategory === category;

                    if (shouldShow) {
                        card.style.display = 'flex';
                        // Add fade-in animation
                        card.style.opacity = '0';
                        setTimeout(() => {
                            card.style.opacity = '1';
                        }, 50);
                    } else {
                        card.style.display = 'none';
                    }
                });

                // Restore grid opacity
                if (projectsGrid) {
                    projectsGrid.style.opacity = '1';
                }

                updateProjectCount();
            }, 150);
        }

        // Gestion des clics sur les boutons de filtre
        filterButtons.forEach(button => {
            button.addEventListener('click', () => {
                // Retirer la classe active de tous les boutons
                filterButtons.forEach(btn => {
                    btn.classList.remove('active-filter');
                    btn.classList.add('bg-white', 'text-slate-700', 'border-slate-200');
                    btn.classList.remove('bg-[#01acb6]', 'text-white', 'border-[#01acb6]');
                });

                // Ajouter la classe active au bouton cliqué
                button.classList.add('active-filter');
                button.classList.remove('bg-white', 'text-slate-700', 'border-slate-200');
                button.classList.add('bg-[#01acb6]', 'text-white', 'border-[#01acb6]');

                // Add click feedback animation
                button.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    button.style.transform = 'scale(1)';
                }, 100);

                // Effectuer le filtrage
                const category = button.getAttribute('data-filter');
                filterProjects(category);
            });
        });

        // Initialize smooth transitions
        projectCards.forEach(card => {
            card.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
        });

        if (projectsGrid) {
            projectsGrid.style.transition = 'opacity 0.3s ease';
        }

        // Filter buttons transition
        filterButtons.forEach(btn => {
            btn.style.transition = 'all 0.3s ease, transform 0.1s ease';
        });

        // Initialiser le compteur
        updateProjectCount();
    </script>
    <script>
        function openPopup(imageSrc, title) {
            const popup = document.getElementById('imagePopup');
            const popupImage = document.getElementById('popupImage');
            const popupTitle = document.getElementById('popupTitle');

            popupImage.src = imageSrc;
            popupImage.alt = title;
            popupTitle.textContent = title;

            popup.classList.remove('hidden');
            popup.classList.add('flex');

            // Prevent body scroll when popup is open
            document.body.style.overflow = 'hidden';
        }

        function closePopup() {
            const popup = document.getElementById('imagePopup');
            popup.classList.add('hidden');
            popup.classList.remove('flex');

            // Restore body scroll
            document.body.style.overflow = 'auto';
        }

        // Close popup when clicking outside the image
        document.getElementById('imagePopup').addEventListener('click', function(e) {
            if (e.target === this) {
                closePopup();
            }
        });

        // Initialize preloading when page loads
        document.addEventListener('DOMContentLoaded', function() {
            preloadImages();
            console.log('Images preloaded successfully');
        });
    </script>

    <div style="display: none;">
        <img src="design/2835 copy.png" alt="Design créatif MaxMind" id="preload-img1">
        <img src="design/dwdwdw.png" alt="Design professionnel MaxMind" id="preload-img2">
        <img src="newImages/COVER-COPIMA.png" alt="Design branding MaxMind" id="preload-img3">
        <img src="newImages/COVER-SESAME.png" alt="Design innovant MaxMind" id="preload-img4">
    </div>

    <!-- Design Carousel Functionality -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Design carousel functionality
            const designCarousel = {
                currentSlide: 0,
                slides: document.querySelectorAll('.design-carousel-slide'),
                dots: document.querySelectorAll('.design-carousel-dot'),
                slidesContainer: document.querySelector('.design-carousel-slides'),
                prevBtn: document.querySelector('.design-carousel-prev'),
                nextBtn: document.querySelector('.design-carousel-next'),
                autoChangeInterval: null,

                init() {
                    if (!this.slides.length || !this.dots.length || !this.slidesContainer) {
                        console.log('Design carousel elements not found');
                        return;
                    }

                    console.log('Initializing design carousel with', this.slides.length, 'slides');

                    // Add click events to navigation buttons
                    if (this.prevBtn) {
                        this.prevBtn.addEventListener('click', () => {
                            this.prevSlide();
                        });
                    }

                    if (this.nextBtn) {
                        this.nextBtn.addEventListener('click', () => {
                            this.nextSlide();
                        });
                    }

                    // Add click events to dots
                    this.dots.forEach((dot, index) => {
                        dot.addEventListener('click', () => {
                            this.goToSlide(index);
                        });
                    });

                    // Start auto-change every 4 seconds to match portfolio style
                    this.startAutoChange();

                    // Pause on hover
                    const container = document.querySelector('.design-carousel-container');
                    if (container) {
                        container.addEventListener('mouseenter', () => {
                            this.stopAutoChange();
                        });

                        container.addEventListener('mouseleave', () => {
                            this.startAutoChange();
                        });
                    }
                },

                goToSlide(index) {
                    // Remove active class from current dot
                    if (this.dots[this.currentSlide]) {
                        this.dots[this.currentSlide].classList.remove('active');
                        this.dots[this.currentSlide].classList.remove('bg-[#01acb6]');
                        this.dots[this.currentSlide].classList.add('bg-white/30');
                    }

                    // Update current slide
                    this.currentSlide = index;

                    // Add active class to new dot
                    if (this.dots[this.currentSlide]) {
                        this.dots[this.currentSlide].classList.add('active');
                        this.dots[this.currentSlide].classList.add('bg-[#01acb6]');
                        this.dots[this.currentSlide].classList.remove('bg-white/30');
                    }

                    // Move carousel
                    const translateX = -this.currentSlide * 100;
                    this.slidesContainer.style.transform = `translateX(${translateX}%)`;

                    console.log('Switched to design slide', index);
                },

                nextSlide() {
                    const nextIndex = (this.currentSlide + 1) % this.slides.length;
                    this.goToSlide(nextIndex);
                },

                prevSlide() {
                    const prevIndex = (this.currentSlide - 1 + this.slides.length) % this.slides.length;
                    this.goToSlide(prevIndex);
                },

                startAutoChange() {
                    this.autoChangeInterval = setInterval(() => {
                        this.nextSlide();
                    }, 4000); // 4 seconds interval to match portfolio style
                    console.log('Design carousel auto-change started');
                },

                stopAutoChange() {
                    if (this.autoChangeInterval) {
                        clearInterval(this.autoChangeInterval);
                        this.autoChangeInterval = null;
                    }
                }
            };

            // Initialize the design carousel
            designCarousel.init();

            // Handle visibility change to pause carousel when tab is not visible
            document.addEventListener('visibilitychange', function() {
                if (document.hidden) {
                    designCarousel.stopAutoChange();
                } else {
                    designCarousel.startAutoChange();
                }
            });
        });
    </script>

    <!-- Portfolio Carousel Functionality -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Portfolio carousel functionality
            const portfolioCarousel = {
                currentSlide: 0,
                slides: document.querySelectorAll('.carousel-slide-highlight'),
                dots: document.querySelectorAll('.carousel-dot-highlight'),
                autoChangeInterval: null,

                init() {
                    if (this.slides.length === 0 || this.dots.length === 0) {
                        console.log('Portfolio carousel elements not found');
                        return;
                    }

                    console.log('Initializing portfolio carousel with', this.slides.length, 'slides');

                    // Add click events to dots
                    this.dots.forEach((dot, index) => {
                        dot.addEventListener('click', () => {
                            this.goToSlide(index);
                        });
                    });

                    // Start auto-change every 0.5 seconds (500ms)
                    this.startAutoChange();

                    // Design carousel continues playing even on hover (no pause functionality)
                },

                goToSlide(index) {
                    // Remove active class from current slide and dot
                    this.slides[this.currentSlide].classList.remove('active');
                    this.slides[this.currentSlide].style.opacity = '0';
                    this.dots[this.currentSlide].classList.remove('active');
                    this.dots[this.currentSlide].style.backgroundColor = 'rgba(255, 255, 255, 0.5)';

                    // Update current slide
                    this.currentSlide = index;

                    // Add active class to new slide and dot
                    this.slides[this.currentSlide].classList.add('active');
                    this.slides[this.currentSlide].style.opacity = '1';
                    this.dots[this.currentSlide].classList.add('active');
                    this.dots[this.currentSlide].style.backgroundColor = 'white';
                    this.dots[this.currentSlide].style.transform = 'scale(1.2)';

                    // Reset transform for other dots
                    this.dots.forEach((dot, i) => {
                        if (i !== this.currentSlide) {
                            dot.style.transform = 'scale(1)';
                        }
                    });
                },

                nextSlide() {
                    const nextIndex = (this.currentSlide + 1) % this.slides.length;
                    this.goToSlide(nextIndex);
                },

                startAutoChange() {
                    this.stopAutoChange(); // Clear any existing interval
                    this.autoChangeInterval = setInterval(() => {
                        this.nextSlide();
                    }, 500); // Change every 0.5 seconds as requested
                },

                stopAutoChange() {
                    if (this.autoChangeInterval) {
                        clearInterval(this.autoChangeInterval);
                        this.autoChangeInterval = null;
                    }
                }
            };

            // Initialize the carousel
            portfolioCarousel.init();

            // Handle visibility change to pause carousel when tab is not visible
            document.addEventListener('visibilitychange', function() {
                if (document.hidden) {
                    portfolioCarousel.stopAutoChange();
                } else {
                    portfolioCarousel.startAutoChange();
                }
            });
        });
    </script>

    <!-- Enhanced Hero Carousel Functionality -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Hero carousel functionality
            const heroCarousel = {
                currentSlide: 0,
                slides: document.querySelectorAll('.carousel-slide'),
                dots: document.querySelectorAll('.carousel-dot'),
                nextBtn: document.getElementById('nextSlide'),
                prevBtn: document.getElementById('prevSlide'),
                progressBar: document.getElementById('carouselProgress'),
                autoChangeInterval: null,
                progressInterval: null,
                slideInterval: 6000, // 6 seconds per slide

                init() {
                    if (this.slides.length === 0) {
                        console.log('Hero carousel elements not found');
                        return;
                    }

                    console.log('Initializing hero carousel with', this.slides.length, 'slides');

                    // Set up event listeners
                    this.setupEventListeners();

                    // Start auto change and progress
                    this.startAutoChange();
                    this.startProgress();

                    // Initialize first slide
                    this.updateSlide(0);
                },

                setupEventListeners() {
                    // Dot navigation
                    this.dots.forEach((dot, index) => {
                        dot.addEventListener('click', () => {
                            this.goToSlide(index);
                        });
                    });

                    // Arrow navigation
                    if (this.nextBtn) {
                        this.nextBtn.addEventListener('click', () => {
                            this.nextSlide();
                        });
                    }

                    if (this.prevBtn) {
                        this.prevBtn.addEventListener('click', () => {
                            this.prevSlide();
                        });
                    }

                    // Carousel continues playing even on hover (no pause functionality)

                    // Keyboard navigation
                    document.addEventListener('keydown', (e) => {
                        if (e.key === 'ArrowLeft') {
                            this.prevSlide();
                        } else if (e.key === 'ArrowRight') {
                            this.nextSlide();
                        }
                    });
                },

                goToSlide(index) {
                    if (index === this.currentSlide) return;

                    // Remove active class from current slide and dot
                    this.slides[this.currentSlide].classList.remove('active');
                    this.dots[this.currentSlide].classList.remove('active');

                    // Update current slide
                    this.currentSlide = index;

                    // Add active class to new slide and dot
                    this.slides[this.currentSlide].classList.add('active');
                    this.dots[this.currentSlide].classList.add('active');

                    // Restart auto change and progress
                    this.startAutoChange();
                    this.startProgress();
                },

                updateSlide(index) {
                    this.goToSlide(index);
                },

                nextSlide() {
                    const nextIndex = (this.currentSlide + 1) % this.slides.length;
                    this.goToSlide(nextIndex);
                },

                prevSlide() {
                    const prevIndex = (this.currentSlide - 1 + this.slides.length) % this.slides.length;
                    this.goToSlide(prevIndex);
                },

                startAutoChange() {
                    this.stopAutoChange();
                    this.autoChangeInterval = setInterval(() => {
                        this.nextSlide();
                    }, this.slideInterval);
                },

                stopAutoChange() {
                    if (this.autoChangeInterval) {
                        clearInterval(this.autoChangeInterval);
                        this.autoChangeInterval = null;
                    }
                },

                startProgress() {
                    this.stopProgress();
                    if (this.progressBar) {
                        this.progressBar.style.width = '0%';
                        let width = 0;
                        const increment = 100 / (this.slideInterval / 100);

                        this.progressInterval = setInterval(() => {
                            width += increment;
                            if (width >= 100) {
                                width = 0;
                            }
                            this.progressBar.style.width = width + '%';
                        }, 100);
                    }
                },

                stopProgress() {
                    if (this.progressInterval) {
                        clearInterval(this.progressInterval);
                        this.progressInterval = null;
                    }
                }
            };

            // Initialize the hero carousel
            heroCarousel.init();

            // Handle visibility change to pause carousel when tab is not visible
            document.addEventListener('visibilitychange', function() {
                if (document.hidden) {
                    heroCarousel.stopAutoChange();
                    heroCarousel.stopProgress();
                } else {
                    heroCarousel.startAutoChange();
                    heroCarousel.startProgress();
                }
            });
        });
    </script>

    <!-- Timeline Scroll Animation Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Timeline scroll animations
            const timelineItems = document.querySelectorAll('.timeline-item');
            const timelineProgress = document.querySelector('.timeline-progress');

            // Track scroll direction with debouncing for better performance
            let lastScrollTop = 0;
            let isScrollingDown = true;
            let scrollTimeout;

            window.addEventListener('scroll', () => {
                clearTimeout(scrollTimeout);
                scrollTimeout = setTimeout(() => {
                    const st = window.pageYOffset || document.documentElement.scrollTop;
                    if (Math.abs(lastScrollTop - st) > 5) { // Only update if significant scroll change
                        isScrollingDown = st > lastScrollTop;
                        lastScrollTop = st <= 0 ? 0 : st;
                    }
                }, 10);
            });

            // Track animated elements to prevent re-animation
            const animatedElements = new Set();

            // Create intersection observer for timeline items (only animate when scrolling down)
            const timelineObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    const element = entry.target;

                    // Only trigger animations when scrolling down and element hasn't been animated yet
                    if (entry.isIntersecting &&
                        isScrollingDown &&
                        !element.classList.contains('animate-in') &&
                        !animatedElements.has(element) &&
                        !element.hasAttribute('data-animated')) {

                        // Mark element as animated in multiple ways to prevent re-animation
                        element.classList.add('animate-in');
                        element.setAttribute('data-animated', 'true');
                        animatedElements.add(element);

                        // Add sweep animation to timeline content
                        const timelineContent = element.querySelector('.timeline-content');
                        if (timelineContent) {
                            setTimeout(() => {
                                timelineContent.classList.add('animate-sweep');
                                timelineContent.setAttribute('data-swept', 'true');
                            }, 300); // Delay the sweep animation slightly after the main animation
                        }

                        // Update timeline progress based on visible items
                        updateTimelineProgress();

                        // Stop observing this element since it's now permanently animated
                        timelineObserver.unobserve(element);
                    }
                });
            }, {
                threshold: 0.3,
                rootMargin: '-50px 0px'
            });

            // Observe all timeline items
            timelineItems.forEach(item => {
                timelineObserver.observe(item);
            });

            // Function to update timeline progress
            function updateTimelineProgress() {
                const visibleItems = document.querySelectorAll('.timeline-item.animate-in');
                const totalItems = timelineItems.length;
                const progressPercentage = (visibleItems.length / totalItems) * 100;

                if (timelineProgress) {
                    timelineProgress.style.height = progressPercentage + '%';
                }
            }

            // GSAP ScrollTrigger for enhanced animations (if available)
            if (typeof gsap !== 'undefined' && gsap.registerPlugin) {
                gsap.registerPlugin(ScrollTrigger);

                // Animate timeline title
                gsap.fromTo('.timeline-title', {
                    opacity: 0,
                    y: -50
                }, {
                    opacity: 1,
                    y: 0,
                    duration: 1,
                    ease: 'power3.out',
                    scrollTrigger: {
                        trigger: '.timeline-title',
                        start: 'top 80%',
                        end: 'bottom 20%',
                        toggleActions: 'play none none none'
                    }
                });

                // Enhanced timeline items animation
                timelineItems.forEach((item, index) => {
                    const isEven = index % 2 === 0;

                    gsap.fromTo(item, {
                        opacity: 0,
                        x: isEven ? -100 : 100,
                        y: -50
                    }, {
                        opacity: 1,
                        x: 0,
                        y: 0,
                        duration: 0.6,
                        ease: 'power3.out',
                        scrollTrigger: {
                            trigger: item,
                            start: 'top 95%',
                            end: 'bottom 15%',
                            toggleActions: 'play none none none',
                            once: true
                        }
                    });
                });

                // Timeline progress line animation
                if (timelineProgress) {
                    gsap.fromTo(timelineProgress, {
                        height: '0%'
                    }, {
                        height: '100%',
                        duration: 2,
                        ease: 'power2.out',
                        scrollTrigger: {
                            trigger: '#timeline',
                            start: 'top 60%',
                            end: 'bottom 40%',
                            scrub: 1
                        }
                    });
                }
            }
        });
    </script>

    <!-- Process Timeline Live Animation Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Process timeline animations
            const processSteps = document.querySelectorAll('.process-step');
            const processTimelineProgress = document.querySelector('.process-timeline-progress');
            let activeProcessStep = 0;
            let processInterval;

            // Create intersection observer for process steps
            const processObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate-in');
                        updateProcessProgress();

                        // Start live animation when first step is visible
                        if (entry.target.dataset.step === '1' && !processInterval) {
                            startLiveProcessAnimation();
                        }
                    }
                });
            }, {
                threshold: 0.3,
                rootMargin: '-50px 0px'
            });

            // Observe all process steps
            processSteps.forEach(step => {
                processObserver.observe(step);
            });

            // Function to update process timeline progress
            function updateProcessProgress() {
                const visibleSteps = document.querySelectorAll('.process-step.animate-in');
                const totalSteps = processSteps.length;
                const progressPercentage = (visibleSteps.length / totalSteps) * 100;

                if (processTimelineProgress) {
                    processTimelineProgress.style.height = progressPercentage + '%';
                }
            }

            // Live process animation
            function startLiveProcessAnimation() {
                processInterval = setInterval(() => {
                    // Highlight current step
                    processSteps.forEach((step, index) => {
                        const stepContent = step.querySelector('.process-content');
                        const stepNumber = step.querySelector('.process-step-number');
                        const stepIcon = step.querySelector('.process-icon');

                        if (index === activeProcessStep) {
                            // Active step styling
                            stepContent.style.transform = 'scale(1.01)';
                            stepContent.style.boxShadow = '0 15px 35px rgba(0, 0, 0, 0.12)';
                            stepNumber.style.animation = 'pulse-number 1s ease-in-out infinite';
                            stepIcon.style.transform = 'scale(1.05) rotate(3deg)';
                        } else {
                            // Reset other steps
                            stepContent.style.transform = 'scale(1)';
                            stepContent.style.boxShadow = '';
                            stepNumber.style.animation = '';
                            stepIcon.style.transform = 'scale(1) rotate(0deg)';
                        }
                    });

                    // Move to next step
                    activeProcessStep = (activeProcessStep + 1) % processSteps.length;
                }, 4000); // Change every 4 seconds
            }

            // Stop animation when user scrolls away
            const processSection = document.getElementById('processus');
            if (processSection) {
                const sectionObserver = new IntersectionObserver((entries) => {
                    entries.forEach(entry => {
                        if (!entry.isIntersecting && processInterval) {
                            clearInterval(processInterval);
                            processInterval = null;

                            // Reset all steps
                            processSteps.forEach(step => {
                                const stepContent = step.querySelector('.process-content');
                                const stepNumber = step.querySelector('.process-step-number');
                                const stepIcon = step.querySelector('.process-icon');

                                stepContent.style.transform = 'scale(1)';
                                stepContent.style.boxShadow = '';
                                stepNumber.style.animation = '';
                                stepIcon.style.transform = 'scale(1) rotate(0deg)';
                            });
                        }
                    });
                }, {
                    threshold: 0.1
                });

                sectionObserver.observe(processSection);
            }

            // GSAP ScrollTrigger for enhanced animations (if available)
            if (typeof gsap !== 'undefined' && gsap.registerPlugin) {
                gsap.registerPlugin(ScrollTrigger);

                // Animate process title
                gsap.fromTo('.process-title', {
                    opacity: 0,
                    y: 50
                }, {
                    opacity: 1,
                    y: 0,
                    duration: 1,
                    ease: 'power3.out',
                    scrollTrigger: {
                        trigger: '.process-title',
                        start: 'top 80%',
                        end: 'bottom 20%',
                        toggleActions: 'play none none reverse'
                    }
                });

                // Enhanced process steps animation
                processSteps.forEach((step, index) => {
                    const isEven = index % 2 === 0;

                    gsap.fromTo(step, {
                        opacity: 0,
                        x: isEven ? -100 : 100,
                        y: -50
                    }, {
                        opacity: 1,
                        x: 0,
                        y: 0,
                        duration: 0.6,
                        ease: 'power3.out',
                        scrollTrigger: {
                            trigger: step,
                            start: 'top 95%',
                            end: 'bottom 15%',
                            toggleActions: 'play none none reverse'
                        }
                    });
                });

                // Process timeline progress animation
                if (processTimelineProgress) {
                    gsap.fromTo(processTimelineProgress, {
                        height: '0%'
                    }, {
                        height: '100%',
                        duration: 2,
                        ease: 'power2.out',
                        scrollTrigger: {
                            trigger: '#processus',
                            start: 'top 60%',
                            end: 'bottom 40%',
                            scrub: 1
                        }
                    });
                }
            }

            // Add click handlers for process steps
            processSteps.forEach((step, index) => {
                step.addEventListener('click', () => {
                    activeProcessStep = index;

                    // Immediately highlight clicked step
                    processSteps.forEach((s, i) => {
                        const stepContent = s.querySelector('.process-content');
                        const stepNumber = s.querySelector('.process-step-number');
                        const stepIcon = s.querySelector('.process-icon');

                        if (i === index) {
                            stepContent.style.transform = 'scale(1.02)';
                            stepContent.style.boxShadow = '0 25px 50px rgba(0, 0, 0, 0.15)';
                            stepNumber.style.animation = 'pulse-number 1s ease-in-out infinite';
                            stepIcon.style.transform = 'scale(1.1) rotate(5deg)';
                        } else {
                            stepContent.style.transform = 'scale(1)';
                            stepContent.style.boxShadow = '';
                            stepNumber.style.animation = '';
                            stepIcon.style.transform = 'scale(1) rotate(0deg)';
                        }
                    });
                });
            });
        });
    </script>

    <!-- Mobile Navigation Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Mobile menu toggle functionality
            const mobileMenuBtn = document.getElementById('mobile-menu-btn');
            const mobileMenu = document.getElementById('mobile-menu');

            if (mobileMenuBtn && mobileMenu) {
                mobileMenuBtn.addEventListener('click', function() {
                    // Toggle the hidden class
                    mobileMenu.classList.toggle('hidden');

                    // Update ARIA attributes for accessibility
                    const isOpen = !mobileMenu.classList.contains('hidden');
                    mobileMenuBtn.setAttribute('aria-expanded', isOpen);

                    // Change icon based on menu state
                    const icon = mobileMenuBtn.querySelector('i');
                    if (icon) {
                        if (isOpen) {
                            icon.setAttribute('data-lucide', 'x');
                        } else {
                            icon.setAttribute('data-lucide', 'menu');
                        }
                        // Refresh Lucide icons
                        if (typeof lucide !== 'undefined') {
                            lucide.createIcons();
                        }
                    }
                });

                // Close mobile menu when clicking on nav links
                const mobileNavLinks = mobileMenu.querySelectorAll('a');
                mobileNavLinks.forEach(link => {
                    link.addEventListener('click', function() {
                        mobileMenu.classList.add('hidden');
                        mobileMenuBtn.setAttribute('aria-expanded', 'false');

                        // Reset icon
                        const icon = mobileMenuBtn.querySelector('i');
                        if (icon) {
                            icon.setAttribute('data-lucide', 'menu');
                            if (typeof lucide !== 'undefined') {
                                lucide.createIcons();
                            }
                        }
                    });
                });

                // Close mobile menu when clicking outside
                document.addEventListener('click', function(event) {
                    const isClickInsideMenu = mobileMenu.contains(event.target);
                    const isClickOnButton = mobileMenuBtn.contains(event.target);

                    if (!isClickInsideMenu && !isClickOnButton && !mobileMenu.classList.contains('hidden')) {
                        mobileMenu.classList.add('hidden');
                        mobileMenuBtn.setAttribute('aria-expanded', 'false');

                        // Reset icon
                        const icon = mobileMenuBtn.querySelector('i');
                        if (icon) {
                            icon.setAttribute('data-lucide', 'menu');
                            if (typeof lucide !== 'undefined') {
                                lucide.createIcons();
                            }
                        }
                    }
                });
            }
        });
    </script>

    <!-- Advanced Carousel JavaScript -->
    <script>
        class AdvancedCarousel {
            constructor() {
                console.log('AdvancedCarousel constructor called');

                this.carousel = document.getElementById('carousel');
                this.dotsContainer = document.getElementById('dotsContainer');
                this.prevBtn = document.getElementById('prevBtn');
                this.nextBtn = document.getElementById('nextBtn');

                console.log('Carousel elements found:', {
                    carousel: !!this.carousel,
                    dotsContainer: !!this.dotsContainer,
                    prevBtn: !!this.prevBtn,
                    nextBtn: !!this.nextBtn
                });

                if (!this.carousel) {
                    console.log('No carousel found, exiting');
                    return; // Exit if carousel doesn't exist on this page
                }

                this.currentIndex = 0;
                this.cardWidth = 370; // 350px width + 20px gap
                this.visibleDotsCount = 5;
                this.dotsStartIndex = 0;

                console.log('Initializing carousel...');
                this.init();
            }

            init() {
                this.cards = Array.from(this.carousel.children);
                this.totalSlides = this.cards.length;

                if (this.totalSlides === 0) return;

                this.setupImages();
                this.generateDots();
                this.updateCarousel();
                this.attachEventListeners();
                this.updateNavigationButtons();
                this.startAutoPlay();
            }

            setupImages() {
                console.log('Setting up images for', this.cards.length, 'cards');

                this.cards.forEach((card, index) => {
                    const placeholder = card.querySelector('.advanced-loading-placeholder');
                    const img = card.querySelector('img');

                    if (img && placeholder) {
                        console.log('Setting up image for card', index, 'with src:', img.src);

                        // Check if image is already loaded (for cached images)
                        if (img.complete && img.naturalHeight !== 0) {
                            console.log('Image already loaded for card', index);
                            placeholder.style.display = 'none';
                            return;
                        }

                        // Show image when loaded, hide placeholder
                        img.onload = () => {
                            console.log('Image loaded successfully for card', index);
                            if (placeholder) {
                                placeholder.style.display = 'none';
                            }
                        };

                        // Handle image load error
                        img.onerror = () => {
                            console.error('Image failed to load for card', index, 'src:', img.src);
                            if (placeholder) {
                                placeholder.textContent = 'Failed to load';
                                placeholder.style.background = 'linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%)';
                            }
                        };

                        // For already loaded images (immediate check)
                        setTimeout(() => {
                            if (img.complete && img.naturalHeight !== 0) {
                                console.log('Image was already loaded (delayed check) for card', index);
                                if (placeholder) {
                                    placeholder.style.display = 'none';
                                }
                            }
                        }, 100);
                    } else {
                        console.warn('Missing image or placeholder for card', index);
                    }
                });
            }

            generateDots() {
                if (!this.dotsContainer) return;

                this.dotsContainer.innerHTML = '';

                for (let i = 0; i < this.totalSlides; i++) {
                    const dot = document.createElement('div');
                    dot.className = 'advanced-dot';
                    dot.dataset.index = i;
                    dot.addEventListener('click', () => this.goToSlide(i));
                    this.dotsContainer.appendChild(dot);
                }

                this.dots = Array.from(this.dotsContainer.children);
                this.updateDotsVisibility();
            }

            updateDotsVisibility() {
                if (!this.dots) return;

                // Hide all dots first
                this.dots.forEach(dot => {
                    dot.style.display = 'none';
                    dot.classList.remove('center', 'adjacent', 'outer');
                });

                // Calculate the range of dots to show
                let start = Math.max(0, this.currentIndex - 2);
                let end = Math.min(this.totalSlides - 1, start + 4);

                // Adjust if we're near the end
                if (end - start < 4 && this.totalSlides >= 5) {
                    start = Math.max(0, end - 4);
                }

                // Show and style the visible dots
                for (let i = start; i <= end; i++) {
                    const dot = this.dots[i];
                    if (dot) {
                        dot.style.display = 'block';

                        const relativePos = i - start;
                        const centerPos = Math.floor((end - start) / 2);

                        if (i === this.currentIndex) {
                            dot.classList.add('center');
                        } else if (Math.abs(relativePos - centerPos) === 1) {
                            dot.classList.add('adjacent');
                        } else {
                            dot.classList.add('outer');
                        }
                    }
                }
            }

            updateCarousel() {
                if (!this.carousel) return;

                const translateX = -this.currentIndex * this.cardWidth;
                this.carousel.style.transform = `translateX(${translateX}px)`;
                this.updateDotsVisibility();
            }

            updateNavigationButtons() {
                if (this.prevBtn) this.prevBtn.disabled = this.currentIndex === 0;
                if (this.nextBtn) this.nextBtn.disabled = this.currentIndex === this.totalSlides - 1;
            }

            goToSlide(index) {
                if (index >= 0 && index < this.totalSlides) {
                    this.currentIndex = index;
                    this.updateCarousel();
                    this.updateNavigationButtons();
                }
            }

            nextSlide() {
                if (this.currentIndex < this.totalSlides - 1) {
                    this.goToSlide(this.currentIndex + 1);
                }
            }

            prevSlide() {
                if (this.currentIndex > 0) {
                    this.goToSlide(this.currentIndex - 1);
                }
            }

            startAutoPlay() {
                this.stopAutoPlay(); // Clear any existing interval
                this.autoPlayInterval = setInterval(() => {
                    if (this.currentIndex >= this.totalSlides - 1) {
                        // Reset to first slide when reaching the end
                        this.goToSlide(0);
                    } else {
                        this.nextSlide();
                    }
                }, 4000); // Move every 1 second
            }

            stopAutoPlay() {
                if (this.autoPlayInterval) {
                    clearInterval(this.autoPlayInterval);
                    this.autoPlayInterval = null;
                }
            }

            attachEventListeners() {
                if (this.prevBtn) {
                    this.prevBtn.addEventListener('click', () => {
                        this.stopAutoPlay();
                        this.prevSlide();
                        this.startAutoPlay();
                    });
                }
                if (this.nextBtn) {
                    this.nextBtn.addEventListener('click', () => {
                        this.stopAutoPlay();
                        this.nextSlide();
                        this.startAutoPlay();
                    });
                }

                // Pause auto-play on hover
                if (this.carousel.parentElement) {
                    this.carousel.parentElement.addEventListener('mouseenter', () => {
                        this.stopAutoPlay();
                    });
                    this.carousel.parentElement.addEventListener('mouseleave', () => {
                        this.startAutoPlay();
                    });
                }

                // Card click events
                this.cards.forEach((card, index) => {
                    card.addEventListener('click', (e) => {
                        // If clicked directly on the card (not the link icon)
                        if (!e.target.closest('.link-icon')) {
                            const link = card.dataset.link;
                            if (link) {
                                window.location.href = link;
                            }
                        }
                    });

                    // Link icon click events
                    const linkIcon = card.querySelector('.link-icon');
                    if (linkIcon) {
                        linkIcon.addEventListener('click', (e) => {
                            e.stopPropagation(); // Prevent card click
                            const link = card.dataset.link;
                            if (link) {
                                window.open(link, '_blank');
                            }
                        });
                    }
                });

                // Keyboard navigation
                document.addEventListener('keydown', (e) => {
                    if (e.key === 'ArrowLeft') {
                        this.stopAutoPlay();
                        this.prevSlide();
                        this.startAutoPlay();
                    } else if (e.key === 'ArrowRight') {
                        this.stopAutoPlay();
                        this.nextSlide();
                        this.startAutoPlay();
                    }
                });

                // Touch/swipe support for mobile
                let startX = 0;
                let isDragging = false;

                if (this.carousel) {
                    this.carousel.addEventListener('touchstart', (e) => {
                        startX = e.touches[0].clientX;
                        isDragging = true;
                        this.stopAutoPlay();
                    });

                    this.carousel.addEventListener('touchmove', (e) => {
                        if (!isDragging) return;
                        e.preventDefault();
                    });

                    this.carousel.addEventListener('touchend', (e) => {
                        if (!isDragging) return;

                        const endX = e.changedTouches[0].clientX;
                        const diff = startX - endX;

                        if (Math.abs(diff) > 50) { // Minimum swipe distance
                            if (diff > 0) {
                                this.nextSlide();
                            } else {
                                this.prevSlide();
                            }
                        }

                        isDragging = false;
                        this.startAutoPlay();
                    });
                }
            }
        }

        // Initialize carousel when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            new AdvancedCarousel();
        });
    </script>
</body>

</html>