<!DOCTYPE html>
<html lang="en">

<head
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
    <style>
        .imgs{
            border-radius: 5px;
        }
        .header-blur {
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            background: rgba(0, 0, 0, 0.8);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-menu {
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            background: rgba(0, 0, 0, 0.95);
        }

        .mobile-menu.hidden {
            transform: translateX(100%);
            opacity: 0;
        }

        .mobile-menu:not(.hidden) {
            transform: translateX(0);
            opacity: 1;
        }

        .marquee-wrapper {
            overflow: hidden;
            white-space: nowrap;
            position: relative;
            width: 100vw;
            padding: 15px 0;
            margin: 0 0 30px 0;
            left: 50%;
            transform: translateX(-50%);
        }

        @media (min-width: 640px) {
            .marquee-wrapper {
                padding: 18px 0;
                margin: 0 0 40px 0;
            }
        }

        @media (min-width: 1024px) {
            .marquee-wrapper {
                padding: 22px 0;
                margin: 0 0 50px 0;
            }
        }

        .marquee-track {
            display: inline-flex;
            animation: marquee 70s linear infinite;
            align-items: center;
            gap: 4rem;
        }

        .marquee-logo {
            height: auto;
            width: 80px;
            opacity: 0.7;
            transition: opacity 0.3s ease;
            filter: brightness(0) invert(1);
            flex-shrink: 0;
        }

        @media (min-width: 480px) {
            .marquee-logo {
                width: 100px;
            }
        }

        @media (min-width: 768px) {
            .marquee-logo {
                width: 120px;
            }
        }

        @media (min-width: 1024px) {
            .marquee-logo {
                width: 150px;
            }
        }

        .marquee-logo:hover {
            opacity: 1;
        }

        @keyframes marquee {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-50%);
            }
        }

        /* Scroll to top button */
        #scroll-to-top {
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        #scroll-to-top.visible {
            opacity: 1;
            visibility: visible;
        }

        /* Enhanced mobile-first responsive footer layout */
        .footer-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .footer-map-container {
            grid-column: span 1;
        }

        @media (min-width: 640px) {
            .footer-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 2rem;
            }

            .footer-map-container {
                grid-column: span 2;
            }
        }

        @media (min-width: 1024px) {
            .footer-grid {
                grid-template-columns: repeat(5, 1fr);
                gap: 1rem;
            }

            .footer-map-container {
                grid-column: span 3;
            }
        }

        /* Fixed desktop social media and Meta image positioning */
        .footer-social {
            justify-content: center;
            gap: 1rem;
            flex-wrap: wrap;
            display: flex;
            align-items: center;
        }

        .footer-social a {
            padding: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 0.75rem;
            transition: all 0.3s ease;
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .footer-social a:hover {
            transform: translateY(-2px);
            border-color: #01acb6;
            background: rgba(1, 172, 182, 0.1);
        }

        /* Hide mobile Meta image on desktop */
        .meta-image-mobile {
            display: none;
        }

        /* Show Meta image in Services section on desktop */
        .footer-grid > div:first-child img {
            display: block;
            width: 150px;
            height: auto;
            margin-top: 1rem;
        }

        .footer-bottom {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 2rem;
            text-align: center;
            padding: 2rem 0;
            background: rgba(255, 255, 255, 0.02);
            margin-top: 2rem;
        }

        .footer-links {
            display: flex;
            gap: 1rem;
            align-items: center;
            flex-wrap: wrap;
            justify-content: center;
        }

        .footer-links a {
            padding: 0.5rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 0.5rem;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            color: rgba(255, 255, 255, 0.8);
            font-size: 0.875rem;
        }

        .footer-links a:hover {
            background: rgba(1, 172, 182, 0.1);
            border-color: #01acb6;
            color: #01acb6;
            transform: translateY(-1px);
        }

        .footer-copyright {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.7);
        }

        /* Tablet-specific improvements */
        @media (min-width: 768px) and (max-width: 1023px) {
            .footer-grid > div h3 {
                font-size: 1rem;
                margin-bottom: 1rem;
            }

            .footer-grid > div ul li a {
                font-size: 0.875rem;
            }
        }

        /* Major mobile layout improvements for better organization */
        @media (max-width: 767px) {
            /* Complete mobile footer restructure to match reference design */
            .footer-grid {
                grid-template-columns: 1fr;
                gap: 0;
                padding: 0 0.2rem;
            }

            .footer-grid > div.col-span-2 {
                grid-column: span 1;
            }

            .footer-map-container {
                grid-column: span 1;
                margin-top: 0;
                order: 4; /* Move map to bottom on mobile */
            }

            /* Clean section styling matching reference */
            .footer-grid > div {
                text-align: left;
                padding: 0.5rem 0;
                background: transparent;
                border-radius: 0;
                border: none;
                border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            }

            .footer-grid > div:last-child {
                border-bottom: none;
            }

            .footer-grid h3 {
                text-align: left;
                font-size: 1.125rem;
                margin-bottom: 1rem;
                color: #ffffff;
                font-weight: 600;
                text-transform: none;
            }

            .footer-grid ul {
                display: flex;
                flex-direction: column;
                align-items: flex-start;
                gap: 0.75rem;
                list-style: none;
                padding: 0;
                margin: 0;
            }

            .footer-grid ul li {
                width: 100%;
            }

            .footer-grid ul li a {
                font-size: 0.9rem;
                padding: 0;
                display: block;
                border-radius: 0;
                transition: all 0.3s ease;
                background: transparent;
                border: none;
                color: rgba(255, 255, 255, 0.7);
                line-height: 1.5;
            }

            .footer-grid ul li a:hover {
                background: transparent;
                border: none;
                transform: none;
                color: #01acb6;
            }

            /* Improved mobile bottom footer layout to match reference */
            .footer-bottom {
                flex-direction: column;
                gap: 1.5rem;
                text-align: left;
                padding: 1.5rem 1rem;
                background: transparent;
                border-radius: 0;
                margin: 0;
                border: none;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
            }

            /* Mobile-specific social media styling */
            .footer-social {
                justify-content: flex-start;
                gap: 1rem;
                flex-wrap: nowrap;
                order: 1;
                margin-bottom: 1.5rem;
                display: flex;
                align-items: center;
            }

            .footer-social a {
                padding: 0.75rem;
                background: rgba(255, 255, 255, 0.1);
                border: 1px solid rgba(255, 255, 255, 0.2);
                border-radius: 0.5rem;
                transition: all 0.3s ease;
                width: 44px;
                height: 44px;
                display: flex;
                align-items: center;
                justify-content: center;
                flex-shrink: 0;
            }

            .footer-social a:hover {
                transform: none;
                border-color: #01acb6;
                background: rgba(1, 172, 182, 0.1);
            }

            .footer-links {
                flex-direction: column;
                gap: 0.75rem;
                margin-top: 0;
                order: 2;
                align-items: flex-start;
            }

            .footer-links a {
                padding: 0;
                background: transparent;
                border-radius: 0;
                border: none;
                transition: all 0.3s ease;
                color: rgba(255, 255, 255, 0.7);
                font-size: 0.9rem;
            }

            .footer-links a:hover {
                background: transparent;
                border: none;
                color: #01acb6;
            }

            .footer-links span {
                display: none;
            }

            .footer-copyright {
                font-size: 0.85rem;
                order: 3;
                margin-top: 1rem;
                padding-top: 1rem;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
                color: rgba(255, 255, 255, 0.6);
            }

            /* Show Meta image after social media icons on mobile only */
            .meta-image-mobile {
                display: block;
                order: 2;
                margin-bottom: 1.5rem;
                padding: 0 0 1.5rem 0;
                border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            }

            .meta-image-mobile img {
                width: 150px;
                height: auto;
            }

            /* Hide Meta image from Services section on mobile */
            .footer-grid > div:first-child img {
                display: none;
            }
        }

        /* Footer clickability fixes */
        footer * {
            pointer-events: auto;
            position: relative;
            z-index: 1;
        }

        footer a, footer button, footer input, footer iframe {
            pointer-events: auto !important;
            position: relative;
            z-index: 10;
        }

        /* Newsletter section improvements */
        .newsletter-section {
            border-top: 1px solid rgb(51 65 85);
            padding-top: 1rem;
            margin-bottom: 1rem;
            position: relative;
            z-index: 5;
        }

        .newsletter-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 1.5rem;
            align-items: flex-start;
        }

        .newsletter-form {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            align-items: stretch;
        }

        @media (min-width: 640px) {
            .newsletter-form {
                flex-direction: row;
            }
        }

        @media (min-width: 768px) {
            .newsletter-grid {
                grid-template-columns: 1fr 1fr;
                gap: 2rem;
                align-items: center;
            }
        }

        /* Mobile newsletter specific styles */
        @media (max-width: 767px) {
            .newsletter-section {
                padding: 1.5rem 1rem;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
                margin: 0;
            }

            .newsletter-grid h3 {
                font-size: 1.125rem;
                margin-bottom: 0.75rem;
                color: #ffffff;
                font-weight: 600;
            }

            .newsletter-grid p {
                font-size: 0.9rem;
                color: rgba(255, 255, 255, 0.7);
                line-height: 1.5;
            }

            .newsletter-form input {
                width: 100%;
                padding: 0.875rem 1rem;
                font-size: 0.9rem;
                border-radius: 0.5rem;
            }

            .newsletter-form button {
                width: 100%;
                padding: 0.875rem 1rem;
                font-size: 0.9rem;
                border-radius: 0.5rem;
            }
        }

        /* Small mobile screens */
        @media (max-width: 480px) {
            .footer-grid h3 {
                font-size: 1rem;
            }

            .footer-grid ul li a {
                font-size: 0.85rem;
            }

            .newsletter-grid h3 {
                font-size: 1rem;
            }

            .newsletter-grid p {
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<?php
if (!function_exists('getBaseUrl')) {
    function getBaseUrl()
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
        $host = $_SERVER['HTTP_HOST'];
        $script = $_SERVER['SCRIPT_NAME'];

        $basePath = dirname($script);

        return $protocol . $host . $basePath;
    }
}
    $baseUrl = getBaseUrl();
    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : '';
    $isHomepage = isHomepage();
?>


<body class="bg-black text-white">
    <?php $baseUrl = getBaseUrl(); ?>
    <footer class="bg-[#000000] text-white relative" style="z-index: 1000; position: relative; pointer-events: auto;">
        <div class="max-w-7xl mx-auto px-3 sm:px-4 md:px-6 lg:px-8 py-4 sm:py-6 lg:py-8 relative z-10">
            <!-- Logo Marquee Section -->
            <section class="bg-black">
                <div class="max-w-7xl mx-auto px-6">
                    <div class="marquee-wrapper">
                        <div class="marquee-track">
                            <img src="<?php echo $baseUrl . "/logos/africamotors.png"; ?>" alt="Africa Motors" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/apm.png"; ?>" alt="APM" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/bruder.png"; ?>" alt="Bruder" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/coca.png"; ?>" alt="Coca Cola" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/copima.svg"; ?>" alt="Copima" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/creditinfo.png"; ?>" alt="Credit Info" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/dfsk.png"; ?>" alt="DFSK" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/gardenia.png"; ?>" alt="Gardenia" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/gipam.png"; ?>" alt="Gipam" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/grief.png"; ?>" alt="Grief" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/gsk.png"; ?>" alt="GSK" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/hortensia.png"; ?>" alt="Hortensia" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/inara.png"; ?>" alt="Inara" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/ivala.png"; ?>" alt="Ivala" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/iveco.png"; ?>" alt="Iveco" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/lina.png"; ?>" alt="Lina" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/longovis.png"; ?>" alt="Longovis" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/luxa.png"; ?>" alt="Luxa" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/maersk.png"; ?>" alt="Maersk" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/mat.png"; ?>" alt="MAT" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/mazars.png"; ?>" alt="Mazars" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/merinos.png"; ?>" alt="Merinos" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/monjouet.png"; ?>" alt="Mon Jouet" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/nis.png"; ?>" alt="NIS" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/oubaha.png"; ?>" alt="Oubaha" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/preface.png"; ?>" alt="Preface" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/realite.png"; ?>" alt="Realite" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/standsolutions.png"; ?>" alt="Stand Solutions" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/vintro.png"; ?>" alt="Vintro" class="marquee-logo">
                            <!-- Duplicate set for seamless loop -->
                            <img src="<?php echo $baseUrl . "/logos/africamotors.png"; ?>" alt="Africa Motors" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/apm.png"; ?>" alt="APM" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/bruder.png"; ?>" alt="Bruder" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/coca.png"; ?>" alt="Coca Cola" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/copima.svg"; ?>" alt="Copima" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/creditinfo.png"; ?>" alt="Credit Info" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/dfsk.png"; ?>" alt="DFSK" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/gardenia.png"; ?>" alt="Gardenia" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/gipam.png"; ?>" alt="Gipam" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/grief.png"; ?>" alt="Grief" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/gsk.png"; ?>" alt="GSK" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/hortensia.png"; ?>" alt="Hortensia" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/inara.png"; ?>" alt="Inara" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/ivala.png"; ?>" alt="Ivala" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/iveco.png"; ?>" alt="Iveco" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/lina.png"; ?>" alt="Lina" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/longovis.png"; ?>" alt="Longovis" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/luxa.png"; ?>" alt="Luxa" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/maersk.png"; ?>" alt="Maersk" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/mat.png"; ?>" alt="MAT" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/mazars.png"; ?>" alt="Mazars" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/merinos.png"; ?>" alt="Merinos" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/monjouet.png"; ?>" alt="Mon Jouet" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/nis.png"; ?>" alt="NIS" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/oubaha.png"; ?>" alt="Oubaha" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/preface.png"; ?>" alt="Preface" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/realite.png"; ?>" alt="Realite" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/standsolutions.png"; ?>" alt="Stand Solutions" class="marquee-logo">
                            <img src="<?php echo $baseUrl . "/logos/vintro.png"; ?>" alt="Vintro" class="marquee-logo">
                        </div>
                    </div>
                </div>
            </section>

            <div class="footer-grid">
                <div>
                    <h3 class="text-lg font-semibold mb-4 text-white">Services</h3>
                    <ul class="space-y-3">
                        <li><a href="#services" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Développement Web</a></li>
                        <li><a href="#services" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Applications Mobile</a></li>
                        <li><a href="#services" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">E-commerce</a></li>
                        <li><a href="#services" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Design UI/UX</a></li>
                        <li><a href="#services" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">SEO & Marketing</a></li>
                    </ul>
                </div>

                <div>
                    <h3 class="text-lg font-semibold mb-4 text-white">Entreprise</h3>
                    <ul class="space-y-3">
                        <li><a href="#about" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">À propos</a></li>
                        <li><a href="<?php echo $baseUrl . $adminPath . 'project.php'; ?>" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Nos projets</a></li>
                        <li><a href="#about" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Équipe</a></li>
                        <li><a href="#contact" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Carrières</a></li>
                        <li><a href="#projects" class="text-slate-300 hover:text-[#01acb6] transition-colors duration-300 text-sm">Blog</a></li>
                    </ul>
                </div>

                <div class="footer-map-container">
                    <h3 class="text-lg font-semibold mb-4 text-white">Notre Localisation</h3>
                    
                    <div class="bg-slate-800 rounded-lg overflow-hidden border border-slate-700 shadow-lg">
                        <div class="relative">
                            <iframe
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4172.511986204663!2d-7.6334459288526!3d33.552025481445746!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xda7d3d71082704b%3A0x7208176912e231c0!2sMaxmind%20Digital%20Agency!5e0!3m2!1sfr!2sma!4v1755005183125!5m2!1sfr!2sma"
                                width="100%" height="200" style="border:0; pointer-events: auto; position: relative; z-index: 15;" allowfullscreen=""
                                loading="lazy" referrerpolicy="no-referrer-when-downgrade" class="w-full h-48 sm:h-52 lg:h-56" tabindex="0">
                            </iframe>
                        </div>
                        <div class="p-3 sm:p-4 bg-slate-800">
                            <p class="text-slate-300 text-sm flex items-center justify-center sm:justify-start">
                                <i data-lucide="map-pin" class="w-4 h-4 mr-2 text-[#01acb6] flex-shrink-0"></i>
                                <span class="text-center sm:text-left">MaxMind Digital Agency, Casablanca</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-6 sm:mt-8 lg:mt-10 flex flex-wrap sm:flex-nowrap w-full sm:w-auto max-w-[400px] sm:max-w-[200px] gap-2 mx-auto sm:mx-0 sm:ml-5 justify-center sm:justify-start">
                <img class="imgs w-[90px] sm:w-auto h-auto"
                    src="<?php echo $baseUrl . '/logos/meta.jpeg'; ?>"
                    alt="Meta Logo"
                >
                <img class="imgs w-[90px] sm:w-auto h-auto"
                    src="<?php echo $baseUrl . '/imgs/agence_de_developpement_du_digital_logo2.jpg'; ?>"
                    alt="ADD Logo"
                >
            </div>
            <br>
            <!-- Newsletter -->
            <div class="newsletter-section">
                <div class="newsletter-grid">
                    <div>
                        <h3 class="text-xl font-bold mb-2">Restez informé</h3>
                        <p class="text-slate-300">
                            Recevez nos dernières actualités et conseils tech directement dans votre boîte mail.
                        </p>
                    </div>
                    <form id="newsletter-form" novalidate>
                        <div class="newsletter-form">
                        <input type="email" name="email" id="newsletter-email" placeholder="Votre adresse email" required
                            class="flex-1 px-4 py-3 bg-slate-800 border border-[#01acb6]/50 rounded-xl text-white placeholder-slate-400 focus:ring-2 focus:ring-[#01acb6] focus:border-[#01acb6]">
                        <button
                            type="submit"
                            class="px-6 py-3 bg-[#01acb6] rounded-xl font-medium hover:scale-105 transition-transform duration-300 shadow-lg hover:shadow-[#01acb6]/30 whitespace-nowrap">
                            S'abonner
                        </button>
                        </div>
                        <div id="newsletter-error" class="text-red-400 text-sm mt-2 hidden"></div>
                    </form>
                </div>
            </div>

            <!-- Bottom Footer -->
            <div class="footer-bottom">
                <!-- Social Links -->
                <div class="footer-social">
                    <a href="https://www.facebook.com/maxmind.ma/" target="_blank"
                        class="p-3 bg-slate-800 rounded-xl text-slate-300 hover:text-blue-500 hover:bg-slate-700 transition-all duration-300 hover:scale-110">
                        <i data-lucide="facebook" class="w-4 h-4"></i>
                    </a>
                    <a href="https://www.linkedin.com/company/maxmindma/" target="_blank"
                        class="p-3 bg-slate-800 rounded-xl text-slate-300 hover:text-blue-600 hover:bg-slate-700 transition-all duration-300 hover:scale-110">
                        <i data-lucide="linkedin" class="w-4 h-4"></i>
                    </a>
                    <a href="https://www.instagram.com/maxmind.ma/" target="_blank"
                        class="p-3 bg-slate-800 rounded-xl text-slate-300 hover:text-pink-500 hover:bg-slate-700 transition-all duration-300 hover:scale-110">
                        <i data-lucide="instagram" class="w-4 h-4"></i>
                    </a>
                </div>

                <!-- Meta Image -->
                

                <!-- Footer Links and Copyright -->
                <div class="flex flex-col items-center gap-4">
                    <div class="footer-links">
                        <a href="<?php echo $baseUrl . "/mentions-legales.php"; ?>" class="hover:text-[#01acb6] transition-colors">Mentions légales</a>
                        <a href="<?php echo $baseUrl . "/politique_de_confidentialite_max_mind_maroc.php"; ?>" class="hover:text-[#01acb6] transition-colors">Politique de confidentialité</a>
                    </div>
                    <div class="footer-copyright">
                        <p>&copy; 2025 MaxMind. Tous droits réservés.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Scroll to Top Button -->
        <!-- <button id="scroll-to-top"
            class="fixed bottom-8 right-8 p-3 bg-[#01acb6] rounded-full text-white shadow-lg hover:scale-110 transition-all duration-300 z-50 hover:shadow-[#01acb6]/40">
            <i data-lucide="arrow-up" class="w-5 h-5"></i>
        </button> -->

        <!-- Background decoration -->
        <div class="absolute inset-0 opacity-5 pointer-events-none" style="z-index: -1;">
            <div class="absolute top-0 left-1/4 w-96 h-96 bg-[#01acb6] rounded-full mix-blend-multiply filter blur-3xl"></div>
            <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-[#EF234B] rounded-full mix-blend-multiply filter blur-3xl"></div>
        </div>
    </footer>

    <script>
        // Initialize Lucide icons
        lucide.createIcons();

        // Header scroll effect
        const header = document.getElementById('header');
        let lastScrollY = window.scrollY;

        window.addEventListener('scroll', () => {
            const currentScrollY = window.scrollY;

            if (header && currentScrollY > 100) {
                header.classList.add('header-blur');
            } else if (header) {
                header.classList.remove('header-blur');
            }

            lastScrollY = currentScrollY;
        });

        // Mobile menu functionality
        const mobileMenuBtn = document.getElementById('mobile-menu-btn');
        const mobileMenu = document.getElementById('mobile-menu');
        const mobileMenuClose = document.getElementById('mobile-menu-close');

        function toggleMobileMenu() {
            if (mobileMenu) {
                mobileMenu.classList.toggle('hidden');
            }
        }

        if (mobileMenuBtn) {
            mobileMenuBtn.addEventListener('click', toggleMobileMenu);
        }

        if (mobileMenuClose) {
            mobileMenuClose.addEventListener('click', toggleMobileMenu);
        }

        // Close mobile menu when clicking on links
        if (mobileMenu) {
            const mobileMenuLinks = mobileMenu.querySelectorAll('a');
            mobileMenuLinks.forEach(link => {
                link.addEventListener('click', () => {
                    mobileMenu.classList.add('hidden');
                });
            });
        }

        // Scroll to top functionality
        const scrollToTopBtn = document.getElementById('scroll-to-top');

        window.addEventListener('scroll', () => {
            if (window.scrollY > 300) {
                scrollToTopBtn.classList.add('visible');
            } else {
                scrollToTopBtn.classList.remove('visible');
            }
        });

        scrollToTopBtn.addEventListener('click', () => {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Newsletter form functionality
        const newsletterForm = document.getElementById('newsletter-form');
        const newsletterEmail = document.getElementById('newsletter-email');
        const newsletterError = document.getElementById('newsletter-error');

        function validateEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        function showNewsletterError(message) {
            newsletterError.textContent = message;
            newsletterError.classList.remove('hidden');
            newsletterEmail.classList.add('border-red-500');
        }

        function hideNewsletterError() {
            newsletterError.classList.add('hidden');
            newsletterEmail.classList.remove('border-red-500');
        }

        function showAlert(message, type = 'success') {
            const alertContainer = document.createElement('div');
            alertContainer.className = `fixed top-4 right-4 z-[9999] p-4 rounded-lg shadow-lg border max-w-md transform transition-all duration-300 opacity-0 scale-95`;

            if (type === 'success') {
                alertContainer.classList.add('bg-green-900', 'border-green-700', 'text-green-100');
            } else {
                alertContainer.classList.add('bg-red-900', 'border-red-700', 'text-red-100');
            }

            alertContainer.innerHTML = `
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <i data-lucide="${type === 'success' ? 'check-circle' : 'x-circle'}" class="w-5 h-5"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium">${message}</p>
                    </div>
                </div>
            `;

            document.body.appendChild(alertContainer);
            lucide.createIcons();

            setTimeout(() => {
                alertContainer.classList.remove('opacity-0', 'scale-95');
                alertContainer.classList.add('opacity-100', 'scale-100');
            }, 10);

            setTimeout(() => {
                alertContainer.classList.add('opacity-0', 'scale-95');
                setTimeout(() => {
                    if (alertContainer.parentNode) {
                        alertContainer.parentNode.removeChild(alertContainer);
                    }
                }, 300);
            }, 2000);
        }

        if (newsletterForm) {
            newsletterForm.addEventListener('submit', async function(e) {
                e.preventDefault();
                hideNewsletterError();

                const email = newsletterEmail.value.trim();

                if (!email) {
                    showNewsletterError('Veuillez saisir votre adresse email');
                    return;
                }

                if (!validateEmail(email)) {
                    showNewsletterError('Veuillez saisir une adresse email valide');
                    return;
                }

                const submitButton = newsletterForm.querySelector('button[type="submit"]');
                const originalText = submitButton.textContent;
                submitButton.textContent = 'Envoi...';
                submitButton.disabled = true;

                try {
                    const formData = new FormData();
                    formData.append('email', email);
                    formData.append('type', 'newsletter');

                    const response = await fetch('<?php echo $baseUrl; ?>/mail/submit-form.php', {
                        method: 'POST',
                        body: formData
                    });

                    const result = await response.json();

                    if (result.status === 'success') {
                        showAlert(result.message, 'success');
                        newsletterForm.reset();
                    } else {
                        showAlert(result.message || 'Une erreur est survenue', 'error');
                    }
                } catch (error) {
                    console.error('Erreur lors de l\'envoi:', error);
                    showAlert('Une erreur est survenue lors de l\'envoi', 'error');
                } finally {
                    submitButton.textContent = originalText;
                    submitButton.disabled = false;
                }
            });

            newsletterEmail.addEventListener('input', function() {
                hideNewsletterError();
            });
        }
    </script>
</body>

</html>
