<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MaxMind - Navigation Only</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', '-apple-system', 'sans-serif'],
                        display: ['Space Grotesk', 'Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        }
                    }
                }
            }
        }
    </script>

    <style>
        html {
            scroll-behavior: smooth;
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            line-height: 1.6;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            margin: 0;
            padding: 0;
            width: 100%;
            min-height: 100vh;
            overflow-x: hidden;
            background-color: #f8fafc;
        }

        /* Header with smooth hide/show transitions */
        #mpui1-main-header-container {
            z-index: 9999 !important;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            will-change: transform, background-color, backdrop-filter;
            backdrop-filter: blur(25px);
            background: #1B2638;
            border-bottom: 1px solid #1b263862;
            box-shadow: 0 8px 32px #1b2638d8;
            position: fixed !important;
            top: 0;
            left: 0;
            right: 0;
        }

        /* Enhanced smooth transitions for all header elements */
        #mpui1-main-header-container * {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Modern scrolled state with glassmorphism */
        #mpui1-main-header-container.mpui1-header-scrolled-bg {
            background: #1B2638 !important;
            backdrop-filter: blur(30px) !important;
            border-bottom: 1px solid #1B2638;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5),
                       0 0 0 1px #1B2638 !important;
        }

        /* Enhanced navigation links with advanced animations */
        .mpui1-nav-item-element {
            position: relative;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.75rem;
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
            overflow: hidden;
        }

        .mpui1-nav-item-element::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(1, 172, 182, 0.12);
            transform: scale(0) rotate(45deg);
            transition: all 0.4s cubic-bezier(0.23, 1, 0.32, 1);
            border-radius: 0.75rem;
            z-index: -1;
        }

        .mpui1-nav-item-element::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: #1B2638;
            transform: translate(-50%, -50%);
            transition: all 0.6s cubic-bezier(0.23, 1, 0.32, 1);
            border-radius: 50%;
            z-index: -1;
        }

        .mpui1-nav-item-element:hover::before {
            transform: scale(1.1) rotate(0deg);
        }

        .mpui1-nav-item-element:hover::after {
            width: 100px;
            height: 100px;
        }

        .mpui1-nav-item-element:hover {
            transform: translateY(-3px) scale(1.02);
            text-shadow: 0 0 20px rgba(1, 172, 182, 0.5);
            box-shadow: 0 8px 25px rgba(1, 172, 182, 0.2);
        }

        .mpui1-nav-item-element:hover i {
            transform: scale(1.15) rotate(10deg);
            filter: drop-shadow(0 0 8px rgba(1, 172, 182, 0.4));
        }

        /* Active state for current page */
        .mpui1-nav-item-element.mpui1-nav-current-page {
            background: rgba(1, 172, 182, 0.15);
            color: #01acb6 !important;
            font-weight: 600;
            transform: translateY(-1px);
            box-shadow: 0 4px 15px rgba(1, 172, 182, 0.25);
        }

        .mpui1-nav-item-element i {
            transition: all 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            display: inline-block;
        }

        /* Header entrance animation */
        @keyframes mpui1HeaderEntryAnim {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        #mpui1-main-header-container {
            animation: mpui1HeaderEntryAnim 0.8s cubic-bezier(0.23, 1, 0.32, 1);
        }

        /* Enhanced logo with hover effects */
        #mpui1-main-header-container img {
            transition: all 0.5s cubic-bezier(0.23, 1, 0.32, 1);
            filter: drop-shadow(0 0 10px rgba(1, 172, 182, 0.2));
        }

        #mpui1-main-header-container img:hover {
            transform: scale(1.08) rotate(5deg);
            filter: drop-shadow(0 0 25px rgba(1, 172, 182, 0.6));
        }

        #mpui1-main-header-container.mpui1-header-scrolled-bg img {
            filter: brightness(1.1) drop-shadow(0 0 15px rgba(1, 172, 182, 0.4));
        }

        /* Modern mobile menu button */
        #mpui1-mobile-toggle-btn {
            position: relative;
            padding: 0.75rem;
            border-radius: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        #mpui1-mobile-toggle-btn:hover {
            background: rgba(1, 172, 182, 0.2);
            border-color: rgba(1, 172, 182, 0.4);
            transform: scale(1.05);
        }

        #mpui1-main-header-container.mpui1-header-scrolled-bg #mpui1-mobile-toggle-btn {
            background: rgba(1, 172, 182, 0.1);
            border-color: rgba(1, 172, 182, 0.3);
        }

        /* Enhanced mobile menu */
        #mpui1-mobile-nav-dropdown {
            background: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(1, 172, 182, 0.2);
            border-radius: 1rem;
            margin-top: 1rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            transform: translateY(-10px);
            opacity: 0;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        #mpui1-mobile-nav-dropdown.mpui1-mobile-nav-hidden {
            display: none;
        }

        #mpui1-mobile-nav-dropdown:not(.mpui1-mobile-nav-hidden) {
            display: block;
            transform: translateY(0);
            opacity: 1;
        }

        #mpui1-mobile-nav-dropdown .mpui1-nav-item-element {
            display: block;
            margin: 0.25rem 0;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        #mpui1-mobile-nav-dropdown .mpui1-nav-item-element:hover {
            background: rgba(1, 172, 182, 0.1);
            transform: translateX(10px);
        }
        
        /* Header visible state */
        #mpui1-main-header-container.mpui1-header-show-state {
            transform: translateY(0);
        }

        /* Header hidden state */
        #mpui1-main-header-container.mpui1-header-hide-state {
            transform: translateY(-100%);
        }
    </style>
</head>

<?php 
    // Check if function exists before declaring it to avoid redeclaration errors
    if (!function_exists('getBaseUrl')) {
        function getBaseUrl() {
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
            $host = $_SERVER['HTTP_HOST'];
            $script = $_SERVER['SCRIPT_NAME'];

            $basePath = dirname($script);

            return $protocol . $host . $basePath;
        }
    }

    // Function to determine if we're on the homepage
    if (!function_exists('isHomepage')) {
        function isHomepage() {
            $currentPage = basename($_SERVER['PHP_SELF']);
            $requestUri = $_SERVER['REQUEST_URI'];
            $basePath = dirname($_SERVER['SCRIPT_NAME']);
            
            // Remove base path from request URI to get relative path
            $relativePath = str_replace($basePath, '', $requestUri);
            $relativePath = ltrim($relativePath, '/');
            
            // Check if we're on homepage (index.php or root)
            return ($currentPage === 'index.php' || $relativePath === '' || $relativePath === 'index.php');
        }
    }

    // Function to get the correct link format
    if (!function_exists('getNavLink')) {
        function getNavLink($anchor, $baseUrl) {
            if (isHomepage()) {
                return '#' . $anchor;
            } else {
                return $baseUrl . '#' . $anchor;
            }
        }
    }
?>
<body>
    <!-- Header -->
    <header id="mpui1-main-header-container" class="fixed top-0 left-0 right-0 z-50 transition-all duration-300">
        <div class="max-w-7xl mx-auto px-6 py-4">
            <div class="flex items-center justify-between">
                <?php 
                    $baseUrl = getBaseUrl();
                    $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : '';
                    $isHomepage = isHomepage();
                ?>
                <!-- Logo -->
                <div class="flex items-center space-x-3">
                    <img src="<?php echo $baseUrl . '/imgs/LOGO_MAXMIND_WHITE.png'; ?>" alt="MaxMind Logo" class="h-12 w-auto">
                </div>
                <nav class="max-md:hidden md:flex items-center space-x-2" role="navigation" aria-label="Navigation principale">
                    <a href="<?php echo $baseUrl; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group <?php echo $isHomepage ? 'mpui1-nav-current-page' : ''; ?>">
                        <i data-lucide="home" class="w-4 h-4 inline mr-2"></i>
                        Accueil
                    </a>
                    <a href="<?php echo getNavLink('about', $baseUrl); ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group">
                        
                        À propos
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'services.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group">
                        
                        Services
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'project_web.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group">
                        
                        Projets
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'project_design.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group">
                        
                        Design
                    </a>
                    <a href="<?php echo getNavLink('contact', $baseUrl); ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group">
                        Contact
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'blogs.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] relative group">
                        <i data-lucide="book-open" class="w-4 h-4 inline mr-2"></i>
                        Blog
                    </a>
                </nav>

                <button id="mpui1-mobile-toggle-btn" class="md:hidden text-white" aria-label="Ouvrir le menu de navigation" aria-expanded="false">
                    <i data-lucide="menu" class="w-6 h-6"></i>
                </button>
            </div>

            <!-- Enhanced Mobile menu -->
            <div id="mpui1-mobile-nav-dropdown" class="md:hidden mt-4 p-4 mpui1-mobile-nav-hidden">
                <nav class="flex flex-col space-y-2">
                    <a href="<?php echo $baseUrl; ?>" class="mpui1-nav-item-element <?php echo $isHomepage ? 'mpui1-nav-current-page text-[#01acb6]' : 'text-white/90 hover:text-[#01acb6]'; ?> font-medium flex items-center">
                        <span class="flex mt-1"><i data-lucide="home" class="w-4 h-4 mr-3"></i>
                        Accueil</span>
                    </a>
                    <a href="<?php echo getNavLink('about', $baseUrl); ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] font-medium flex items-center">
                        À propos
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'services.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] font-medium flex items-center">
                        Services
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'project_web.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] font-medium flex items-center">
                        Projets
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'project_design.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] font-medium flex items-center">
                        
                        Design
                    </a>
                    <a href="<?php echo getNavLink('contact', $baseUrl); ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] font-medium flex items-center">
                        
                        Contact
                    </a>
                    <a href="<?php echo $baseUrl . $adminPath . 'blogs.php'; ?>" class="mpui1-nav-item-element text-white/90 hover:text-[#01acb6] font-medium flex items-center">
                        <span class="flex mt-1">
                            <i data-lucide="book-open" class="w-4 h-4 mr-3"></i>
                        Blog
                        </span>
                    </a>
                </nav>
            </div>
        </div>
    </header>

    <?php include 'social-floating.php'; ?>

    <script>
        lucide.createIcons();

        // Header scroll behavior
        document.addEventListener('DOMContentLoaded', function() {
            const mpui1HeaderElement = document.getElementById('mpui1-main-header-container');
            let mpui1PreviousScroll = 0;

            window.addEventListener('scroll', function() {
                const mpui1CurrentScroll = window.pageYOffset || document.documentElement.scrollTop;

                // Add scrolled class when scrolling
                if (mpui1CurrentScroll > 50) {
                    mpui1HeaderElement.classList.add('mpui1-header-scrolled-bg');
                } else {
                    mpui1HeaderElement.classList.remove('mpui1-header-scrolled-bg');
                }

                mpui1PreviousScroll = mpui1CurrentScroll;
            });
        });

        // Mobile menu functionality
        document.addEventListener('DOMContentLoaded', function() {
            const mpui1MobileBtn = document.getElementById('mpui1-mobile-toggle-btn');
            const mpui1MobileDropdown = document.getElementById('mpui1-mobile-nav-dropdown');

            if (mpui1MobileBtn && mpui1MobileDropdown) {
                mpui1MobileBtn.addEventListener('click', function() {
                    // Toggle the hidden class
                    mpui1MobileDropdown.classList.toggle('mpui1-mobile-nav-hidden');

                    // Update ARIA attributes for accessibility
                    const mpui1MenuOpen = !mpui1MobileDropdown.classList.contains('mpui1-mobile-nav-hidden');
                    mpui1MobileBtn.setAttribute('aria-expanded', mpui1MenuOpen);

                    // Change icon based on menu state
                    const mpui1BtnIcon = mpui1MobileBtn.querySelector('i');
                    if (mpui1BtnIcon) {
                        if (mpui1MenuOpen) {
                            mpui1BtnIcon.setAttribute('data-lucide', 'x');
                        } else {
                            mpui1BtnIcon.setAttribute('data-lucide', 'menu');
                        }
                        // Refresh Lucide icons
                        lucide.createIcons();
                    }
                });

                // Close mobile menu when clicking on nav links
                const mpui1MobileLinks = mpui1MobileDropdown.querySelectorAll('a');
                mpui1MobileLinks.forEach(link => {
                    link.addEventListener('click', function() {
                        mpui1MobileDropdown.classList.add('mpui1-mobile-nav-hidden');
                        mpui1MobileBtn.setAttribute('aria-expanded', 'false');

                        // Reset icon
                        const mpui1BtnIcon = mpui1MobileBtn.querySelector('i');
                        if (mpui1BtnIcon) {
                            mpui1BtnIcon.setAttribute('data-lucide', 'menu');
                            lucide.createIcons();
                        }
                    });
                });

                // Close mobile menu when clicking outside
                document.addEventListener('click', function(event) {
                    const mpui1ClickInMenu = mpui1MobileDropdown.contains(event.target);
                    const mpui1ClickOnBtn = mpui1MobileBtn.contains(event.target);

                    if (!mpui1ClickInMenu && !mpui1ClickOnBtn && !mpui1MobileDropdown.classList.contains('mpui1-mobile-nav-hidden')) {
                        mpui1MobileDropdown.classList.add('mpui1-mobile-nav-hidden');
                        mpui1MobileBtn.setAttribute('aria-expanded', 'false');

                        // Reset icon
                        const mpui1BtnIcon = mpui1MobileBtn.querySelector('i');
                        if (mpui1BtnIcon) {
                            mpui1BtnIcon.setAttribute('data-lucide', 'menu');
                            lucide.createIcons();
                        }
                    }
                });
            }
        });

        document.addEventListener('DOMContentLoaded', function() {
            const mpui1NavElements = document.querySelectorAll('.mpui1-nav-item-element');
            const mpui1PageSections = document.querySelectorAll('section[id]');

            function mpui1UpdateActiveLink() {
                let mpui1ActiveSection = '';

                mpui1PageSections.forEach(section => {
                    const mpui1SectionTop = section.getBoundingClientRect().top;
                    const mpui1SectionHeight = section.offsetHeight;
                    
                    if (mpui1SectionTop <= 120 && (mpui1SectionTop + mpui1SectionHeight) > 120) {
                        mpui1ActiveSection = section.getAttribute('id');
                    }
                });

                mpui1NavElements.forEach(link => {
                    link.classList.remove('mpui1-nav-current-page');
                    const href = link.getAttribute('href');
                    
                    // Check if the link matches the active section
                    if (href && (href === '#' + mpui1ActiveSection || href.endsWith('#' + mpui1ActiveSection))) {
                        link.classList.add('mpui1-nav-current-page');
                    }
                });
            }

            window.addEventListener('scroll', mpui1UpdateActiveLink);
            mpui1UpdateActiveLink(); // Initial call
        });
    </script>
</body>

</html>
