<?php

// Enable error reporting for debugging
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Set content type to JSON
header('Content-Type: application/json');

include './PHPMailer.php';
include './SMTP.php';
include './Exception.php';

$mail     = new PHPMailer\PHPMailer\PHPMailer();
$response = [];
$payload  = [];


//Sanitize Post values from SQL injections, etc.
function sanitize_post_params()
{
    // Loop through all POST parameters
    foreach ($_POST as $key => $value) {
        // If the value is an array, recursively call this function
        if (is_array($value)) {
            $_POST[$key] = sanitize_post_params($value);
        } else {
            // Remove whitespace from the beginning and end of the value
            $value = trim($value);
            // Remove backslashes that have been added to escape characters
            $value = stripslashes($value);
            // Convert special characters to HTML entities to prevent XSS attacks
            $value = htmlspecialchars($value, ENT_QUOTES | ENT_HTML5, 'UTF-8');
            // Replace the original value with the sanitized value
            $_POST[$key] = $value;
        }
    }
    return $_POST;
}

sanitize_post_params();

// Set the form values
$nomComplet = isset($_POST['full-name']) ? $_POST['full-name'] : '';
$telephone = isset($_POST['phone-number']) ? $_POST['phone-number'] : '';
$email = isset($_POST['email']) ? $_POST['email'] : '';
$ville = isset($_POST['ville']) ? $_POST['ville'] : '';
$type_demande = isset($_POST['type_demande']) ? $_POST['type_demande'] : '';
$MessageClient = isset($_POST['MessageClient']) ? $_POST['MessageClient'] : '';
$date = date('Y-m-d H:i:s');
$payload = $_POST;
$submission_id = null;

// Database storage temporarily disabled - focus on email sending only
$submission_id = null;

// Get the base URL of the website
$LinkBase = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";

// Function to convert type_demande value to readable text
function getTypeDemandeText($value) {
    $types = [
        'developpement_applicatif' => 'Développement d\'applicatif sur mesure',
        'site_ecommerce' => 'Site E-commerce',
        'marketing_digital' => 'Marketing Digital et Advertising',
        'gestion_reseaux_sociaux' => 'Gestion des réseaux sociaux',
        'seo_sem' => 'SEO - SEM',
        'solution_facturation' => 'Solution de gestion de facturation',
        'gestion_commerciale_crm' => 'Gestion Commerciale/CRM',
        'gestion_stock' => 'Gestion de Stock',
        'systeme_rh' => 'Système de gestion des Ressources Humaines',
        'systeme_salle_sport' => 'Système de gestion de salle de sport'
    ];
    
    return isset($types[$value]) ? $types[$value] : $value;
}

$type_demande_text = getTypeDemandeText($type_demande);

// Workaround for older PHPMailer versions
if (!method_exists('PHPMailer\PHPMailer\SMTP', 'setSMTPUTF8')) {
    class_alias('PHPMailer\PHPMailer\SMTP', 'TempSMTP');
    class SMTP extends TempSMTP {
        public function setSMTPUTF8($enable) {
            // Empty method for compatibility
            return true;
        }
    }
}

// Credentials & Setup for PHPMailer
$mail->isSMTP();
$mail->Host       = 'mail.maxmind.ma';
$mail->SMTPAuth   = true;
$mail->Username   = 'website@maxmind.ma';
$mail->Password   = 'e7U6qftdD9f9YRLd';
$mail->SMTPSecure = 'ssl';
$mail->Port       = 465;

$mail->CharSet    = 'UTF-8';
$mail->Encoding   = "base64";

//Recipients
$mail->setFrom('website@maxmind.ma', 'MaxMind Website');
$mail->addReplyTo($email, $nomComplet);
$mail->addAddress('benjellounzakaria@gmail.com', 'Zakaria Benjelloun');


$mail->Subject = 'Nouveau Lead';
$mail->isHTML(true);
$mail->Body = '
<html>
<head>
    <style type="text/css">
    </style>
</head>
<body>
    <div style="text-align: center; border:0px solid black; border-radius: 10px; padding:10px 20px 10px 20px;">
        <img style="display: block;margin-left: auto;margin-right: auto; width: 20%;" src="' . $LinkBase . '/imgs/LOGO_MAXMIND_BLACK.png" alt="MaxMind">
        <div style="display: inline-block; text-align: left; font-size: 120%;">
            <h3>Vous avez re&ccedil;u un nouveau Lead avec les d&eacute;tails suivants :</h3>
            <p><b style="color:#01acb6">Nom Complet : </b>' . $nomComplet . '</p>
            <p><b style="color:#01acb6">T&eacute;l&eacute;phone : </b>' . $telephone . '</p>
            <p><b style="color:#01acb6">Email : </b>' . $email . '</p>
            <p><b style="color:#01acb6">Ville : </b>' . $ville . '</p>
            <p><b style="color:#01acb6">Type de demande : </b>' . $type_demande_text . '</p>
            <p><b style="color:#01acb6">Message : </b>' . nl2br($MessageClient) . '</p>
        </div>
    </div>
</body>
</html>';

if (!$mail->send()) {
    $response = [
        'status'  => 'error',
        'payload' => $payload,
        'message' => 'Une erreur est survenue lors de l\'envoi de l\'email. Prière de réessayer plus tard.',
        'debug' => $mail->ErrorInfo
    ];
    echo json_encode($response);
    exit();
}

// Database operations temporarily disabled

$response = [
    'status'  => 'success',
    'payload' => $payload,
    'message' => 'Nous avons bien reçu vos informations. Nous vous contacterons bientôt'
];

echo json_encode($response);
exit();