<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Politique de confidentialité | MaxMind – Agence Digitale</title>
  <!--
    Intégration légère :
    - La page s'adapte à n'importe quel design système.
    - Les classes utilitaires sont neutres (prefix mm-*) pour éviter les collisions.
    - Remplacez/complétez les variables CSS dans :root pour parfaitement matcher la charte.
  -->
  <style>
    :root{
      --mm-bg:#0b0f1a;
      --mm-bg-soft:#111729;
      --mm-fg:#eef2ff;
      --mm-fg-dim:#c7cbe0;
      --mm-accent:#5eead4; /* à aligner avec la couleur primaire du site */
      --mm-border:#233045;
      --mm-radius:16px;
      --mm-maxw:1100px;
    }
    html,body{margin:0;padding:0;background:var(--mm-bg);color:var(--mm-fg);font:16px/1.65 system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,"Helvetica Neue",Arial,sans-serif}
    a{color:var(--mm-accent);text-decoration:none}
    a:hover{text-decoration:underline}
    .mm-wrap{max-width:var(--mm-maxw);margin-inline:auto;padding:32px 20px}
    .mm-hero{padding:72px 20px 32px;background:linear-gradient(180deg,rgba(94,234,212,.08),rgba(94,234,212,0));border-bottom:1px solid var(--mm-border)}
    .mm-kicker{letter-spacing:.15em;text-transform:uppercase;color:var(--mm-fg-dim);font-weight:600}
    h1{font-size:clamp(28px,4vw,44px);margin:.3em 0 .2em}
    .mm-meta{color:var(--mm-fg-dim);font-size:14px}
    .mm-grid{display:grid;gap:18px}
    @media(min-width:900px){.mm-grid{grid-template-columns:260px 1fr}}
    .mm-card{background:var(--mm-bg-soft);border:1px solid var(--mm-border);border-radius:var(--mm-radius);padding:20px}
    h2{font-size:clamp(20px,2.6vw,26px);margin:0 0 .4em}
    h3{font-size:18px;margin:1.2em 0 .3em}
    .mm-toc ul{list-style:none;padding:0;margin:0}
    .mm-toc li{padding:10px 12px;border:1px solid var(--mm-border);border-radius:12px;margin-bottom:10px;background:#0e1424}
    .mm-badge{display:inline-flex;align-items:center;gap:8px;padding:6px 10px;border:1px solid var(--mm-border);border-radius:999px;background:#0f172a;color:var(--mm-fg-dim);font-size:12px}
    .mm-note{font-size:14px;color:var(--mm-fg-dim)}
    .mm-table{width:100%;border-collapse:collapse}
    .mm-table th,.mm-table td{border:1px solid var(--mm-border);padding:12px;vertical-align:top}
    .mm-table th{background:#0e1424;text-align:left}
    .mm-callout{border-left:3px solid var(--mm-accent);padding:12px 16px;background:#0e1424;border-radius:8px}
    .title{ font-size: 40px; font-weight: bold;}
    .lisss{color: #01ACB6;}
    .title2{ font-size: 20px;}
  </style>
</head>
<body>
  <header class="mm-hero">
    <div class="mm-wrap">
      <div class="mm-kicker">Protection des données</div>
      <h1 class="title">Politique de confidentialité</h1>
      <p class="mm-meta">Version du <time datetime="2025-09-25">25 septembre 2025</time> · Responsable de traitement : MaxMind Digital Agency, Casablanca (Maroc)</p>
      <div style="margin-top:10px" class="mm-badge">Conforme à la Loi marocaine n° 09-08 (CNDP)</div>
    </div>
  </header>
  <?php include 'header.php'; ?>

  <main class="mm-wrap mm-grid" id="contenu">
    <aside class="mm-card mm-toc">
      <h2>Sommaire</h2>
      <ul>
        <li class="lisss"><a href="#qui">Qui sommes-nous ?</a></li>
        <li class="lisss"><a href="#donnees">Quelles données collectons‑nous ?</a></li>
        <li class="lisss"><a href="#finalites">Finalités & bases légales</a></li>
        <li class="lisss"><a href="#cookies">Cookies & traceurs</a></li>
        <li class="lisss"><a href="#destinataires">Destinataires & sous‑traitants</a></li>
        <li class="lisss"><a href="#transferts">Transferts hors Maroc</a></li>
        <li class="lisss"><a href="#durees">Durées de conservation</a></li>
        <li class="lisss"><a href="#droits">Vos droits (Loi 09‑08)</a></li>
        <li class="lisss"><a href="#securite">Sécurité</a></li>
        <li class="lisss"><a href="#mineurs">Mineurs</a></li>
        <li class="lisss"><a href="#maj">Mises à jour</a></li>
        <li class="lisss"><a href="#contact">Contact CNDP & MaxMind</a></li>
      </ul>
    </aside>

    <section class="mm-card">
      <h2 id="qui" class="title2">1) Qui sommes‑nous ?</h2>
      <p>MaxMind Digital Agency (« MaxMind », « nous ») est une agence digitale établie au Maroc : Imm Soft City, Oasis, Office 17, 3e étage, Casablanca 20180. Email : <a href="mailto:contact@maxmind.ma">contact@maxmind.ma</a> – Tél. : +212 620 15 12 53.</p>
      <p>Nous agissons en qualité de <strong>responsable du traitement</strong> pour les traitements décrits aux présentes. Lorsque nous opérons pour le compte de nos clients, nous intervenons comme <strong>sous‑traitant</strong> et appliquons leurs instructions contractuelles.</p>

      <h2 id="donnees" class="title2">2) Quelles données collectons‑nous ?</h2>
      <table class="mm-table">
        <thead><tr><th>Catégories</th><th>Exemples</th><th>Origine</th></tr></thead>
        <tbody>
          <tr><td>Données d’identification</td><td>Nom, prénom, société, fonction</td><td>Formulaires « Contact » et « Devis », échanges email/téléphone</td></tr>
          <tr><td>Données de contact</td><td>Email, téléphone, adresse professionnelle</td><td>Formulaires, devis, support</td></tr>
          <tr><td>Données de navigation</td><td>Pages vues, événements, identifiants de session, adresse IP abrégée/anonymisée lorsque possible</td><td>Cookies/traceurs nécessaires et de mesure d’audience</td></tr>
          <tr><td>Données commerciales</td><td>Besoins projet, budget indicatif, historique des échanges et propositions</td><td>Qualification commerciale</td></tr>
          <tr><td>Données techniques</td><td>Type d’appareil, navigateur, logs</td><td>Serveurs et outils d’hébergement</td></tr>
        </tbody>
      </table>

      <h2 id="finalites" class="title2">3) Finalités & bases légales</h2>
      <p>Conformément à la Loi n° 09‑08, les traitements reposent sur des bases légales telles que le <strong>consentement</strong>, l’<strong>exécution d’un contrat</strong> ou de mesures précontractuelles, et l’<strong>intérêt légitime</strong> dûment mis en balance avec vos droits et libertés.</p>
      <div class="mm-callout">
        <strong>Principales finalités</strong> : (i) gestion des demandes (contact, devis), (ii) prospection B2B avec consentement lorsqu’exigé, (iii) amélioration du site et mesure d’audience, (iv) exécution des contrats et suivi clients, (v) sécurité et prévention de la fraude, (vi) obligations légales (facturation, comptabilité).
      </div>

      <h2 id="cookies" class="title2">4) Cookies & traceurs</h2>
      <p>Les cookies strictement nécessaires sont déposés pour assurer le fonctionnement et la sécurité du site. Les cookies de mesure d’audience et de marketing ne sont utilisés qu’avec votre <strong>consentement préalable</strong>. Vous pouvez à tout moment gérer vos préférences via le bandeau cookies.</p>

      <h2 id="destinataires" class="title2">5) Destinataires & sous‑traitants</h2>
      <p>Accès limité aux équipes habilitées de MaxMind. Des prestataires (hébergeur, messagerie, CRM, analytics) peuvent intervenir en qualité de <em>sous‑traitants</em> contractuellement tenus à la confidentialité et à la sécurité, conformément à la Loi 09‑08.</p>

      <h2 id="transferts" class="title2">6) Transferts hors Maroc</h2>
      <p>En cas d’hébergement ou d’outils situés hors du Royaume du Maroc, nous encadrons les transferts conformément à la Loi 09‑08 et, le cas échéant, aux <strong>autorisations/notifications auprès de la CNDP</strong>. Lorsque possible, nous privilégions des solutions hébergées au Maroc ou dans des pays offrant un niveau de protection adéquat.</p>

      <h2 id="durees" class="title2">7) Durées de conservation</h2>
      <table class="mm-table">
        <thead><tr><th>Traitement</th><th>Durée</th></tr></thead>
        <tbody>
          <tr><td>Prospects (formulaires de contact/devis)</td><td>Jusqu’à 3 ans après le dernier contact émanant du prospect</td></tr>
          <tr><td>Clients & contrats</td><td>Durée de la relation contractuelle, puis archivage légal (jusqu’à 10 ans pour les pièces comptables)</td></tr>
          <tr><td>Cookies de mesure</td><td>13 mois au maximum (durée de vie du cookie), données associées 25 mois</td></tr>
          <tr><td>Logs de sécurité</td><td>6 à 12 mois selon nécessité</td></tr>
        </tbody>
      </table>

      <h2 id="droits" class="title2">8) Vos droits (Loi 09‑08)</h2>
      <p>Vous disposez des droits <strong>d’accès</strong>, de <strong>rectification</strong>, d’<strong>opposition</strong> aux traitements pour des motifs légitimes, et le cas échéant de <strong>suppression</strong> ou <strong>limitation</strong> conformément à la Loi 09‑08. Vous pouvez également définir des directives relatives au sort de vos données personnelles après votre décès lorsque la loi l’autorise.</p>
      <p>Pour exercer vos droits : envoyez un email à <a href="mailto:privacy@maxmind.ma">privacy@maxmind.ma</a> ou par courrier à l’adresse ci‑dessus en joignant une copie d’un justificatif d’identité.</p>

      <h2 id="securite" class="title2">9) Sécurité</h2>
      <p>Nous mettons en œuvre des mesures techniques et organisationnelles adaptées (contrôles d’accès, chiffrement en transit, sauvegardes, journalisation, politique de gestion des incidents) afin de préserver la confidentialité, l’intégrité et la disponibilité des données.</p>

      <h2 id="mineurs" class="title2">10) Mineurs</h2>
      <p>Nos services s’adressent principalement à un public professionnel. Nous ne collectons pas sciemment de données concernant des mineurs.</p>

      <h2 id="maj" class="title2">11) Mises à jour de la politique</h2>
      <p>La présente politique peut être mise à jour pour refléter des évolutions légales ou techniques. En cas de modification substantielle, nous informerons les personnes concernées par les moyens appropriés.</p>

      <h2 id="contact" class="title2">12) Contacts utiles</h2>
      <p><strong>MaxMind Digital Agency</strong> – Email dédié : <a href="mailto:privacy@maxmind.ma">privacy@maxmind.ma</a> · Adresse : Imm Soft City, Oasis, Office 17, 3e étage, Casablanca 20180.</p>
      <p><strong>Autorité de contrôle (CNDP)</strong> – Commission Nationale de contrôle de la protection des Données à caractère Personnel (CNDP). Adresse : Avenue Al Arz, Secteur 4, M1, Hay Riyad, Rabat. Site : <a href="https://www.cndp.ma/" target="_blank" rel="noopener">cndp.ma</a>.</p>
      <p class="mm-note">En cas de difficulté, vous pouvez introduire une réclamation auprès de la CNDP ou de nos services. Nous privilégierons toujours une résolution amiable et rapide.</p>
    </section>
  </main>

    <?php include 'footer.php'; ?>

</body>
</html>
