<?php include "backend/backend.php" ?>
<?php include "backend/projects.php" ?>

<!DOCTYPE html>
<html lang="fr">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MaxMind - Innovation Technology | Solutions Digitales Maroc</title>
    <meta name="description" content="MaxMind, votre partenaire technologique au Maroc. Développement web, applications mobile, e-commerce et design UI/UX. Solutions digitales innovantes à Casablanca.">
    <meta name="keywords" content="développement web Maroc, application mobile Casablanca, e-commerce Maroc, design UI/UX, MaxMind technology">
    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">
    <link rel="stylesheet" href="styleMl.css">
    <link rel="stylesheet" href="css/index.css">
    <!-- Open Graph -->
    <meta property="og:title" content="MaxMind - Innovation Technology">
    <meta property="og:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo htmlspecialchars($baseUrl); ?>">
    <meta property="og:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta property="og:locale" content="fr_MA">
    <meta property="og:site_name" content="MaxMind">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="MaxMind - Innovation Technology">
    <meta name="twitter:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta name="twitter:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta name="twitter:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta name="twitter:site" content="@MaxMindMA">
    <meta name="twitter:creator" content="@MaxMindMA">

    <!-- Additional SEO -->
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="author" content="MaxMind">
    <meta name="publisher" content="MaxMind">
    <meta name="language" content="French">
    <meta name="theme-color" content="#01acb6">
    <meta name="msapplication-TileColor" content="#01acb6">

    <?php if ($heroData): ?>
        <meta name="hero:title" content="<?php echo htmlspecialchars($heroData['title'] ?? ''); ?>">
        <meta name="hero:subtitle" content="<?php echo htmlspecialchars($heroData['sous_titre'] ?? ''); ?>">
        <?php if (isset($heroData['images']) && is_array($heroData['images'])): ?>
            <meta name="hero:image_count" content="<?php echo count($heroData['images']); ?>">
            <?php foreach ($heroData['images'] as $index => $image): ?>
                <meta name="hero:image_<?php echo $index + 1; ?>" content="<?php echo htmlspecialchars($image); ?>">
            <?php endforeach; ?>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Blog/Projects Meta Data -->
    <?php if ($projects && isset($projects['data']['items'])): ?>
        <meta name="homepage:total_projects" content="<?php echo count($projects['data']['items']); ?>">
        <meta name="homepage:projects_displayed" content="<?php echo min(8, count($projects['data']['items'])); ?>">
        <?php if (isset($projects['data']['pagination']['total'])): ?>
            <meta name="homepage:total_available_projects" content="<?php echo $projects['data']['pagination']['total']; ?>">
        <?php endif; ?>

        <?php
        $project_categories = [];
        $project_tags = [];
        foreach ($projects['data']['items'] as $project) {
            if (isset($project['values']['category']) && !in_array($project['values']['category'], $project_categories)) {
                $project_categories[] = $project['values']['category'];
            }
            if (isset($project['values']['tags'])) {
                $tags = is_array($project['values']['tags']) ? $project['values']['tags'] : explode(',', $project['values']['tags']);
                foreach ($tags as $tag) {
                    $tag = trim($tag);
                    if (!empty($tag) && !in_array($tag, $project_tags)) {
                        $project_tags[] = $tag;
                    }
                }
            }
        }
        ?>
        <?php if (!empty($project_categories)): ?>
            <meta name="homepage:project_categories" content="<?php echo htmlspecialchars(implode(', ', $project_categories)); ?>">
            <meta name="homepage:category_count" content="<?php echo count($project_categories); ?>">
        <?php endif; ?>

        <?php if (!empty($project_tags)): ?>
            <meta name="homepage:project_tags" content="<?php echo htmlspecialchars(implode(', ', array_slice($project_tags, 0, 10))); ?>">
            <meta name="homepage:tag_count" content="<?php echo count($project_tags); ?>">
        <?php endif; ?>
    <?php endif; ?>

    <!-- Schema.org Structured Data -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars($baseUrl); ?>",
            "logo": "<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png",
            "description": "Solutions digitales exceptionnelles au Maroc - Développement web, applications mobile, e-commerce et design UI/UX",
            "foundingDate": "2020",
            "address": {
                "@type": "PostalAddress",
                "addressCountry": "MA",
                "addressLocality": "Casablanca"
            },
            "contactPoint": {
                "@type": "ContactPoint",
                "contactType": "customer service",
                "availableLanguage": ["French", "Arabic", "English"]
            },
            "sameAs": [
                "https://www.linkedin.com/company/maxmind-ma",
                "https://www.facebook.com/maxmind.ma",
                "https://www.instagram.com/maxmind.ma"
            ],
            "service": [{
                    "@type": "Service",
                    "name": "Développement Web",
                    "description": "Solutions web sur mesure et développement d'applications web modernes"
                },
                {
                    "@type": "Service",
                    "name": "Applications Mobile",
                    "description": "Développement d'applications mobiles iOS et Android"
                },
                {
                    "@type": "Service",
                    "name": "E-commerce",
                    "description": "Solutions e-commerce complètes et plateformes de vente en ligne"
                },
                {
                    "@type": "Service",
                    "name": "Design UI/UX",
                    "description": "Design d'interface utilisateur et expérience utilisateur optimisée"
                }
            ] <?php if ($heroData && isset($heroData['title'])): ?>,
            "slogan": "<?php echo htmlspecialchars($heroData['title']); ?>"
        <?php endif; ?>
        }
    </script>

    <!-- Preload critical resources -->
    <link rel="preload" href="./imgs/LOGO_MAXMIND_WHITE.png" as="image" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- GSAP -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', '-apple-system', 'sans-serif'],
                        display: ['Space Grotesk', 'Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>

    <link rel="stylesheet" href="css/projects.css">
</head>

<body class="bg-white" style="margin: 0; padding: 0; width: 100%; height: 100%;">
    <!-- Skip to content link for accessibility -->
    <a href="#main-content" class="sr-only focus:not-sr-only focus:absolute focus:top-4 focus:left-4 bg-primary-500 text-white px-4 py-2 rounded-md z-50">Passer au contenu principal</a>

    <?php include 'social-floating.php'; ?>

    <?php include 'header.php'; ?>

    <main>
        <br>
        <!-- design section -->
        <section id="design-content"
            class="py-20 bg-slate-900 relative overflow-hidden">
            <!-- Background Effects -->
            <div class="absolute inset-0">
                <div class="absolute top-20 left-10 w-72 h-72 bg-[#01acb6]/5 rounded-full blur-xl opacity-30"></div>
                <div class="absolute bottom-20 right-10 w-96 h-96 bg-[#EF234B]/5 rounded-full blur-xl opacity-30"></div>
                <div
                    class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-purple-500/3 rounded-full blur-xl opacity-30">
                </div>
            </div>
            <div class="max-w-7xl mx-auto px-6 relative z-10">
                <!-- Section Header -->
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-bold text-white mb-6">
                        Nos
                        <span class="bg-[#01acb6] bg-clip-text text-transparent" id="design">création visuelles et Design</span>
                    </h2>
                    <p class="text-xl text-slate-300 max-w-3xl mx-auto leading-relaxed">
                        Découvrez notre expertise créative à travers une sélection de nos plus beaux designs.
                        Chaque création reflète notre passion pour l'innovation visuelle et l'excellence graphique.
                    </p>
                </div>

                <!-- Design Gallery - Grid -->
                <?php if ($projects['success'] && !empty($projects['data']['items'])): ?>
                    <?php
                    // Filter projects to only show design content items (where values[5] == 8)
                    $designProjects = array_filter($projects['data']['items'], function ($project) {
                        return $project['values'][5] == 8;
                    });
                    $designProjects = array_values($designProjects); // Reset array keys

                    // Further filter to only include projects with valid images
                    $validDesignProjects = [];
                    foreach ($designProjects as $project) {
                        $projectImage = $project['values'][2] ?? null;
                        if (!empty($projectImage) && is_array($projectImage) && !empty($projectImage[0])) {
                            $validDesignProjects[] = $project;
                        }
                    }
                    ?>
                    <?php if (!empty($validDesignProjects)): ?>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-16">
                            <?php foreach ($validDesignProjects as $index => $project): ?>
                                <?php $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : ''; ?>
                                <div class="group relative bg-slate-800 rounded-xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 cursor-pointer"
                                    onclick="window.open('<?php echo $baseUrl . $adminPath . 'portfolio.php/' . htmlspecialchars($project['slug']); ?>')">

                                    <!-- Image -->
                                    <div class="relative h-64 overflow-hidden">
                                        <img src="<?php echo htmlspecialchars($project['values'][2][0]); ?>"
                                            alt="<?php echo htmlspecialchars($project['values'][0]); ?>"
                                            loading="lazy"
                                            class="w-full h-full object-cover group-hover:scale-110 transition-all duration-500">

                                        <!-- Hover overlay with dark background -->
                                        <div class="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                                    </div>

                                    <!-- Content overlay -->
                                    <div class="absolute inset-0 p-6 flex flex-col justify-end opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                        <h3 class="text-xl font-bold text-white mb-2">
                                            <?php echo htmlspecialchars($project['values'][0]); ?>
                                        </h3>
                                        <p class="text-slate-300 text-sm leading-relaxed">
                                            <?php echo htmlspecialchars(truncateText(stripHTMLTags($project['values'][1]), 80)); ?>
                                        </p>
                                    </div>

                                    <!-- Link icon -->
                                    <div class="absolute top-4 right-4 w-10 h-10 bg-[#01acb6] rounded-full flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7h10v10" />
                                            <path d="M7 17 17 7" />
                                        </svg>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <!-- Pagination -->
                        <?php if ($projects['success'] && isset($projects['data']['pagination'])): ?>
                            <?php
                            $pagination = $projects['data']['pagination'];
                            $total_pages = $pagination['total_pages'] ?? 1;
                            $current_page = $pagination['current_page'] ?? 1;
                            ?>
                            <?php if ($total_pages > 1): ?>
                                <div class="flex justify-center items-center gap-2 mt-12">
                                    <!-- Previous Button -->
                                    <?php if ($current_page > 1): ?>
                                        <a href="?page=<?php echo $current_page - 1; ?><?php echo !empty($search_query) ? '&search=' . urlencode($search_query) : ''; ?>"
                                            class="px-4 py-2 bg-slate-800 text-white rounded-lg hover:bg-[#01acb6] transition-colors duration-300">
                                            <i data-lucide="chevron-left" class="w-5 h-5"></i>
                                        </a>
                                    <?php endif; ?>

                                    <!-- Page Numbers -->
                                    <?php
                                    $start_page = max(1, $current_page - 2);
                                    $end_page = min($total_pages, $current_page + 2);

                                    if ($start_page > 1): ?>
                                        <a href="?page=1<?php echo !empty($search_query) ? '&search=' . urlencode($search_query) : ''; ?>"
                                            class="px-4 py-2 bg-slate-800 text-white rounded-lg hover:bg-[#01acb6] transition-colors duration-300">1</a>
                                        <?php if ($start_page > 2): ?>
                                            <span class="text-slate-400">...</span>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                                        <a href="?page=<?php echo $i; ?><?php echo !empty($search_query) ? '&search=' . urlencode($search_query) : ''; ?>"
                                            class="px-4 py-2 rounded-lg transition-colors duration-300 <?php echo $i === $current_page ? 'bg-[#01acb6] text-white' : 'bg-slate-800 text-white hover:bg-[#01acb6]'; ?>">
                                            <?php echo $i; ?>
                                        </a>
                                    <?php endfor; ?>

                                    <?php if ($end_page < $total_pages): ?>
                                        <?php if ($end_page < $total_pages - 1): ?>
                                            <span class="text-slate-400">...</span>
                                        <?php endif; ?>
                                        <a href="?page=<?php echo $total_pages; ?><?php echo !empty($search_query) ? '&search=' . urlencode($search_query) : ''; ?>"
                                            class="px-4 py-2 bg-slate-800 text-white rounded-lg hover:bg-[#01acb6] transition-colors duration-300"><?php echo $total_pages; ?></a>
                                    <?php endif; ?>

                                    <!-- Next Button -->
                                    <?php if ($current_page < $total_pages): ?>
                                        <a href="?page=<?php echo $current_page + 1; ?><?php echo !empty($search_query) ? '&search=' . urlencode($search_query) : ''; ?>"
                                            class="px-4 py-2 bg-slate-800 text-white rounded-lg hover:bg-[#01acb6] transition-colors duration-300">
                                            <i data-lucide="chevron-right" class="w-5 h-5"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div id="imagePopup" class="fixed inset-0 z-50 hidden items-center justify-center p-4">
                <!-- Blurred + dark background -->
                <div class="absolute inset-0 bg-black/60 backdrop-blur-md"></div>

                <div class="relative max-w-4xl max-h-full z-10">
                    <!-- Close button -->
                    <button onclick="closePopup()" class="absolute -top-12 right-0 text-white hover:text-gray-300 transition-colors duration-200">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>

                </div>
            </div>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mb-16">
                <div class="text-center group">
                    <div
                        class="text-3xl md:text-4xl font-bold bg-[#01acb6] bg-clip-text text-transparent mb-2 group-hover:scale-110 transition-transform duration-300">
                        200+</div>
                    <div class="text-slate-300">Designs créés</div>
                </div>
                <div class="text-center group">
                    <div
                        class="text-3xl md:text-4xl font-bold text-[#01acb6] mb-2 group-hover:scale-110 transition-transform duration-300">
                        50+</div>
                    <div class="text-slate-300">Marques accompagnées</div>
                </div>
                <div class="text-center group">
                    <div
                        class="text-3xl md:text-4xl font-bold text-[#01acb6] mb-2 group-hover:scale-110 transition-transform duration-300">
                        8</div>
                    <div class="text-slate-300">Années d'expertise</div>
                </div>
                <div class="text-center group">
                    <div
                        class="text-3xl md:text-4xl font-bold text-[#01acb6] mb-2 group-hover:scale-110 transition-transform duration-300">
                        100%</div>
                    <div class="text-slate-300">Satisfaction client</div>
                </div>
            </div>

            <!-- CTA Section -->
            <!-- <div class="text-center">
                <div
                    class="inline-flex items-center px-8 py-4 bg-[#01acb6] rounded-full text-white font-semibold hover:scale-105 hover:shadow-2xl transition-all duration-300 cursor-pointer group">
                    <i data-lucide="brush" class="w-5 h-5 mr-2 group-hover:rotate-12 transition-transform duration-300"></i>
                    <span class="mr-2">Découvrir notre portfolio complet</span>
                    <i data-lucide="arrow-right"
                        class="w-5 h-5 group-hover:translate-x-1 transition-transform duration-300"></i>
                </div>
            </div> -->
            </div>
        </section>
        <?php include 'footer.php'; ?>

    </main>
    <script src="js/projects.js"></script>
</body>

</html>
