<?php include "backend/backend.php" ?>
<?php include "backend/projects.php" ?>

<!DOCTYPE html>
<html lang="fr">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MaxMind - Innovation Technology | Solutions Digitales Maroc</title>
    <meta name="description" content="MaxMind, votre partenaire technologique au Maroc. Développement web, applications mobile, e-commerce et design UI/UX. Solutions digitales innovantes à Casablanca.">
    <meta name="keywords" content="développement web Maroc, application mobile Casablanca, e-commerce Maroc, design UI/UX, MaxMind technology">
    <link rel="icon" href="./imgs/LOGO_MAXMIND_BLACK.png" type="image/x-icon">
    <link rel="stylesheet" href="styleMl.css">

    <!-- Open Graph -->
    <meta property="og:title" content="MaxMind - Innovation Technology">
    <meta property="og:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo htmlspecialchars($baseUrl); ?>">
    <meta property="og:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta property="og:locale" content="fr_MA">
    <meta property="og:site_name" content="MaxMind">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="MaxMind - Innovation Technology">
    <meta name="twitter:description" content="Solutions digitales exceptionnelles au Maroc">
    <meta name="twitter:image" content="<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png">
    <meta name="twitter:image:alt" content="MaxMind - Innovation Technology Logo">
    <meta name="twitter:site" content="@MaxMindMA">
    <meta name="twitter:creator" content="@MaxMindMA">

    <!-- Additional SEO -->
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="author" content="MaxMind">
    <meta name="publisher" content="MaxMind">
    <meta name="language" content="French">
    <meta name="theme-color" content="#01acb6">
    <meta name="msapplication-TileColor" content="#01acb6">
    <link rel="stylesheet" href="css/index.css">
    <?php if ($heroData): ?>
        <meta name="hero:title" content="<?php echo htmlspecialchars($heroData['title'] ?? ''); ?>">
        <meta name="hero:subtitle" content="<?php echo htmlspecialchars($heroData['sous_titre'] ?? ''); ?>">
        <?php if (isset($heroData['images']) && is_array($heroData['images'])): ?>
            <meta name="hero:image_count" content="<?php echo count($heroData['images']); ?>">
            <?php foreach ($heroData['images'] as $index => $image): ?>
                <meta name="hero:image_<?php echo $index + 1; ?>" content="<?php echo htmlspecialchars($image); ?>">
            <?php endforeach; ?>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Blog/Projects Meta Data -->
    <?php if ($projects && isset($projects['data']['items'])): ?>
        <meta name="homepage:total_projects" content="<?php echo count($projects['data']['items']); ?>">
        <meta name="homepage:projects_displayed" content="<?php echo min(8, count($projects['data']['items'])); ?>">
        <?php if (isset($projects['data']['pagination']['total'])): ?>
            <meta name="homepage:total_available_projects" content="<?php echo $projects['data']['pagination']['total']; ?>">
        <?php endif; ?>

        <?php
        $project_categories = [];
        $project_tags = [];
        foreach ($projects['data']['items'] as $project) {
            if (isset($project['values']['category']) && !in_array($project['values']['category'], $project_categories)) {
                $project_categories[] = $project['values']['category'];
            }
            if (isset($project['values'][6])) {
                $tags = is_array($project['values'][6]) ? $project['values'][6] : explode(',', $project['values'][6]);
                foreach ($tags as $tag) {
                    $tag = trim($tag);
                    if (!empty($tag) && !in_array($tag, $project_tags)) {
                        $project_tags[] = $tag;
                    }
                }
            }
        }
        ?>
        <?php if (!empty($project_categories)): ?>
            <meta name="homepage:project_categories" content="<?php echo htmlspecialchars(implode(', ', $project_categories)); ?>">
            <meta name="homepage:category_count" content="<?php echo count($project_categories); ?>">
        <?php endif; ?>

        <?php if (!empty($project_tags)): ?>
            <meta name="homepage:project_tags" content="<?php echo htmlspecialchars(implode(', ', array_slice($project_tags, 0, 10))); ?>">
            <meta name="homepage:tag_count" content="<?php echo count($project_tags); ?>">
        <?php endif; ?>
    <?php endif; ?>

    <!-- Schema.org Structured Data -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": "MaxMind",
            "url": "<?php echo htmlspecialchars($baseUrl); ?>",
            "logo": "<?php echo htmlspecialchars($baseUrl); ?>/imgs/LOGO_MAXMIND_BLACK.png",
            "description": "Solutions digitales exceptionnelles au Maroc - Développement web, applications mobile, e-commerce et design UI/UX",
            "foundingDate": "2020",
            "address": {
                "@type": "PostalAddress",
                "addressCountry": "MA",
                "addressLocality": "Casablanca"
            },
            "contactPoint": {
                "@type": "ContactPoint",
                "contactType": "customer service",
                "availableLanguage": ["French", "Arabic", "English"]
            },
            "sameAs": [
                "https://www.linkedin.com/company/maxmind-ma",
                "https://www.facebook.com/maxmind.ma",
                "https://www.instagram.com/maxmind.ma"
            ],
            "service": [{
                    "@type": "Service",
                    "name": "Développement Web",
                    "description": "Solutions web sur mesure et développement d'applications web modernes"
                },
                {
                    "@type": "Service",
                    "name": "Applications Mobile",
                    "description": "Développement d'applications mobiles iOS et Android"
                },
                {
                    "@type": "Service",
                    "name": "E-commerce",
                    "description": "Solutions e-commerce complètes et plateformes de vente en ligne"
                },
                {
                    "@type": "Service",
                    "name": "Design UI/UX",
                    "description": "Design d'interface utilisateur et expérience utilisateur optimisée"
                }
            ] <?php if ($heroData && isset($heroData['title'])): ?>,
            "slogan": "<?php echo htmlspecialchars($heroData['title']); ?>"
        <?php endif; ?>
        }
    </script>

    <!-- Preload critical resources -->
    <link rel="preload" href="./imgs/LOGO_MAXMIND_WHITE.png" as="image" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Performance Optimization Styles -->
    <style>
        /* GPU acceleration for animations */
        .project-card {
            will-change: transform, opacity;
            transform: translateZ(0);
            backface-visibility: hidden;
        }

        .project-card img {
            will-change: transform, opacity;
            transform: translateZ(0);
        }

        /* Skeleton animation */
        @keyframes shimmer {
            0% {
                background-position: -1000px 0;
            }
            100% {
                background-position: 1000px 0;
            }
        }

        .skeleton-card {
            animation: shimmer 2s infinite;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 1000px 100%;
        }

        /* Smooth transitions */
        .project-card,
        .filter-btn {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Reduce motion for accessibility */
        @media (prefers-reduced-motion: reduce) {
            .project-card,
            .filter-btn,
            .project-card img {
                transition: none !important;
                animation: none !important;
                will-change: auto !important;
            }
        }

        /* Optimize grid rendering */
        .grid {
            contain: layout style paint;
        }
    </style>

    <!-- GSAP -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', '-apple-system', 'sans-serif'],
                        display: ['Space Grotesk', 'Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#e6f9fa',
                            100: '#b3f0f3',
                            200: '#80e7ec',
                            300: '#4ddde4',
                            400: '#1ad4dd',
                            500: '#01acb6',
                            600: '#018a92',
                            700: '#01686e',
                            800: '#01464a',
                            900: '#002426',
                        },
                        accent: {
                            50: '#fef2f4',
                            100: '#fce7ea',
                            200: '#f9ced5',
                            300: '#f5a3b0',
                            400: '#f1788b',
                            500: '#EF234B',
                            600: '#d91e42',
                            700: '#c31a39',
                            800: '#ad1530',
                            900: '#971127',
                        },
                        dark: '#000000'
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'float-delayed': 'float 8s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
                        'text-shimmer': 'text-shimmer 3s ease-in-out infinite',
                        'bounce-gentle': 'bounce-gentle 2s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': {
                                transform: 'translateY(0px) rotate(0deg)'
                            },
                            '33%': {
                                transform: 'translateY(-20px) rotate(1deg)'
                            },
                            '66%': {
                                transform: 'translateY(-10px) rotate(-1deg)'
                            },
                        },
                        'pulse-glow': {
                            '0%, 100%': {
                                boxShadow: '0 0 20px rgba(6, 182, 212, 0.3), 0 0 40px rgba(6, 182, 212, 0.1)',
                                transform: 'scale(1)'
                            },
                            '50%': {
                                boxShadow: '0 0 40px rgba(6, 182, 212, 0.6), 0 0 80px rgba(6, 182, 212, 0.2)',
                                transform: 'scale(1.05)'
                            },
                        },
                        'text-shimmer': {
                            '0%': {
                                backgroundPosition: '-200% center'
                            },
                            '100%': {
                                backgroundPosition: '200% center'
                            },
                        },
                        'bounce-gentle': {
                            '0%, 100%': {
                                transform: 'translateY(0px)'
                            },
                            '50%': {
                                transform: 'translateY(-5px)'
                            },
                        }
                    }
                }
            }
        }
    </script>

    <link rel="stylesheet" href="css/projects.css">
</head>

<body class="bg-white" style="margin: 0; padding: 0; width: 100%; height: 100%;">
    <a href="#main-content" class="sr-only focus:not-sr-only focus:absolute focus:top-4 focus:left-4 bg-primary-500 text-white px-4 py-2 rounded-md z-50">Passer au contenu principal</a>

    <?php include 'header.php'; ?>

    <main>
        <br>
        <section id="projects" class="py-20 bg-slate-50 mt-10">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-16">
                    <h2 class="projects-title text-4xl md:text-5xl font-bold text-slate-800 mb-6">
                        Nos
                        <span class="text-[#01acb6]">Projets</span>
                    </h2>
                    <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                        Découvrez quelques-uns de nos projets les plus remarquables et les solutions innovantes que nous
                        avons créées pour nos clients
                    </p>
                </div>

                <div class="flex flex-wrap justify-center gap-3 mb-12">
                    <button class="filter-btn px-6 py-3 bg-[#01acb6] text-white border-2 border-[#01acb6] rounded-full font-medium active-filter" data-filter="all" data-category-id="all">
                        <i data-lucide="grid-3x3" class="w-4 h-4 inline mr-2"></i>
                        Tous les projets
                    </button>
                    <button class="filter-btn px-6 py-3 bg-white text-slate-700 border-2 border-slate-200 rounded-full font-medium" data-filter="design-projects" data-category-id="8">
                        <i data-lucide="palette" class="w-4 h-4 inline mr-2"></i>
                        Design Projects
                    </button>
                    <button class="filter-btn px-6 py-3 bg-white text-slate-700 border-2 border-slate-200 rounded-full font-medium" data-filter="web-projects" data-category-id="11">
                        <i data-lucide="globe" class="w-4 h-4 inline mr-2"></i>
                        Web Projects
                    </button>
                    <?php if (!empty($projectTypes)): ?>
                        <?php foreach ($projectTypes as $type):
                            $typeSlug = strtolower(trim(preg_replace('/[^A-Za-z0-9\-]/', '', str_replace(' ', '-', $type))));
                            $typeSlug = preg_replace('/-+/', '-', $typeSlug);

                            // Map icons to different project types
                            $icon = 'folder';
                            if (stripos($type, 'rh') !== false || stripos($type, 'recrutement') !== false) {
                                $icon = 'users';
                            } elseif (stripos($type, 'industrie') !== false || stripos($type, 'manufacturing') !== false) {
                                $icon = 'factory';
                            } elseif (stripos($type, 'verification') !== false || stripos($type, 'check') !== false) {
                                $icon = 'shield-check';
                            } elseif (stripos($type, 'ecommerce') !== false || stripos($type, 'shop') !== false || stripos($type, 'store') !== false) {
                                $icon = 'shopping-cart';
                            } elseif (stripos($type, 'portfolio') !== false || stripos($type, 'showcase') !== false) {
                                $icon = 'briefcase';
                            } elseif (stripos($type, 'web') !== false || stripos($type, 'site') !== false) {
                                $icon = 'globe';
                            } elseif (stripos($type, 'mobile') !== false || stripos($type, 'app') !== false) {
                                $icon = 'smartphone';
                            } elseif (stripos($type, 'design') !== false || stripos($type, 'ui') !== false || stripos($type, 'ux') !== false) {
                                $icon = 'palette';
                            }
                        ?>
                            <button class="filter-btn px-6 py-3 bg-white text-slate-700 border-2 border-slate-200 rounded-full font-medium" data-filter="<?php echo htmlspecialchars($typeSlug); ?>" data-category-id="">
                                <i data-lucide="<?php echo $icon; ?>" class="w-4 h-4 inline mr-2"></i>
                                <?php echo htmlspecialchars($type); ?>
                            </button>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- Projects Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
                    <?php
                    // Check if we have projects data
                    if (isset($projects['data']['items']) && !empty($projects['data']['items'])) {
                        // Filter for both Design Projects (ID 8) and Web Projects (ID 11)
                        $filteredProjects = array_filter($projects['data']['items'], function($project) {
                            return $project['values'][5] == 8 || $project['values'][5] == 11;
                        });

                        foreach ($filteredProjects as $project) {
                            $id = $project['id'];
                            $slug = $project['slug'];
                            $title = $project['values'][0];
                            $description = $project['values'][1];
                            $image = $project['values'][2];
                            $tags = !empty($project['values'][6]) && is_array($project['values'][6]) ? $project['values'][6] : [];
                            $links = $project['values']['links'] ?? "";
                            $type = $project['values'][8] ?? "Portfolio";
                            $taglist = $project['values'][7];
                            $type = trim($type);

                            // Generate slug for the type for filtering
                            $typeSlug = strtolower(trim(preg_replace('/[^A-Za-z0-9\-]/', '', str_replace(' ', '-', $type))));
                            $typeSlug = preg_replace('/-+/', '-', $typeSlug);

                            // Get the first link if available
                            $project_link = '#';
                            if (!empty($links)) {
                                if (is_array($links)) {
                                    $project_link = $links[0];
                                } else {
                                    $project_link = $links;
                                }
                            }
                            $adminPath = (strpos($baseUrl, 'localhost') !== false) ? '/' : '';
                    ?>
                        <?php if (!empty($image) && is_array($image) && !empty($image[0])): ?>
                            <div class="project-card group relative bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 flex flex-col cursor-pointer"
                            data-category="<?php echo htmlspecialchars($typeSlug); ?>"
                            data-type="<?php echo htmlspecialchars($type); ?>"
                            data-category-id="<?php echo htmlspecialchars($project['values'][5]); ?>"
                            onclick="window.open('<?php echo $baseUrl . $adminPath . 'portfolio.php/' . htmlspecialchars($project['slug']); ?>')">

                            <div class="relative h-64 overflow-hidden bg-slate-200">
                                <img src="<?php echo $project['values'][2][0]; ?>"
                                    alt="<?php echo htmlspecialchars($project['values'][0]); ?>"
                                    loading="lazy"
                                    class="w-full h-full object-cover group-hover:scale-110 transition-all duration-500 origin-center"
                                    onload="this.style.opacity=1"
                                    style="opacity:0;transition:opacity 0.3s ease-in-out">

                                <div class="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                                <div class="absolute inset-0 bg-black/20 group-hover:bg-black/10 transition-colors duration-300"></div>

                                <div class="absolute top-4 left-4 px-3 py-1 bg-[#01acb6] text-white text-sm font-medium rounded-full">
                                    <?php echo htmlspecialchars($type); ?>
                                </div>
                            </div>

                            <div class="p-6 flex-1 flex flex-col">
                                <h3 class="text-xl font-bold text-slate-800 mb-3 group-hover:text-slate-900 transition-colors">
                                    <?php echo htmlspecialchars($title); ?>
                                </h3>

                                <p class="text-slate-600 text-sm leading-relaxed mb-4 flex-1">
                                    <?php echo htmlspecialchars(truncateText(stripHTMLTags($description), 120)); ?>
                                </p>

                                <?php if (!empty($tags) && is_array($tags)): ?>
                                    <div class="flex flex-wrap gap-2 mb-4">
                                        <?php foreach ($tags as $tag): ?>
                                            <span class="px-2 py-1 bg-slate-100 text-slate-600 text-xs rounded-full"><?php echo htmlspecialchars($tag); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>

                                <div class="flex items-center text-slate-400 group-hover:text-slate-600 transition-colors cursor-pointer mt-auto">
                                    <a href="" class="font-medium mr-2 text-sm">Voir le projet</a>
                                    <i data-lucide="arrow-right" class="w-4 h-4 group-hover:translate-x-1 transition-transform"></i>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                    <?php
                        }
                    } else {
                        // Fallback content if no projects are found
                       
                    }
                    ?>
                </div>

                <!-- Load More Button -->
                <div class="flex justify-center mb-16">
                    <button id="loadMoreBtn2" class="group flex items-center px-8 py-4 bg-[#01acb6] text-white rounded-full font-semibold hover:bg-[#018a92] transition-all duration-300 hover:shadow-xl hover:scale-105">
                        <i data-lucide="plus-circle" class="w-5 h-5 mr-2 group-hover:rotate-90 transition-transform duration-300"></i>
                        <span>Charger plus de projets</span>
                        <i data-lucide="chevron-down" class="w-5 h-5 ml-2 group-hover:translate-y-1 transition-transform duration-300"></i>
                    </button>
                </div>

                <!-- Pagination Section (Hidden when Load More is active) -->
                <?php if (isset($paginatedType11['pagination'])): ?>
                    <?php
                    $pagination = $paginatedType11['pagination'];
                    $total_pages = $pagination['total_pages'] ?? 1;
                    $current_page = $pagination['current_page'] ?? 1;
                    $per_page = $pagination['per_page'] ?? 8;

                    // Build URL parameters for pagination links
                    $url_params = [];
                    if (!empty($search_query)) $url_params[] = 'search=' . urlencode($search_query);
                    if (isset($_GET['filter'])) $url_params[] = 'filter=' . urlencode($_GET['filter']);
                    $param_string = !empty($url_params) ? '&' . implode('&', $url_params) : '';

                    if ($total_pages > 1): ?>
                        <div class="pagination-container flex flex-col items-center space-y-4 mb-16">
                            <!-- Page Info -->
                            <div class="text-center text-slate-600">
                                <span>Page <?php echo $current_page; ?> of <?php echo $total_pages; ?></span>
                                <span class="mx-2">•</span>
                                <span><?php echo $pagination['total']; ?> total projects</span>
                            </div>

                            <!-- Pagination Controls -->
                            <div class="flex items-center justify-center space-x-2">
                                <?php
                                // Previous button
                                if ($current_page > 1): ?>
                                    <a href="?page11=<?php echo $current_page - 1; ?><?php echo $param_string; ?>"
                                       class="px-4 py-2 bg-white text-slate-700 border border-slate-300 rounded-lg hover:bg-slate-50 transition-colors duration-200">
                                        <i data-lucide="chevron-left" class="w-4 h-4"></i>
                                    </a>
                                <?php endif; ?>

                                <?php
                                // Page numbers
                                $start_page = max(1, $current_page - 2);
                                $end_page = min($total_pages, $current_page + 2);

                                // Show first page if not in range
                                if ($start_page > 1): ?>
                                    <a href="?page=1<?php echo $param_string; ?>"
                                       class="px-4 py-2 bg-white text-slate-700 border border-slate-300 rounded-lg hover:bg-slate-50 transition-colors duration-200">1</a>
                                    <?php if ($start_page > 2): ?>
                                        <span class="px-2 text-slate-400">...</span>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                                    <?php if ($i == $current_page): ?>
                                        <span class="px-4 py-2 bg-[#01acb6] text-white border border-[#01acb6] rounded-lg font-medium"><?php echo $i; ?></span>
                                    <?php else: ?>
                                        <a href="?page=<?php echo $i; ?><?php echo $param_string; ?>"
                                           class="px-4 py-2 bg-white text-slate-700 border border-slate-300 rounded-lg hover:bg-slate-50 transition-colors duration-200"><?php echo $i; ?></a>
                                    <?php endif; ?>
                                <?php endfor; ?>

                                <?php
                                // Show last page if not in range
                                if ($end_page < $total_pages): ?>
                                    <?php if ($end_page < $total_pages - 1): ?>
                                        <span class="px-2 text-slate-400">...</span>
                                    <?php endif; ?>
                                    <a href="?page=<?php echo $total_pages; ?><?php echo $param_string; ?>"
                                       class="px-4 py-2 bg-white text-slate-700 border border-slate-300 rounded-lg hover:bg-slate-50 transition-colors duration-200"><?php echo $total_pages; ?></a>
                                <?php endif; ?>

                                <?php
                                // Next button
                                if ($current_page < $total_pages): ?>
                                    <a href="?page=<?php echo $current_page + 1; ?><?php echo $param_string; ?>"
                                       class="px-4 py-2 bg-white text-slate-700 border border-slate-300 rounded-lg hover:bg-slate-50 transition-colors duration-200">
                                        <i data-lucide="chevron-right" class="w-4 h-4"></i>
                                    </a>
                                <?php endif; ?>
                            </div>

                            <!-- Items per page selector -->
                            <div class="flex items-center space-x-2 text-sm text-slate-600">
                                <span>Show:</span>
                                <select id="itemsPerPage" class="px-3 py-1 border border-slate-300 rounded-md bg-white text-slate-700 focus:border-[#01acb6] focus:outline-none" onchange="changeItemsPerPage(this.value)">
                                    <option value="6" <?php echo $per_page == 6 ? 'selected' : ''; ?>>6</option>
                                    <option value="12" <?php echo $per_page == 12 ? 'selected' : ''; ?>>12</option>
                                    <option value="18" <?php echo $per_page == 18 ? 'selected' : ''; ?>>18</option>
                                    <option value="24" <?php echo $per_page == 24 ? 'selected' : ''; ?>>24</option>
                                </select>
                                <span>per page</span>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Stats Section -->
                <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mb-16">
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold text-slate-800 mb-2">50+</div>
                        <div class="text-slate-600">Projets réalisés</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold text-slate-800 mb-2">5</div>
                        <div class="text-slate-600">Années d'expérience</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold text-slate-800 mb-2">30+</div>
                        <div class="text-slate-600">Clients satisfaits</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold text-slate-800 mb-2">24/7</div>
                        <div class="text-slate-600">Support client</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <?php include 'footer.php'; ?>

    </main>

    <!-- Debug script - Load BEFORE projects.js -->

    <script src="js/projects.js"></script>
    <script src="js/carousell.js"></script>
</body>

</html>
