<!-- Social Media Icons Floating -->
<style>
    /* Social Media Icons Floating - Right Side */
    .social-floating2 {
        position: fixed;
        right: 20px;
        top: 94%;
        transform: translateY(-50%);
        z-index: 9999;
        display: flex;
        flex-direction: column;
        gap: 15px;
        font-family: 'Roboto', sans-serif;
    }

    .social-floating2 a {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        position: relative;
        overflow: hidden;
    }

    .social-floating2 a::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: inherit;
        border-radius: 50%;
        transform: scale(0);
        transition: transform 0.3s ease;
        z-index: -1;
    }

    .social-floating2 a:hover::before {
        transform: scale(1.2);
    }

    .social-floating2 a:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 25px rgba(0, 0, 0, 0.3);
    }

    .social-floating2 a i,
    .social-floating2 a svg {
        font-size: 24px;
        width: 24px;
        height: 24px;
        color: white;
        fill: white;
        z-index: 2;
        position: relative;
    }

    /* Individual social media colors */
    .social-tiktok2 {
        background: #000000;
    }
    
    .social-whatsapp {
        background: #25D366;
    }

    /* Responsive adjustments for social icons */
    @media (max-width: 768px) {
        .social-floating2 {
            right: 10px;
            gap: 12px;
        }

        .social-floating2 a {
            width: 45px;
            height: 45px;
        }

        .social-floating2 a i,
        .social-floating2 a svg {
            font-size: 20px;
            width: 20px;
            height: 20px;
        }
    }

    @media (max-width: 480px) {
        .social-floating2 {
            right: 8px;
            gap: 10px;
        }

        .social-floating2 a {
            width: 40px;
            height: 40px;
        }

        .social-floating2 a i,
        .social-floating2 a svg {
            font-size: 18px;
            width: 18px;
            height: 18px;
        }
    }

    /* Animation for social icons */
    .social-floating2 a {
        animation: socialFloat 6s ease-in-out infinite;
    }

    .social-floating2 a:nth-child(1) {
        animation-delay: 0s;
    }

    .social-floating2 a:nth-child(2) {
        animation-delay: 0.5s;
    }

    .social-floating2 a:nth-child(3) {
        animation-delay: 1s;
    }

    .social-floating2 a:nth-child(4) {
        animation-delay: 1.5s;
    }

    .social-floating2 a:nth-child(5) {
        animation-delay: 2s;
    }

    @keyframes socialFloat {
        0%,
        100% {
            transform: translateY(0px) translateX(0px);
        }

        25% {
            transform: translateY(-5px) translateX(2px);
        }

        50% {
            transform: translateY(0px) translateX(-2px);
        }

        75% {
            transform: translateY(5px) translateX(1px);
        }
    }

    /* Pause animation on hover */
    .social-floating2 a:hover {
        animation-play-state: paused;
    }
</style>

<div class="social-floating2">
    <a href="https://wa.me/+212620151253" target="_blank" rel="noopener noreferrer" class="social-whatsapp"
        title="WhatsApp">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
            <path
                d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.465 3.488" />
        </svg>
    </a>
</div>
